/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import org.apache.xerces.impl.dtd.Grammar;
import org.apache.xerces.impl.validation.GrammarPool;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.util.SymbolTable;

public class CachingParserPool {
    public static final boolean DEFAULT_SHADOW_SYMBOL_TABLE = false;
    public static final boolean DEFAULT_SHADOW_GRAMMAR_POOL = false;
    protected SymbolTable fSynchronizedSymbolTable;
    protected GrammarPool fSynchronizedGrammarPool;
    protected boolean fShadowSymbolTable = false;
    protected boolean fShadowGrammarPool = false;

    public CachingParserPool() {
        this(new SymbolTable(), new GrammarPool());
    }

    public CachingParserPool(SymbolTable symbolTable, GrammarPool grammarPool) {
        this.fSynchronizedSymbolTable = new SynchronizedSymbolTable(symbolTable);
        this.fSynchronizedGrammarPool = new SynchronizedGrammarPool(grammarPool);
    }

    public SymbolTable getSymbolTable() {
        return this.fSynchronizedSymbolTable;
    }

    public GrammarPool getGrammarPool() {
        return this.fSynchronizedGrammarPool;
    }

    public void setShadowSymbolTable(boolean shadow) {
        this.fShadowSymbolTable = shadow;
    }

    public DOMParser createDOMParser() {
        SymbolTable symbolTable = this.fShadowSymbolTable ? new ShadowedSymbolTable(this.fSynchronizedSymbolTable) : this.fSynchronizedSymbolTable;
        GrammarPool grammarPool = this.fShadowGrammarPool ? new ShadowedGrammarPool(this.fSynchronizedGrammarPool) : this.fSynchronizedGrammarPool;
        return new DOMParser(symbolTable, grammarPool);
    }

    public SAXParser createSAXParser() {
        SymbolTable symbolTable = this.fShadowSymbolTable ? new ShadowedSymbolTable(this.fSynchronizedSymbolTable) : this.fSynchronizedSymbolTable;
        GrammarPool grammarPool = this.fShadowGrammarPool ? new ShadowedGrammarPool(this.fSynchronizedGrammarPool) : this.fSynchronizedGrammarPool;
        return new SAXParser(symbolTable, grammarPool);
    }

    public static final class ShadowedGrammarPool
    extends GrammarPool {
        private GrammarPool fGrammarPool;

        public ShadowedGrammarPool(GrammarPool grammarPool) {
            this.fGrammarPool = grammarPool;
        }

        public Grammar getGrammar(String key) {
            if (super.containsGrammar(key)) {
                return super.getGrammar(key);
            }
            return this.fGrammarPool.getGrammar(key);
        }

        public boolean containsGrammar(String key) {
            return super.containsGrammar(key) || this.fGrammarPool.containsGrammar(key);
        }
    }

    public static final class SynchronizedGrammarPool
    extends GrammarPool {
        private GrammarPool fGrammarPool;

        public SynchronizedGrammarPool(GrammarPool grammarPool) {
            this.fGrammarPool = grammarPool;
        }

        public void putGrammar(String key, Grammar grammar) {
            GrammarPool grammarPool = this.fGrammarPool;
            synchronized (grammarPool) {
                this.fGrammarPool.putGrammar(key, grammar);
            }
        }

        public Grammar getGrammar(String key) {
            GrammarPool grammarPool = this.fGrammarPool;
            synchronized (grammarPool) {
                Grammar grammar = this.fGrammarPool.getGrammar(key);
                return grammar;
            }
        }

        public Grammar removeGrammar(String key) {
            GrammarPool grammarPool = this.fGrammarPool;
            synchronized (grammarPool) {
                Grammar grammar = this.fGrammarPool.removeGrammar(key);
                return grammar;
            }
        }

        public boolean containsGrammar(String key) {
            GrammarPool grammarPool = this.fGrammarPool;
            synchronized (grammarPool) {
                boolean bl = this.fGrammarPool.containsGrammar(key);
                return bl;
            }
        }
    }

    public static final class ShadowedSymbolTable
    extends SymbolTable {
        protected SymbolTable fSymbolTable;

        public ShadowedSymbolTable(SymbolTable symbolTable) {
            this.fSymbolTable = symbolTable;
        }

        public String addSymbol(String symbol) {
            if (this.fSymbolTable.containsSymbol(symbol)) {
                return this.fSymbolTable.addSymbol(symbol);
            }
            return super.addSymbol(symbol);
        }

        public String addSymbol(char[] buffer, int offset, int length) {
            if (this.fSymbolTable.containsSymbol(buffer, offset, length)) {
                return this.fSymbolTable.addSymbol(buffer, offset, length);
            }
            return super.addSymbol(buffer, offset, length);
        }

        public int hash(String symbol) {
            return this.fSymbolTable.hash(symbol);
        }

        public int hash(char[] buffer, int offset, int length) {
            return this.fSymbolTable.hash(buffer, offset, length);
        }
    }

    public static final class SynchronizedSymbolTable
    extends SymbolTable {
        protected SymbolTable fSymbolTable;

        public SynchronizedSymbolTable(SymbolTable symbolTable) {
            this.fSymbolTable = symbolTable;
        }

        public String addSymbol(String symbol) {
            SymbolTable symbolTable = this.fSymbolTable;
            synchronized (symbolTable) {
                String string = this.fSymbolTable.addSymbol(symbol);
                return string;
            }
        }

        public String addSymbol(char[] buffer, int offset, int length) {
            SymbolTable symbolTable = this.fSymbolTable;
            synchronized (symbolTable) {
                String string = this.fSymbolTable.addSymbol(buffer, offset, length);
                return string;
            }
        }

        public boolean containsSymbol(String symbol) {
            SymbolTable symbolTable = this.fSymbolTable;
            synchronized (symbolTable) {
                boolean bl = this.fSymbolTable.containsSymbol(symbol);
                return bl;
            }
        }

        public boolean containsSymbol(char[] buffer, int offset, int length) {
            SymbolTable symbolTable = this.fSymbolTable;
            synchronized (symbolTable) {
                boolean bl = this.fSymbolTable.containsSymbol(buffer, offset, length);
                return bl;
            }
        }
    }
}

