/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import org.apache.xerces.parsers.AbstractXMLDocumentParser;
import org.apache.xerces.util.EntityResolverWrapper;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class AbstractSAXParser
extends AbstractXMLDocumentParser
implements Parser,
XMLReader {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected boolean fNamespaces;
    protected boolean fNamespacePrefixes = false;
    protected ContentHandler fContentHandler;
    protected DocumentHandler fDocumentHandler;
    protected DTDHandler fDTDHandler;
    protected DeclHandler fDeclHandler;
    protected LexicalHandler fLexicalHandler;
    protected QName fQName = new QName();
    private String fEmptySymbol;
    private String fXmlnsSymbol;
    protected boolean fParseInProgress = false;
    private final AttributesProxy fAttributesProxy = new AttributesProxy();

    protected AbstractSAXParser(XMLParserConfiguration config) {
        super(config);
        String[] recognizedFeatures = new String[]{NAMESPACES, NAMESPACE_PREFIXES, "http://xml.org/sax/features/string-interning"};
        config.addRecognizedFeatures(recognizedFeatures);
        String[] recognizedProperties = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/properties/declaration-handler", "http://xml.org/sax/properties/dom-node"};
        config.addRecognizedProperties(recognizedProperties);
    }

    public void startDocument(XMLLocator locator, String encoding) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                if (locator != null) {
                    this.fDocumentHandler.setDocumentLocator(new LocatorProxy(locator));
                }
                this.fDocumentHandler.startDocument();
            }
            if (this.fContentHandler != null) {
                if (locator != null) {
                    this.fContentHandler.setDocumentLocator(new LocatorProxy(locator));
                }
                this.fContentHandler.startDocument();
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId) throws XNIException {
        this.fInDTD = true;
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startDTD(rootElement, publicId, systemId);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws XNIException {
        try {
            if (this.fContentHandler != null) {
                this.fContentHandler.startPrefixMapping(prefix, uri);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void startElement(QName element, XMLAttributes attributes) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fAttributesProxy.setAttributes(attributes);
                this.fDocumentHandler.startElement(element.rawname, this.fAttributesProxy);
            }
            if (this.fContentHandler != null) {
                if (!this.fNamespacePrefixes) {
                    int len = attributes.getLength();
                    int i = len - 1;
                    while (i >= 0) {
                        attributes.getName(i, this.fQName);
                        if (this.fQName.rawname == this.fXmlnsSymbol || this.fQName.prefix == this.fXmlnsSymbol) {
                            attributes.removeAttributeAt(i);
                        }
                        --i;
                    }
                }
                String uri = element.uri != null ? element.uri : this.fEmptySymbol;
                String localpart = this.fNamespaces ? element.localpart : this.fEmptySymbol;
                this.fAttributesProxy.setAttributes(attributes);
                this.fContentHandler.startElement(uri, localpart, element.rawname, this.fAttributesProxy);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void characters(XMLString text) throws XNIException {
        if (this.fInDTD) {
            return;
        }
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.characters(text.ch, text.offset, text.length);
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.characters(text.ch, text.offset, text.length);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void ignorableWhitespace(XMLString text) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.ignorableWhitespace(text.ch, text.offset, text.length);
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.ignorableWhitespace(text.ch, text.offset, text.length);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void endElement(QName element) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.endElement(element.rawname);
            }
            if (this.fContentHandler != null) {
                String uri = element.uri != null ? element.uri : this.fEmptySymbol;
                String localpart = this.fNamespaces ? element.localpart : this.fEmptySymbol;
                this.fContentHandler.endElement(uri, localpart, element.rawname);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void endPrefixMapping(String prefix) throws XNIException {
        try {
            if (this.fContentHandler != null) {
                this.fContentHandler.endPrefixMapping(prefix);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void endDocument() throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.endDocument();
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.endDocument();
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void startEntity(String name, String publicId, String systemId, String baseSystemId, String encoding) throws XNIException {
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startEntity(name);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void endEntity(String name) throws XNIException {
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.endEntity(name);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void startCDATA() throws XNIException {
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startCDATA();
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void endCDATA() throws XNIException {
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.endCDATA();
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void comment(XMLString text) throws XNIException {
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.comment(text.ch, 0, text.length);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void processingInstruction(String target, XMLString data) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.processingInstruction(target, data.toString());
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.processingInstruction(target, data.toString());
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void elementDecl(String name, String contentModel) throws XNIException {
        try {
            if (this.fDeclHandler != null) {
                this.fDeclHandler.elementDecl(name, contentModel);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue) throws XNIException {
        try {
            if (this.fDeclHandler != null) {
                if (type.equals("NOTATION")) {
                    StringBuffer str = new StringBuffer();
                    str.append(type);
                    str.append(" (");
                    int i = 0;
                    while (i < enumeration.length) {
                        str.append(enumeration[i]);
                        if (i < enumeration.length - 1) {
                            str.append('|');
                        }
                        ++i;
                    }
                    str.append(')');
                    type = str.toString();
                }
                String value = defaultValue.toString();
                this.fDeclHandler.attributeDecl(elementName, attributeName, type, defaultType, value);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText) throws XNIException {
        try {
            if (this.fDeclHandler != null) {
                this.fDeclHandler.internalEntityDecl(name, text.toString());
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId, String baseSystemId) throws XNIException {
        try {
            if (this.fDeclHandler != null) {
                this.fDeclHandler.externalEntityDecl(name, publicId, systemId);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) throws XNIException {
        try {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.unparsedEntityDecl(name, publicId, systemId, notation);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws XNIException {
        try {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.notationDecl(name, publicId, systemId);
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    public void endDTD() throws XNIException {
        this.fInDTD = false;
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.endDTD();
            }
        }
        catch (SAXException e) {
            throw new XNIException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(String systemId) throws SAXException, IOException {
        XMLInputSource source = new XMLInputSource(null, systemId, null);
        try {
            try {
                this.parse(source);
            }
            catch (XNIException e) {
                Exception ex = e.getException();
                if (ex == null) {
                    throw new SAXException(e.getMessage());
                }
                if (ex instanceof SAXException) {
                    throw (SAXException)ex;
                }
                if (!(ex instanceof IOException)) throw new SAXException(ex);
                throw (IOException)ex;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            try {
                Reader reader = source.getCharacterStream();
                if (reader != null) {
                    reader.close();
                    throw throwable;
                }
                InputStream is = source.getByteStream();
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        Reader reader = source.getCharacterStream();
        if (reader != null) {
            reader.close();
            return;
        }
        InputStream is = source.getByteStream();
        if (is == null) return;
        is.close();
        return;
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        try {
            XMLInputSource xmlInputSource = new XMLInputSource(inputSource.getPublicId(), inputSource.getSystemId(), null);
            xmlInputSource.setByteStream(inputSource.getByteStream());
            xmlInputSource.setCharacterStream(inputSource.getCharacterStream());
            xmlInputSource.setEncoding(inputSource.getEncoding());
            this.parse(xmlInputSource);
        }
        catch (XNIException e) {
            Exception ex = e.getException();
            if (ex == null) {
                throw new SAXException(e.getMessage());
            }
            if (ex instanceof SAXException) {
                throw (SAXException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new SAXException(ex);
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
        try {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new EntityResolverWrapper(resolver));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public EntityResolver getEntityResolver() {
        EntityResolver entityResolver = null;
        try {
            XMLEntityResolver xmlEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
            if (xmlEntityResolver != null && xmlEntityResolver instanceof EntityResolverWrapper) {
                entityResolver = ((EntityResolverWrapper)xmlEntityResolver).getEntityResolver();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        try {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", new ErrorHandlerWrapper(errorHandler));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = null;
        try {
            XMLErrorHandler xmlErrorHandler = (XMLErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
            if (xmlErrorHandler != null && xmlErrorHandler instanceof ErrorHandlerWrapper) {
                errorHandler = ((ErrorHandlerWrapper)xmlErrorHandler).getErrorHandler();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return errorHandler;
    }

    public void setLocale(Locale locale) throws SAXException {
        this.fConfiguration.setLocale(locale);
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        if (dtdHandler == null) {
            throw new NullPointerException();
        }
        this.fDTDHandler = dtdHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fContentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setFeature(String featureId, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (featureId.startsWith("http://xml.org/sax/features/")) {
                String feature = featureId.substring("http://xml.org/sax/features/".length());
                if (feature.equals("namespaces")) {
                    this.fConfiguration.setFeature(featureId, state);
                    this.fNamespaces = state;
                    return;
                }
                if (feature.equals("namespace-prefixes")) {
                    this.fConfiguration.setFeature(featureId, state);
                    this.fNamespacePrefixes = state;
                    return;
                }
                if (feature.equals("string-interning")) {
                    if (state) {
                        throw new SAXNotSupportedException("PAR018 " + state + " state for feature \"" + featureId + "\" is not supported.\n" + state + '\t' + featureId);
                    }
                    return;
                }
            }
            this.fConfiguration.setFeature(featureId, state);
        }
        catch (XMLConfigurationException e) {
            String message = e.getMessage();
            if (e.getType() == 0) {
                throw new SAXNotRecognizedException(message);
            }
            throw new SAXNotSupportedException(message);
        }
    }

    public boolean getFeature(String featureId) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (featureId.startsWith("http://xml.org/sax/features/")) {
                String feature = featureId.substring("http://xml.org/sax/features/".length());
                if (feature.equals("namespace-prefixes")) {
                    boolean state = this.fConfiguration.getFeature(featureId);
                    return state;
                }
                if (feature.equals("string-interning")) {
                    return false;
                }
            }
            return this.fConfiguration.getFeature(featureId);
        }
        catch (XMLConfigurationException e) {
            String message = e.getMessage();
            if (e.getType() == 0) {
                throw new SAXNotRecognizedException(message);
            }
            throw new SAXNotSupportedException(message);
        }
    }

    public void setProperty(String propertyId, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (propertyId.startsWith("http://xml.org/sax/properties/")) {
                String property = propertyId.substring("http://xml.org/sax/properties/".length());
                if (property.equals("lexical-handler")) {
                    try {
                        this.setLexicalHandler((LexicalHandler)value);
                    }
                    catch (ClassCastException e) {
                        throw new SAXNotSupportedException("PAR012 For propertyID \"" + propertyId + "\", the value \"" + value + "\" cannot be cast to LexicalHandler." + '\n' + propertyId + '\t' + value + "\tLexicalHandler");
                    }
                    return;
                }
                if (property.equals("declaration-handler")) {
                    try {
                        this.setDeclHandler((DeclHandler)value);
                    }
                    catch (ClassCastException e) {
                        throw new SAXNotSupportedException("PAR012 For propertyID \"" + propertyId + "\", the value \"" + value + "\" cannot be cast to DeclHandler." + '\n' + propertyId + '\t' + value + "\tDeclHandler");
                    }
                    return;
                }
                if (property.equals("dom-node")) {
                    throw new SAXNotSupportedException("PAR013 Property \"" + propertyId + "\" is read only." + '\n' + propertyId);
                }
            }
            this.fConfiguration.setProperty(propertyId, value);
        }
        catch (XMLConfigurationException e) {
            String message = e.getMessage();
            if (e.getType() == 0) {
                throw new SAXNotRecognizedException(message);
            }
            throw new SAXNotSupportedException(message);
        }
    }

    public Object getProperty(String propertyId) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (propertyId.startsWith("http://xml.org/sax/properties/")) {
                String property = propertyId.substring("http://xml.org/sax/properties/".length());
                if (property.equals("lexical-handler")) {
                    return this.getLexicalHandler();
                }
                if (property.equals("declaration-handler")) {
                    return this.getDeclHandler();
                }
                if (property.equals("dom-node")) {
                    throw new SAXNotSupportedException("PAR014 Cannot getProperty(\"" + propertyId + "\". No DOM Tree exists.\n" + propertyId);
                }
            }
            return this.fConfiguration.getProperty(propertyId);
        }
        catch (XMLConfigurationException e) {
            String message = e.getMessage();
            if (e.getType() == 0) {
                throw new SAXNotRecognizedException(message);
            }
            throw new SAXNotSupportedException(message);
        }
    }

    protected void setDeclHandler(DeclHandler handler) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR011 Feature: http://xml.org/sax/properties/declaration-handler is not supported during parse.\nhttp://xml.org/sax/properties/declaration-handler");
        }
        this.fDeclHandler = handler;
    }

    protected DeclHandler getDeclHandler() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fDeclHandler;
    }

    protected void setLexicalHandler(LexicalHandler handler) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR011 Feature: http://xml.org/sax/properties/lexical-handler is not supported during parse.\nhttp://xml.org/sax/properties/lexical-handler");
        }
        this.fLexicalHandler = handler;
    }

    protected LexicalHandler getLexicalHandler() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fLexicalHandler;
    }

    public void reset() throws XNIException {
        super.reset();
        this.fInDTD = false;
        this.fNamespaces = this.fConfiguration.getFeature(NAMESPACES);
        this.fNamespacePrefixes = this.fConfiguration.getFeature(NAMESPACE_PREFIXES);
        SymbolTable symbolTable = (SymbolTable)this.fConfiguration.getProperty(SYMBOL_TABLE);
        if (symbolTable != null) {
            this.fEmptySymbol = symbolTable.addSymbol("");
            this.fXmlnsSymbol = symbolTable.addSymbol("xmlns");
        }
    }

    protected static final class AttributesProxy
    implements AttributeList,
    Attributes {
        protected XMLAttributes fAttributes;

        protected AttributesProxy() {
        }

        public void setAttributes(XMLAttributes attributes) {
            this.fAttributes = attributes;
        }

        public int getLength() {
            return this.fAttributes.getLength();
        }

        public String getName(int i) {
            return this.fAttributes.getQName(i);
        }

        public String getQName(int index) {
            return this.fAttributes.getQName(index);
        }

        public String getURI(int index) {
            return this.fAttributes.getURI(index);
        }

        public String getLocalName(int index) {
            return this.fAttributes.getLocalName(index);
        }

        public String getType(int i) {
            return this.fAttributes.getType(i);
        }

        public String getType(String name) {
            return this.fAttributes.getType(name);
        }

        public String getType(String uri, String localName) {
            return this.fAttributes.getType(uri, localName);
        }

        public String getValue(int i) {
            return this.fAttributes.getValue(i);
        }

        public String getValue(String name) {
            return this.fAttributes.getValue(name);
        }

        public String getValue(String uri, String localName) {
            return this.fAttributes.getValue(uri, localName);
        }

        public int getIndex(String qName) {
            return this.fAttributes.getIndex(qName);
        }

        public int getIndex(String uri, String localPart) {
            return this.fAttributes.getIndex(uri, localPart);
        }
    }

    protected static class LocatorProxy
    implements Locator {
        protected XMLLocator fLocator;

        public LocatorProxy(XMLLocator locator) {
            this.fLocator = locator;
        }

        public String getPublicId() {
            return this.fLocator.getPublicId();
        }

        public String getSystemId() {
            return this.fLocator.getSystemId();
        }

        public int getLineNumber() {
            return this.fLocator.getLineNumber();
        }

        public int getColumnNumber() {
            return this.fLocator.getColumnNumber();
        }
    }
}

