/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Hashtable;
import org.apache.xerces.impl.xs.SchemaGrammar;

public class XSGrammarResolver {
    private Hashtable fGrammarRegistry = new Hashtable();
    private SchemaGrammar fNoNSGrammar = null;

    public SchemaGrammar getGrammar(String namespace) {
        if (namespace == null) {
            return this.fNoNSGrammar;
        }
        return (SchemaGrammar)this.fGrammarRegistry.get(namespace);
    }

    public void putGrammar(SchemaGrammar grammar) {
        if (grammar.getTargetNamespace() == null) {
            this.fNoNSGrammar = grammar;
        } else {
            this.fGrammarRegistry.put(grammar.getTargetNamespace(), grammar);
        }
    }

    public void putGrammar(String namespace, SchemaGrammar grammar) {
        if (namespace == null) {
            this.fNoNSGrammar = grammar;
        } else {
            this.fGrammarRegistry.put(namespace, grammar);
        }
    }

    public boolean contains(String namespace) {
        if (namespace == null) {
            return this.fNoNSGrammar != null;
        }
        return this.fGrammarRegistry.containsKey(namespace);
    }

    public void reset() {
        this.fNoNSGrammar = null;
        this.fGrammarRegistry.clear();
    }
}

