/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xs.SchemaSymbols;

public abstract class AbstractNumericFacetValidator
extends AbstractDatatypeValidator {
    protected Object[] fEnumeration;
    protected Object fMaxInclusive;
    protected Object fMaxExclusive;
    protected Object fMinInclusive;
    protected Object fMinExclusive;
    protected static final short INDETERMINATE = 2;

    public AbstractNumericFacetValidator() {
        this(null, null, false, null);
    }

    public AbstractNumericFacetValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList, XMLErrorReporter reporter) {
        block56: {
            this.fEnumeration = null;
            this.fMaxInclusive = null;
            this.fMaxExclusive = null;
            this.fMinInclusive = null;
            this.fMinExclusive = null;
            this.fBaseValidator = base;
            this.fErrorReporter = reporter;
            if (derivedByList) {
                return;
            }
            try {
                int result;
                this.initializeValues();
                if (facets == null) break block56;
                Vector enumeration = null;
                Enumeration e = facets.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = null;
                    if (key.equals(SchemaSymbols.ELT_PATTERN)) {
                        this.fPattern = (String)facets.get(key);
                        if (this.fPattern != null) {
                            this.fRegex = new RegularExpression(this.fPattern, "X");
                        }
                        if (this.fRegex == null) continue;
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                        continue;
                    }
                    if (key.equals(SchemaSymbols.ELT_ENUMERATION)) {
                        enumeration = (Vector)facets.get(key);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                        continue;
                    }
                    if (key.equals(SchemaSymbols.ELT_MAXINCLUSIVE)) {
                        value = (String)facets.get(key);
                        this.setMaxInclusive(value);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                        continue;
                    }
                    if (key.equals(SchemaSymbols.ELT_MAXEXCLUSIVE)) {
                        value = (String)facets.get(key);
                        this.setMaxExclusive(value);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                        continue;
                    }
                    if (key.equals(SchemaSymbols.ELT_MININCLUSIVE)) {
                        value = (String)facets.get(key);
                        this.setMinInclusive(value);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                        continue;
                    }
                    if (key.equals(SchemaSymbols.ELT_MINEXCLUSIVE)) {
                        value = (String)facets.get(key);
                        this.setMinExclusive(value);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                        continue;
                    }
                    if (key.equals("fixed")) {
                        this.fFlags = (Short)facets.get(key);
                        continue;
                    }
                    this.assignAdditionalFacets(key, facets);
                }
                if (this.fFacetsDefined != 0) {
                    if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x20) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
                    }
                    if ((this.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x80) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
                    }
                    if ((this.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x80) != 0 && ((result = this.compareValues(this.fMinInclusive, this.fMaxInclusive)) == 1 || result == 2)) {
                        throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "'must be <= maxInclusive value ='" + this.getMaxInclusive(false) + "'. ");
                    }
                    if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x100) != 0 && ((result = this.compareValues(this.fMinExclusive, this.fMaxExclusive)) == 1 || result == 2)) {
                        throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "'must be <= maxExclusive value ='" + this.getMaxExclusive(false) + "'. ");
                    }
                    if ((this.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMinExclusive, this.fMaxInclusive) != -1) {
                        throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "'must be > maxInclusive value ='" + this.getMaxInclusive(false) + "'. ");
                    }
                    if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x80) != 0 && this.compareValues(this.fMinInclusive, this.fMaxExclusive) != -1) {
                        throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "'must be < maxExclusive value ='" + this.getMaxExclusive(false) + "'. ");
                    }
                    this.checkFacetConstraints();
                }
                if (base == null) break block56;
                AbstractNumericFacetValidator numBase = (AbstractNumericFacetValidator)base;
                if (this.fFacetsDefined != 0) {
                    if ((this.fFacetsDefined & 0x20) != 0) {
                        if ((numBase.fFacetsDefined & 0x20) != 0) {
                            result = this.compareValues(this.fMaxInclusive, numBase.fMaxInclusive);
                            if ((numBase.fFlags & 0x20) != 0 && result != 0) {
                                throw new InvalidDatatypeFacetException("maxInclusive value = '" + this.getMaxInclusive(false) + "' must be equal to base.maxInclusive value = '" + this.getMaxInclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (result == 1 || result == 2) {
                                throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                            }
                        }
                        if ((numBase.fFacetsDefined & 0x40) != 0 && this.compareValues(this.fMaxInclusive, numBase.fMaxExclusive) != -1) {
                            throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x80) != 0 && ((result = this.compareValues(this.fMaxInclusive, numBase.fMinInclusive)) == -1 || result == 2)) {
                            throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be >= base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMaxInclusive, numBase.fMinExclusive) != 1) {
                            throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be > base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                        }
                    }
                    if ((this.fFacetsDefined & 0x40) != 0) {
                        if ((numBase.fFacetsDefined & 0x40) != 0) {
                            result = this.compareValues(this.fMaxExclusive, numBase.fMaxExclusive);
                            if ((numBase.fFlags & 0x40) != 0 && result != 0) {
                                throw new InvalidDatatypeFacetException("maxExclusive value = '" + this.getMaxExclusive(false) + "' must be equal to base.maxExclusive value = '" + this.getMaxExclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (result == 1 || result == 2) {
                                throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                            }
                        }
                        if ((numBase.fFacetsDefined & 0x20) != 0 && ((result = this.compareValues(this.fMaxExclusive, numBase.fMaxInclusive)) == 1 || result == 2)) {
                            throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMaxExclusive, numBase.fMinExclusive) != 1) {
                            throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be > base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x80) != 0 && this.compareValues(this.fMaxExclusive, numBase.fMinInclusive) != 1) {
                            throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be > base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                        }
                    }
                    if ((this.fFacetsDefined & 0x100) != 0) {
                        if ((numBase.fFacetsDefined & 0x100) != 0) {
                            result = this.compareValues(this.fMinExclusive, numBase.fMinExclusive);
                            if ((numBase.fFlags & 0x100) != 0 && result != 0) {
                                throw new InvalidDatatypeFacetException("minExclusive value = '" + this.getMinExclusive(false) + "' must be equal to base.minExclusive value = '" + this.getMinExclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (result == -1 || result == 2) {
                                throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be >= base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                            }
                        }
                        if ((numBase.fFacetsDefined & 0x20) != 0 && ((result = this.compareValues(this.fMinExclusive, numBase.fMaxInclusive)) == 1 || result == 2)) {
                            throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x80) != 0 && ((result = this.compareValues(this.fMinExclusive, numBase.fMinInclusive)) == -1 || result == 2)) {
                            throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be >= base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x40) != 0 && this.compareValues(this.fMinExclusive, numBase.fMaxExclusive) != -1) {
                            throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                        }
                    }
                    if ((this.fFacetsDefined & 0x80) != 0) {
                        if ((numBase.fFacetsDefined & 0x80) != 0) {
                            result = this.compareValues(this.fMinInclusive, numBase.fMinInclusive);
                            if ((numBase.fFlags & 0x80) != 0 && result != 0) {
                                throw new InvalidDatatypeFacetException("minInclusive value = '" + this.getMinInclusive(false) + "' must be equal to base.minInclusive value = '" + this.getMinInclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (result == -1 || result == 2) {
                                throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be >= base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                            }
                        }
                        if ((numBase.fFacetsDefined & 0x20) != 0 && ((result = this.compareValues(this.fMinInclusive, numBase.fMaxInclusive)) == 1 || result == 2)) {
                            throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMinInclusive, numBase.fMinExclusive) != 1) {
                            throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be > base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x40) != 0 && this.compareValues(this.fMinInclusive, numBase.fMaxExclusive) != -1) {
                            throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                        }
                    }
                    this.checkBaseFacetConstraints();
                }
                if ((this.fFacetsDefined & 0x10) == 0 && (numBase.fFacetsDefined & 0x10) != 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    this.fEnumeration = numBase.fEnumeration;
                }
                if ((numBase.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x20) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                    this.fMaxExclusive = numBase.fMaxExclusive;
                }
                if ((numBase.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x20) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                    this.fMaxInclusive = numBase.fMaxInclusive;
                }
                if ((numBase.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                    this.fMinExclusive = numBase.fMinExclusive;
                }
                if ((numBase.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                    this.fMinInclusive = numBase.fMinInclusive;
                }
                this.inheritAdditionalFacets();
                this.fFlags = (short)(this.fFlags | numBase.fFlags);
                if ((this.fFacetsDefined & 0x10) == 0 || enumeration == null) break block56;
                try {
                    this.setEnumeration(enumeration);
                }
                catch (Exception idve) {
                    throw new InvalidDatatypeFacetException(idve.getMessage());
                }
            }
            catch (Exception e) {
                if (this.fErrorReporter == null) {
                    throw new RuntimeException("InternalDatatype error ANFV.");
                }
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "DatatypeFacetError", new Object[]{e.getMessage()}, (short)1);
            }
        }
    }

    protected abstract int compareValues(Object var1, Object var2);

    protected abstract void setMaxInclusive(String var1);

    protected abstract void setMinInclusive(String var1);

    protected abstract void setMaxExclusive(String var1);

    protected abstract void setMinExclusive(String var1);

    protected abstract void setEnumeration(Vector var1) throws InvalidDatatypeValueException;

    protected abstract String getMaxInclusive(boolean var1);

    protected abstract String getMinInclusive(boolean var1);

    protected abstract String getMaxExclusive(boolean var1);

    protected abstract String getMinExclusive(boolean var1);

    protected void initializeValues() {
    }

    public boolean hasEnumeration() {
        return this.fEnumeration != null;
    }

    protected abstract void assignAdditionalFacets(String var1, Hashtable var2) throws InvalidDatatypeFacetException;

    protected void inheritAdditionalFacets() {
    }

    protected void checkBaseFacetConstraints() throws InvalidDatatypeFacetException {
    }

    protected void checkFacetConstraints() throws InvalidDatatypeFacetException {
    }
}

