/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqldbctest;

import com.sap.sapdb.sqldbctest.SQLDBCTest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class TestProgramRunner
extends Thread {
    private String commandline;
    private String commandonly;
    private String parameter;
    private SQLDBCTest testcase;
    private Vector infoMessages;
    private Vector errorMessages;
    private Process runningProgram;
    private int runningStatus;
    private boolean good = true;
    private int acceptedExitCode = 0;
    private String referenceProtocolNameSTDERR;
    private String referenceProtocolNameSTDOUT;
    private Vector referenceProtocolSTDERR;
    private Vector referenceProtocolSTDOUT;
    private Vector protocolSTDERR;
    private Vector protocolSTDOUT;
    private static final int STDERR = 2;
    private static final int STDOUT = 1;

    public TestProgramRunner(String string, SQLDBCTest sQLDBCTest) {
        this.parameter = string;
        this.testcase = sQLDBCTest;
        this.infoMessages = new Vector();
        this.errorMessages = new Vector();
        this.runningStatus = 0;
        this.initCommandLine(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.good) {
            this.testcase.message("", 'E', "Running test specified by parameter " + this.parameter + " failed in initialisation.");
        }
        SQLDBCTest.println("######################################################################");
        Thread thread = this;
        synchronized (thread) {
            this.runningStatus = 1;
        }
        try {
            SQLDBCTest.println("Executing " + this.commandline + " in " + SQLDBCTest.getSQLDBCTestRoot() + ".");
            this.runningProgram = Runtime.getRuntime().exec(this.commandline, null, SQLDBCTest.getSQLDBCTestRoot());
        }
        catch (IOException iOException) {
            this.testcase.message("", 'E', "Program execution failed: " + iOException.getMessage() + "\n" + "wanted to execute: " + this.getCommandLine());
            SQLDBCTest.println("######################################################################");
            return;
        }
        thread = new TestOutputReader(this.runningProgram.getErrorStream(), 2);
        TestOutputReader testOutputReader = new TestOutputReader(this.runningProgram.getInputStream(), 1);
        thread.start();
        testOutputReader.start();
        int n = 0;
        try {
            this.runningProgram.waitFor();
            n = 1;
            thread.join();
            n = 2;
            testOutputReader.join();
            n = 3;
            TestProgramRunner testProgramRunner = this;
            synchronized (testProgramRunner) {
                this.runningStatus = 2;
            }
            int n2 = this.runningProgram.exitValue();
            if (n2 == this.acceptedExitCode) {
                this.testcase.message("", 'I', this.commandonly + " successful.");
            } else {
                this.testcase.message("", 'E', this.commandonly + " failed, exit code " + n2 + " instead of " + this.acceptedExitCode + ", error output follows.");
                String string = this.makeStringFromVector(this.errorMessages);
                this.testcase.message("", 'E', string);
            }
            if (this.protocolSTDERR != null) {
                this.compareProtocols(this.protocolSTDERR, this.referenceProtocolSTDERR, this.referenceProtocolNameSTDERR);
            }
            if (this.protocolSTDOUT != null) {
                this.compareProtocols(this.protocolSTDOUT, this.referenceProtocolSTDOUT, this.referenceProtocolNameSTDOUT);
            }
        }
        catch (InterruptedException interruptedException) {
            if (n == 0) {
                this.testcase.message("", 'E', "Test Program was interrupted.\nCommand Line: " + this.getCommandLine());
                this.runningProgram.destroy();
                this.testcase.notifySuccessfulInterrupt(1);
                SQLDBCTest.println("######################################################################");
                return;
            }
            switch (n) {
                case 1: {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException2) {
                        // empty catch block
                    }
                }
                case 2: {
                    try {
                        testOutputReader.join();
                        break;
                    }
                    catch (InterruptedException interruptedException3) {
                        // empty catch block
                    }
                }
            }
            TestProgramRunner testProgramRunner = this;
            synchronized (testProgramRunner) {
                this.runningStatus = 2;
            }
            int n3 = this.runningProgram.exitValue();
            if (n3 == this.acceptedExitCode) {
                this.testcase.message("", 'I', this.commandonly + " successful.");
            } else {
                this.testcase.message("", 'E', this.commandonly + " failed, exit code " + n3 + "instead of " + this.acceptedExitCode + ", error output follows.");
                String string = this.makeStringFromVector(this.errorMessages);
                this.testcase.message("", 'E', string);
            }
            if (this.protocolSTDERR != null) {
                this.compareProtocols(this.protocolSTDERR, this.referenceProtocolSTDERR, this.referenceProtocolNameSTDERR);
            }
            if (this.protocolSTDOUT != null) {
                this.compareProtocols(this.protocolSTDOUT, this.referenceProtocolSTDOUT, this.referenceProtocolNameSTDOUT);
            }
            this.testcase.notifySuccessfulInterrupt(2);
        }
        SQLDBCTest.println("######################################################################");
    }

    private String makeStringFromVector(Vector vector) {
        Enumeration enumeration = vector.elements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append("\n");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptExecution() {
        TestProgramRunner testProgramRunner = this;
        synchronized (testProgramRunner) {
            if (this.runningStatus == 1) {
                this.interrupt();
            } else if (this.runningStatus == 2) {
                while (this.runningStatus == 2) {
                    try {
                        TestProgramRunner.sleep(10L);
                    }
                    catch (Exception exception) {
                    }
                    this.yield();
                }
                this.testcase.notifySuccessfulInterrupt(2);
            } else {
                return;
            }
        }
    }

    private void initCommandLine(String string) {
        Object object;
        if ((string = string.trim()).startsWith("::")) {
            int n = string.indexOf("::", 2);
            if (n == -1) {
                this.good = false;
                return;
            }
            object = string.substring(2, n);
            this.initAdditionalParameters((String)object);
            string = string.substring(n + 2);
        }
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        try {
            TestProgramRunner testProgramRunner = this;
            object = testProgramRunner.testcase.getDatabase();
            String[] stringArray = new String[]{"$database", "$node", "$user", "$password", "$testpath"};
            String[] stringArray2 = new String[]{object.getName(), object.getHost(), SQLDBCTest.getTestUser(), SQLDBCTest.getTestUser(), SQLDBCTest.getSQLDBCTestRoot().getCanonicalPath()};
            if (object.getPort() != 7210) {
                stringArray2[1] = object.getHost() + ":" + object.getPort();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                int n = -1;
                while ((n = (string2 = stringBuffer.toString()).indexOf(stringArray[i])) != -1) {
                    stringBuffer.replace(n, n + stringArray[i].length(), stringArray2[i]);
                }
            }
            String string3 = stringBuffer.toString();
            String string4 = this.commandonly = string3.indexOf(32) == -1 ? string3 : string3.substring(0, string3.indexOf(32));
            if (SQLDBCTest.isTestVariableInput() && !this.commandonly.equals("sqldbc_cons")) {
                string3 = string3 + " -p VARIABLEINPUT=1";
            }
            this.commandline = SQLDBCTest.getSQLDBCTestRoot() + File.separator + string3;
        }
        catch (IOException iOException) {
            this.good = false;
            this.testcase.message("", 'E', "IO Exception: " + iOException.getMessage());
        }
    }

    private void initAdditionalParameters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("@");
            if (n == -1) {
                this.good = false;
                this.testcase.message("", 'E', "Missing '=' in detailed test specification.");
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (string3.equalsIgnoreCase("EXITCODE")) {
                this.acceptedExitCode = Integer.parseInt(string4);
                continue;
            }
            if (string3.equalsIgnoreCase("STDERR")) {
                this.referenceProtocolNameSTDERR = string4;
                this.referenceProtocolSTDERR = this.readReferenceProtocol(string4);
                this.protocolSTDERR = new Vector();
                continue;
            }
            if (string3.equalsIgnoreCase("STDOUT")) {
                this.referenceProtocolNameSTDOUT = string4;
                this.referenceProtocolSTDOUT = this.readReferenceProtocol(string4);
                this.protocolSTDOUT = new Vector();
                continue;
            }
            this.testcase.message("", 'W', "Ignoring unknown detail specification '" + string3 + "'");
        }
    }

    Vector readReferenceProtocol(String string) {
        try {
            String string2;
            TestProgramRunner testProgramRunner = this;
            File file = new File(testProgramRunner.testcase.getSQLDBCTestRoot(), string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Vector<String> vector = new Vector<String>();
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.addElement(string2);
            }
            return vector;
        }
        catch (IOException iOException) {
            this.testcase.message("", 'E', "IOException reading reference protocol file : " + string + "\n " + iOException.getMessage());
            this.good = false;
            return null;
        }
    }

    public String getCommandLine() {
        return this.commandline;
    }

    private synchronized void addMessage(String string, int n) {
        SQLDBCTest.println(string);
        int n2 = 0;
        if (n == 2 && this.protocolSTDERR != null) {
            this.protocolSTDERR.addElement(string);
        }
        if (n == 1 && this.protocolSTDOUT != null) {
            this.protocolSTDOUT.addElement(string);
        }
        if (string.startsWith("INFO:")) {
            n2 = (string = string.substring(5)).indexOf(58, 2);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            this.infoMessages.add(string);
            return;
        }
        if (string.startsWith("ERROR:")) {
            n2 = (string = string.substring(6)).indexOf(58, 2);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            this.errorMessages.add(string);
            return;
        }
        this.infoMessages.add(string);
    }

    private void writeTestProtocol(Vector vector, String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(new File(this.testcase.getProtocolDir(), string + ".testrun")));
            for (int i = 0; i < vector.size(); ++i) {
                printStream.println("" + vector.elementAt(i));
            }
            printStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void compareProtocols(Vector vector, Vector vector2, String string) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        while (n < vector.size() || n2 < vector2.size()) {
            String string2;
            if (n >= vector.size()) {
                while (n2 < vector2.size()) {
                    string2 = (String)vector2.elementAt(n2);
                    if (string2.trim().length() == 0 || string2.startsWith("//")) {
                        ++n2;
                        continue;
                    }
                    this.testcase.message("", 'E', "Protocol file " + string + " has " + (vector2.size() - n2) + " differences (reference protocol is longer).");
                    for (int i = n2; i < vector2.size(); ++i) {
                        SQLDBCTest.println("reference: " + vector2.elementAt(i));
                    }
                    this.writeTestProtocol(vector, string);
                    return;
                }
                break;
            }
            if (n2 >= vector2.size()) {
                while (n < vector.size()) {
                    string2 = (String)vector.elementAt(n);
                    if (string2.trim().length() == 0) {
                        ++n;
                        continue;
                    }
                    this.testcase.message("", 'E', "Protocol file " + string + " has " + (vector.size() - n) + " differences (protocol is longer).");
                    for (int i = n; i < vector.size(); ++i) {
                        SQLDBCTest.println("protocol: " + vector.elementAt(i));
                    }
                    this.writeTestProtocol(vector, string);
                    return;
                }
                break;
            }
            if (vector.elementAt(n).equals(vector2.elementAt(n2))) {
                ++n;
                ++n2;
                continue;
            }
            string2 = (String)vector2.elementAt(n2);
            if (string2.startsWith("//")) {
                ++n;
                ++n2;
                continue;
            }
            if (++n4 == 1 || n3 != n - 1) {
                SQLDBCTest.println("DIFF " + string + " from line " + (n + 1));
            }
            SQLDBCTest.println("reference: " + vector2.elementAt(n));
            SQLDBCTest.println("protocol: " + vector.elementAt(n2));
            n3 = n++;
            ++n2;
        }
        if (n4 > 0) {
            this.testcase.message("", 'E', "Protocol file " + string + " has " + n4 + " line differences.");
            this.writeTestProtocol(vector, string);
            return;
        }
    }

    private class TestOutputReader
    extends Thread {
        private BufferedReader input;
        private int category;

        TestOutputReader(InputStream inputStream, int n) {
            this.input = new BufferedReader(new InputStreamReader(inputStream));
            this.category = n;
        }

        public void run() {
            try {
                String string = null;
                while ((string = this.input.readLine()) != null) {
                    TestProgramRunner.this.addMessage(string, this.category);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

