/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.oltptest.sqlmanager.DatabaseObject;
import com.sap.sapdb.oltptest.sqlmanager.QueryTests;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DynamicTables
extends TestCase {
    private static Properties DBAConnectionInternalProperties;
    private static Properties DBAConnectionOracleProperties;
    private static String SCHEMANAME;
    private String testrunname;
    private static final int USERCOUNT = 1;
    private static int TABLECOUNT;
    private static int MAXCOLUMNCOUNT;
    private static int MAXDATACOUNT;
    private Vector tableList = new Vector();
    private boolean UNICODE;
    private String DATABASEVERSION;
    private String stopOnError = "0";
    private boolean USEPREPAREDSTATEMENTS;
    private QueryTests tests;

    static {
        SCHEMANAME = "TESTSCHEMA";
        TABLECOUNT = 100;
        MAXCOLUMNCOUNT = 15;
        MAXDATACOUNT = 500;
    }

    public static void prepare() throws TestCaseException {
        System.out.println("Prepare of " + DynamicTables.getTestClassId());
        DBAConnectionInternalProperties = new Properties();
        DBAConnectionOracleProperties = new Properties();
        DBAConnectionInternalProperties.put("user", TestCase.getUser());
        DBAConnectionInternalProperties.put("password", TestCase.getPassword());
        DBAConnectionInternalProperties.put("autocommit", "on");
        DBAConnectionInternalProperties.put("sqlmode", "internal");
        DBAConnectionOracleProperties.put("user", TestCase.getUser());
        DBAConnectionOracleProperties.put("password", TestCase.getPassword());
        DBAConnectionOracleProperties.put("autocommit", "on");
        DBAConnectionOracleProperties.put("sqlmode", "Oracle");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block30: {
            table = null;
            DatabaseConnection = null;
            runStatement = null;
            fmt = new SimpleDateFormat();
            fmt.applyPattern("yyyy-MM-dd_HH-mm-ss");
            this.testrunname = String.valueOf(this.getTestId()) + "_Log_" + fmt.format(new Date());
            try {
                try {
                    System.out.println("Run of " + DynamicTables.getTestClassId());
                    DatabaseConnection = TestCase.getDatabase().connect(DynamicTables.DBAConnectionInternalProperties);
                    this.UNICODE = TestCase.getDatabase().executeDBMcmd("param_getvalue _UNICODE").trim().equalsIgnoreCase("yes") != false;
                    this.DATABASEVERSION = String.valueOf(((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion()) + "." + ((TestDatabaseSap)TestCase.getDatabase()).getKernelBuild().substring(0, 3);
                    WARNINGONLY = TestCase.getParameterString((String)"WARNINGONLY", (String)"");
                    st = new StringTokenizer(WARNINGONLY, ";,");
                    WARNINGONLYLIST = new Properties();
                    while (true) {
                        if (!st.hasMoreTokens()) {
                            DynamicTables.TABLECOUNT = Integer.parseInt(TestCase.getParameterString((String)"TABLECOUNT", (String)Integer.toString(DynamicTables.TABLECOUNT)));
                            this.USEPREPAREDSTATEMENTS = Boolean.valueOf(TestCase.getParameterString((String)"USEPREPARESTATEMENTS", (String)"true"));
                            this.stopOnError = TestCase.getParameterString((String)"StopOnError", (String)"0");
                            if (!this.stopOnError.equals("0")) {
                                TestCase.getDatabase().executeDBMcmd("util_connect");
                                TestCase.getDatabase().executeDBMcmd("util_execute DIAGNOSE VTRACE STOP ON ERROR " + this.stopOnError);
                                TestCase.getDatabase().executeDBMcmd("util_release");
                            }
                            System.out.println("Testrun: \t" + this.testrunname);
                            System.out.println("Usercount: \t1");
                            System.out.println("Unicode: \t" + this.UNICODE);
                            System.out.println("Tablecount: \t" + DynamicTables.TABLECOUNT + "  (Parameter: TABLECOUNT)");
                            System.out.println("MaxColumns: \t" + DynamicTables.MAXCOLUMNCOUNT);
                            System.out.println("MaxDatasets: \t" + DynamicTables.MAXDATACOUNT);
                            System.out.println("Stop on Error: \t" + TestCase.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)");
                            System.out.println("Known Errors: \t" + WARNINGONLY + "  (Parameter: WARNINGONLY)");
                            System.out.println("Use Prepared Statements: \t" + this.USEPREPAREDSTATEMENTS + "  (Parameter: USEPREPAREDSTATEMENTS)");
                            this.addMessage("", 'I', "Testrun: \t" + this.testrunname + "\nUsercount: \t" + 1 + "\nUnicode: \t" + this.UNICODE + "\nTablecount: \t" + DynamicTables.TABLECOUNT + "(Parameter: TABLECOUNT)" + "\nMaxColumns: \t" + DynamicTables.MAXCOLUMNCOUNT + "\nMaxDatasets: \t" + DynamicTables.MAXDATACOUNT + "\nStop on Error: \t" + TestCase.getParameterString((String)"StopOnError", (String)"0") + "  (Parameter: StopOnError)" + "\nKnown Errors: \t" + WARNINGONLY + " (Parameter: WARNINGONLY)" + "\nUse Prepared Statements: \t" + this.USEPREPAREDSTATEMENTS + "  (Parameter: USEPREPAREDSTATEMENTS)");
                            System.out.println("Data generation started");
                            this.tableList = TestDriver.compareRelease((String)this.DATABASEVERSION, (String)"<", (String)"7.6") != false ? this.createTables("DBA", "TAB", "COL", DynamicTables.TABLECOUNT, DynamicTables.MAXCOLUMNCOUNT, DynamicTables.MAXDATACOUNT, this.UNICODE) : this.createTables(DynamicTables.SCHEMANAME, "TAB", "COL", DynamicTables.TABLECOUNT, DynamicTables.MAXCOLUMNCOUNT, DynamicTables.MAXDATACOUNT, this.UNICODE);
                        }
                        WARNINGONLYLIST.setProperty(st.nextToken(), "");
                    }
                    System.out.println("Data generation finished");
                    var8_9 = null;
                    ** GOTO lbl79
                }
                catch (Exception e) {
                    this.handleExceptions(e);
                    ** GOTO lbl-1000
                }
            }
            catch (Throwable var9_24) {
                var8_10 = null;
                try {
                    block29: {
                        DatabaseConnection = TestCase.getDatabase().connect(DynamicTables.DBAConnectionInternalProperties);
                        runStatement = new TestStatement(null, DatabaseConnection);
                        if (TestDriver.compareRelease((String)this.DATABASEVERSION, (String)"<", (String)"7.6")) {
                            it = this.tableList.iterator();
                            table = null;
                            while (it.hasNext()) {
                                table = (DatabaseObject)it.next();
                                try {
                                    runStatement.executeUpdateIgnoreErrors(table.getSqlDropString());
                                }
                                catch (Exception e) {
                                    this.addMessage(String.valueOf(this.nextStep("")) + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e.toString());
                                }
                            }
                        } else {
                            try {
                                runStatement.executeUpdateIgnoreErrors("drop schema " + DynamicTables.SCHEMANAME);
                            }
                            catch (Exception e) {
                                this.addMessage(String.valueOf(this.nextStep("")) + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e.toString());
                            }
                        }
                        runStatement.close();
                        DatabaseConnection.commit();
                        DatabaseConnection.close();
                        throw var9_24;
lbl79:
                        // 1 sources

                        ** try [egrp 2[TRYBLOCK] [6 : 841->1075)] { 
lbl80:
                        // 1 sources

                        DatabaseConnection = TestCase.getDatabase().connect(DynamicTables.DBAConnectionInternalProperties);
                        runStatement = new TestStatement(null, DatabaseConnection);
                        if (TestDriver.compareRelease((String)this.DATABASEVERSION, (String)"<", (String)"7.6")) {
                            it = this.tableList.iterator();
                            table = null;
                            while (it.hasNext()) {
                                table = (DatabaseObject)it.next();
                                ** try [egrp 3[TRYBLOCK] [4 : 902->914)] { 
lbl88:
                                // 1 sources

                                runStatement.executeUpdateIgnoreErrors(table.getSqlDropString());
                                continue;
lbl91:
                                // 1 sources

                                catch (Exception e) {
                                    this.addMessage(String.valueOf(this.nextStep("")) + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e.toString());
                                }
                            }
                        } else {
                            ** try [egrp 4[TRYBLOCK] [5 : 978->1005)] { 
lbl96:
                            // 1 sources

                            runStatement.executeUpdateIgnoreErrors("drop schema " + DynamicTables.SCHEMANAME);
                        }
                        break block29;
lbl99:
                        // 1 sources

                        catch (Exception e) {
                            this.addMessage(String.valueOf(this.nextStep("")) + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e.toString());
                        }
                    }
                    runStatement.close();
                    DatabaseConnection.commit();
                    DatabaseConnection.close();
                    return;
                }
lbl106:
                // 1 sources

                catch (Exception var10_14) {
                    // empty catch block
                }
                return;
                catch (Exception var10_17) {
                    // empty catch block
                }
            }
            throw var9_24;
lbl-1000:
            // 1 sources

            {
                var8_11 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 841->1075)] { 
lbl114:
            // 1 sources

            DatabaseConnection = TestCase.getDatabase().connect(DynamicTables.DBAConnectionInternalProperties);
            runStatement = new TestStatement(null, DatabaseConnection);
            if (TestDriver.compareRelease((String)this.DATABASEVERSION, (String)"<", (String)"7.6")) {
                it = this.tableList.iterator();
                table = null;
                while (it.hasNext()) {
                    table = (DatabaseObject)it.next();
                    try {}
                    catch (Exception e) {
                        this.addMessage(String.valueOf(this.nextStep("")) + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e.toString());
                        continue;
                    }
                    runStatement.executeUpdateIgnoreErrors(table.getSqlDropString());
                }
            } else {
                ** try [egrp 4[TRYBLOCK] [5 : 978->1005)] { 
lbl130:
                // 1 sources

                runStatement.executeUpdateIgnoreErrors("drop schema " + DynamicTables.SCHEMANAME);
            }
            break block30;
lbl133:
            // 1 sources

            catch (Exception e) {
                this.addMessage(String.valueOf(this.nextStep("")) + "The SQL-statement " + runStatement.getSqlString() + " failed", 'W', e.toString());
            }
        }
        runStatement.close();
        DatabaseConnection.commit();
        DatabaseConnection.close();
        return;
lbl140:
        // 1 sources

        catch (Exception var10_20) {
            return;
        }
    }

    public String getLogFile() {
        return this.tests.getLogFile();
    }

    private Vector createTables(String schemaName, String tablePrefix, String columnPrefix, int tablecount, int maxColumnCount, int maxDataCount, boolean unicode) throws Exception {
        Vector<DatabaseObject> tableList = new Vector<DatabaseObject>();
        Connection DBConnection = TestCase.getDatabase().connect(DBAConnectionInternalProperties);
        TestStatement statement = new TestStatement(null, DBConnection);
        if (TestDriver.compareRelease((String)this.DATABASEVERSION, (String)">=", (String)"7.6")) {
            statement.executeUpdateIgnoreErrors("drop schema " + schemaName);
            statement.executeUpdate("create schema " + schemaName);
        }
        int i = 0;
        while (i < tablecount) {
            tableList.add(DatabaseObject.getRandomTable(schemaName, String.valueOf(tablePrefix) + i, columnPrefix, maxColumnCount, unicode));
            ++i;
        }
        Iterator it = tableList.iterator();
        while (it.hasNext()) {
            try {
                DatabaseObject dbo = (DatabaseObject)it.next();
                statement.executeUpdateIgnoreErrors(dbo.getSqlDropString());
                statement.execute(dbo.getSqlCreateString());
            }
            catch (SQLException e) {
                System.out.println(statement.getSqlString());
                e.printStackTrace();
            }
        }
        Iterator it2 = tableList.iterator();
        SimpleDateFormat TEST_TIME_FORMAT = new SimpleDateFormat("mm:ss.SSS");
        int i2 = 1;
        while (it2.hasNext() && i2 == 1) {
            DatabaseObject dbo = (DatabaseObject)it2.next();
            long time = System.currentTimeMillis();
            if (this.USEPREPAREDSTATEMENTS) {
                try {
                    dbo.insertRandomData(DBConnection, maxDataCount);
                    i2 = 2;
                    System.out.println("Table Creation " + dbo.getObjectIdentifier() + " Data Creation/Insertion: " + TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time)));
                }
                catch (Exception e) {
                    System.out.println(statement.getSqlString());
                    e.printStackTrace();
                }
                continue;
            }
            Vector insertSqlStringList = dbo.getSqlInsertRandomDataString(maxDataCount);
            String generationTime = TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time));
            Iterator itInsertSqlStringList = insertSqlStringList.iterator();
            time = System.currentTimeMillis();
            while (itInsertSqlStringList.hasNext()) {
                String insertSqlString = (String)itInsertSqlStringList.next();
                try {
                    statement.execute(insertSqlString);
                }
                catch (SQLException e) {
                    System.out.println(statement.getSqlString());
                    e.printStackTrace();
                }
            }
            String insertionTime = TEST_TIME_FORMAT.format(new Date(System.currentTimeMillis() - time));
            System.out.println("Table Creation " + dbo.getObjectIdentifier() + " Data Creation: " + generationTime + " Data Insertion: " + insertionTime);
        }
        statement.close();
        DBConnection.close();
        return tableList;
    }

    public static String getTestClassId() {
        return "DynamicTables";
    }
}

