/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.oltptest.simple.SQLMaster;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

abstract class TestActor
extends Thread {
    public static final int RES_NO_ERROR = 0;
    public static final int RES_FINISHED_LOOPS = 1;
    public static final int RES_INTERRUPTED = 2;
    public static final int RES_SHUTDOWN_COMPLETE = 3;
    public static final int ERR_CONSISTENCY_ERROR = -1;
    public static final int ERR_SQL_ERROR = -2;
    public static final int ERR_GENERAL_ERROR = -3;
    protected SQLMaster mMaster = null;
    protected String mTitle;
    protected int mStatus = 0;
    protected String mStatusMessage = "No errors";
    protected Connection mConnection;
    protected Statement mStatement;
    protected boolean mRunning = false;
    protected boolean mShouldStop = false;
    protected boolean mTraceOn = false;

    public TestActor() {
    }

    public TestActor(Runnable target) {
        super(target);
    }

    public TestActor(Runnable target, String name) {
        super(target, name);
    }

    public TestActor(String name) {
        super(name);
    }

    public TestActor(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    public TestActor(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    public TestActor(ThreadGroup group, String name) {
        super(group, name);
    }

    protected void cleanup() {
        try {
            this.mStatement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mConnection.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final int getStatus() {
        return this.mStatus;
    }

    public final String getStatusMessage() {
        return this.mStatusMessage;
    }

    public final String getTitle() {
        return this.mTitle;
    }

    public final boolean hasError() {
        return this.mStatus < 0;
    }

    public final boolean isRunning() {
        return this.mRunning;
    }

    public abstract void run();

    public void setMaster(SQLMaster newMaster) throws TestDatabaseException, SQLException {
        this.mMaster = newMaster;
        this.mTraceOn = this.mMaster.isTraceOn();
        this.mConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
        this.mConnection.setAutoCommit(false);
        this.mStatement = new TestStatement((TestCase)this.mMaster, this.mConnection);
        this.mRunning = true;
    }

    protected final void setStatus(int Status) {
        this.mStatus = Status;
        switch (Status) {
            case 0: {
                this.mStatusMessage = "No errors";
                break;
            }
            case 2: {
                this.mStatusMessage = "Interrupted by master thread";
                break;
            }
            case 1: {
                this.mStatusMessage = "Finished the loops successfully";
                break;
            }
            case -1: {
                this.mStatusMessage = "Data Inconsistency";
                break;
            }
            case -2: {
                this.mStatusMessage = "SQL error";
                break;
            }
            case -3: {
                this.mStatusMessage = "General error";
            }
        }
    }

    protected final void setStatus(int Status, String StatusMessage) {
        this.mStatus = Status;
        this.mStatusMessage = StatusMessage;
    }

    public final void setTitle(String newTitle) {
        this.mTitle = newTitle;
    }

    public final void shouldStop() {
        this.mShouldStop = true;
    }
}

