/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.mut;

import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.oltptest.mut.OLTPTestActor;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.testcase.VerificationDataSorted;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class RecoveryCancelOltp
extends TestCase {
    private static final String sVersion = "3.1";
    private String mKernelMode = "FAST";
    private static Connection mMainConnection = null;
    private static TestStatement mMainStatement = null;
    private static TestPreparedStatement mMainPrepStatement = null;
    private static Connection[] mConnections;
    private static TestStatement[] mStatements;
    private static TestPreparedStatement[] mPrepStatement;
    protected static int mNumberOfConcurrentUsers;
    protected static int mNumberOfKillers;
    protected static int mNumberOfWriters;
    protected static String mTypeOfKilling;
    protected static int mNoOfRecords;
    protected static int mLOG_SEGMENT_SIZE;
    protected static int mStartDistance;
    protected static int mWaitTimeAfterStart;
    protected static int mNoOfCycles;
    private String sString = null;
    private static Random mRandomGenerator;
    private static int mTraceLevel;
    private DBM mDBMan = null;
    private DBM mDBMan2 = null;
    private DBM mDBMan3 = null;
    protected static boolean noFullRecovery;
    protected static boolean killing;
    protected static Killer[] KillerSet;
    protected static QueueCountChanger queueCountChangerThread;
    protected static Integer converterVersionObj;
    protected static int converterVersionNew;
    protected static int converterVersionStart;
    protected static int recoveryAborted;
    protected boolean globalError = false;
    protected String globalErrorText = "";
    protected static boolean testIsInterrupted;

    static {
        mRandomGenerator = new Random();
        testIsInterrupted = false;
    }

    public static String getMinimumRelease() {
        return "7.4.*";
    }

    public static String getTestClassId() {
        return "RecoveryCancelOltp";
    }

    public static void prepare() throws TestCaseException {
        RecoveryCancelOltp.readAndPrintParameters();
    }

    public static void readAndPrintParameters() throws TestCaseException {
        mTraceLevel = TestCase.getParameterInt((String)"TraceLevel", (int)2);
        mNumberOfKillers = TestCase.getParameterInt((String)"NumberOfKillers", (int)1);
        mTypeOfKilling = "";
        if (mNumberOfKillers == 1) {
            mTypeOfKilling = TestCase.getParameterString((String)"TypeOfKilling", (String)"db_stop");
        }
        mNumberOfConcurrentUsers = mNumberOfWriters = TestCase.getParameterInt((String)"NumberOfWriters", (int)8);
        mNoOfRecords = TestCase.getParameterInt((String)"NoOfRecords", (int)1000);
        mNoOfCycles = TestCase.getParameterInt((String)"NoOfCycles", (int)400);
        mLOG_SEGMENT_SIZE = TestCase.getParameterInt((String)"LOG_SEGMENT_SIZE", (int)3000);
        mStartDistance = TestCase.getParameterInt((String)"StartDistance", (int)1);
        mWaitTimeAfterStart = TestCase.getParameterInt((String)"WaitTimeAfterStart", (int)2);
        RecoveryCancelOltp.printInfo(1, "\n" + RecoveryCancelOltp.getTestClassId(), "Starting " + RecoveryCancelOltp.getTestClassId() + " Test - Version: " + sVersion + "\n");
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: NumberOfKillers = " + mNumberOfKillers);
        if (mNumberOfKillers == 1) {
            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: TypeOfKilling   = " + mTypeOfKilling);
        }
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: NumberOfWriters = " + mNumberOfWriters);
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: StartDistance   = " + mStartDistance);
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: WaitTimeAfterStart  = " + mWaitTimeAfterStart);
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: TraceLevel          = " + mTraceLevel);
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: NoOfRecords         = " + mNoOfRecords);
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: NoOfCycles          = " + mNoOfCycles);
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: LOG_SEGMENT_SIZE    = " + mLOG_SEGMENT_SIZE);
    }

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "USER_LOGON DBM,DBM";
        String mHost = "";
        String mName = "";
        RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), "executeDBMCmd: " + pCmd);
        try {
            mHost = TestCase.getDatabase().getHost();
            mName = TestCase.getDatabase().getName();
            int mPort = TestCase.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(String.valueOf(mHost) + ":" + mPort), (String)mName);
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            if (this.mDBMan != null) {
                try {
                    this.mDBMan.release();
                }
                catch (RTEException rTEException) {
                    // empty catch block
                }
                this.mDBMan = null;
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public String executeDBMCmd2(String pCmd) throws TestDatabaseException {
        String logon = "USER_LOGON DBM,DBM";
        String mHost = "";
        String mName = "";
        try {
            mHost = TestCase.getDatabase().getHost();
            mName = TestCase.getDatabase().getName();
            int mPort = TestCase.getDatabase().getPort();
            if (this.mDBMan2 == null) {
                this.mDBMan2 = DBM.dbDBM((String)(String.valueOf(mHost) + ":" + mPort), (String)mName);
                this.mDBMan2.cmd(logon);
            }
            return this.mDBMan2.cmd(pCmd);
        }
        catch (Exception e) {
            if (this.mDBMan2 != null) {
                try {
                    this.mDBMan2.release();
                }
                catch (RTEException rTEException) {
                    // empty catch block
                }
                this.mDBMan2 = null;
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public String executeDBMCmd3(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = TestCase.getDatabase().getHost();
            mName = TestCase.getDatabase().getName();
            int mPort = TestCase.getDatabase().getPort();
            if (this.mDBMan3 == null) {
                this.mDBMan3 = DBM.dbDBM((String)(String.valueOf(mHost) + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan3.cmd(logon);
            }
            return this.mDBMan3.cmd(pCmd);
        }
        catch (Exception e) {
            if (this.mDBMan3 != null) {
                try {
                    this.mDBMan3.release();
                }
                catch (RTEException rTEException) {
                    // empty catch block
                }
                this.mDBMan3 = null;
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public static int randomInteger(int MinValue, int MaxValue) {
        return (int)((double)mRandomGenerator.nextFloat() * (double)(MaxValue - MinValue + 1)) + MinValue;
    }

    public static void cleanUp() throws TestCaseException {
        if (mTraceLevel > 0) {
            System.out.println("End of " + RecoveryCancelOltp.getTestClassId());
        }
    }

    private static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(String.valueOf(pComponent) + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            TestCase.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            TestCase.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    private static boolean createConnections() {
        try {
            mMainConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
            mMainConnection.setAutoCommit(true);
            mMainStatement = new TestStatement(null, mMainConnection);
            mConnections = new Connection[mNumberOfConcurrentUsers];
            mStatements = new TestStatement[mNumberOfConcurrentUsers];
            mPrepStatement = new TestPreparedStatement[mNumberOfConcurrentUsers];
            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Creating " + mNumberOfConcurrentUsers + " connections!");
            int i = 0;
            while (i < mNumberOfConcurrentUsers) {
                RecoveryCancelOltp.mConnections[i] = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
                mConnections[i].setAutoCommit(false);
                RecoveryCancelOltp.mStatements[i] = new TestStatement(null, mConnections[i]);
                mConnections[i].commit();
                ++i;
            }
        }
        catch (Exception e) {
            TestCase.addGlobalMessage((String)"createConnections", (char)'E', (String)("Error during connection creation: " + e.getMessage()));
            return false;
        }
        return true;
    }

    private void createTables(int i) throws TestCaseException, SQLException {
        try {
            this.sString = "DROP TABLE RCTAB_" + i;
            RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), this.sString);
            mMainStatement.executeUpdateIgnoreErrors(this.sString);
            this.sString = "CREATE TABLE RCTAB_" + i + " (KEY1 INTEGER, KEY2 INTEGER, VALUE_A INTEGER, VALUE_B CHAR(24), PRIMARY KEY (KEY1, KEY2))";
            RecoveryCancelOltp.printInfo(3, RecoveryCancelOltp.getTestClassId(), this.sString);
            mMainStatement.executeUpdate(this.sString);
            mMainConnection.commit();
            mMainPrepStatement = new TestPreparedStatement(null, mMainConnection, "insert RCTAB_" + i + " values (?, ?, ?, ? )");
            int ix = 0;
            while (ix < mNoOfRecords) {
                mMainPrepStatement.setInt(1, ix);
                mMainPrepStatement.setInt(2, 0);
                mMainPrepStatement.setInt(3, ix);
                mMainPrepStatement.setString(4, Integer.toString(ix));
                mMainPrepStatement.addBatch();
                if (ix % 1000 == 0) {
                    mMainPrepStatement.executeBatch();
                    mMainPrepStatement.clearBatch();
                }
                ++ix;
            }
            mMainPrepStatement.executeBatch();
            mMainConnection.commit();
            RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), "just created RCTAB_" + i);
        }
        catch (Exception e) {
            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Error during table creation: " + e.getMessage());
        }
    }

    private void handleException(Exception e) {
        this.handleExceptions(e);
    }

    public void startingMultipleThreads(int StartDistance) throws TestCaseException {
        block15: {
            try {
                boolean areWAlive;
                long SleepTime = 500 * StartDistance;
                Writer[] WriterSet = new Writer[mNumberOfWriters + 1];
                int i = 0;
                while (i < mNumberOfWriters) {
                    RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Start Writer" + Integer.toString(i));
                    WriterSet[i] = new Writer(i, i);
                    Thread.sleep(SleepTime);
                    if (mTraceLevel > 2) {
                        System.out.println("created writer: i = " + i);
                    }
                    if (mTraceLevel > 2) {
                        System.out.println("writer uses connection: i = " + i);
                    }
                    ++i;
                }
                SleepTime = 60000 * mWaitTimeAfterStart;
                Thread.sleep(SleepTime);
                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Stop all writer threads");
                i = 0;
                while (i < mNumberOfWriters) {
                    if (WriterSet[i] != null) {
                        WriterSet[i].pleaseStop();
                    }
                    if (mTraceLevel > 2) {
                        System.out.println("asked to stop writer i = " + i + " isAlive: " + WriterSet[i].isAlive());
                    }
                    ++i;
                }
                Thread.sleep(24000L);
                int k = 0;
                do {
                    ++k;
                    areWAlive = false;
                    i = 0;
                    while (i < mNumberOfWriters) {
                        if (WriterSet[i] != null) {
                            areWAlive |= WriterSet[i].isAlive();
                        }
                        ++i;
                    }
                    Thread.sleep(200L);
                    i = 0;
                    while (i < mNumberOfWriters) {
                        if (WriterSet[i] != null && WriterSet[i].isAlive()) {
                            WriterSet[i].interrupt();
                        }
                        ++i;
                    }
                } while (areWAlive && k < 100);
                if (mTraceLevel > 0) {
                    System.out.println("Are writers alive? Answer: " + areWAlive);
                }
                if (!areWAlive) {
                    RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "All threads stopped...\n");
                    break block15;
                }
                TestCase.addGlobalMessage((String)"db_cons show all", (char)'T', (String)("Because not all threads are stopped, call 'db_cons show all'\n" + this.executeDBMCmd("db_cons show all")));
                throw new TestCaseException("Not all threads stopped!\n");
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
    }

    public long getChecksum(int user) {
        String cks = "Select sum(KEY1) from RCTAB_" + user;
        long sum = 0L;
        try {
            ResultSet rs = mMainStatement.executeQuery(cks);
            if (rs.next()) {
                sum = rs.getLong(1);
                if (mTraceLevel > 0) {
                    System.out.println("***Checksum Writer_" + user + ": " + sum);
                }
            }
        }
        catch (SQLException sqlex) {
            this.handleExceptions(sqlex);
        }
        return sum;
    }

    public void pause(String mode) {
        try {
            String state = "";
            String mode2 = "unknown";
            if (mode.equalsIgnoreCase("ADMIN")) {
                mode2 = "COLD";
            }
            if (mode.equalsIgnoreCase("ONLINE")) {
                mode2 = "WARM";
            }
            if (mTraceLevel > 0) {
                if (mode2.equalsIgnoreCase("unknown")) {
                    System.out.println("Mode: '" + mode + "' \n");
                } else {
                    System.out.println("Mode: '" + mode + "' or  '" + mode2 + "'\n");
                }
            }
            while (!state.equals(mode) && !state.equals(mode2)) {
                Thread.sleep(200L);
                state = this.executeDBMCmd("db_state").substring(6).trim().toUpperCase();
                if (mTraceLevel <= 0) continue;
                System.out.println("State: '" + state + "'");
            }
        }
        catch (Exception ex) {
            this.handleExceptions(ex);
        }
    }

    public void dbCheck() {
        String query1 = "Select (KEY1) from RCTAB_0\twhere KEY1 > (select max(key1) - 10 from rctab_0) ";
        String query2 = "Select count(KEY1) from RCTAB_0";
        try {
            ResultSet rs2;
            ResultSet rs1 = mMainStatement.executeQuery(query1);
            VerificationDataSorted veri1 = new VerificationDataSorted(rs1);
            if (mTraceLevel > 0) {
                System.out.println("***RCTAB_0 - last table entries:\n" + veri1.toString());
            }
            if ((rs2 = mMainStatement.executeQuery(query2)).next() && mTraceLevel > 0) {
                System.out.println("***RCTAB_0 - Count: " + rs2.getInt(1));
            }
        }
        catch (SQLException sqlex) {
            this.handleExceptions(sqlex);
        }
    }

    public void startingKillerThread() {
        KillerSet = new Killer[mNumberOfKillers + 1];
        try {
            int j = 0;
            while (j < mNumberOfKillers) {
                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Start Killer " + Integer.toString(j));
                RecoveryCancelOltp.KillerSet[j] = new Killer(j);
                if (mTraceLevel > 0) {
                    System.out.println("created killer: j = " + j);
                }
                ++j;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public int getConverterVersion() {
        try {
            String theCurrentDBState = this.executeDBMCmd2("db_state").substring(6).trim().toUpperCase();
            if (theCurrentDBState.equals("ADMIN") || theCurrentDBState.equals("COLD")) {
                boolean theLastStatementWasOK = true;
                int attemptCounter = 0;
                String lastErrorMessage = null;
                String temp = null;
                do {
                    try {
                        ++attemptCounter;
                        temp = this.executeDBMCmd2("db_execute get restart version");
                        theLastStatementWasOK = true;
                    }
                    catch (Exception exp) {
                        theLastStatementWasOK = false;
                        lastErrorMessage = exp.getLocalizedMessage();
                    }
                } while (!theLastStatementWasOK && attemptCounter < 11);
                if (attemptCounter == 11) {
                    this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getConverterVersion() after 11 attempts it was not possible to call 'db_execute get restart version'; \nlast message: " + lastErrorMessage);
                    return converterVersionNew;
                }
                BufferedReader br = new BufferedReader(new StringReader(temp));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("CONVERTER VERSION")) continue;
                    converterVersionObj = new Integer(line.substring(line.indexOf("=") + 1).trim());
                    converterVersionNew = converterVersionObj;
                    break;
                }
                br.close();
                if (mTraceLevel > 3) {
                    System.out.println("NEW Converter Version: " + converterVersionNew);
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getConverterVersion(): NumberFormatException " + e.getLocalizedMessage());
        }
        catch (TestDatabaseException e) {
            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getConverterVersion() caught an exception. \n" + e.getMessage() + "\n Used Converter Version: " + converterVersionNew);
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return converterVersionNew;
    }

    public int getNumberOfLogSegments() {
        int noOfSegments = 0;
        String cmd = "backup_history_list -r last -c LABEL";
        String backup = null;
        try {
            backup = this.executeDBMCmd(cmd);
            if (backup.indexOf("LOG") != -1) {
                noOfSegments = Integer.parseInt(backup.substring(backup.length() - 5, backup.length() - 2).trim());
            }
        }
        catch (NumberFormatException e) {
            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getNumberOfLogSegments() caught an exception. \n" + e.getMessage() + "\n Number of log segments: " + noOfSegments);
        }
        catch (TestDatabaseException e) {
            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getNumberOfLogSegments() caught an exception. \n" + e.getMessage() + "\n Number of log segments: " + noOfSegments);
        }
        this.addMessage(RecoveryCancelOltp.getTestClassId(), 'I', "Tried to call: " + cmd + "\ngot:\n" + backup + "\nNo of Segments = " + noOfSegments);
        return noOfSegments;
    }

    public int getUsedLogPage() {
        int usedLogPage = 0;
        String tmp = "";
        try {
            boolean loop_2 = true;
            do {
                try {
                    tmp = this.executeDBMCmd("db_restartinfo");
                    loop_2 = false;
                }
                catch (TestDatabaseException e) {
                    if (mTraceLevel > 0) {
                        System.out.println("*** UsedLogPage ERROR: " + e.toString());
                    }
                    this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getUsedLogPage() caught an exception. \n" + e.getMessage() + " usedLogPage = " + usedLogPage);
                    if (e.toString().indexOf("-104") != -1) continue;
                    loop_2 = false;
                }
            } while (loop_2);
            int index = tmp.indexOf("First");
            Integer usedLogPageObj = new Integer(tmp.substring(index - 6, index - 1).trim());
            usedLogPage = usedLogPageObj;
            if (mTraceLevel > 0) {
                System.out.println("UsedLogPage: " + usedLogPage);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return usedLogPage;
    }

    public int getLogSegmentForRecovery(int usedLogPage) {
        Vector<Integer> lowerBound = new Vector<Integer>();
        Vector<Integer> upperBound = new Vector<Integer>();
        int LogSegmentForRecovery = 0;
        try {
            StringTokenizer hack = new StringTokenizer(this.executeDBMCmd("backup_history_list -r last -c LABEL,FIRSTLOG,LASTLOG"), "|");
            int a = 1;
            while (hack.hasMoreElements()) {
                if (++a < 6) {
                    hack.nextElement();
                    continue;
                }
                Integer int_1 = new Integer(hack.nextElement().toString().trim());
                Integer int_2 = new Integer(hack.nextElement().toString().trim());
                if (mTraceLevel > 0) {
                    System.out.println(int_1);
                }
                if (mTraceLevel > 0) {
                    System.out.println(int_2);
                }
                lowerBound.add(int_1);
                upperBound.add(int_2);
                if (mTraceLevel <= 0) continue;
                System.out.println(hack.nextElement().toString().trim());
            }
            int endOfLoop = this.getNumberOfLogSegments();
            int i = 0;
            while (i < endOfLoop) {
                if (usedLogPage > (Integer)lowerBound.elementAt(i) && usedLogPage < (Integer)upperBound.elementAt(i)) {
                    LogSegmentForRecovery = i + 1;
                    break;
                }
                if (usedLogPage == (Integer)lowerBound.elementAt(i) || usedLogPage == (Integer)upperBound.elementAt(i)) {
                    LogSegmentForRecovery = i + 1;
                    break;
                }
                if (usedLogPage < 0) {
                    if (mTraceLevel > 0) {
                        System.out.println("IMPOSSIBLE");
                    }
                    break;
                }
                if (usedLogPage > (Integer)upperBound.elementAt(i)) {
                    if (mTraceLevel > 0) {
                        System.out.println("continue");
                    }
                } else {
                    if (usedLogPage < (Integer)lowerBound.elementAt(i) && (Integer)lowerBound.elementAt(i) != 0) {
                        LogSegmentForRecovery = i;
                        break;
                    }
                    if (mTraceLevel > 0) {
                        System.out.println("Lower: " + (Integer)lowerBound.elementAt(i));
                    }
                    if (mTraceLevel > 0) {
                        System.out.println("Upper: " + (Integer)upperBound.elementAt(i));
                    }
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getLogSegmentForRecovery() caught an exception. \n" + e.getMessage() + " LogSegmentForRecovery = " + LogSegmentForRecovery);
            e.printStackTrace();
        }
        catch (TestDatabaseException e) {
            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getLogSegmentForRecovery() caught an exception. \n" + e.getMessage() + " LogSegmentForRecovery = " + LogSegmentForRecovery);
            e.printStackTrace();
        }
        return LogSegmentForRecovery;
    }

    public String getRecoveryString(int number) {
        String recoveryString = "";
        if (number > 0 && number < 10) {
            recoveryString = "00" + number;
        } else if (number >= 10 && number < 100) {
            recoveryString = "0" + number;
        } else if (number >= 100) {
            recoveryString = "" + number;
        } else if (number == 0) {
            if (mTraceLevel > 0) {
                System.out.println("getRecoveryString impossible ---> number = " + number);
            }
            recoveryString = "";
        }
        return recoveryString;
    }

    public static long getTimeout() {
        return 1800000L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block99: {
            block100: {
                block97: {
                    block98: {
                        block95: {
                            block96: {
                                block94: {
                                    block93: {
                                        try {
                                            try {
                                                block85: {
                                                    block84: {
                                                        this.setStatus("createConnections");
                                                        RecoveryCancelOltp.createConnections();
                                                        if (RecoveryCancelOltp.mLOG_SEGMENT_SIZE != 1666) {
                                                            if (RecoveryCancelOltp.mTraceLevel > 2) {
                                                                System.out.println("Put LOG_SEGMENT_SIZE: " + RecoveryCancelOltp.mLOG_SEGMENT_SIZE + "\n");
                                                            }
                                                            this.executeDBMCmd("param_directput LOG_SEGMENT_SIZE " + RecoveryCancelOltp.mLOG_SEGMENT_SIZE);
                                                            this.executeDBMCmd("db_offline");
                                                        }
                                                        this.executeDBMCmd("db_warm");
                                                        this.executeDBMCmd("autosave_off");
                                                        this.setStatus("createBackupMedia");
                                                        this.executeDBMCmd("util_connect");
                                                        this.executeDBMCmd("backup_media_put recancelauto recancelauto FILE AUTO");
                                                        this.executeDBMCmd("backup_media_put recanceldat recanceldat FILE DATA 0 8 YES NO ");
                                                        this.executeDBMCmd("util_release");
                                                        this.setStatus("backup DATA");
                                                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Backup data");
                                                        this.executeDBMCmd("util_connect");
                                                        this.executeDBMCmd("backup_save recanceldat DATA");
                                                        this.executeDBMCmd("util_release");
                                                        this.executeDBMCmd("util_connect");
                                                        this.executeDBMCmd("autosave_on");
                                                        this.executeDBMCmd("util_release");
                                                        this.setStatus("createTables + DBProcs");
                                                        i = 0;
                                                        while (true) {
                                                            if (i >= RecoveryCancelOltp.mNumberOfWriters) {
                                                                this.setStatus("backup DATA");
                                                                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Backup data");
                                                                this.executeDBMCmd("util_connect");
                                                                this.executeDBMCmd("backup_save recanceldat DATA");
                                                                this.executeDBMCmd("util_release");
                                                                this.setStatus("Multi Users on DB");
                                                                mTestDatabase = TestCase.getDatabase();
                                                                sapdb = null;
                                                                if (mTestDatabase.isSap()) {
                                                                    sapdb = (TestDatabaseSap)mTestDatabase;
                                                                }
                                                                if (!TestDriver.compareRelease((String)(String.valueOf(sapdb.getKernelVersion()) + "." + sapdb.getKernelBuild().substring(0, 3)), (String)">=", (String)"7.6.0.15")) break;
                                                                RecoveryCancelOltp.queueCountChangerThread = new QueueCountChanger();
                                                                this.startingMultipleThreads(RecoveryCancelOltp.mStartDistance);
                                                                if (RecoveryCancelOltp.queueCountChangerThread.isAlive()) {
                                                                    RecoveryCancelOltp.queueCountChangerThread.pleaseStop();
                                                                    Thread.sleep(5000L);
                                                                    RecoveryCancelOltp.queueCountChangerThread.interrupt();
                                                                }
                                                                break block84;
                                                            }
                                                            this.createTables(i);
                                                            ++i;
                                                        }
                                                        this.startingMultipleThreads(RecoveryCancelOltp.mStartDistance);
                                                    }
                                                    if (this.globalError) {
                                                        throw new TestCaseException("An global error after startingMultipleThreads is occured.\nDescription: " + this.globalErrorText);
                                                    }
                                                    this.executeDBMCmd("util_connect");
                                                    this.executeDBMCmd("autosave_off");
                                                    this.executeDBMCmd("backup_start recancelauto");
                                                    this.executeDBMCmd("autosave_on");
                                                    this.executeDBMCmd("util_release");
                                                    check_1 = new long[RecoveryCancelOltp.mNumberOfWriters];
                                                    i = 0;
                                                    while (true) {
                                                        if (i >= RecoveryCancelOltp.mNumberOfWriters) {
                                                            this.dbCheck();
                                                            query = "Select (KEY1) from RCTAB_0";
                                                            rs1 = RecoveryCancelOltp.mMainStatement.executeQuery(query);
                                                            v1 = new VerificationDataComplete(rs1);
                                                            this.setStatus("Restart Database");
                                                            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Restart with init-config and backup_restore");
                                                            this.executeDBMCmd("autosave_off");
                                                            this.executeDBMCmd("db_offline");
                                                            this.executeDBMCmd("db_cold -" + this.mKernelMode);
                                                            this.executeDBMCmd("util_connect");
                                                            this.executeDBMCmd("backup_start recancelauto");
                                                            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "db_activate RECOVER recanceldat DATA");
                                                            actualCommand = "";
                                                            if (!TestDriver.compareRelease((String)(String.valueOf(sapdb.getKernelVersion()) + "." + sapdb.getKernelBuild().substring(0, 3)), (String)">=", (String)"7.4.4.1")) break;
                                                            actualCommand = "db_activate RECOVER recanceldat DATA";
                                                            this.executeDBMCmd(actualCommand);
                                                            break block85;
                                                        }
                                                        check_1[i] = this.getChecksum(i);
                                                        ++i;
                                                    }
                                                    actualCommand = "util_execute INIT CONFIG";
                                                    this.executeDBMCmd(actualCommand);
                                                    actualCommand = "backup_restore recanceldat DATA";
                                                    this.executeDBMCmd(actualCommand);
                                                }
                                                if (RecoveryCancelOltp.mTraceLevel > 2) {
                                                    System.out.println("Result from backup_history_list (short): " + this.executeDBMCmd("backup_history_list -r last -c LABEL"));
                                                }
                                                NumberOfLogSegments = 0;
                                                NumberOfLogSegments = this.getNumberOfLogSegments();
                                                if (RecoveryCancelOltp.mTraceLevel > 2) {
                                                    System.out.println("Number of LogSegments: " + NumberOfLogSegments);
                                                }
                                                RecoveryCancelOltp.converterVersionStart = this.getConverterVersion();
                                                RecoveryCancelOltp.killing = false;
                                                RecoveryCancelOltp.noFullRecovery = true;
                                                firstTime = true;
                                                usedLogPageForException = 0;
                                                RecoveryCancelOltp.recoveryAborted = 0;
                                                this.startingKillerThread();
                                                if (NumberOfLogSegments > 0) {
                                                    while (RecoveryCancelOltp.noFullRecovery) {
                                                        block86: {
                                                            block87: {
                                                                try {
                                                                    i = 1;
                                                                    while (i <= NumberOfLogSegments) {
                                                                        if (RecoveryCancelOltp.mNumberOfKillers == 1 && !RecoveryCancelOltp.killing) {
                                                                            if (firstTime) {
                                                                                if (NumberOfLogSegments > 1) {
                                                                                    i = 2;
                                                                                }
                                                                                firstTime = false;
                                                                                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_start recancelauto 001");
                                                                                this.executeDBMCmd("recover_start recancelauto 001");
                                                                                RecoveryCancelOltp.recoveryAborted = 0;
                                                                            }
                                                                            if (NumberOfLogSegments > 1) {
                                                                                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_replace recancelauto " + this.getRecoveryString(i).trim());
                                                                                this.executeDBMCmd("recover_replace recancelauto recancelauto " + this.getRecoveryString(i).trim());
                                                                                RecoveryCancelOltp.recoveryAborted = 0;
                                                                            }
                                                                        }
                                                                        if (RecoveryCancelOltp.mNumberOfKillers == 1 && RecoveryCancelOltp.killing) {
                                                                            loop = true;
                                                                            do {
                                                                                try {
                                                                                    this.executeDBMCmd("util_connect");
                                                                                    loop = false;
                                                                                }
                                                                                catch (Exception e) {
                                                                                    if (e.toString().indexOf("-24992") != -1) continue;
                                                                                    loop = false;
                                                                                }
                                                                            } while (loop);
                                                                            usedLogPage = this.getUsedLogPage();
                                                                            usedLogPageForException = i = this.getLogSegmentForRecovery(usedLogPage);
                                                                            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_start " + this.getRecoveryString(i).trim());
                                                                            this.executeDBMCmd("recover_start recancelauto " + this.getRecoveryString(i).trim());
                                                                            RecoveryCancelOltp.recoveryAborted = 0;
                                                                            RecoveryCancelOltp.killing = false;
                                                                        }
                                                                        if (RecoveryCancelOltp.mNumberOfKillers == 0) {
                                                                            if (i == 1) {
                                                                                if (NumberOfLogSegments > 1) {
                                                                                    i = 2;
                                                                                }
                                                                                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_start recancelauto 001");
                                                                                this.executeDBMCmd("recover_start recancelauto 001");
                                                                                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_cancel");
                                                                                this.executeDBMCmd("recover_cancel");
                                                                                this.pause("OFFLINE");
                                                                                this.executeDBMCmd("db_cold -" + this.mKernelMode);
                                                                                this.pause("ADMIN");
                                                                                if (RecoveryCancelOltp.mTraceLevel > 2) {
                                                                                    System.out.println("Result from db_restartinfo: " + this.executeDBMCmd("db_restartinfo"));
                                                                                }
                                                                                this.executeDBMCmd("util_connect");
                                                                                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_start recancelauto 001");
                                                                                rtcd = this.executeDBMCmd("recover_start recancelauto 001");
                                                                                if (RecoveryCancelOltp.mTraceLevel > 2) {
                                                                                    System.out.println(rtcd);
                                                                                }
                                                                            }
                                                                            if (NumberOfLogSegments > 1) {
                                                                                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_replace recancelauto " + this.getRecoveryString(i).trim());
                                                                                this.executeDBMCmd("recover_replace recancelauto recancelauto " + this.getRecoveryString(i).trim());
                                                                                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_cancel");
                                                                                this.executeDBMCmd("recover_cancel");
                                                                                this.pause("OFFLINE");
                                                                                this.executeDBMCmd("db_cold -" + this.mKernelMode);
                                                                                this.pause("ADMIN");
                                                                                if (RecoveryCancelOltp.mTraceLevel > 2) {
                                                                                    System.out.println("Result from db_restartinfo: " + this.executeDBMCmd("db_restartinfo"));
                                                                                }
                                                                                this.executeDBMCmd("util_connect");
                                                                                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_start " + this.getRecoveryString(i).trim());
                                                                                this.executeDBMCmd("recover_start recancelauto " + this.getRecoveryString(i).trim());
                                                                            }
                                                                        }
                                                                        if (i == NumberOfLogSegments) {
                                                                            RecoveryCancelOltp.noFullRecovery = false;
                                                                            if (RecoveryCancelOltp.mTraceLevel > 2) {
                                                                                System.out.println("***ENDE***");
                                                                            }
                                                                            j = 0;
                                                                            while (j < RecoveryCancelOltp.mNumberOfKillers) {
                                                                                if (RecoveryCancelOltp.KillerSet[j] != null) {
                                                                                    RecoveryCancelOltp.KillerSet[j].pleaseStop();
                                                                                    Thread.sleep(3000L);
                                                                                    RecoveryCancelOltp.KillerSet[j].interrupt();
                                                                                }
                                                                                if (RecoveryCancelOltp.mTraceLevel > 2) {
                                                                                    System.out.println("asked to stop killer: j = " + j + " Status: " + RecoveryCancelOltp.KillerSet[j].isAlive() + "\n");
                                                                                }
                                                                                ++j;
                                                                            }
                                                                        }
                                                                        ++i;
                                                                    }
                                                                    continue;
                                                                }
                                                                catch (Exception ex) {
                                                                    if (!RecoveryCancelOltp.mTypeOfKilling.equals("db_stop") || RecoveryCancelOltp.killing) break block86;
                                                                    if (++RecoveryCancelOltp.recoveryAborted < 4) break block87;
                                                                    throw new Exception("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                                                                }
                                                            }
                                                            while (!RecoveryCancelOltp.killing) {
                                                                Thread.sleep(1L);
                                                            }
                                                        }
                                                        if (RecoveryCancelOltp.mTypeOfKilling.equals("cancel") && !RecoveryCancelOltp.killing) {
                                                            if (++RecoveryCancelOltp.recoveryAborted >= 4) {
                                                                throw new Exception("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                                                            }
                                                            while (!RecoveryCancelOltp.killing) {
                                                                Thread.sleep(1L);
                                                            }
                                                        }
                                                        if (RecoveryCancelOltp.mTypeOfKilling.equals("db_stop") && RecoveryCancelOltp.killing) {
                                                            if (++RecoveryCancelOltp.recoveryAborted >= 4) {
                                                                throw new Exception("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                                                            }
                                                            if (RecoveryCancelOltp.mTraceLevel > 1) {
                                                                System.out.println("DB_STOP Exception");
                                                            }
                                                            this.pause("OFFLINE");
                                                            if (RecoveryCancelOltp.mTraceLevel > 1) {
                                                                System.out.println("db_cold -" + this.mKernelMode);
                                                            }
                                                            this.executeDBMCmd("db_cold -" + this.mKernelMode);
                                                            this.pause("ADMIN");
                                                        }
                                                        if (RecoveryCancelOltp.mTypeOfKilling.equals("cancel") && RecoveryCancelOltp.killing) {
                                                            if (++RecoveryCancelOltp.recoveryAborted >= 4) {
                                                                throw new Exception("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                                                            }
                                                            if (ex.toString().indexOf("-24992") != -1) {
                                                                this.executeDBMCmd("util_connect");
                                                                this.executeDBMCmd("recover_start recancelauto " + this.getRecoveryString(usedLogPageForException).trim());
                                                                RecoveryCancelOltp.killing = false;
                                                            }
                                                            if (RecoveryCancelOltp.mTraceLevel > 1) {
                                                                System.out.println("CANCEL Exception");
                                                            }
                                                            this.pause("OFFLINE");
                                                            if (RecoveryCancelOltp.mTraceLevel > 1) {
                                                                System.out.println("db_cold -" + this.mKernelMode);
                                                            }
                                                            this.executeDBMCmd("db_cold -" + this.mKernelMode);
                                                            this.pause("ADMIN");
                                                        }
                                                        if (RecoveryCancelOltp.mNumberOfKillers != 0) continue;
                                                        RecoveryCancelOltp.noFullRecovery = false;
                                                        if (RecoveryCancelOltp.mTraceLevel <= 0) continue;
                                                        System.out.println("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                                                    }
                                                }
                                                Thread.sleep(2000L);
                                                this.executeDBMCmd("recover_ignore");
                                                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_replace recancelauto 00* done");
                                                if (RecoveryCancelOltp.mTraceLevel > 1) {
                                                    System.out.println("State: '" + this.executeDBMCmd("db_state").substring(6).trim() + "'");
                                                }
                                                check_2 = new long[RecoveryCancelOltp.mNumberOfWriters];
                                                i = 0;
                                                while (true) {
                                                    if (i >= RecoveryCancelOltp.mNumberOfWriters) break;
                                                    check_2[i] = this.getChecksum(i);
                                                    ++i;
                                                }
                                                user = 0;
                                                while (true) {
                                                    block92: {
                                                        if (user < RecoveryCancelOltp.mNumberOfWriters) break block92;
                                                        this.dbCheck();
                                                        rs2 = RecoveryCancelOltp.mMainStatement.executeQuery(query);
                                                        System.out.println("check the reference data");
                                                        v2 = new VerificationDataComplete(rs2);
                                                        if (!v1.equals((VerificationData)v2)) {
                                                            System.out.println("Error 'expected data not found. -> " + v1.getErrorMessage());
                                                            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "Expected result does not equal given result!\n" + v1.getErrorMessage());
                                                        }
                                                        ** GOTO lbl-1000
                                                    }
                                                    if (check_1[user] == check_2[user]) {
                                                        if (RecoveryCancelOltp.mTraceLevel > 0) {
                                                            System.out.println("***Writer_" + user + ": Recovery was successful***");
                                                        }
                                                    } else if (RecoveryCancelOltp.mTraceLevel > 0) {
                                                        System.out.println("***Writer_" + user + ": Recovery FAILED***");
                                                    }
                                                    ++user;
                                                }
                                            }
                                            catch (Exception e) {
                                                RecoveryCancelOltp.testIsInterrupted = true;
                                                this.handleExceptions(e);
                                            }
                                            ** GOTO lbl-1000
                                        }
                                        catch (Throwable var15_25) {
                                            var14_26 = null;
                                            try {
                                                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all statements!");
                                                RecoveryCancelOltp.mMainStatement.close();
                                                Thread.sleep(1000L);
                                                i = 0;
                                                while (i < RecoveryCancelOltp.mNumberOfConcurrentUsers) {
                                                    RecoveryCancelOltp.mStatements[i].close();
                                                    ++i;
                                                }
                                            }
                                            catch (Exception i) {
                                                // empty catch block
                                            }
                                        }
                                        try {
                                            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all connections!");
                                            RecoveryCancelOltp.mMainConnection.commit();
                                            RecoveryCancelOltp.mMainConnection.close();
                                            i = 0;
                                            while (i < RecoveryCancelOltp.mNumberOfConcurrentUsers) {
                                                RecoveryCancelOltp.mConnections[i].commit();
                                                RecoveryCancelOltp.mConnections[i].close();
                                                ++i;
                                            }
                                        }
                                        catch (Exception var16_31) {
                                            // empty catch block
                                        }
                                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all opened dbm server connections!");
                                        if (this.mDBMan != null) {
                                            try {
                                                this.mDBMan.release();
                                            }
                                            catch (RTEException var16_32) {
                                                // empty catch block
                                            }
                                            this.mDBMan = null;
                                        }
                                        if (this.mDBMan2 != null) {
                                            try {
                                                this.mDBMan2.release();
                                            }
                                            catch (RTEException var16_33) {
                                                // empty catch block
                                            }
                                            this.mDBMan2 = null;
                                        }
                                        if (this.mDBMan3 != null) {
                                            try {
                                                this.mDBMan3.release();
                                            }
                                            catch (RTEException var16_34) {
                                                // empty catch block
                                            }
                                            this.mDBMan3 = null;
                                        }
                                        if (RecoveryCancelOltp.mTraceLevel <= 0) throw var15_25;
                                        System.out.println("Game Over");
                                        throw var15_25;
lbl-1000:
                                        // 3 sources

                                        {
                                            var14_27 = null;
                                        }
                                        ** try [egrp 4[TRYBLOCK] [5 : 2588->2639)] { 
lbl372:
                                        // 1 sources

                                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all statements!");
                                        RecoveryCancelOltp.mMainStatement.close();
                                        Thread.sleep(1000L);
                                        i = 0;
                                        while (i < RecoveryCancelOltp.mNumberOfConcurrentUsers) {
                                            RecoveryCancelOltp.mStatements[i].close();
                                            ++i;
                                        }
                                        break block93;
lbl381:
                                        // 1 sources

                                        catch (Exception i) {
                                            // empty catch block
                                        }
                                    }
                                    ** try [egrp 5[TRYBLOCK] [6 : 2641->2709)] { 
lbl385:
                                    // 1 sources

                                    RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all connections!");
                                    RecoveryCancelOltp.mMainConnection.commit();
                                    RecoveryCancelOltp.mMainConnection.close();
                                    i = 0;
                                    while (i < RecoveryCancelOltp.mNumberOfConcurrentUsers) {
                                        RecoveryCancelOltp.mConnections[i].commit();
                                        RecoveryCancelOltp.mConnections[i].close();
                                        ++i;
                                    }
                                    break block94;
lbl395:
                                    // 1 sources

                                    catch (Exception var16_38) {
                                        // empty catch block
                                    }
                                }
                                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all opened dbm server connections!");
                                if (this.mDBMan == null) break block95;
                                ** try [egrp 6[TRYBLOCK] [7 : 2728->2738)] { 
lbl401:
                                // 1 sources

                                this.mDBMan.release();
                                break block96;
lbl403:
                                // 1 sources

                                catch (RTEException var16_39) {
                                    // empty catch block
                                }
                            }
                            this.mDBMan = null;
                        }
                        if (this.mDBMan2 == null) break block97;
                        ** try [egrp 7[TRYBLOCK] [8 : 2752->2762)] { 
lbl410:
                        // 1 sources

                        this.mDBMan2.release();
                        break block98;
lbl412:
                        // 1 sources

                        catch (RTEException var16_40) {
                            // empty catch block
                        }
                    }
                    this.mDBMan2 = null;
                }
                if (this.mDBMan3 == null) break block99;
                ** try [egrp 8[TRYBLOCK] [9 : 2776->2786)] { 
lbl419:
                // 1 sources

                this.mDBMan3.release();
                break block100;
lbl421:
                // 1 sources

                catch (RTEException var16_41) {
                    // empty catch block
                }
            }
            this.mDBMan3 = null;
        }
        if (RecoveryCancelOltp.mTraceLevel <= 0) return;
        System.out.println("Game Over");
    }

    static /* synthetic */ void access$6(String string, char c, String string2) {
        TestCase.addGlobalMessage((String)string, (char)c, (String)string2);
    }

    class Writer
    extends OLTPTestActor {
        boolean keepRunning = true;
        String nameW;
        int numberW;
        int StmtCount;
        int connectionW;

        Writer(int writerNo, int conNo) {
            this.nameW = "Writer" + writerNo;
            this.numberW = writerNo;
            this.connectionW = conNo;
            this.StmtCount = 0;
            this.start();
            RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), String.valueOf(this.nameW) + " just started!");
        }

        public void check() {
            if (mTraceLevel > 0) {
                System.out.println("does not check anything yet");
            }
        }

        public void run() {
            try {
                Connection con = mConnections[this.connectionW];
                RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), String.valueOf(this.nameW) + " uses Connection number " + this.connectionW);
                while (this.keepRunning && !RecoveryCancelOltp.this.globalError) {
                    ++this.StmtCount;
                    this.executeWritingOps(con, this.numberW);
                    Thread.sleep(50L);
                }
            }
            catch (Exception e) {
                if (mTraceLevel > 0) {
                    System.out.println("Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                }
                RecoveryCancelOltp.this.handleException(e);
            }
        }

        public void pleaseStop() {
            if (mTraceLevel > 0) {
                System.out.println(String.valueOf(this.nameW) + ": Asking thread to please stop!");
            }
            this.keepRunning = false;
        }

        private void executeWritingOps(Connection pConnection, int user) throws TestCaseException {
            int CurrentCycle = 0;
            int maxValue = 0;
            this.mRunning = true;
            try {
                while (this.keepRunning && !RecoveryCancelOltp.this.globalError) {
                    if (CurrentCycle % 50 == 0 && mTraceLevel > 0) {
                        System.out.println(String.valueOf(this.nameW) + " - CurrentCycle:" + CurrentCycle);
                    }
                    String sql = "SELECT MAX(KEY1) AS largestKey FROM RCTAB_" + user;
                    ResultSet rs = mStatements[user].executeQuery(sql);
                    if (rs.next()) {
                        maxValue = rs.getInt("largestKey");
                    }
                    mPrepStatement[user] = new TestPreparedStatement(null, pConnection, "insert RCTAB_" + user + " (key1, key2, value_a, value_b) values (?, ?, ?, ? )");
                    int ix = maxValue + 1;
                    while (ix <= mNoOfRecords + maxValue) {
                        mPrepStatement[user].setInt(1, ix);
                        mPrepStatement[user].setInt(2, 0);
                        mPrepStatement[user].setInt(3, ix);
                        mPrepStatement[user].setString(4, Integer.toString(ix));
                        mPrepStatement[user].addBatch();
                        if (ix % 1000 == 0) {
                            mPrepStatement[user].executeBatch();
                            mPrepStatement[user].clearBatch();
                        }
                        ++ix;
                    }
                    mPrepStatement[user].executeBatch();
                    pConnection.commit();
                    sql = "delete from rctab_" + user + " where key1 > (select max(key1) - 10 from rctab_" + user + ") ";
                    mStatements[user].executeUpdate(sql);
                    mConnections[user].commit();
                    sql = "update rctab_" + user + " set VALUE_B = 'Test' where key1 > (select max(key1) - 10 from rctab_" + user + ")";
                    mStatements[user].executeUpdate(sql);
                    mConnections[user].commit();
                    if (CurrentCycle < 11) {
                        sql = "alter table rctab_" + user + " add COL_" + CurrentCycle + " CHAR(10) default null";
                        mStatements[user].executeUpdate(sql);
                        mConnections[user].commit();
                    }
                    Thread.sleep(25L);
                    if (mNoOfCycles != -1 && ++CurrentCycle > mNoOfCycles) {
                        if (mTraceLevel > 0) {
                            System.out.println(String.valueOf(this.nameW) + ": Finished <" + (CurrentCycle - 1) + "> cycles");
                        }
                        this.keepRunning = false;
                        this.setStatus(1);
                    }
                    if (!this.mShouldStop) continue;
                    if (mTraceLevel > 0) {
                        System.out.println(String.valueOf(this.nameW) + ": Soft interrupted at " + (CurrentCycle - 1) + " cycles");
                    }
                    this.keepRunning = false;
                    this.setStatus(2, "Interrupted by master thread at " + (CurrentCycle - 1) + " cycles");
                }
            }
            catch (InterruptedException e) {
                if (mTraceLevel > 0) {
                    System.out.println(String.valueOf(this.nameW) + ": Hard interrupted");
                }
                e.printStackTrace();
                this.setStatus(2);
                RecoveryCancelOltp.this.globalError = true;
                RecoveryCancelOltp.this.globalErrorText = String.valueOf(this.nameW) + ": hard interrupted -> " + e.getMessage();
            }
            catch (Exception e) {
                RecoveryCancelOltp.this.globalError = true;
                if (mTraceLevel > 0) {
                    System.out.println(String.valueOf(this.nameW) + ": ** ERROR **  General exception: " + e.getMessage());
                }
                e.printStackTrace();
                this.setStatus(-3, "Exception: " + e.getMessage());
                RecoveryCancelOltp.this.globalErrorText = "During executeWritingOps an general exception occured for " + this.nameW + "; please look into knldiag and test protocol.";
            }
        }
    }

    class QueueCountChanger
    extends OLTPTestActor {
        boolean keepRunning = true;
        String nameR = "QueueCntChanger ";

        QueueCountChanger() {
            if (mTraceLevel > 0) {
                System.out.println(String.valueOf(this.nameR) + " constucted!");
            }
            this.start();
            RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), String.valueOf(this.nameR) + " just started!");
        }

        public void check() {
            if (mTraceLevel > 0) {
                System.out.println("in check");
            }
        }

        public void run() {
            int queueCount = 1;
            try {
                String sMaxCPU = RecoveryCancelOltp.this.executeDBMCmd3("param_directget MAXCPU");
                sMaxCPU = sMaxCPU.substring(7, 8);
                int iMaxCPU = RecoveryCancelOltp.this.string2number(sMaxCPU);
                while (this.keepRunning && !testIsInterrupted) {
                    Thread.sleep(500L);
                    String theCurrentDBState = RecoveryCancelOltp.this.executeDBMCmd3("db_state").substring(6).trim().toUpperCase();
                    if (!theCurrentDBState.equals("ONLINE") && !theCurrentDBState.equals("WARM")) continue;
                    RecoveryCancelOltp.this.executeDBMCmd3("param_put -running -permanent LOG_QUEUE_COUNT " + queueCount);
                    if (++queueCount <= iMaxCPU) continue;
                    queueCount = 0;
                }
                RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), "Exiting QueueCountChanger");
                if (testIsInterrupted) {
                    System.out.println("QueueCountChanger interrupted by main test in run() - method.");
                }
            }
            catch (Exception e) {
                if (mTraceLevel > 0) {
                    System.out.println("+++++++++++++++++++++Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                }
                if (e instanceof InterruptedException) {
                    RecoveryCancelOltp.access$6(RecoveryCancelOltp.getTestClassId(), 'W', "QueueCountChanger caught an InterruptedException and stopped.\nMessage: " + e.getMessage());
                }
                RecoveryCancelOltp.access$6(RecoveryCancelOltp.getTestClassId(), 'E', "QueueCountChanger caught an exception and stopped.\nMessage: " + e.getMessage());
            }
        }

        public void pleaseStop() {
            if (mTraceLevel > 0) {
                System.out.println(String.valueOf(this.nameR) + ": Asking QueueCountChanger thread to please stop!");
            }
            RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), String.valueOf(this.nameR) + " please stop!");
            this.keepRunning = false;
        }
    }

    class Killer
    extends OLTPTestActor {
        boolean keepRunning = true;
        String nameR;
        int numberR;
        int tmpConVers;

        Killer(int killerNo) {
            this.nameR = "Killer " + killerNo;
            this.numberR = killerNo;
            this.tmpConVers = 0;
            if (mTraceLevel > 0) {
                System.out.println(String.valueOf(this.nameR) + " constucted!");
            }
            this.start();
            RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), String.valueOf(this.nameR) + " just started!");
        }

        public void check() {
            if (mTraceLevel > 0) {
                System.out.println("in check");
            }
        }

        public void run() {
            try {
                while (this.keepRunning && !testIsInterrupted) {
                    Thread.sleep(1000L);
                    if (!noFullRecovery) {
                        this.keepRunning = false;
                    }
                    if (!killing) {
                        this.tmpConVers = RecoveryCancelOltp.this.getConverterVersion();
                    }
                    if (this.tmpConVers <= converterVersionStart) continue;
                    this.executeKillingOps(this.numberR);
                    this.keepRunning = true;
                    converterVersionStart = this.tmpConVers;
                }
                if (testIsInterrupted) {
                    System.out.println("Killer interrupted by main test in run() - method.");
                }
            }
            catch (Exception e) {
                if (mTraceLevel > 0) {
                    System.out.println("Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                    e.printStackTrace();
                }
                RecoveryCancelOltp.this.handleException(e);
                RecoveryCancelOltp.access$6(RecoveryCancelOltp.getTestClassId(), 'E', "Killer caught an exception and stopped.\nMessage: " + e.getMessage());
            }
        }

        public void pleaseStop() {
            if (mTraceLevel > 0) {
                System.out.println(String.valueOf(this.nameR) + ": Asking killer thread to please stop!");
            }
            this.keepRunning = false;
        }

        private void executeKillingOps(int user) throws TestCaseException {
            block11: {
                try {
                    while (this.keepRunning && !testIsInterrupted) {
                        if (mTypeOfKilling.equals("db_stop")) {
                            RecoveryCancelOltp.this.executeDBMCmd2("db_stop");
                            if (mTraceLevel > 0) {
                                System.out.println("DB_STOP by Killer");
                            }
                            killing = true;
                            if (mTraceLevel > 0) {
                                System.out.println("killing: " + killing);
                            }
                        } else if (mTypeOfKilling.equals("cancel")) {
                            RecoveryCancelOltp.this.executeDBMCmd2("db_cons cancel t4");
                            if (mTraceLevel > 0) {
                                System.out.println("Cancel by Killer");
                            }
                            Thread.sleep(1000L);
                            killing = true;
                            if (mTraceLevel > 0) {
                                System.out.println("killing: " + killing);
                            }
                        }
                        this.keepRunning = false;
                    }
                    if (testIsInterrupted) {
                        System.out.println("Killer interrupted by main test in executeKillingOps(" + user + ").");
                    }
                }
                catch (Exception e) {
                    if (mTraceLevel <= 0) break block11;
                    System.out.println("Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                }
            }
        }
    }
}

