/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCell;
import com.sap.sapdb.oltptest.join.simulation.AscendingComparator;
import com.sap.sapdb.oltptest.join.simulation.Assertion;
import com.sap.sapdb.oltptest.join.simulation.NullValueCell;
import com.sap.sapdb.oltptest.join.simulation.Table;
import com.sap.sapdb.oltptest.join.simulation.TableDefinition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TableRow
implements Cloneable {
    TableDefinition tableDef;
    AbstractCell[] cells;
    static final NullValueCell NULL_VALUE = new NullValueCell();

    public TableRow(TableDefinition tableDefinition) {
        this.tableDef = tableDefinition;
        this.cells = new AbstractCell[this.tableDef.getColumnCount()];
        int i = 0;
        while (i < this.tableDef.getColumnCount()) {
            this.cells[i] = null;
            ++i;
        }
    }

    public TableRow(Table table) {
        this(table.getTableDefinition());
    }

    public TableRow(TableRow row) {
        this(row.tableDef);
    }

    public Object clone() {
        TableRow row = null;
        try {
            row = (TableRow)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        row.cells = new AbstractCell[this.cells.length];
        int i = 0;
        while (i < this.cells.length) {
            row.cells[i] = (AbstractCell)this.cells[i].clone();
            ++i;
        }
        return row;
    }

    public int getColumnCount() {
        return this.cells.length;
    }

    public Iterator getValueIterator() {
        return Arrays.asList(this.cells).iterator();
    }

    public AbstractCell getValue(int columnNumber) {
        return this.cells[columnNumber - 1];
    }

    public void setValue(int columnNumber, AbstractCell value) {
        Assertion.assertTrue(this.cells.length <= this.tableDef.getColumnCount());
        if (value == null) {
            this.setNullValue(columnNumber);
        } else {
            this.cells[columnNumber - 1] = value;
        }
    }

    public void setNullValue(int columnNumber) {
        this.cells[columnNumber - 1] = NULL_VALUE;
    }

    public String toString() {
        StringBuffer rowString = new StringBuffer();
        Iterator valIt = this.getValueIterator();
        while (valIt.hasNext()) {
            AbstractCell cell = (AbstractCell)valIt.next();
            rowString.append(cell.getValue());
            rowString.append("\t");
        }
        return rowString.toString();
    }

    public void setValues(int startColumn, TableRow row) {
        int srcCol = 0;
        int dstCol = startColumn - 1;
        while (srcCol < row.cells.length) {
            this.cells[dstCol] = row.cells[srcCol];
            ++srcCol;
            ++dstCol;
        }
    }

    public static TableRow mergeRows(TableDefinition table, TableRow leftRow, TableRow rightRow) {
        TableRow newRow = new TableRow(table);
        int dstCol = 0;
        int srcCol = 0;
        while (srcCol < leftRow.cells.length) {
            newRow.cells[dstCol] = leftRow.cells[srcCol];
            ++dstCol;
            ++srcCol;
        }
        srcCol = 0;
        while (srcCol < rightRow.cells.length) {
            newRow.cells[dstCol] = rightRow.cells[srcCol];
            ++dstCol;
            ++srcCol;
        }
        return newRow;
    }

    public static void mergeRows(TableRow row, TableRow leftRow, TableRow rightRow) {
        Assertion.assertTrue(row.getColumnCount() == leftRow.getColumnCount() + rightRow.getColumnCount());
        row.setValues(1, leftRow);
        row.setValues(leftRow.getColumnCount() + 1, rightRow);
    }

    public static Comparator createAscendingComparator(List columnList) {
        return new AscendingComparator(columnList);
    }
}

