/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCell;
import com.sap.sapdb.oltptest.join.simulation.AddableCell;

public class IntegerCell
extends AbstractCell
implements Cloneable,
AddableCell {
    private int value;

    public IntegerCell(int value) {
        this.value = value;
    }

    public IntegerCell(float floatValue) {
        this.value = (int)floatValue;
    }

    public String getType() {
        return "IntegerCell";
    }

    public boolean isEqual(AbstractCell otherCell) {
        if (otherCell.isNull()) {
            throw new NullPointerException();
        }
        return this.value == ((IntegerCell)otherCell).value;
    }

    public boolean isGreater(AbstractCell otherCell) {
        if (otherCell.isNull()) {
            throw new NullPointerException();
        }
        return this.value > ((IntegerCell)otherCell).value;
    }

    public boolean isLess(AbstractCell otherCell) {
        if (otherCell.isNull()) {
            throw new NullPointerException();
        }
        return this.value < ((IntegerCell)otherCell).value;
    }

    public String getValue() {
        return Integer.toString(this.value);
    }

    public Object clone() {
        return super.clone();
    }

    public boolean isNull() {
        return false;
    }

    public String getSqlLiteral() {
        return this.getValue();
    }

    public int getIntValue() {
        return this.value;
    }

    public float getFloatValue() {
        return this.value;
    }

    public AbstractCell add(AddableCell cellToAdd) {
        return new IntegerCell(this.value + ((IntegerCell)cellToAdd).value);
    }
}

