/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.description;

public class IntForLoop {
    int from;
    int to;
    int width;
    int[] current;

    public IntForLoop(int from, int to, int width) {
        this.from = from;
        this.to = to;
        this.width = width;
        this.current = new int[width];
        int i = 0;
        while (i < width - 1) {
            this.current[i] = from;
            ++i;
        }
        this.current[width - 1] = from - 1;
    }

    public int[] next() {
        boolean hasNext = this.increment(this.width - 1);
        if (!hasNext) {
            return null;
        }
        int[] result = new int[this.width];
        System.arraycopy(this.current, 0, result, 0, this.width);
        return result;
    }

    protected boolean increment(int column) {
        if (column < 0) {
            return false;
        }
        if (this.current[column] < this.to) {
            int n = column;
            this.current[n] = this.current[n] + 1;
            int i = column + 1;
            while (i < this.width) {
                this.current[i] = this.from;
                ++i;
            }
            return true;
        }
        return this.increment(column - 1);
    }

    public static void main(String[] args) {
        int[] value;
        int width = 3;
        IntForLoop iter = new IntForLoop(0, 2, width);
        while ((value = iter.next()) != null) {
            System.out.print("!!! ");
            int i = 0;
            while (i < width) {
                System.out.print(" " + value[i]);
                ++i;
            }
            System.out.println("");
        }
    }
}

