/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join;

import com.sap.sapdb.oltptest.join.ParameterIterator;
import com.sap.sapdb.oltptest.join.description.JoinQuery;
import com.sap.sapdb.oltptest.join.simplejdbc.Connection;
import java.io.PrintStream;
import java.sql.SQLException;

public class ParameterCombination {
    private JoinQuery join;
    private Connection session;
    private ParameterIterator[] parameters;
    private boolean beforeStart;

    public ParameterCombination(JoinQuery join, Connection session, ParameterIterator[] parameters) {
        this.join = join;
        this.session = session;
        this.parameters = parameters;
        this.beforeStart = true;
    }

    public boolean next() throws SQLException {
        boolean result = true;
        if (this.beforeStart) {
            int i = 0;
            while (i < this.parameters.length) {
                result = result && this.parameters[i].resetFor(this.join, this.session);
                ++i;
            }
            this.beforeStart = false;
        } else {
            result = this.next(this.parameters.length - 1);
        }
        return result;
    }

    protected boolean next(int index) throws SQLException {
        if (index < 0) {
            return false;
        }
        boolean result = this.parameters[index].nextFor(this.join, this.session);
        if (!result) {
            return this.next(index - 1);
        }
        int i = index + 1;
        while (i < this.parameters.length) {
            this.parameters[i].resetFor(this.join, this.session);
            ++i;
        }
        return true;
    }

    public void dumpOn(PrintStream stream) {
        int i = 0;
        while (i < this.parameters.length) {
            stream.print("== ");
            stream.print(this.parameters[i].dumpString());
            stream.println();
            ++i;
        }
    }
}

