/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.upgradetest.Configuration;
import com.sap.sapdb.upgradetest.ConfigurationException;
import com.sap.sapdb.upgradetest.Executor;
import com.sap.sapdb.upgradetest.ExecutorEvent;
import com.sap.sapdb.upgradetest.ExecutorListener;
import com.sap.sapdb.upgradetest.ExecutorServer;
import com.sap.sapdb.upgradetest.ExecutorServerImpl;
import com.sap.sapdb.upgradetest.InstallationHelper;
import com.sap.sapdb.upgradetest.Logger;
import com.sap.sapdb.upgradetest.RemoteExecutor;
import com.sap.sapdb.upgradetest.SettingNotFoundException;
import com.sap.sapdb.upgradetest.UpgradeTestException;
import com.sap.sapdb.upgradetest.UpgradeTestExecutor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class UpgradeTest
extends TestCase
implements RemoteExecutor {
    private static String startDateTime;
    private static final String UNKNOWNSTEP = "UNKOWN STEP";
    public static final String TIMESTAMP = "Mittwoch, der 07. Dezember 2005, 16:29 Uhr";
    private Configuration config;
    private InstallationHelper ih;
    private Vector testmsgs = new Vector();
    private String currentStep = "UNKOWN STEP";
    private int stepCounter = 0;
    private int plannedRuns = 0;
    private int MAKEKEY_OLTP = -1;
    private int MAKEKEY_APO = -1;
    private volatile boolean isInterrupted = false;
    private volatile boolean isRunning = false;
    private volatile boolean isStarted = false;
    private volatile boolean isDone = false;
    private final Vector executorListeners = new Vector();
    private final Vector brokenListenerIds = new Vector();
    private UpgradeTestExecutor upgradeTestExecutor;

    public UpgradeTest() throws SQLException, TestDatabaseException, TestCaseException {
        Logger.addLogListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                UpgradeTest.this.fireRemoteLogEvent(e.getPropertyName());
            }
        });
    }

    public String getSubDataOutputPath() {
        StringBuffer sDOPsb = new StringBuffer(super.getDataOutputPath());
        sDOPsb.append(File.separator);
        sDOPsb.append("UpgradeTest_at_");
        sDOPsb.append(startDateTime);
        File sDOPFile = new File(sDOPsb.toString());
        String sDOPs = sDOPsb.toString();
        if (sDOPFile.exists() && !sDOPFile.isDirectory()) {
            Logger.error("Output dir blocked by " + sDOPs);
            return null;
        }
        if (!sDOPFile.exists()) {
            sDOPFile.mkdirs();
        }
        Logger.log(Logger.DEBUG, "UpgradeTest.dataOutputPath() requested, returning " + sDOPs);
        return sDOPs;
    }

    File prepareLogger() throws SettingNotFoundException, IOException {
        Logger.setEcho(!"NO".equals(TestCase.getParameterString((String)"echo-log", (String)"NO")));
        UpgradeTest.resetStartDateTime();
        Logger.setLevel(this.config.getLogLevel());
        File logFile = this.config.getLogFile();
        if (this.config.isAutoCreate() || logFile == null) {
            logFile = new File(this.getSubDataOutputPath(), "UpgradeTest_at_" + startDateTime + ".log");
            this.config.setLogFile(logFile);
        }
        Logger.log(Logger.STANDARD, "Logfile is " + logFile.getAbsolutePath());
        Logger.setStdOutToFile(logFile);
        Logger.setStdErrToFile(logFile);
        Logger.log(Logger.STANDARD, "=========================================================");
        Logger.log(Logger.STANDARD, "  Logfile started on " + new Date() + " ");
        Logger.log(Logger.STANDARD, "=========================================================");
        return logFile;
    }

    void abortUnhandled(Exception ex) {
        try {
            this.fireRemoteExceptionEvent(ex);
            this.handleExceptions(ex);
            Logger.stackTrace(ex);
            this.abort("UpgradeTest()", ex.getMessage(), ex, null);
        }
        catch (TestCaseException testCaseException) {
            // empty catch block
        }
    }

    private void connectExecutorServer() throws UnknownHostException, RemoteException, MalformedURLException, NotBoundException {
        this.upgradeTestExecutor = new UpgradeTestExecutor(this);
        UnicastRemoteObject.exportObject(this.upgradeTestExecutor);
        ExecutorServer exec = ExecutorServerImpl.getLocalExecutorServer();
        exec.setCurrentExecutor(this.upgradeTestExecutor);
    }

    private void connectExecutorServerHandled() {
        try {
            this.connectExecutorServer();
        }
        catch (NotBoundException nbe) {
            String message = "Cannot connect to ExecutorServer: Server not up!";
            Logger.log(message);
            this.addMessage("", 'I', message);
        }
        catch (MalformedURLException mfe) {
            String message = "Cannot connect to ExecutorServer: Wrong url:" + mfe.getMessage();
            Logger.log(message);
            this.addMessage("", 'I', message);
        }
        catch (RemoteException re) {
            String message = "RemoteException while connecting ExecutorServer:" + re.getMessage();
            Throwable cause = re.getCause();
            if (cause != null) {
                message = message + "\n(" + cause.getMessage() + ")";
            }
            Logger.log(message);
            this.addMessage("", 'I', message);
        }
        catch (UnknownHostException uhe) {
            String message = "Cannot connect ExecutorServer, unknown host: " + uhe.getMessage();
            Logger.log(message);
            this.addMessage("", 'I', message);
        }
    }

    private void disconnectExecutorServer() throws UnknownHostException, RemoteException, MalformedURLException, NotBoundException {
        if (this.upgradeTestExecutor != null) {
            ExecutorServer exec = ExecutorServerImpl.getLocalExecutorServer();
            exec.setCurrentExecutor(null);
        }
    }

    private void disconnectExecutorServerHandled() {
        try {
            this.disconnectExecutorServer();
        }
        catch (NotBoundException nbe) {
            String message = "Cannot disconnect from ExecutorServer: Server not up!";
            this.addMessage("", 'I', message);
        }
        catch (MalformedURLException mfe) {
            String message = "Cannot disconnect from ExecutorServer: Wrong url:" + mfe.getMessage();
            this.addMessage("", 'I', message);
        }
        catch (RemoteException re) {
            String message = "RemoteException while disconnecting ExecutorServer:" + re.getMessage();
            Throwable cause = re.getCause();
            if (cause != null) {
                message = message + "\n(" + cause.getMessage() + ")";
            }
            this.addMessage("", 'I', message);
        }
        catch (UnknownHostException uhe) {
            String message = "Cannot disconnect ExecutorServer, unknown host: " + uhe.getMessage();
            this.addMessage("", 'I', message);
        }
    }

    public void run() {
        boolean keepTemps;
        this.isStarted = true;
        this.isRunning = true;
        this.fireStartedEvent();
        try {
            this.runUnhandled();
        }
        catch (ConfigurationException ec) {
            Logger.error("Configuration error occured.");
            this.abortUnhandled(ec);
        }
        catch (SQLException es) {
            Logger.error("SQL exception occured.");
            this.abortUnhandled(es);
        }
        catch (IOException ef) {
            Logger.error("FileNotFoundException occured.");
            this.abortUnhandled(ef);
        }
        catch (ParserConfigurationException ep) {
            Logger.error("XML parser error occured.");
            this.abortUnhandled(ep);
        }
        catch (SAXException esax) {
            Logger.error("XML parser error occured.");
            this.abortUnhandled(esax);
        }
        for (int i = 0; i < this.testmsgs.size(); ++i) {
            Logger.log(Logger.STANDARD, (String)this.testmsgs.get(i));
        }
        if (this.isInterrupted) {
            String message = "Test interrupted by external event!";
            this.addMessage("", 'I', message);
            Logger.log(Logger.STANDARD, message);
        }
        boolean bl = keepTemps = !"".equals(TestCase.getParameterString((String)"keep-temps", (String)""));
        if (this.ih != null) {
            String message;
            if (!keepTemps) {
                message = "Removing temporary files";
                this.ih.deleteTempFiles();
            } else {
                message = "Keeping temporary files";
            }
            Logger.log(message);
        }
        this.isRunning = false;
        this.isDone = true;
        this.fireFinishedEvent(this.isInterrupted ? "killed" : "finished normally");
        this.disconnectExecutorServerHandled();
    }

    public void runUnhandled() throws ConfigurationException, SQLException, IOException, ParserConfigurationException, SAXException {
        String firstMessage = "Timestamp:Mittwoch, der 07. Dezember 2005, 16:29 Uhr, OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version") + ", HOST: " + InetAddress.getLocalHost().getHostName();
        this.addMessage("", 'I', firstMessage);
        this.configureTests();
        Logger.log(firstMessage);
        this.plannedRuns = this.config.getTestCount();
        String secondMessage = "Starting " + this.plannedRuns + " upgrades on " + this.config.getEnvironmentDescription();
        Logger.log(secondMessage);
        this.addMessage("", 'I', secondMessage);
        this.connectExecutorServerHandled();
        for (int testindex = 0; testindex < this.plannedRuns; ++testindex) {
            try {
                if (Configuration.isUnix()) {
                    this.cleanPreviousTestRuns();
                }
                if (this.isInterrupted) {
                    this.cleanTestEnvironment(testindex);
                    break;
                }
                this.runOneTest(testindex);
                continue;
            }
            catch (UpgradeTestException ex) {
                this.testmsgs.add("Test #[" + testindex + "]: " + this.config.getVersionDescription(testindex) + " Result: FAILED");
                this.addMessage("Test #[" + testindex + "]", 'I', this.config.getVersionDescription(testindex) + " Result: FAILED");
                this.handleTestRunError(ex, testindex);
                Logger.stackTrace(ex.getNestedException());
                if (!ex.needsCleanup()) continue;
                this.cleanTestEnvironment(testindex);
                continue;
            }
            catch (Exception ex) {
                this.testmsgs.add("Test #[" + testindex + "]: " + this.config.getVersionDescription(testindex) + " Result: FAILED");
                this.addMessage("Test #[" + testindex + "]", 'I', this.config.getVersionDescription(testindex) + " Result: FAILED");
                this.handleTestRunError(ex, testindex);
                this.cleanTestEnvironment(testindex);
            }
        }
    }

    void cleanTestEnvironment(int testindex) {
        try {
            this.ih.runDBMscript(testindex, "prepuninst");
            Logger.log("Test database dropped");
        }
        catch (Exception ex) {
            Logger.log("Drop test database failed: " + ex.getMessage());
        }
        try {
            this.ih.stopXServer();
        }
        catch (Exception ex) {
            Logger.log("Stop xserver failed: " + ex.getMessage());
        }
        try {
            this.ih.uninstallDB(testindex);
            Logger.log("Software uninstalled");
        }
        catch (Exception ex) {
            Logger.log("Uninstall software failed: " + ex.getMessage());
        }
    }

    private void cleanPreviousTestRuns() {
        try {
            this.ih.stopXServer();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] files = new String[]{this.config.getIndepProgOrNullString(), this.config.getIndepDataOrNullString(), "/usr/spool/sql/ini", "/usr/spool/sql/config", "/usr/spool/sql/dbspeed", "/usr/spool/sql/diag", "/usr/spool/sql/fifo", "/usr/spool/sql/ipc", "/usr/spool/sql/pid", "/usr/spool/sql/pipe", "/usr/spool/sql/pppid", "/var/spool/sql/ini", "/etc/opt/sdb"};
        for (int i = 0; i < files.length; ++i) {
            UpgradeTest.myDelTree(files[i] == null ? null : new File(files[i]));
        }
    }

    private static void myDelTree(File f) {
        if (InstallationHelper.deltree(f)) {
            Logger.log("Removed  '" + f + "'");
        }
    }

    private void handleTestRunError(Exception ex, int testindex) {
        this.fireRemoteExceptionEvent(ex);
        Logger.log("ERROR in  " + this.currentStep);
        Logger.stackTrace(ex);
        String name = ex.getClass().getName();
        int index = name.lastIndexOf(".");
        name = index > 0 && index + 1 < name.length() ? name.substring(index + 1) : name;
        String testDescription = this.config.getVersionDescription(testindex);
        String prefix = "Test #[" + testindex + "]";
        String msg = "ERROR MESSAGE:";
        String exmsg = ex.getMessage();
        String string = exmsg = exmsg == null ? "[NO ERROR MESSAGE]" : exmsg.trim();
        if (msg.indexOf("\n") > 0) {
            LineNumberReader lr = new LineNumberReader(new StringReader(exmsg));
            String line = null;
            try {
                while ((line = lr.readLine()) != null) {
                    msg = msg + "\n\t" + line;
                }
            }
            catch (IOException exx) {}
        } else {
            msg = "\n\tERROR MESSAGE: " + exmsg;
        }
        this.addMessage(prefix, 'E', "\tERROR IN       : " + testDescription + "\n\tDURING STEP  : [" + this.currentStep.toUpperCase() + "]" + "\n\tERROR TYPE   : " + name + "" + msg);
    }

    private void beginStep(String step, boolean setStatus, int index) {
        this.currentStep = step;
        if (setStatus) {
            String status = "";
            if ((status = status + index + "/" + this.plannedRuns + ": " + this.currentStep).length() > 62) {
                status = status.substring(0, 62) + "..";
            }
            this.setStatus(status);
        }
        Logger.log("[STEP " + this.stepCounter + ": " + this.currentStep.toUpperCase() + "]");
        ++this.stepCounter;
    }

    private void endStep() {
    }

    TestResult runOneTest(int testindex) throws UpgradeTestException, IOException, TestDatabaseException, InterruptedException, RTEException, DBMException {
        this.stepCounter = 1;
        TestResult testResult = new TestResult();
        boolean bricktest = this.config.isBrickTest(testindex);
        String testDescription = this.config.getVersionDescription(testindex);
        this.fireRemoteStatusEvent("subprocess started", testDescription, null);
        Logger.log(Logger.STANDARD, "");
        Logger.log(Logger.STANDARD, "*************************************************************************************");
        Logger.log(Logger.STANDARD, "Test #" + testindex + " " + testDescription + " STARTED ...");
        Logger.log(Logger.STANDARD, "*************************************************************************************");
        Logger.log(Logger.STANDARD, "");
        testResult.exitValue = 0;
        this.beginStep("getting source software", false, testindex);
        this.ih.getPackage(testindex, "source");
        this.endStep();
        if (this.isInterrupted) {
            return testResult;
        }
        this.beginStep("getting target software", false, testindex);
        this.ih.getPackage(testindex, "target");
        this.endStep();
        if (this.isInterrupted) {
            return testResult;
        }
        if (bricktest) {
            this.beginStep("getting brick software", false, testindex);
            this.ih.getPackage(testindex, "brick");
            this.endStep();
            if (this.isInterrupted) {
                return testResult;
            }
        }
        this.beginStep("installing source software", true, testindex);
        this.ih.installDB(testindex, "source");
        this.endStep();
        if (this.isInterrupted) {
            return testResult;
        }
        if (bricktest) {
            this.ih.installDB(testindex, "brick");
            this.endStep();
            if (this.isInterrupted) {
                return testResult;
            }
        }
        this.beginStep("starting x-server", false, testindex);
        this.ih.startXServer(testindex);
        this.endStep();
        if (this.isInterrupted) {
            return testResult;
        }
        this.beginStep("creating test database", false, testindex);
        this.ih.createTestDatabase(testindex, this.ih);
        this.endStep();
        if (this.isInterrupted) {
            return testResult;
        }
        this.beginStep("preparing the db for update", false, testindex);
        this.ih.runDBMscript(testindex, "prepupdate");
        this.endStep();
        if (this.isInterrupted) {
            return testResult;
        }
        this.beginStep("updating", true, testindex);
        this.ih.updateDB(testindex, "target");
        this.endStep();
        if (this.isInterrupted) {
            return testResult;
        }
        this.beginStep("dropping instance", false, testindex);
        this.ih.runDBMscript(testindex, "prepuninst");
        this.endStep();
        if (this.isInterrupted) {
            return testResult;
        }
        this.beginStep("stopping x-server", false, testindex);
        this.ih.stopXServer();
        this.endStep();
        if (this.isInterrupted) {
            return testResult;
        }
        this.beginStep("uninstalling software", true, testindex);
        this.ih.uninstallDB(testindex);
        this.endStep();
        this.ih.removeLogFiles(testindex);
        this.testmsgs.add("Test #[" + testindex + "]: " + testDescription + " Result: SUCCESS");
        this.addMessage("Test #[" + testindex + "]", 'I', testDescription + " Result: SUCCESS");
        String event = "finished";
        this.fireRemoteStatusEvent("subprocess finished", "finished subtest", "finished normally");
        return testResult;
    }

    public boolean isOLTPTest() {
        return this.getMakeKeyOLTP() > 0 && this.getMakeKeyAPO() == 0;
    }

    public boolean isAPOTest() {
        return this.getMakeKeyOLTP() > 0 && this.getMakeKeyAPO() > 0;
    }

    public boolean isMinimalTest() {
        boolean minimalTesting = false;
        try {
            minimalTesting = TestCase.getParameterBoolean((String)"minimaltest", (boolean)false);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return minimalTesting;
    }

    public int getMakeKeyAPO() {
        if (this.MAKEKEY_APO < 0) {
            if ("MakeKey2" != null) {
                this.MAKEKEY_APO = Integer.parseInt(mTestDriverOptions.getProperty("MakeKey2"));
            }
            if (this.MAKEKEY_APO < 0) {
                this.MAKEKEY_APO = 0;
            }
        }
        return this.MAKEKEY_APO;
    }

    public int getMakeKeyOLTP() {
        if (this.MAKEKEY_OLTP < 0) {
            if ("MakeKey" != null) {
                this.MAKEKEY_OLTP = Integer.parseInt(mTestDriverOptions.getProperty("MakeKey"));
            }
            if (this.MAKEKEY_OLTP < 0) {
                this.MAKEKEY_OLTP = 0;
            }
        }
        return this.MAKEKEY_OLTP;
    }

    private void platformCheck() throws ConfigurationException {
        Configuration.Platform plfMakeKey = this.config.getPlatformFromMakeKey();
        Configuration.Platform plfQADB = this.config.getPlatformFromQADB();
        if (plfMakeKey != null && plfQADB != null) {
            if (!plfMakeKey.distribName.equals(plfQADB.distribName)) {
                String message = "Platform from make key " + plfMakeKey.descText + " wrong, need " + plfQADB.descText;
                this.addMessage("", 'E', message);
                throw new ConfigurationException(message);
            }
            this.addMessage("", 'I', "Platform from make key " + this.getMakeKeyOLTP() + " is " + ":  " + plfMakeKey.stringRep());
        }
    }

    private void configureTests() throws ConfigurationException, SQLException, IOException, ParserConfigurationException, SAXException {
        String paramFileLocation = this.getParameterFileLocation();
        File paramFile = paramFileLocation != null ? new File(paramFileLocation) : null;
        this.config = Configuration.getInstance(new File(this.getDataInputPath()), paramFile);
        try {
            File f = this.prepareLogger();
            if (f != null) {
                System.out.println("upgr--> Logging to file     '" + f + "'");
                Logger.log("Original location of this log: '" + f + "'");
            } else {
                this.addMessage("", 'E', "Error initializing log files: (No error message available)");
            }
        }
        catch (Exception ex) {
            this.addMessage("", 'E', "Error initializing log files: " + ex.getMessage(), ex);
        }
        Logger.log(Logger.STANDARD, "Parameter  file is '" + this.config.getParameterFile() + "'");
        Logger.log(Logger.STANDARD, "Configuration file is '" + this.config.getConfigFile() + "'");
        if (this.isMinimalTest()) {
            Logger.log("Minimal tests are enabled.");
        }
        if (this.isOLTPTest()) {
            this.config.createAutoConfigOLTP(this.getMakeKeyOLTP() + "", this.isMinimalTest());
            this.platformCheck();
        } else if (this.isAPOTest()) {
            this.config.createAutoConfigAPO(this.getMakeKeyOLTP() + "", this.getMakeKeyAPO() + "", this.isMinimalTest());
            this.platformCheck();
        } else {
            String msg = "Test scenario is taken from file '" + this.config.getConfigFile() + "'";
            Logger.log(msg);
            this.addMessage("", 'I', msg);
        }
        if (TestCase.getParameterString((String)"os", (String)"").equals("AIX")) {
            if ((double)Float.parseFloat(System.getProperty("os.version")) >= 5.0) {
                this.config.setEnvironmentOs("AIX5");
            } else {
                this.config.setEnvironmentOs("AIX");
            }
        } else {
            this.config.setEnvironmentOs(TestCase.getParameterString((String)"os", (String)""));
        }
        this.config.setEnvironmentBits(TestCase.getParameterString((String)"bit", (String)""));
        this.config.setEnvironmentPlatform(System.getProperty("os.arch"));
        String platformMessage = "Platform determined: " + this.config.getCurrentPlatform().stringRep();
        if (Configuration.UNKNOWNPLATFORM.equals(this.config.getCurrentPlatform())) {
            if (Configuration.isWindows()) {
                this.config.setCurrentPlatform(Configuration.NTINTEL);
                platformMessage = "Platform guissed: " + this.config.getCurrentPlatform().stringRep();
            } else {
                platformMessage = "Could not determine platform of test server";
                this.addMessage("", 'E', platformMessage);
                throw new ConfigurationException(platformMessage);
            }
        }
        this.addMessage("", 'I', platformMessage);
        Logger.log(platformMessage);
        this.ih = new InstallationHelper(this.config, new File(this.getSubDataOutputPath()));
    }

    void logExecutableError(Executor exe, int index) {
        String message = exe.contextErrorMessage;
        Logger.warning(message);
        this.testmsgs.add(message);
        this.addMessage("[]test #" + index + "]: ", 'E', message);
    }

    public static long getTimeout() {
        return 0L;
    }

    public String getLogFile() {
        Logger.log(Logger.VERBOSE, "Logfile requested, creating the ZIP containing it.");
        if (this.ih == null) {
            Logger.warning("Cannot create zip with logfiles, InstallationHelper hasn't been created yet.");
            this.addMessage("[UpgradeTest]", 'W', "Failed to create zip with logfiles, InstallationHelper hasn't been created yet.");
            return null;
        }
        String logpath = null;
        try {
            logpath = this.ih.createLogfileZip(this.testmsgs, this.getDataOutputPath());
        }
        catch (Exception e) {
            this.addMessage("[UpgradeTest]", 'W', "Failed to create logfile with zips - no logfiles added!");
            Logger.stackTrace(e);
        }
        return logpath;
    }

    public static void cleanup() {
    }

    public static int getDBPort() {
        return Integer.parseInt(TestCase.mTestDriverOptions.getProperty("db-port", "7210"));
    }

    public static String getStartDateTime() {
        return startDateTime;
    }

    public static void resetStartDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yy_HH.mm");
        startDateTime = sdf.format(new Date());
    }

    public Executor getExecutor() throws RemoteException {
        return this.upgradeTestExecutor.getExecutor();
    }

    public void start() throws RemoteException {
        Thread thr = new Thread(new Runnable(){

            public void run() {
                UpgradeTest.this.run();
            }
        });
        thr.start();
    }

    public void setDelegates(RemoteExecutor[] delegates) throws RemoteException {
    }

    public RemoteExecutor[] getDelegates() throws RemoteException {
        return null;
    }

    public void execute() throws RemoteException {
        this.run();
    }

    public boolean isRunning() throws RemoteException {
        return this.isRunning;
    }

    public boolean isStarted() throws RemoteException {
        return this.isStarted;
    }

    public boolean wasInterrupted() throws RemoteException {
        return this.isInterrupted;
    }

    public void addExecutorListener(ExecutorListener l) throws RemoteException {
        this.executorListeners.add(l);
    }

    public void removeExecutorListener(ExecutorListener l) throws RemoteException {
        this.executorListeners.remove(l);
    }

    public boolean destroy() throws RemoteException {
        this.isInterrupted = true;
        while (this.isRunning) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                break;
            }
        }
        return true;
    }

    public boolean isDone() throws RemoteException {
        return this.isDone;
    }

    public boolean isForce() throws RemoteException {
        return false;
    }

    void fireRemoteLogEvent(String line) {
        Iterator iter = this.executorListeners.iterator();
        ExecutorEvent event = new ExecutorEvent("stdout event", line, null, "UPGRADE_TEST_JTEST_EXECUTOR");
        while (iter.hasNext()) {
            ExecutorListener l = (ExecutorListener)iter.next();
            Integer listenerRef = new Integer(l.hashCode());
            try {
                if (this.brokenListenerIds.contains(listenerRef)) continue;
                l.log(event);
            }
            catch (RemoteException ex) {
                this.brokenListenerIds.add(listenerRef);
            }
        }
    }

    void fireRemoteStatusEvent(String status, String msg, String finishedStatus) {
        Iterator iter = this.executorListeners.iterator();
        ExecutorEvent event = new ExecutorEvent("status event", msg, status, "UPGRADE_TEST_JTEST_EXECUTOR");
        event.setFinishedStatus(finishedStatus);
        while (iter.hasNext()) {
            ExecutorListener l = (ExecutorListener)iter.next();
            Integer listenerRef = new Integer(l.hashCode());
            try {
                if (this.brokenListenerIds.contains(listenerRef)) continue;
                l.executorStatus(event);
            }
            catch (RemoteException ex) {
                this.brokenListenerIds.add(listenerRef);
            }
        }
    }

    void fireRemoteExceptionEvent(Exception ex) {
        Iterator iter = this.executorListeners.iterator();
        ExecutorEvent event = new ExecutorEvent(new RemoteException(ex.getMessage(), ex), "UPGRADE_TEST_JTEST_EXECUTOR");
        while (iter.hasNext()) {
            ExecutorListener l = (ExecutorListener)iter.next();
            Integer listenerRef = new Integer(l.hashCode());
            try {
                if (this.brokenListenerIds.contains(listenerRef)) continue;
                l.exceptionOccurred(event);
            }
            catch (RemoteException rex) {
                this.brokenListenerIds.add(listenerRef);
            }
        }
    }

    void fireFinishedEvent(String finishedStatus) {
        String event = "finished";
        String msg = "Finished  upgradetests";
        this.fireRemoteStatusEvent(event, msg, finishedStatus);
    }

    void fireStartedEvent() {
        String event = "started";
        String msg = "Started upgradetests";
        this.fireRemoteStatusEvent(event, msg, null);
    }

    static class TestResult {
        int exitValue = -1337;
        Executor failedProcess = null;
        boolean fatalError = false;
        boolean failure = false;
        boolean warning = false;

        TestResult() {
        }
    }
}

