/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.upgradetest.ComplexParameter;
import com.sap.sapdb.upgradetest.Configuration;
import com.sap.sapdb.upgradetest.ConfigurationException;
import com.sap.sapdb.upgradetest.Executor;
import com.sap.sapdb.upgradetest.ExecutorEvent;
import com.sap.sapdb.upgradetest.ExecutorListener;
import com.sap.sapdb.upgradetest.ExecutorListenerAdapter;
import com.sap.sapdb.upgradetest.ExecutorListenerDelegator;
import com.sap.sapdb.upgradetest.ExecutorServer;
import com.sap.sapdb.upgradetest.ExecutorServerImpl;
import com.sap.sapdb.upgradetest.Logger;
import com.sap.sapdb.upgradetest.RemoteExecutor;
import com.sap.sapdb.upgradetest.TestCaseLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.SQLException;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TemplateTest
extends TestCase
implements TestCaseLogger {
    private Configuration config;
    private Configuration.SoftwareDescription software;
    private ExecutorServer executorServer = new ExecutorServerImpl();
    private RemoteExecutor currentExecutor;
    private String currentStep;
    private boolean isRemote = false;
    private String currentSubStep;
    private File logFile;
    private Writer log;
    private boolean logErrorReported = false;
    private boolean hasErrors = false;
    public static final String TIMESTAMP = "Mittwoch, der 23. November 2005, 16:36 Uhr";

    public void setCurrentStep(String s) {
        this.currentStep = s;
    }

    public void setCurrentSubStep(String s) {
        this.currentSubStep = s;
    }

    public void setHasErrors(boolean b) {
        this.hasErrors = b;
    }

    public synchronized void log(String line) {
        block3: {
            if (line == null) {
                return;
            }
            line = line.endsWith("\n") ? line : line + "\n";
            try {
                this.log.write(line);
                this.log.flush();
            }
            catch (IOException ex) {
                if (this.logErrorReported) break block3;
                TemplateTest.db("IOError writing log:  " + ex.getMessage());
                this.logErrorReported = true;
            }
        }
    }

    private void initialize() throws IOException, ConfigurationException, ParserConfigurationException, SAXException, SQLException {
        Logger.USE_STDOUT = false;
        String aparamFile = this.getParameterFileLocation();
        File dataInputPath = new File(this.getDataInputPath());
        File paramFile = aparamFile != null ? new File(aparamFile) : null;
        File xmlConfig = new File(dataInputPath, "templatetest.xml");
        this.config = new Configuration(dataInputPath, paramFile, xmlConfig);
        this.logFile = new File(this.getDataOutputPath(), "templatetest.log");
        this.log = new FileWriter(this.logFile);
        this.log("Starting template tests at " + new Date());
        this.log("-------------------------------------------------------------");
        this.log("\n");
        this.log("Compilation  timestamp is 'Mittwoch, der 23. November 2005, 16:36 Uhr'");
        this.initExecutorServer();
    }

    private void initExecutorServer() {
        try {
            this.executorServer = ExecutorServerImpl.getLocalExecutorServer();
            this.isRemote = true;
        }
        catch (NotBoundException ex) {
            String msg = "ExecutorServer not bound, cannot run in server";
            this.addMessage("", 'I', msg);
            this.log(msg + "\n");
        }
        catch (UnknownHostException ex2) {
            String msg = "Cannot connect ExecutorServer :" + ex2;
            this.addMessage("", 'I', msg);
            this.log(msg + "\n");
        }
        catch (MalformedURLException ex3) {
            String msg = "Wrong url for  ExecutorServer, cannot connect:" + ex3;
            this.addMessage("", 'I', msg);
            this.log(msg + "\n");
        }
        catch (RemoteException ex4) {
            String msg = "RemoteException connecting ExecutorServer: " + ex4;
            this.addMessage("", 'I', msg);
            this.log(msg + "\n");
        }
    }

    private void finishUp() throws IOException, RemoteException {
        if (this.hasErrors) {
            this.wipeOut();
        }
        Logger.USE_STDOUT = true;
        this.log.flush();
        this.log.close();
    }

    private void wipeOut() throws RemoteException {
        if (this.software == null) {
            return;
        }
        Executor exec = this.config.createCleanerExecutor(this.software, true);
        RemoteExecutor remoteExecutor = this.executorServer.createRemoteExecutor(exec);
        ExecutorListener cleanerListener = new CleanerListener(this);
        if (this.isRemote) {
            cleanerListener = new ExecutorListenerDelegator(cleanerListener);
            UnicastRemoteObject.exportObject(cleanerListener);
        }
        remoteExecutor.addExecutorListener(cleanerListener);
        remoteExecutor.execute();
    }

    static String exceptionType(Throwable ex) {
        String className = ex.getClass().getName();
        int index = className.lastIndexOf(".");
        className = index > 0 && index + 1 < className.length() ? className.substring(index + 1) : className;
        return className;
    }

    String formatException(Throwable ex) {
        return "\tERROR IN          Template Tests\n\tDURING STEP     : " + this.currentStep + "\n\tDURING SUBSTEP  : " + this.currentSubStep + "\n\tERROR TYPE      : " + TemplateTest.exceptionType(ex) + TemplateTest.formatMessage(ex);
    }

    static String formatMessage(Throwable ex) {
        String msg = "ERROR MESSAGE:";
        String exmsg = ex.getMessage();
        String string = exmsg = exmsg == null ? "[NO ERROR MESSAGE]" : exmsg.trim();
        if (msg.indexOf("\n") > 0) {
            LineNumberReader lr = new LineNumberReader(new StringReader(exmsg));
            String line = null;
            try {
                while ((line = lr.readLine()) != null) {
                    msg = msg + "\n\t" + line;
                }
            }
            catch (IOException exx) {}
        } else {
            msg = "\n\tERROR MESSAGE: " + exmsg;
        }
        return msg;
    }

    public void runUnHandled() throws IOException, ConfigurationException, ParserConfigurationException, SAXException, SQLException {
        this.initialize();
        String makeKey = mTestDriverOptions.getProperty("MakeKey");
        this.software = this.config.middleRelease(makeKey, "Server");
        if (this.software == null) {
            this.handleException(new Exception("Cannot find release information in QADB for make key " + makeKey));
            return;
        }
        if (!Configuration.TEMPLATE.supportsVersion(this.software.version)) {
            this.addMessage("", 'I', "Skipping template tests for version " + this.software.version);
            return;
        }
        if (this.config != null) {
            try {
                this.log("Starting force clear ...");
                this.wipeOut();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Executor exec = this.config.createTemplateTestExecutor(this.software, new ComplexParameter("perl", null));
        this.runExecutor(exec);
    }

    private void runExecutor(Executor exec) throws RemoteException {
        this.currentExecutor = this.executorServer.createRemoteExecutor(exec);
        ExecutorListener executorListener = new MyExecutorListener(this);
        if (this.isRemote) {
            executorListener = new ExecutorListenerDelegator(executorListener);
            UnicastRemoteObject.exportObject(executorListener);
        }
        this.currentExecutor.addExecutorListener(executorListener);
        while (!this.currentExecutor.isDone()) {
            this.currentExecutor.execute();
        }
        this.currentExecutor.removeExecutorListener(executorListener);
    }

    private static void db(Object ob) {
        System.out.println(ob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.runUnHandled();
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
        catch (ConfigurationException configException) {
            this.handleException(configException);
        }
        catch (ParserConfigurationException parserException) {
            this.handleException(parserException);
        }
        catch (SAXException saxException) {
            this.handleException(saxException);
        }
        catch (SQLException sqlException) {
            this.handleException(sqlException);
        }
        finally {
            try {
                this.finishUp();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void handleException(Throwable ex) {
        String formattedException = this.formatException(ex);
        String formattedMessage = TemplateTest.formatMessage(ex);
        this.addMessage("", 'E', formattedException);
        String logMsg = "[EXCEPTION] (" + ex.getClass() + "): " + formattedMessage;
        this.log(logMsg);
        TemplateTest.db(logMsg);
    }

    public static long getTimeout() {
        return 3600000L;
    }

    public String getLogFile() {
        String aFile = null;
        try {
            aFile = this.logFile.getCanonicalPath();
        }
        catch (Exception ex) {
            TemplateTest.db("Error getting name of logfile (" + ex.getClass() + "): " + ex.getMessage());
        }
        return aFile;
    }

    static class CleanerListener
    extends ExecutorListenerAdapter {
        private transient TestCaseLogger templateTest;

        CleanerListener(TestCaseLogger templateTest) {
            this.templateTest = templateTest;
        }

        public void exceptionOccurred(ExecutorEvent e) {
            if (this.templateTest == null) {
                return;
            }
            Throwable thr = e.getThrowable();
            this.templateTest.log("[CLEANER ERROR] " + thr.getClass() + thr.getMessage());
        }
    }

    static class MyExecutorListener
    extends ExecutorListenerAdapter {
        int level = 0;
        private transient TestCaseLogger templateTest;

        MyExecutorListener(TestCaseLogger ts) {
            this.templateTest = ts;
        }

        private String indent() {
            StringBuffer b = new StringBuffer("");
            for (int i = 1; i < this.level; ++i) {
                b.append("  ");
            }
            return b.toString();
        }

        private void levelDecrease() {
            int decreased = --this.level;
            this.level = Math.max(0, decreased);
        }

        public void log(ExecutorEvent e) throws RemoteException {
            this.templateTest.log("[LOG] " + e.getText());
        }

        public void stdout(ExecutorEvent e) throws RemoteException {
            this.templateTest.log("[STDOUT] " + e.getText());
        }

        public void stderr(ExecutorEvent e) throws RemoteException {
            this.templateTest.log("[STDERR] " + e.getText());
        }

        public void dbm(ExecutorEvent e) throws RemoteException {
            this.templateTest.log("[DBM] " + e.getText());
        }

        public void executorStatus(ExecutorEvent e) throws RemoteException {
            String status = e.getExecutorStateChange();
            String text = e.getText();
            String executorClass = e.getExecutorClass();
            if ("started".equals(status)) {
                this.templateTest.log("[START] " + e.getText());
                ++this.level;
                this.templateTest.setCurrentStep("[" + text + "]");
                TemplateTest.db(this.indent() + text);
                if ("Template Executor".equals(executorClass) || "Template Test Executor".equals(executorClass)) {
                    this.templateTest.addMessage("", 'I', text);
                }
            } else if ("finished".equals(status)) {
                this.templateTest.log("[END] " + e.getText());
                TemplateTest.db(this.indent() + text);
                if ("Template Executor".equals(executorClass) || "Template Test Executor".equals(executorClass)) {
                    this.templateTest.addMessage("", 'I', text);
                }
                this.levelDecrease();
                this.templateTest.setCurrentStep("[UNKNOWN STEP]");
            } else if ("subprocess started".equals(status)) {
                this.templateTest.log("[START] " + e.getText());
                this.templateTest.setCurrentSubStep("[" + text + "]");
                ++this.level;
                TemplateTest.db(this.indent() + text);
            } else if ("subprocess finished".equals(status)) {
                this.templateTest.log("[END] " + e.getText());
                TemplateTest.db(this.indent() + text);
                this.levelDecrease();
                this.templateTest.setCurrentSubStep("[UNKNOWN SUBSTEP]");
            } else if ("fork started".equals(status)) {
                this.templateTest.log("[FORK START] " + e.getText());
            } else if ("fork finished".equals(status)) {
                this.templateTest.log("[FORK END] " + e.getText());
            }
        }

        public void exceptionOccurred(ExecutorEvent e) throws RemoteException {
            this.templateTest.setHasErrors(true);
            Throwable thr = e.getThrowable();
            String executorClass = e.getExecutorClass();
            this.templateTest.handleException(thr);
        }
    }
}

