/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.utilities.Zipper;
import com.sap.sapdb.upgradetest.ComplexParameter;
import com.sap.sapdb.upgradetest.Configuration;
import com.sap.sapdb.upgradetest.ConfigurationException;
import com.sap.sapdb.upgradetest.Executor;
import com.sap.sapdb.upgradetest.Logger;
import com.sap.sapdb.upgradetest.SettingNotFoundException;
import com.sap.sapdb.upgradetest.UpgradeTest;
import com.sap.sapdb.upgradetest.UpgradeTestException;
import com.stevesoft.pat.Regex;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.Vector;

public class InstallationHelper {
    private Configuration config;
    private File outputBaseDir;
    private Vector tempfiles;
    private static final String KEY_KNLDIAG = "KNLDIAG";
    private static final String KEY_KNLERR = "KNLDIAGERR";

    public InstallationHelper(Configuration config, File outputBaseDir) {
        this.config = config;
        this.outputBaseDir = outputBaseDir;
        this.tempfiles = new Vector();
    }

    public Executor getPackage(int testindex, String role) throws UpgradeTestException, IOException, InterruptedException {
        Executor myExec = new Executor();
        String profile = this.config.getInstProfile(testindex);
        File unpackDir = this.getUnpackDir(testindex, role);
        VersionInfo versionInfo = new VersionInfo(testindex, role, unpackDir);
        if (unpackDir.exists() && unpackDir.isDirectory()) {
            Logger.log("InstallationHelper: Found a directory fitting the requested version (" + unpackDir.getName() + "), using that one");
            myExec.contextResult = 0;
            return myExec;
        }
        myExec = this.config.createPackdistribExecutor(profile, versionInfo.versionnumber + "", this.config.getLCVersion(testindex, role), Configuration.getQAStatus(this.config.getQAStatus(testindex, role)), Configuration.getQAStatus(this.config.getLCState(testindex, role)), unpackDir, this.config.getBranchInfo(testindex, role), this.config.getPlatform(testindex, role), new File(this.config.getPackdistribPath()), this.config.getLCPoolId(testindex, role), this.config.getLCAPoolId(testindex, role), this.config.getLCAVariant(testindex, role), new ComplexParameter("perl", null));
        myExec.setLogfile(this.createLogFileName(testindex, "packdistrib_" + role + ".log"));
        myExec.run();
        int retval = myExec.runResult;
        if (retval != 0) {
            if (!unpackDir.delete()) {
                Logger.log(Logger.VERBOSE, "Couldn't remove the target directory for the installation files - this might lead to errors");
            }
            String msg = "PACKDISTRIB failed for " + role + " profile '" + profile + "' and version " + this.config.getVersionDescription(testindex, role);
            msg = msg + myExec.getLastLines();
            throw new UpgradeTestException(msg, null, false);
        }
        myExec.contextResult = retval;
        myExec.contextErrorMessage = null;
        return myExec;
    }

    private static String concat(String[] sa) {
        if (sa == null) {
            return null;
        }
        String s = "";
        for (int i = 0; i < sa.length; ++i) {
            s = s + sa[i];
        }
        return s;
    }

    public void createTestDatabase(int testindex, InstallationHelper hp) throws ConfigurationException, IOException, TestDatabaseException, InterruptedException, RTEException, DBMException, UpgradeTestException {
        String version = this.config.getSourceVersionNumber(testindex);
        boolean needsOsUser = version.compareTo("7.5") < 0 && Configuration.isUnix();
        String[] args = needsOsUser ? new String[]{this.config.getDbmcliExe().getCanonicalPath(), "-R", this.config.getDependendSourcePath(testindex).getCanonicalPath(), "db_create", "TESTDB", "dbm,dbm", "remuser,Remuser"} : new String[]{this.config.getDbmcliExe().getCanonicalPath(), "-R", this.config.getDependendSourcePath(testindex).getCanonicalPath(), "db_create", "TESTDB", "dbm,dbm"};
        Executor exec = new Executor(args);
        exec.run();
        int exitvalue = exec.runResult;
        if (exitvalue != 0) {
            String msg = "db_create command failed.\n(Command was '" + InstallationHelper.concat(args);
            msg = msg + exec.getLastLines();
            throw new UpgradeTestException(msg, null, true);
        }
        hp.runDBMscript(testindex, "createdb");
    }

    public File getUnpackDir(int testindex, String role) throws SettingNotFoundException {
        Regex regex = Regex.perlCode((String)"s/\\.0?/_/");
        String stateAppendix = this.config.getQAStatus(testindex, role);
        return new File(this.config.getDirectoriesTemp() + "/sapdb-" + this.config.getInstProfile(testindex).toLowerCase().replace(' ', '_') + "-" + this.config.getEnvironmentOs() + "-" + this.config.getEnvironmentBits() + "bit-" + this.config.getEnvironmentPlatform() + "-" + regex.replaceAll(this.config.getVersionNumber(testindex, role)) + stateAppendix);
    }

    public int installDB(int testindex, String role) throws SettingNotFoundException, IOException, ConfigurationException, InterruptedException {
        File dir = this.getUnpackDir(testindex, role);
        Vector<String> cmdline = new Vector<String>();
        String directory = dir.getCanonicalPath();
        cmdline.add(directory + File.separator + "SDBINST");
        cmdline.add("-b");
        cmdline.add("-profile");
        String prf = this.config.getInstProfile(testindex);
        cmdline.add(prf);
        cmdline.add("-indep_prog");
        cmdline.add(this.config.getIndepProg().getCanonicalPath());
        cmdline.add("-indep_data");
        cmdline.add(this.config.getIndepData().getCanonicalPath());
        cmdline.add("-depend");
        cmdline.add(this.config.getDependendPath(testindex, role).getCanonicalPath());
        if (Configuration.isUnix()) {
            float versionNumber = this.config.getReleaseAsFloat(testindex, role);
            String concept = (double)versionNumber >= 7.5 ? "new" : "old";
            cmdline.add("-o");
            cmdline.add(this.config.getInstallUser(concept));
            cmdline.add("-g");
            cmdline.add(this.config.getInstallGroup(concept));
            Logger.log(Logger.DEBUG, "Detected version that needs " + concept + " security concept.");
        }
        Executor myExec = new Executor(cmdline.toArray(new String[0]), null, dir, null);
        myExec.setLogfile(this.createLogFileName(testindex, "installDB-" + role + ".log"));
        myExec.run();
        int exitvalue = myExec.runResult;
        this.saveLogs(testindex);
        if (exitvalue != 0) {
            String msg = "SDBINST returned  " + exitvalue + " for " + role + " " + this.config.getVersionDescription(testindex, role);
            msg = msg + myExec.getLastLines();
            throw new ConfigurationException(msg, null, true);
        }
        return exitvalue;
    }

    void saveKnldiag(int testindex) {
        this.saveLogFileByDbm(KEY_KNLDIAG, "knldiag", testindex);
        this.saveLogFileByDbm(KEY_KNLERR, "knldiag.err", testindex);
    }

    void saveLogFile(File path, int testindex) throws IOException {
        String sourceName = path.getName();
        File destination = new File(this.logFileConvention(testindex), sourceName);
        InstallationHelper.copyFile(path.getCanonicalPath(), destination.getCanonicalPath());
    }

    protected void saveLogFileByDbm(String key, String targetFileName, int testindex) {
        File destination = new File(this.logFileConvention(testindex), targetFileName);
        File logfile = new File(this.logFileConvention(testindex), "saveLogFiles.log");
        try {
            String[] args = new String[]{this.config.getDbmgetfExe().getCanonicalPath(), "-d", "TESTDB", "-u", "dbm,dbm", "-k", key, "-f", destination.getAbsolutePath()};
            this.callExecutor(args, logfile);
        }
        catch (Exception ex) {
            Logger.log("Could not save log " + targetFileName);
            Logger.log(ex.getMessage());
        }
    }

    void callExecutor(String[] args, File logfile) throws IOException, InterruptedException, ConfigurationException {
        Executor myExec = new Executor((Serializable[])args, null, null, null, logfile);
        myExec.run();
        int exitvalue = myExec.runResult;
        if (exitvalue != 0) {
            String msg = "Executor returned  " + exitvalue + " during call of " + myExec.getDisplayableCommandline();
            msg = msg + myExec.getLastLines();
            throw new ConfigurationException(msg, null, true);
        }
    }

    private static void copyFile(String source, String destination) throws IOException {
        RandomAccessFile datei = new RandomAccessFile(source, "r");
        RandomAccessFile neudatei = new RandomAccessFile(destination, "rw");
        while (neudatei.length() < datei.length()) {
            neudatei.write(datei.read());
        }
        datei.close();
        neudatei.close();
    }

    protected File logFileConvention(int testindex) {
        DecimalFormat decimalformat = new DecimalFormat("000");
        return new File(this.outputBaseDir.getAbsolutePath() + File.separator + "testrun" + decimalformat.format(testindex) + File.separator);
    }

    private File createLogFileName(int testindex, String logFileName) throws IOException {
        File path = this.logFileConvention(testindex);
        if (!path.exists()) {
            path.mkdirs();
        }
        return new File(path.getAbsolutePath() + File.separator + logFileName);
    }

    public boolean removeLogFiles(int testindex) {
        File path = this.logFileConvention(testindex);
        if (path.exists()) {
            return InstallationHelper.deltree(path);
        }
        return false;
    }

    public int startXServer(int testindex) throws IOException, InterruptedException, UpgradeTestException {
        Executor myExec;
        File f = this.config.getXServerExecutable();
        if (!f.exists()) {
            return -1;
        }
        String[] commandline = new String[]{f.getCanonicalPath(), "start"};
        if (this.config.needsLD_ASSUME_KERNEL(testindex)) {
            String as = "LD_ASSUME_KERNEL=2.4.1";
            Logger.log("[ENVIRONMENT] " + as);
            myExec = new Executor((Serializable[])commandline, new String[]{as}, null, null, null);
        } else {
            myExec = new Executor(commandline);
        }
        myExec.run();
        int exitvalue = myExec.runResult;
        this.saveLogs(testindex);
        if (exitvalue != 0) {
            String msg = "startXServer failed with return code " + exitvalue;
            msg = msg + myExec.getLastLines();
            this.saveKnldiag(testindex);
            throw new UpgradeTestException(msg, null, true);
        }
        return myExec.runResult;
    }

    public int stopXServer() throws SettingNotFoundException, IOException, InterruptedException {
        File f = this.config.getXServerExecutable();
        if (!f.exists()) {
            return -1;
        }
        String[] commandline = new String[]{f.getCanonicalPath(), "stop"};
        Executor myExec = new Executor(commandline);
        myExec.run();
        return myExec.runResult;
    }

    public int updateDB(int testindex, String role) throws SettingNotFoundException, IOException, UpgradeTestException, InterruptedException {
        File dir = this.getUnpackDir(testindex, role);
        String input = null;
        Vector<String> cmdline = new Vector<String>();
        String directory = dir.getCanonicalPath();
        cmdline.add(directory + File.separator + "SDBUPD");
        cmdline.add("-b");
        cmdline.add("-d");
        cmdline.add("TESTDB");
        cmdline.add("-u");
        cmdline.add("dbm,dbm");
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            String version = this.config.getTargetVersionNumber(testindex);
            if ("7.5.00.08".equalsIgnoreCase(version) || "7.5.00.07".equalsIgnoreCase(version)) {
                input = this.config.getNewInstallGroup() + "\n" + this.config.getNewInstallUser() + "\n";
                cmdline.remove("-b");
            } else {
                boolean newSecConcept = true;
                try {
                    this.config.getUpdateNewSecurityConcept(testindex);
                }
                catch (SettingNotFoundException snfe) {
                    newSecConcept = false;
                }
                if (newSecConcept) {
                    cmdline.add("-o");
                    cmdline.add(this.config.getNewInstallUser());
                    cmdline.add("-g");
                    cmdline.add(this.config.getNewInstallGroup());
                }
            }
        }
        Executor myExec = new Executor(cmdline.toArray(new String[0]), null, dir, input);
        myExec.setLogfile(this.createLogFileName(testindex, "updateDB.log"));
        myExec.run();
        int exitvalue = myExec.runResult;
        this.saveLogs(testindex);
        if (exitvalue != 0) {
            String msg = "SDBUPD failed with return code " + exitvalue;
            msg = msg + myExec.getLastLines();
            this.saveKnldiag(testindex);
            throw new UpgradeTestException(msg, null, true);
        }
        return exitvalue;
    }

    public void saveLogs(int testindex) throws SettingNotFoundException, IOException {
        File instLogDir = new File(this.config.getIndepData(), "wrk");
        SAPDBLogsFilter filter = new SAPDBLogsFilter();
        File[] logfilelist = instLogDir.listFiles(filter);
        int installlogcounter = 0;
        if (logfilelist != null) {
            for (int i = 0; i < logfilelist.length; ++i) {
                int bytesread;
                String targetFileName;
                char[] cbuf = new char[1024];
                FileReader fr = new FileReader(logfilelist[i]);
                if (logfilelist[i].getName().indexOf("Update_install") != -1) {
                    targetFileName = "updateDB-internal.log";
                } else if (logfilelist[i].getName().indexOf("Server_install") != -1) {
                    targetFileName = "installDB-" + (installlogcounter < 1 ? "source" : "brick" + installlogcounter) + "-internal.log";
                    ++installlogcounter;
                } else {
                    targetFileName = logfilelist[i].getName().indexOf("Uninstall_install") != -1 ? "uninstallDB-internal.log" : logfilelist[i].getName();
                }
                File output = this.createLogFileName(testindex, targetFileName);
                FileWriter fw = new FileWriter(output);
                while ((bytesread = fr.read(cbuf)) != -1) {
                    fw.write(cbuf, 0, bytesread);
                }
                fr.close();
                fw.close();
                logfilelist[i].delete();
            }
        }
    }

    public int uninstallDB(int testindex) throws SettingNotFoundException, IOException, InterruptedException {
        this.saveLogs(testindex);
        Vector<String> cmdline = new Vector<String>();
        String input = new String("y\n");
        cmdline.add(new File(this.config.getIndepProg(), "bin/sdbuninst").getCanonicalPath());
        cmdline.add("-all");
        Executor myExec = new Executor(cmdline.toArray(new String[0]), null, null, input);
        myExec.setLogfile(this.createLogFileName(testindex, "uninstallDB.log"));
        myExec.run();
        int exitvalue = myExec.runResult;
        return exitvalue;
    }

    public static boolean deltree(File file) {
        boolean res = false;
        if (file == null) {
            return res;
        }
        if (file.isDirectory()) {
            File[] subfiles = file.listFiles();
            for (int i = 0; i < subfiles.length; ++i) {
                res = InstallationHelper.deltree(subfiles[i]);
            }
            return file.delete() && res;
        }
        return file.delete();
    }

    public void addTempFile(File tempfile) {
        this.tempfiles.add(tempfile);
    }

    public boolean forgetTempFile(File tempfile) {
        for (int i = 0; i < this.tempfiles.size(); ++i) {
            if (!((File)this.tempfiles.get(i)).equals(tempfile)) continue;
            this.tempfiles.remove(i);
            return true;
        }
        return false;
    }

    public void deleteTempFiles() {
        for (int i = 0; i < this.tempfiles.size(); ++i) {
            InstallationHelper.deltree((File)this.tempfiles.get(i));
        }
    }

    public String createLogfileZip(Vector testmsgs, String path) throws IOException {
        if (!Logger.loggingToSystemOut()) {
            Logger.log(Logger.VERBOSE, "Logfile will be closed now and reset to System.out.");
            UpgradeTest.resetStartDateTime();
            Logger.log(Logger.STANDARD, "========================================");
            Logger.log(Logger.STANDARD, "== Logfile finished on " + UpgradeTest.getStartDateTime() + " ==");
            Logger.log(Logger.STANDARD, "========================================");
            Logger.setStdOutToSystemOut();
            Logger.log(Logger.STANDARD, "Logfile has been closed, logstream reset to standard out again.");
        }
        if (!Logger.loggingToSystemErr()) {
            Logger.setStdErrToSystemErr();
        }
        StringBuffer zipFileName = new StringBuffer();
        zipFileName.append(path + File.separator + "UpgradeTest_");
        zipFileName.append(UpgradeTest.getStartDateTime() + "_");
        if (!TestCase.getParameterString((String)"autocreatefor", (String)"").equals("")) {
            zipFileName.append(TestCase.getParameterString((String)"autocreatefor", (String)"") + "_");
        } else {
            zipFileName.append("manual_");
        }
        zipFileName.append(TestCase.getParameterString((String)"os", (String)"") + TestCase.getParameterString((String)"bit", (String)"") + ".zip");
        File theZipFile = new File(zipFileName.toString());
        Zipper myZipper = new Zipper(theZipFile);
        myZipper.setRootDirectory(new File(path));
        myZipper.setDeleteSourceFiles(true);
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.getName().endsWith(".zip");
            }
        };
        File[] filelist = this.outputBaseDir.listFiles(filter);
        myZipper.addFiles(filelist);
        filelist = new File(System.getProperty("user.dir")).listFiles(new SAPDBLogsFilter());
        myZipper.addFiles(filelist);
        try {
            myZipper.zip();
        }
        catch (Exception e) {
            Logger.error("Failed to create a zipfile with the logs " + e.getMessage());
            return null;
        }
        InstallationHelper.deltree(this.outputBaseDir);
        return theZipFile.getAbsolutePath();
    }

    public int runDBMscript(int testindex, String task) throws ConfigurationException, FileNotFoundException, TestDatabaseException, InterruptedException, IOException, RTEException, DBMException, UpgradeTestException {
        String script = this.config.getScript(testindex, task);
        DBM myDBM = null;
        Properties dbmprops = this.config.getDBMProperties(testindex);
        Logger.log("Initializing DBM-Conection with " + dbmprops);
        int numberLoops = 0;
        int k = 0;
        while (k < 120) {
            try {
                myDBM = new DBM(dbmprops);
                break;
            }
            catch (RTEException rtee) {
                if (!(rtee.getMessage().equals("Cannot connect to host localhost [Connection refused], -813.") || rtee.getMessage().equals("Cannot connect to host localhost [Connection refused: connect], -813.") || rtee.getMessage().equals("Server or DB unknown"))) {
                    throw new UpgradeTestException("Failed creating the DBM object - ", (Exception)((Object)rtee), true);
                }
                Thread.sleep(1000L);
                numberLoops = k++;
            }
        }
        if (numberLoops != 0) {
            Logger.log("[WAITING] for x-server " + numberLoops + " seconds");
        }
        if (myDBM == null) {
            throw new TestDatabaseException("Failed to create the DBM Object");
        }
        LineNumberReader lr = new LineNumberReader(new StringReader(script));
        String line = "";
        while ((line = lr.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.equals("")) continue;
            try {
                Logger.log("[DBM] " + line);
                myDBM.cmd(line);
            }
            catch (DBMException ex) {
                throw new UpgradeTestException("Error executing command '" + line + "':\n" + ex.getMessage(), (Exception)((Object)ex), true);
            }
        }
        myDBM.release();
        return 0;
    }

    private class SAPDBLogsFilter
    implements FilenameFilter {
        private SAPDBLogsFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".log") || name.equals("xserver.prt") || name.equals("knldiag") || name.equals("dbmsrv.prt");
        }
    }

    class VersionInfo {
        int versionnumber = 0;
        boolean cordevstate = false;
        StringBuffer version;
        String state = null;
        public String lcpoolid = "";
        public String lcapoolid = "";
        public String branchinfo = "";
        public String lcavariant = "";

        public VersionInfo(int testindex, String role, File unpackDir) throws ConfigurationException {
            this.version = new StringBuffer(InstallationHelper.this.config.getVersionNumber(testindex, role));
            if (this.version.length() == 9) {
                this.cordevstate = false;
            } else if (this.version.length() == 6) {
                this.cordevstate = true;
                this.state = InstallationHelper.this.config.getQAStatus(testindex, role);
                InstallationHelper.this.addTempFile(unpackDir);
            } else {
                throw new ConfigurationException("versionnumber has wrong length, must be #.#.##.## (for RAMP states) or #.#.## (for DEV states)");
            }
            for (int pos = 0; pos < this.version.length(); ++pos) {
                if (this.version.charAt(pos) != '.') continue;
                this.version.deleteCharAt(pos);
            }
            try {
                this.versionnumber = Integer.parseInt(this.version.toString());
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Cannot parse  '" + this.version + "',only numbers and  '.' allowed");
            }
            this.lcpoolid = InstallationHelper.this.config.getLCPoolId(testindex, role);
            this.lcapoolid = InstallationHelper.this.config.getLCAPoolId(testindex, role);
            this.branchinfo = InstallationHelper.this.config.getBranchInfo(testindex, role);
            this.lcavariant = InstallationHelper.this.config.getLCAVariant(testindex, role);
        }
    }
}

