/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.sapdb.upgradetest.Configuration;
import com.sap.sapdb.upgradetest.Dbmcli;
import com.sap.sapdb.upgradetest.Executor;
import com.sap.sapdb.upgradetest.ExecutorEvent;
import com.sap.sapdb.upgradetest.ExecutorListenerAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Properties;

public class InstChecker
extends Executor {
    String indepProg = null;
    String indepData = null;
    String[] dbs = null;
    private transient Dbmcli dbmcli = null;
    Properties sysProps;

    String getIndepPrograms() {
        return this.indepProg;
    }

    String getIndepData() {
        return this.indepData;
    }

    String[] getDBS() {
        return this.dbs == null ? new String[]{} : this.dbs;
    }

    Properties getSysProps() {
        return this.sysProps;
    }

    void run() {
        this.setHasStarted();
        this.sysProps = System.getProperties();
        try {
            this.dbmcli = new Dbmcli(2000L);
        }
        catch (IOException ex) {
            this.fireLogEvent("Could not start dbmcli via PATH Environment: '" + ex.getMessage() + "'");
        }
        if (this.dbmcli == null) {
            if (Configuration.isWindows()) {
                this.checkRegistry();
            } else {
                this.checkRegFiles();
            }
        }
        this.evalDbmcli(this.dbmcli);
        this.setHasFinished("finished normally");
    }

    public boolean destroy() throws RemoteException {
        this.interruptMe();
        if (this.dbmcli != null) {
            this.dbmcli.destroy();
        }
        this.setHasFinished("killed");
        return true;
    }

    private void checkRegFiles() {
        this.evalRegFile("/etc/opt/sdb");
        if (this.indepProg == null) {
            this.evalRegFile("/usr/spool/sql/ini/SAP_DBTech.ini");
        }
        if (this.indepProg != null) {
            File f = new File(this.indepProg);
            File dbmcliFile = Configuration.getDbmcliExe(f, Configuration.LINUXINTEL);
            try {
                this.dbmcli = new Dbmcli(dbmcliFile, 2000L);
            }
            catch (IOException ex) {
                this.fireLogEvent("Could not start dbmcli via path found in registry files: " + ex.getMessage());
            }
        } else {
            this.fireLogEvent("Could not find IndepPrograms directory");
        }
    }

    private void evalRegFile(String fileName) {
        File f = new File(fileName);
        if (!f.exists()) {
            this.fireLogEvent(f + " not found");
            return;
        }
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(f));
        }
        catch (IOException ex) {
            this.fireLogEvent("Cannot read " + f + ": " + ex.getMessage());
        }
        this.indepProg = props.getProperty("IndepPrograms");
        if (this.indepProg == null) {
            this.fireLogEvent("Did not find IndepPrograms in " + f);
        } else {
            this.fireLogEvent("Found IndepPrograms='" + this.indepProg + "' in " + f);
        }
        this.indepData = props.getProperty("IndepData");
        if (this.indepData == null) {
            this.fireLogEvent("Did not find IndepData in " + f);
        } else {
            this.fireLogEvent("Found IndepData='" + this.indepData + "' in " + f);
        }
    }

    private void checkRegistry() {
        try {
            Properties props = Configuration.readWinRegistry();
            this.indepProg = props.getProperty("IndepPrograms");
            this.indepData = props.getProperty("IndepData");
        }
        catch (IOException ex) {
            this.fireLogEvent("Error reading windows registry: " + ex.getMessage());
        }
        if (this.indepProg == null) {
            this.fireLogEvent("Could not find IndepPrograms in windows registry");
        } else {
            this.fireLogEvent("Found IndepPrograms='" + this.indepProg + "' in registry");
            File f = new File(this.indepProg);
            File dbmcliFile = Configuration.getDbmcliExe(f, Configuration.NTINTEL);
            try {
                this.dbmcli = new Dbmcli(dbmcliFile, 2000L);
            }
            catch (IOException ex) {
                this.fireLogEvent("Could not start dbmcli via path found in windows registry: " + ex.getMessage());
            }
            if (this.dbmcli != null) {
                // empty if block
            }
        }
        if (this.indepData == null) {
            this.fireLogEvent("Could not find IndepData in windows registry");
        } else {
            this.fireLogEvent("Found IndepData='" + this.indepData + "' in registry");
        }
    }

    private void evalDbmcli(Dbmcli dbmcli) {
        if (dbmcli == null) {
            return;
        }
        try {
            this.fireLogEvent("Trying to get  independend Programs via dbmcli ...");
            this.indepProg = dbmcli.getIndepProg();
            if (this.indepProg != null) {
                this.fireLogEvent("Found IndepPrograms='" + this.indepProg + "' via  dbmcli");
            }
        }
        catch (IOException ex) {
            this.fireLogEvent("Could not get IndepPrograms via dbmcli: " + ex.getMessage());
        }
        try {
            this.indepData = dbmcli.getIndepData();
            if (this.indepData != null) {
                this.fireLogEvent("Found IndepData='" + this.indepData + "' via  dbmcli");
            }
        }
        catch (IOException ex) {
            this.fireLogEvent("Could not get IndepData via dbmcli: " + ex.getMessage());
        }
        try {
            this.dbs = dbmcli.dbenum();
            if (this.dbs != null) {
                for (int i = 0; i < this.dbs.length; ++i) {
                    this.fireLogEvent("Found database " + this.dbs[i]);
                }
            }
        }
        catch (IOException ex) {
            this.fireLogEvent("Could not get instance list via dbmcli: " + ex.getMessage());
        }
        dbmcli.destroy();
    }

    public InstChecker() {
        this.setShortName("Installation Checker");
    }

    public static void main(String[] args) throws Exception {
        InstChecker checker = new InstChecker();
        checker.addExecutorListener(new ExecutorListenerAdapter(){

            public void log(ExecutorEvent e) {
                InstChecker.db("[LOG] " + e.getText());
            }

            public void exceptionOccurred(ExecutorEvent e) {
                InstChecker.db("[Error] " + e.getThrowable());
                e.getThrowable().printStackTrace();
            }
        });
        checker.run();
    }

    private static void db(Object ob) {
        System.out.println(ob);
    }
}

