/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.sapdb.upgradetest.ComplexParameter;
import com.sap.sapdb.upgradetest.Constants;
import com.sap.sapdb.upgradetest.Dbmcli;
import com.sap.sapdb.upgradetest.Executor;
import com.sap.sapdb.upgradetest.ExecutorDelegator;
import com.sap.sapdb.upgradetest.ExecutorEvent;
import com.sap.sapdb.upgradetest.ExecutorListenerAdapter;
import com.sap.sapdb.upgradetest.ExecutorServer;
import com.sap.sapdb.upgradetest.Logger;
import com.sap.sapdb.upgradetest.ReadResult;
import com.sap.sapdb.upgradetest.RemoteCmdlineTool;
import com.sap.sapdb.upgradetest.RemoteCmdlineToolImpl;
import com.sap.sapdb.upgradetest.RemoteExecutor;
import com.sap.sapdb.upgradetest.RemoteExecutorImpl;
import com.sap.sapdb.upgradetest.RemoteInputStream;
import com.sap.sapdb.upgradetest.RemoteInputStreamImpl;
import com.sap.sapdb.upgradetest.SerializableFileFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;

public class ExecutorServerImpl
extends RemoteObject
implements ExecutorServer,
Constants {
    static final long serialVersionUID = 2164725576563406208L;
    static volatile transient RemoteExecutor currentExecutor;
    static transient Executor rmiRegistry;
    static String address;
    static volatile boolean shutdownInProgress;
    private boolean isExported = false;

    public String getEnv(String name) throws RemoteException {
        return System.getenv(name);
    }

    public RemoteExecutor getCurrentExecutor() throws RemoteException {
        return currentExecutor;
    }

    public void setCurrentExecutor(RemoteExecutor exec) throws RemoteException {
        this.checkUndoneExecutor();
        this.checkShutdownInProgress();
        currentExecutor = exec;
    }

    public boolean isRemote() throws RemoteException {
        return this.isExported;
    }

    public Properties getSystemProperties() throws RemoteException {
        return System.getProperties();
    }

    public synchronized RemoteExecutor createRemoteExecutor(Executor executor) throws RemoteException {
        this.checkUndoneExecutor();
        this.checkShutdownInProgress();
        currentExecutor = this.initializeRemoteExecutor(executor);
        return currentExecutor;
    }

    private void checkUndoneExecutor() throws RemoteException {
        if (ExecutorServerImpl.isUndoneExecutor(currentExecutor)) {
            String shortName = ExecutorServerImpl.currentExecutor.getExecutor().shortName;
            throw new RemoteException("'" + shortName + "' running, cannot start another process");
        }
    }

    private void checkShutdownInProgress() throws RemoteException {
        if (shutdownInProgress) {
            throw new RemoteException("Shutdown in progress");
        }
    }

    public void shutdown() throws RemoteException {
        if (!this.isRemote()) {
            throw new RemoteException("Cannot shutdown local server");
        }
        this.checkUndoneExecutor();
        shutdownInProgress = true;
        Thread shutdownThread = new Thread(){

            public void run() {
                ExecutorServerImpl.this.shutdownImpl();
            }
        };
        shutdownThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownImpl() {
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
            Naming.unbind(address);
            ExecutorServerImpl.db("Unbound " + address);
            if (rmiRegistry != null) {
                rmiRegistry.destroy();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ExecutorServerImpl.db("Server exited.");
            System.exit(0);
        }
    }

    static boolean isUndoneExecutor(RemoteExecutor anexec) throws RemoteException {
        return anexec != null && anexec.isStarted() && !anexec.isDone();
    }

    private RemoteExecutor initializeRemoteExecutor(Executor executor) throws RemoteException {
        RemoteExecutor[] delegates = executor.getDelegates();
        RemoteObject ri = delegates != null ? new ExecutorDelegator(executor) : new RemoteExecutorImpl(executor);
        if (this.isRemote()) {
            UnicastRemoteObject.exportObject(ri);
        }
        return ri;
    }

    public File[] listFiles(SerializableFileFilter f, File dir) throws RemoteException {
        return dir.listFiles(f);
    }

    public boolean mkdir(File file) throws RemoteException {
        return file.mkdir();
    }

    public boolean exists(File file) throws RemoteException {
        return file.exists();
    }

    public String canonicalPath(File file) throws RemoteException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    public boolean recursiveDelete(File file) throws RemoteException {
        return ExecutorServerImpl.recursiveDeleteImpl(file);
    }

    static boolean recursiveDeleteImpl(File file) {
        boolean res = false;
        if (file == null) {
            return res;
        }
        if (file.isDirectory()) {
            File[] subfiles = file.listFiles();
            for (int i = 0; i < subfiles.length; ++i) {
                res = ExecutorServerImpl.recursiveDeleteImpl(subfiles[i]);
            }
            return file.delete() && res;
        }
        return file.delete();
    }

    public void write(RemoteInputStream ris, File f, int buf) throws RemoteException, IOException {
        ExecutorServerImpl.internalWrite(ris, f, buf);
    }

    static void internalWrite(RemoteInputStream ris, File f, int buf) throws IOException {
        FileOutputStream fo = new FileOutputStream(f);
        ExecutorServerImpl.internalWrite(ris, fo, buf);
        fo.flush();
        fo.close();
    }

    static void internalWrite(RemoteInputStream ris, OutputStream os, int buf) throws IOException {
        int read = -1;
        byte[] b = new byte[buf];
        while (true) {
            ReadResult rr = ris.read(b, 0, buf);
            if (rr.numBytesRead < 0) break;
            os.write(rr.bytesRead, 0, rr.numBytesRead);
        }
    }

    public RemoteInputStream stream(File f) throws RemoteException, IOException {
        RemoteInputStreamImpl impl = new RemoteInputStreamImpl(f);
        if (this.isRemote()) {
            UnicastRemoteObject.exportObject(impl);
        }
        return impl;
    }

    public static void main(String[] args) {
        Logger.USE_STDOUT = false;
        try {
            ExecutorServerImpl.startRegistry();
        }
        catch (RemoteException ex) {
            ExecutorServerImpl.db("Error starting registry, RemoteException message: " + ex.getMessage());
        }
        try {
            address = ExecutorServerImpl.bind();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (AlreadyBoundException ex) {
            ExecutorServerImpl.db("AlreadyBoundException occured, this indicates that the server \nis already started or  was not properly stopped. Stop all other servers \nand all registry processes");
            System.exit(1);
        }
        catch (RemoteException ex) {
            ExecutorServerImpl.db("Error in Naming.bind occured:\n");
            ExecutorServerImpl.db(ex.getMessage());
            Throwable thr = ex.getCause();
            if (thr != null) {
                ExecutorServerImpl.db("Cause is :\n");
                ExecutorServerImpl.db(thr.getMessage());
            } else {
                ExecutorServerImpl.db("Cause is unknown");
            }
            System.exit(1);
        }
        catch (MalformedURLException ex) {
            ExecutorServerImpl.db("Error in Naming.bind, MalformedURLException: " + ex.getMessage());
            System.exit(1);
        }
    }

    public RemoteCmdlineTool cmdline(String[] call, String[] env, String type) throws RemoteException, IOException {
        RemoteCmdlineToolImpl rcl = new RemoteCmdlineToolImpl(new Dbmcli(call, env));
        if (this.isRemote()) {
            UnicastRemoteObject.exportObject(rcl);
        }
        return rcl;
    }

    static void startRegistry() throws RemoteException {
        String javaHome = System.getProperty("java.home");
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        ComplexParameter regPath = new ComplexParameter("", new File(javaHome, "/bin/rmiregistry"));
        Serializable[] cmdArray = new Serializable[]{regPath};
        rmiRegistry = new Executor();
        rmiRegistry.setCmdArray(cmdArray);
        try {
            ExecutorServerImpl.db("Registry path is " + regPath.getStringReprentation());
        }
        catch (IOException ex) {
            // empty catch block
        }
        ExecutorServerImpl.rmiRegistry.shortName = "RMIREGISTRY";
        rmiRegistry.addExecutorListener(new ExecutorListenerAdapter(){

            public void stderr(ExecutorEvent e) throws RemoteException {
                super.stderr(e);
                String txt = e.getText();
                ExecutorServerImpl.db("[RMIREGISTRY] " + txt);
            }

            public void stdout(ExecutorEvent e) throws RemoteException {
                super.stderr(e);
                String txt = e.getText();
                ExecutorServerImpl.db("[RMIREGISTRY] " + txt);
            }

            public void executorStatus(ExecutorEvent e) throws RemoteException {
                super.executorStatus(e);
                ExecutorServerImpl.db(e.getText());
            }

            public void exceptionOccurred(ExecutorEvent e) throws RemoteException {
                super.exceptionOccurred(e);
                Throwable thr = e.getThrowable();
                thr.printStackTrace();
            }
        });
        rmiRegistry.start();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    static String bind() throws UnknownHostException, MalformedURLException, RemoteException, AlreadyBoundException {
        ExecutorServerImpl obj = new ExecutorServerImpl();
        try {
            UnicastRemoteObject.exportObject(obj);
        }
        catch (RemoteException ex) {
            ExecutorServerImpl.db("Error exporting remote object: " + ex.getMessage());
        }
        obj.isExported = true;
        String hostname = InetAddress.getLocalHost().getHostName();
        String address = "//" + hostname + "/ExecutorServer";
        ExecutorServerImpl.db("Trying to bind    " + address + " ...");
        Naming.bind(address, obj);
        ExecutorServerImpl.db("Done binding, server is up!");
        return address;
    }

    static void db(Object ob) {
        System.out.println(ob);
    }

    static ExecutorServer getLocalExecutorServer() throws UnknownHostException, NotBoundException, MalformedURLException, RemoteException {
        String address = "//" + InetAddress.getLocalHost().getHostName() + "/ExecutorServer";
        ExecutorServer srv = (ExecutorServer)Naming.lookup(address);
        return srv;
    }

    static {
        shutdownInProgress = false;
    }
}

