/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.upgradetest.ComplexParameter;
import com.sap.sapdb.upgradetest.ExecutorEvent;
import com.sap.sapdb.upgradetest.ExecutorListener;
import com.sap.sapdb.upgradetest.ExecutorLogic;
import com.sap.sapdb.upgradetest.LineFilter;
import com.sap.sapdb.upgradetest.Logger;
import com.sap.sapdb.upgradetest.RemoteExecutor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class Executor
implements RemoteExecutor,
Serializable {
    private Serializable[] cmdArray = null;
    private String[] envp;
    private File workdir;
    private File logfile;
    private String input;
    private transient ParallelStreamReader stdoutR;
    private transient ParallelStreamReader stderrR;
    private transient PrintStream logStream;
    private transient Process process;
    private transient DBM dbmConnection;
    private volatile transient Vector executorListeners = new Vector();
    private volatile boolean hasFinished = false;
    private volatile boolean hasStarted = false;
    private volatile boolean interrupted = false;
    private volatile boolean skipped = false;
    private volatile boolean isForce = false;
    private boolean isSubProcess = false;
    private String dbmScript;
    private Hashtable dbmProperties;
    String shortName = "(Short name not available)";
    private ExecutorLogic executorLogic;
    private volatile transient Thread runThread;
    private String executorClass;
    final ArrayList lineBuffer = new ArrayList(1000);
    int exitValue = -13333;
    int expectedExitValue = -99999;
    int runResult = -13334;
    int contextResult = -13335;
    String contextErrorMessage;
    private LineFilter logFilter = DEFAULT_FILTER;
    private LineFilter stdOutFilter = DEFAULT_FILTER;
    private LineFilter stdErrFilter = DEFAULT_FILTER;
    private RemoteExecutor[] delegates = null;
    static final long serialVersionUID = 1813245993481439893L;
    static final LineFilter DEFAULT_FILTER = new DefaultFilter();
    static final int ACCEPT_ANY_EXIT_VALUE = -99999;
    static final boolean STDOUT = true;
    static final boolean STDERR = false;
    static final int MAXLINEBUFFER = 1000;
    static final int PROCESSNOTSTARTED = -13333;
    static final int RUNNOTSTARTED = -13334;
    static final int NOCONTEXT = -13335;
    static final int PROCESSERROR = -1;
    static final String STARTED_PROCESS = "started";
    static final String FINISHED_PROCESS = "finished";
    static final String STARTED_SUB_PROCESS = "subprocess started";
    static final String FINISHED_SUB_PROCESS = "subprocess finished";
    static final String STARTED_FORK = "fork started";
    static final String FINISHED_FORK = "fork finished";
    static final String SCRIPT_EXECUTOR = "DBM-Script Executor";
    static final String SDBUNINST_EXECUTOR = "SDBUNINST Executor";
    static final String SDBINST_EXECUTOR = "SDBINST Executor";
    static final String STOP_XSERVER_EXECUTOR = "Stop X-Server Executor";
    static final String START_XSERVER_EXECUTOR = "Start X-Server Executor";
    static final String DIRTY_FILE_CLEANER_EXECUTOR = "Dirty File Cleaner Executor";
    static final String CLEANER_EXECUTOR = "Cleaner Executor";
    static final String UPGRADE__EXECUTOR = "Ugrade Executor";
    static final String UPGRADE_TEST_EXECUTOR = "Ugrade Test Executor";
    static final String UPGRADE_TEST_SEQUENCE_EXECUTOR = "Upgrade Test Sequence Executor";
    static final String TEMPLATE_EXECUTOR = "Template Executor";
    static final String TEMPLATE_TEST_EXECUTOR = "Template Test Executor";
    static final String PACKDISTRIB_EXECUTOR = "PackdistribExecutor";
    static final String DBDROP_EXECUTOR = "Drop Test Database Executor";
    static final String DBCREATE_EXECUTOR = "Create Test  Database Executor";
    static final String UPGRADE_TEST_JTEST_EXECUTOR = "UPGRADE_TEST_JTEST_EXECUTOR";

    void setShortName(String s) {
        this.shortName = s;
    }

    String getShortName() {
        return this.shortName;
    }

    public String getExecutorClass() {
        return this.executorClass;
    }

    public void setExecutorClass(String aClass) {
        this.executorClass = aClass;
    }

    void setIsSubProcess(boolean flag) {
        this.isSubProcess = flag;
    }

    void setLogFilter(LineFilter f) {
        this.logFilter = f;
    }

    void setStdErrFilter(LineFilter f) {
        this.stdErrFilter = f;
    }

    void setStdOutFilter(LineFilter f) {
        this.stdOutFilter = f;
    }

    void setExpectedExitValue(int aVal) {
        this.expectedExitValue = aVal;
    }

    public void setDelegates(RemoteExecutor[] dels) throws RemoteException {
        this.setDelegatesImpl(dels);
    }

    void setDelegatesImpl(RemoteExecutor[] dels) {
        this.delegates = dels;
    }

    public boolean isForce() throws RemoteException {
        return this.isForce;
    }

    public void setForce(boolean b) {
        this.isForce = b;
    }

    void setExecutorLogic(ExecutorLogic exeLogic) {
        this.executorLogic = exeLogic;
        this.executorLogic.setExecutor(this);
    }

    public RemoteExecutor[] getDelegates() throws RemoteException {
        return this.delegates;
    }

    void setCmdArray(Serializable[] cmdArray) {
        this.cmdArray = cmdArray;
    }

    void setCmdLine(String[] c) {
        this.cmdArray = c;
    }

    void setEnvironment(String[] envp) {
        this.envp = envp;
    }

    void setInput(String input) {
        this.input = input;
    }

    void setHasFinished(String finishedStatus) {
        if (!this.hasFinished) {
            this.hasFinished = true;
            this.fireFinishedEvent(finishedStatus);
        }
    }

    void setHasStarted() {
        if (!this.hasStarted) {
            this.hasStarted = true;
            this.fireStartedEvent();
        }
    }

    void setDBMScript(String ascr, Hashtable props) {
        this.dbmScript = ascr;
        this.dbmProperties = props;
    }

    private String[] serToString(Serializable[] serArray) throws IOException {
        if (serArray == null) {
            return null;
        }
        String[] retVal = new String[serArray.length];
        for (int i = 0; i < serArray.length; ++i) {
            Serializable ser = serArray[i];
            retVal[i] = ser instanceof File ? ((File)ser).getCanonicalPath() : (ser instanceof ComplexParameter ? ((ComplexParameter)ser).getStringReprentation() : (ser == null ? "" : ser.toString()));
        }
        return retVal;
    }

    public boolean isStarted() throws RemoteException {
        return this.hasStarted();
    }

    boolean hasStarted() {
        return this.hasStarted;
    }

    boolean hasFinished() {
        return this.hasFinished;
    }

    public boolean isDone() throws RemoteException {
        return this.hasFinished;
    }

    public boolean wasInterrupted() throws RemoteException {
        return this.interrupted;
    }

    void interruptMe() {
        this.interrupted = true;
    }

    void setSkipped() {
        this.skipped = true;
        this.interrupted = true;
    }

    public boolean isRunning() throws RemoteException {
        return this.hasStarted && !this.hasFinished;
    }

    private Vector executorListeners() {
        if (this.executorListeners == null) {
            this.executorListeners = new Vector();
        }
        return this.executorListeners;
    }

    public void addExecutorListener(ExecutorListener l) throws RemoteException {
        this.executorListeners().add(l);
    }

    public void removeExecutorListener(ExecutorListener l) throws RemoteException {
        this.executorListeners().remove(l);
    }

    void fireRemoteLogEvent(String line) {
        Iterator iter = this.executorListeners().iterator();
        ExecutorEvent event = new ExecutorEvent("stdout event", line, null, this.getExecutorClass());
        while (iter.hasNext()) {
            ExecutorListener l = (ExecutorListener)iter.next();
            try {
                l.log(event);
            }
            catch (RemoteException ex) {
                Executor.db("[Remote log event error]");
            }
        }
    }

    void fireRemoteDbmEvent(String line) {
        Iterator iter = this.executorListeners().iterator();
        ExecutorEvent event = new ExecutorEvent("dbm event", line, null, this.getExecutorClass());
        while (iter.hasNext()) {
            ExecutorListener l = (ExecutorListener)iter.next();
            try {
                l.dbm(event);
            }
            catch (RemoteException ex) {
                Executor.db("[Remote dbm event error]");
            }
        }
    }

    void fireRemoteStdoutEvent(String line) {
        if (!this.stdOutFilter.accept(line)) {
            return;
        }
        Iterator iter = this.executorListeners().iterator();
        ExecutorEvent event = new ExecutorEvent("stdout event", line, null, this.getExecutorClass());
        while (iter.hasNext()) {
            ExecutorListener l = (ExecutorListener)iter.next();
            try {
                l.stdout(event);
            }
            catch (RemoteException ex) {
                Executor.db("[Remote stdout event error]");
            }
        }
    }

    void fireRemoteStderrEvent(String line) {
        if (!this.stdErrFilter.accept(line)) {
            return;
        }
        Iterator iter = this.executorListeners().iterator();
        ExecutorEvent event = new ExecutorEvent("stderr event", line, null, this.getExecutorClass());
        while (iter.hasNext()) {
            ExecutorListener l = (ExecutorListener)iter.next();
            try {
                l.stderr(event);
            }
            catch (RemoteException ex) {
                Executor.db("[Remote stderr event error]");
            }
        }
    }

    void fireRemoteStatusEvent(String status, String msg, String finishedStatus) {
        Iterator iter = this.executorListeners().iterator();
        ExecutorEvent event = new ExecutorEvent("status event", msg, status, this.getExecutorClass());
        event.setFinishedStatus(finishedStatus);
        while (iter.hasNext()) {
            ExecutorListener l = (ExecutorListener)iter.next();
            try {
                l.executorStatus(event);
            }
            catch (RemoteException ex) {
                Executor.db("[Remote status event error]");
            }
        }
    }

    void fireRemoteExceptionEvent(Exception ex) {
        Iterator iter = this.executorListeners().iterator();
        ExecutorEvent event = new ExecutorEvent(new RemoteException(ex.getMessage(), ex), this.getExecutorClass());
        while (iter.hasNext()) {
            ExecutorListener l = (ExecutorListener)iter.next();
            try {
                l.exceptionOccurred(event);
            }
            catch (RemoteException rex) {
                Executor.db("[Remote exception event error]");
            }
        }
    }

    void fireLogEvent(String logLine) {
        if (this.logFilter.accept(logLine)) {
            this.fireRemoteLogEvent(logLine);
        }
    }

    private static void db(Object ob) {
        System.out.println(ob);
    }

    void fireFinishedEvent(String finishedStatus) {
        String event = this.isSubProcess ? FINISHED_SUB_PROCESS : FINISHED_PROCESS;
        String terminated = "Finished";
        if (this.skipped) {
            terminated = "Skipped";
        } else if ("finished by exception".equals(finishedStatus)) {
            terminated = "Finished with exceptions";
        } else if (this.interrupted) {
            terminated = "Killed";
        }
        String msg = terminated + " " + this.shortName;
        this.fireRemoteStatusEvent(event, msg, finishedStatus);
    }

    void fireStartedEvent() {
        String event = this.isSubProcess ? STARTED_SUB_PROCESS : STARTED_PROCESS;
        String msg = "Started " + this.shortName;
        this.fireRemoteStatusEvent(event, msg, null);
    }

    void fireExceptionEvent(Exception ex) {
        this.fireRemoteExceptionEvent(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memorizeLine(String line) {
        if (this.lineBuffer.size() < 1000) {
            Executor executor = this;
            synchronized (executor) {
                this.lineBuffer.add(line.trim());
            }
        }
        Executor executor = this;
        synchronized (executor) {
            this.lineBuffer.remove(0);
            this.lineBuffer.add(line.trim());
        }
    }

    String getLastLines() {
        String s = "";
        Iterator iter = this.lineBuffer.iterator();
        if (iter.hasNext()) {
            s = "\n";
        }
        while (iter.hasNext()) {
            s = s + iter.next() + "\n";
        }
        return s;
    }

    String getDisplayableCommandline() throws IOException {
        String[] cmdStrings = this.serToString(this.cmdArray);
        String s = "";
        if (cmdStrings != null) {
            for (int i = 0; i < cmdStrings.length; ++i) {
                s = s + "'" + cmdStrings[i] + "' ";
            }
        }
        return s;
    }

    String getCommandline() throws IOException {
        String[] cmdStrings = this.serToString(this.cmdArray);
        String s = "";
        if (cmdStrings != null) {
            for (int i = 0; i < cmdStrings.length; ++i) {
                char[] cs = cmdStrings[i].toCharArray();
                String quote = "";
                for (int k = 0; k < cs.length; ++k) {
                    if (!Character.isWhitespace(cs[k])) continue;
                    quote = "\"";
                }
                s = s + quote + cmdStrings[i] + quote + " ";
            }
        }
        return s;
    }

    String getCommands() throws IOException {
        String s = this.getCommandline();
        s = s + (this.dbmScript == null ? "" : "\n" + this.dbmScript);
        return s;
    }

    private void myinit() {
    }

    Executor() {
        this.myinit();
    }

    Executor(String[] cmdline) {
        this((Serializable[])cmdline, null, null, null, null);
        this.myinit();
    }

    Executor(String[] cmdline, String[] envp, File workdir, String input) {
        this((Serializable[])cmdline, envp, workdir, input, null);
        this.myinit();
    }

    Executor(Serializable[] cmdline, String[] envp, File workdir, String input, File logfile) {
        this.cmdArray = cmdline;
        this.envp = envp;
        this.workdir = workdir;
        this.input = input;
        this.setLogfile(logfile);
        this.myinit();
    }

    void setLogfile(File file) {
        if (file != null) {
            this.logfile = file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() throws IOException {
        if (this.hasStarted) {
            return;
        }
        try {
            this.setHasStarted();
            PrintStream printStream = this.logStream = this.logfile != null ? new PrintStream(new FileOutputStream(this.logfile)) : null;
            if (this.executorLogic != null && !this.interrupted) {
                this.executorLogic.executeLogic();
            }
            if (this.cmdArray != null && !this.interrupted) {
                this.runProcess();
            }
            if (this.dbmScript != null && !this.interrupted) {
                this.runDBMScript();
            }
        }
        catch (IOException e) {
            this.fireExceptionEvent(e);
            this.runResult = -1;
            this.cleanup();
            this.setHasFinished("finished by exception");
            throw e;
        }
        catch (RTEException f) {
            this.fireExceptionEvent((Exception)((Object)f));
            this.setHasFinished("finished by exception");
        }
        catch (DBMException g) {
            this.fireExceptionEvent((Exception)((Object)g));
            this.setHasFinished("finished by exception");
        }
        finally {
            this.cleanup();
        }
        this.setHasFinished(this.interrupted ? (this.skipped ? "skipped" : "killed") : "finished normally");
    }

    public void execute() throws RemoteException {
        try {
            this.run();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() throws RemoteException {
        this.runThread = new Thread(){

            public void run() {
                try {
                    Executor.this.execute();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.runThread.start();
    }

    private void runProcess() throws IOException {
        String aLogLine = "[COMMAND] " + this.getCommandline() + "\n";
        this.logLine(aLogLine);
        Logger.log(aLogLine);
        String[] cmdStrings = this.serToString(this.cmdArray);
        if (this.envp != null) {
            String envLog = "";
            for (int i = 0; i < this.envp.length; ++i) {
                envLog = envLog + "[ENVIRONMENT] " + this.envp[i] + "\n";
            }
            this.fireLogEvent(envLog);
        }
        this.process = Runtime.getRuntime().exec(cmdStrings, this.envp, this.workdir);
        String event = STARTED_FORK;
        String startmsg = this.getCommandline();
        this.fireRemoteStatusEvent(event, startmsg, null);
        this.stdoutR = new ParallelStreamReader(true, false, false);
        this.stderrR = new ParallelStreamReader(false, true, true);
        this.stdoutR.start();
        this.stderrR.start();
        if (this.input != null && !this.input.equals("")) {
            this.writeToProcess(this.process);
        }
        try {
            this.process.waitFor();
            this.stdoutR.join(60000L);
            this.stderrR.join(60000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.exitValue = this.process.exitValue();
        event = FINISHED_FORK;
        startmsg = "Finished with exit value " + this.exitValue;
        String finishedStatus = "finished normally";
        if (this.expectedExitValue != -99999 && this.expectedExitValue != this.exitValue) {
            finishedStatus = "wrong exit value";
        }
        this.fireRemoteStatusEvent(event, startmsg, finishedStatus);
        if (this.expectedExitValue != -99999 && this.expectedExitValue != this.exitValue && !this.interrupted) {
            String msg = "Expecteded exit value " + this.expectedExitValue + ", got " + this.exitValue + " while running '" + this.shortName + "': \n" + this.getLastLines();
            throw new ExitValueException(msg);
        }
        this.runResult = this.exitValue;
    }

    private void writeToProcess(Process pr) throws IOException {
        OutputStream os = pr.getOutputStream();
        OutputStreamWriter ous = new OutputStreamWriter(os);
        BufferedWriter out = new BufferedWriter(ous);
        out.write(this.input);
        out.flush();
        out.close();
    }

    private void runDBMScript() throws RTEException, IOException, DBMException {
        if (this.interrupted) {
            return;
        }
        Properties props = new Properties();
        Enumeration keys = this.dbmProperties.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            String keyS = key.toString();
            Object val = this.dbmProperties.get(key);
            String valS = "";
            if (val instanceof File) {
                valS = ((File)val).getCanonicalPath();
            } else if (val != null) {
                valS = val.toString();
            }
            props.put(keyS, valS);
        }
        this.fireLogEvent("Initializing DBM-Connection with " + props + "\n");
        this.dbmConnection = new DBM(props);
        LineNumberReader lr = new LineNumberReader(new StringReader(this.dbmScript));
        String line = "";
        if (this.interrupted) {
            return;
        }
        while ((line = lr.readLine()) != null && !this.interrupted) {
            if ((line = line.trim()).startsWith("#") || line.equals("")) continue;
            this.fireLogEvent("[DBM] " + line + "\n");
            String dbmLine = this.dbmConnection.cmd(line);
            this.fireRemoteDbmEvent(dbmLine);
        }
        this.dbmConnection.release();
        this.dbmConnection = null;
    }

    private void cleanup() {
        if (this.logStream != null) {
            this.logStream.flush();
            this.logStream.close();
        }
    }

    public boolean destroy() throws RemoteException {
        try {
            return this.destroyInternal();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    boolean destroyInternal() throws RTEException, InterruptedException, RemoteException {
        return this.destroyLocal();
    }

    private boolean destroyLocal() throws RTEException, InterruptedException, RemoteException {
        if (this.isRunning()) {
            this.interrupted = true;
            if (this.process != null) {
                this.process.destroy();
            }
            if (this.dbmConnection != null) {
                this.dbmConnection.release();
                this.dbmConnection = null;
            }
            if (this.runThread != null) {
                this.runThread.join();
            }
        }
        return this.hasFinished;
    }

    void logLine(String line, boolean logErrors, boolean fromStream) {
        String prefix = fromStream ? "[STDOUT] " : "[STDERR] ";
        this.logLine(line, logErrors, prefix);
    }

    void logLine(String line, boolean logErrors, String prefix) {
        String outline = prefix + line;
        this.logLine(outline, logErrors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logLine(String line, boolean logErrors) {
        Object object = this;
        synchronized (object) {
            this.fireLogEvent(line);
        }
        if (this.logStream != null) {
            object = this.logStream;
            synchronized (object) {
                this.logStream.println(line);
            }
        }
    }

    void logLine(String line) {
        this.logLine(line, false);
    }

    public Executor getExecutor() throws RemoteException {
        return this;
    }

    static class ExitValueException
    extends IOException {
        ExitValueException(String s) {
            super(s);
        }
    }

    private class ParallelStreamReader
    extends Thread {
        private BufferedReader br;
        private boolean m_MustStop = false;
        private boolean m_LogErrors = false;
        private boolean stream;
        private boolean memorizeLines = false;

        public ParallelStreamReader(boolean stream, boolean logErrors, boolean memorizeLines) throws FileNotFoundException {
            this.m_LogErrors = logErrors;
            this.stream = stream;
            this.memorizeLines = memorizeLines;
            this.br = new BufferedReader(new InputStreamReader(stream ? Executor.this.process.getInputStream() : Executor.this.process.getErrorStream()));
        }

        public void stopReading() {
            this.m_MustStop = true;
        }

        public void run() {
            try {
                String line;
                while (!this.m_MustStop && (line = this.br.readLine()) != null) {
                    if (this.memorizeLines) {
                        Executor.this.memorizeLine(line);
                    }
                    if (Executor.this.logStream != null) {
                        Executor.this.logLine(line, this.m_LogErrors, this.stream);
                        continue;
                    }
                    String prefix = this.stream ? "[STDOUT] " : "[STDERR] ";
                    String logLine = prefix + line;
                    Logger.log(logLine);
                    Executor.this.fireRemoteStdoutEvent(line);
                }
                this.br.close();
            }
            catch (IOException e) {
                String msg = "An IOException occured when reading from a programs Output/Error-Stream " + e.getMessage();
                Logger.error(msg);
                Logger.stackTrace(e);
            }
        }
    }

    static class DefaultFilter
    implements LineFilter {
        DefaultFilter() {
        }

        public boolean accept(String line) {
            return true;
        }
    }
}

