/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.sapdb.upgradetest.CmdlineTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Dbmcli
extends CmdlineTool {
    static final long serialVersionUID = -1630575753344230474L;
    private String prompt;
    private String lastResultCode;
    private final ArrayList lastErrors = new ArrayList();
    private final ArrayList lastResults = new ArrayList();

    boolean success() {
        return "OK".equals(this.lastResultCode);
    }

    String lastErrorString() {
        String s = Dbmcli.arrayListToString(this.lastErrors);
        s = s != null ? s.trim() : s;
        return s;
    }

    String lastResultString() {
        String s = Dbmcli.arrayListToString(this.lastResults);
        s = s != null ? s.trim() : s;
        return s;
    }

    String[] lastResults() {
        return Dbmcli.arrayListToStringArray(this.lastResults);
    }

    String[] lastErrors() {
        return Dbmcli.arrayListToStringArray(this.lastErrors);
    }

    String getPrompt() {
        return this.prompt;
    }

    void initProcess() throws IOException {
        super.initProcess();
        this.initPrompt();
    }

    private void initPrompt() throws IOException {
        this.resetTimer();
        while (true) {
            this.timeCheck();
            this.prompt = this.getStdOut();
            if (this.processExited()) {
                throw new IOException("Process exited: " + this.prompt);
            }
            if (this.prompt.endsWith(">")) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.clearStdOut();
    }

    void call(String cmd) throws IOException {
        String[] lines = this.cmdl(cmd);
        this.lastErrors.clear();
        this.lastResults.clear();
        if (lines.length > 0) {
            this.lastResultCode = lines[0];
        }
        for (int i = 1; i < lines.length; ++i) {
            String l = lines[i];
            if (l.matches("^-?\\d+,\\w+:.*")) {
                this.lastErrors.add(l);
                continue;
            }
            this.lastResults.add(l);
        }
        if (!this.success()) {
            throw new DbmcliException("Error executing '" + cmd + "':\n" + this.lastErrorString());
        }
    }

    String cmd(byte[] b) throws IOException {
        String s;
        this.writeStdout(b);
        while (true) {
            s = this.getStdOut();
            if (this.processExited()) {
                throw new IOException("Process exited: " + s);
            }
            if (s.endsWith(this.prompt)) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
                break;
            }
        }
        s = s.substring(0, s.lastIndexOf("---"));
        this.clearStdOut();
        return s;
    }

    Dbmcli() throws IOException {
        super(new String[]{"dbmcli"});
    }

    Dbmcli(long timeout) throws IOException {
        super(new String[]{"dbmcli"}, timeout);
    }

    Dbmcli(File f) throws IOException {
        super(f);
    }

    Dbmcli(File f, long timeout) throws IOException {
        super(f, timeout);
    }

    Dbmcli(String[] aCallString) throws IOException {
        super(aCallString);
    }

    Dbmcli(String[] aCallString, long timeout) throws IOException {
        super(aCallString, timeout);
    }

    Dbmcli(String[] aCallString, String[] aenv) throws IOException {
        super(aCallString, aenv);
    }

    Dbmcli(String[] aCallString, String[] aenv, long timeout) throws IOException {
        super(aCallString, aenv, timeout);
    }

    String getIndepProg() throws IOException {
        this.call("dbm_getpath IndepProgPath");
        return this.lastResultString();
    }

    String getIndepData() throws IOException {
        this.call("dbm_getpath IndepDataPath");
        return this.lastResultString();
    }

    void destroy() {
        try {
            this.bye();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.destroy();
    }

    void bye() throws IOException {
        String s;
        this.writeStdout("bye\n".getBytes());
        for (int i = 0; i < 10 && ((s = this.getStdOut()) == null || s.indexOf("---") < 0); ++i) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    String[] dbenum() throws IOException {
        this.call("db_enum");
        String s = this.lastResultString();
        StringTokenizer t = new StringTokenizer(s, "\n");
        ArrayList<String> al = new ArrayList<String>();
        while (t.hasMoreElements()) {
            String token = t.nextToken();
            if (!token.matches(".+\\s+fast\\s+.+")) continue;
            al.add(token);
        }
        return al.toArray(new String[0]);
    }

    public static void main(String[] args) throws Exception {
        File f = new File("c:/program files/sdb/programs/pgm/dbmcli");
        String dbmcli = f.getCanonicalPath();
        String[] s = new String[]{dbmcli};
        Dbmcli dbm = new Dbmcli(f);
        try {
            String indepProg = dbm.getIndepProg();
            String indepData = dbm.getIndepData();
            String[] dbs = dbm.dbenum();
            Dbmcli.db("IndepProg: '" + indepProg + "'\n");
            Dbmcli.db("IndepData: '" + indepData + "'\n");
            for (int i = 0; i < dbs.length; ++i) {
                Dbmcli.db(dbs[i]);
            }
        }
        catch (IOException ex) {
            dbm.destroy();
            throw ex;
        }
        dbm.destroy();
    }

    private static void db(Object ob) {
        System.out.print(ob);
    }

    static class DbmcliException
    extends IOException {
        DbmcliException(String s) {
            super(s);
        }
    }
}

