/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.sapdb.upgradetest.CanEnable;
import com.sap.sapdb.upgradetest.Configuration;
import com.sap.sapdb.upgradetest.InstallerTester;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComboBox;

public class ControlContext {
    private InstallerTester installerTester;
    private final HashSet canEnables = new HashSet();
    private final HashSet comboBoxes = new HashSet();

    ControlContext(InstallerTester is) {
        this.installerTester = is;
    }

    void addCanEnable(CanEnable c) {
        this.canEnables.add(c);
    }

    void addComboBox(JComboBox ac) {
        this.comboBoxes.add(ac);
    }

    Iterator canEnablesIterator() {
        return this.canEnables.iterator();
    }

    Iterator comboBoxesIterator() {
        return this.comboBoxes.iterator();
    }

    public void error(Exception ex, String msg) {
        this.installerTester.error(ex, msg);
        this.installerTester.log("Error: " + ex.getMessage() + "\n", "error");
    }

    ResultSet executeSQL(String s) throws SQLException {
        Connection conn = Configuration.getQADBConn();
        Statement stmt = conn.createStatement();
        this.installerTester.log(s + "\n\n", "sql-query", this.installerTester.sqlLog);
        stmt.execute(s);
        return stmt.getResultSet();
    }
}

