/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.sapdb.upgradetest.ComplexParameter;
import com.sap.sapdb.upgradetest.ConfigurationException;
import com.sap.sapdb.upgradetest.Constants;
import com.sap.sapdb.upgradetest.Executor;
import com.sap.sapdb.upgradetest.ExecutorEvent;
import com.sap.sapdb.upgradetest.ExecutorList;
import com.sap.sapdb.upgradetest.ExecutorListenerAdapter;
import com.sap.sapdb.upgradetest.ExecutorLogic;
import com.sap.sapdb.upgradetest.ExecutorServerImpl;
import com.sap.sapdb.upgradetest.LineFilter;
import com.sap.sapdb.upgradetest.Logger;
import com.sap.sapdb.upgradetest.SettingNotFoundException;
import com.sap.sapdb.upgradetest.UpgradeTest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Configuration
implements Constants {
    static final long CONNECTIONWAITSECONDS = 100L;
    static final String SOURCEROLE = "source";
    static final String TARGETROLE = "target";
    static final String BRICKROLE = "brick";
    static final String OLDUSERCONCEPT = "old";
    static final String NEWUSERCONCEPT = "new";
    static final String CREATEDBTASK = "createdb";
    static final String PREPUNINSTTASK = "prepuninst";
    static final String PREPUPDATETASK = "prepupdate";
    static final String APOPROFILE = "APO LiveCache";
    static final String SERVERPROFILE = "Server";
    static final String DETECTPROFILE = "detect";
    static final String LIVECACHE_INSTANCE = "lc";
    static final String OLTP_INSTANCE = "oltp";
    static final String LCABRANCHINFO_NONE = "";
    static final String LCABRANCHINFO_CONS = "CONS";
    static final String LCABRANCHINFO_DEV = "DEV";
    static final String LCAVARIANT_OPT = "opt";
    static final String LCAVARIANT_DBG = "dbg";
    static final String LCAVARIANT_NONE = "";
    static final String LCPOOL_CANCELLED = "cncl";
    static final String LCPOOL_DELETED = "dltd";
    static final String LCPOOL_NONE = "NONE";
    static final String LCPOOL_RUN = "!RUN";
    static final String LCPOOL_SKIP = "skip";
    static final String LCPOOL_WHAT = "?";
    static final int[] RELEVANT73BUILDS = new int[]{36, 37, 38, 39, 40, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    static final LineFilter SDBINSTLINEFILTER = new LineFilter(){

        public boolean accept(String line) {
            return line != null && !"".equals(line.trim()) && !line.startsWith("extracting:");
        }
    };
    private static final Vector sqlListeners = new Vector();
    static final String UNGOODLCPOOLIDS = "'cncl','dltd','NONE','!RUN','skip','?'";
    static final Template TEMPLATE = new Template();
    static final Template DESKTOP_TEMPLATE = new DesktopTemplate();
    static final Template CUSTOM_TEMPLATE = new CustomTemplate();
    static final Template SAPDW_TEMPLATE = new SAPDWTemplate();
    static final Template SAPMC_TEMPLATE = new SAPMCTemplate();
    static final Template SAPSBS_TEMPLATE = new SAPSBSTemplate();
    static final Template[] KNOWN_TEMPLATES = new Template[]{DESKTOP_TEMPLATE, CUSTOM_TEMPLATE, SAPDW_TEMPLATE, SAPMC_TEMPLATE, SAPSBS_TEMPLATE};
    static final int BIT32 = 32;
    static final int BIT64 = 64;
    static final QASTATUS DEV = new DEVSTATUS();
    static final QASTATUS COR = new CORSTATUS();
    static final QASTATUS RAMP = new RAMPSTATUS();
    static final QASTATUS NONE = new NONESTATUS();
    static final QASTATUS QAUNKNOWN = new QASTATUS();
    static final QASTATUS HOT = new HOTSTATUS();
    static final Platform LINUXS390X = new Platform("linuxs390x;linux;Linux S390X;Linux S390X;null;LINUX390X;18;32");
    static final Platform LINUX2_6IA32 = new Platform("linux2.6ia32;linux;Linux 2.6 on i386;Linux;2.6;LINUX32;21;32");
    static final Platform RS6000_51 = new Platform("rs6000_51;aix;AIX 5.1 on PPC, 32 Bit only;null;null;AIX532;11;32");
    static final Platform LINUXINTEL = new Platform("linuxintel;linux;Linux on x86;null;null;LINUX32;6;32");
    static final Platform LINUXIA64 = new Platform("linuxia64;linux;Linux on IA64;null;null;LINUX24IA64;13;64");
    static final Platform LINUX2_6IA64 = new Platform("linux2.6ia64;linux;Linux 2.6 on itanium;Linux;2.6;LINUX26IA64;20;64");
    static final Platform ZLINUX2_6 = new Platform("zLinux2.6;linux;Linux 2.6 on zSeries;Linux;2.6;LINUX390X;22;32"){

        boolean supportsVersion(String version) {
            return version.startsWith("7.5");
        }
    };
    static final Platform HPIA64 = new Platform("hpia64;hpux;HP-UX on IA64 (HP-IPF);HP-UX;11;HPIA64;14;64");
    static final Platform RS6000_64 = new Platform("rs6000_64;aix;AIX 4.3 on PPC;null;null;AIX64;4;64");
    static final Platform SUN_64 = new Platform("sun_64;solaris;SunOS on Sparc;null;null;SUN64;1;64");
    static final Platform NTINTEL = new Platform("NTintel;MSWin32;null;null;null;WIN32;7;32");
    static final Platform SUN = new Platform("sun;solaris;SunOS on Sparc, 32 Bit only;null;null;SUN32;9;32");
    static final Platform HP_64 = new Platform("hp_64;hpux;HP-UX on HPPA;null;null;HP64;5;64");
    static final Platform NTX86_64 = new Platform("NTx86_64;MSWin32;Windows on Opteron/Nocona;Windows;2003;WINAMD64;19;32");
    static final Platform LINUXX86_64 = new Platform("linuxx86_64;linux;Linux on Opteron/Nocona;Linux;null;LINUXX8664;16;64");
    static final Platform LINUXPPC64 = new Platform("linuxppc64;linux;Linux on PPC;Linux;null;LINUXPPC64;15;64");
    static final Platform RS6000_52_64 = new Platform("rs6000_52_64;aix;AIX 5.2 PPC;AIX;5.2;AIX564;17;64");
    static final Platform RS6000_51_64 = new Platform("rs6000_51_64;aix;AIX 5.1 on PPC;null;null;AIX564;3;64");
    static final Platform ALPHAOSF = new Platform("alphaosf;dec_osf;Tru64 on Alpha;null;null;DEC64;2;64");
    static final Platform RS6000 = new Platform("rs6000;aix;AIX 4.3 on PPC, 32 Bit only;null;null;AIX32;10;32");
    static final Platform HP = new Platform("hp;hpux;HP-UX on HPPA, 21 Bit only;null;null;HP32;12;32");
    static final Platform NTIA64 = new Platform("NTia64;MSWin32;null;null;null;WIN64;8;64");
    static final Platform UNKNOWNPLATFORM = new UnknownPlatform();
    private static volatile Connection qadbConnection = null;
    private static volatile SQLException connectionException;
    private File parameterFile;
    private File configFile;
    Properties props;
    private String environmentOs;
    private String environmentBit;
    private String environmentPlatform;
    private String logLevel;
    private File packdistribPathUx = null;
    private File packdistribPathWin = null;
    private File directoriesTemp;
    private File logFile;
    private File indepData = new File("/sapdb/indep_data");
    private File indepProg = new File("/sapdb_indep_prog");
    private File dependendPrefixDir = new File("/sapdb/depend");
    File sapCar = null;
    private boolean isAutoCreate = true;
    private final ArrayList upgradeTests = new ArrayList();
    private final HashMap scripts = new HashMap();
    private final TreeMap scriptRefs = new TreeMap();
    private String newInstallUser = "lcown";
    private String newInstallGroup = "lcadm";
    private String oldInstallUser = "remuser";
    private String oldInstallGroup = "sapsys";
    private String x_serverPortUx = "9907";
    private boolean OLPTseperatedAPO = false;
    private boolean isOLTPTestSerie = false;
    private Platform currentPlatform = UNKNOWNPLATFORM;
    private Platform plfMakeKey = UNKNOWNPLATFORM;
    private Platform plfQADB = UNKNOWNPLATFORM;
    static /* synthetic */ Class class$com$sap$sapdb$upgradetest$Configuration;

    static void addSQLListener(PropertyChangeListener l) {
        sqlListeners.add(l);
    }

    static void removeSQLListener(PropertyChangeListener l) {
        sqlListeners.remove(l);
    }

    static void fireSQLEvent(String sqlStatement) {
        Iterator iter = sqlListeners.iterator();
        while (iter.hasNext()) {
            PropertyChangeListener l = (PropertyChangeListener)iter.next();
            l.propertyChange(new PropertyChangeEvent(sqlStatement, sqlStatement, null, null));
        }
    }

    static boolean isGoodLCPoolId(String id) {
        return id != null && !"".equals(id) && !LCPOOL_CANCELLED.equals(id) && !LCPOOL_DELETED.equals(id) && !LCPOOL_NONE.equals(id) && !LCPOOL_RUN.equals(id) && !LCPOOL_SKIP.equals(id) && !LCPOOL_WHAT.equals(id);
    }

    String getXServerPortUx() {
        return this.x_serverPortUx;
    }

    void setXServerPortUx(String s) {
        this.x_serverPortUx = s;
    }

    String dbDropscript(String version) {
        return "dbdrop";
    }

    String dbCreateScriptNameForVersion(String version, String profile, String subPurpose) {
        String instanceType = APOPROFILE.equals(profile) ? LIVECACHE_INSTANCE : OLTP_INSTANCE;
        return this.dbCreateScriptNameForInstanceType(version, instanceType, subPurpose);
    }

    String dbCreateScriptNameForInstanceType(String version, String instanceType, String subPurpose) {
        StringBuffer scriptNameBuffer = new StringBuffer(CREATEDBTASK);
        if (LIVECACHE_INSTANCE.equals(instanceType)) {
            scriptNameBuffer.append("_lc_");
        } else {
            scriptNameBuffer.append("_oltp_");
        }
        scriptNameBuffer.append(version);
        if (subPurpose != null && !"".equals(subPurpose)) {
            scriptNameBuffer.append("_" + subPurpose);
        }
        return scriptNameBuffer.toString();
    }

    String dbCreateScriptForInstanceType(String version, String instanceType, String subPurpose) {
        String nm = this.dbCreateScriptNameForInstanceType(version, instanceType, subPurpose);
        return this.getScript(nm);
    }

    static String getNormalizedVersion(String version, String build, QASTATUS status) {
        String normVersion = version.substring(0, 1) + "." + version.substring(1, 2) + "." + version.substring(2, 4);
        if (RAMP.equals(status) || HOT.equals(status)) {
            normVersion = normVersion + "." + build;
        }
        return normVersion;
    }

    static String getQADBVersion(String normalizedVersion) {
        return normalizedVersion.substring(0, 1) + normalizedVersion.substring(2, 3) + normalizedVersion.substring(4, 6);
    }

    static String getMinorVersion(String normalizedVersion) {
        return normalizedVersion.substring(2, 3);
    }

    static String getMajorVersion(String normalizedVersion) {
        return normalizedVersion.substring(0, 1);
    }

    static File constructPackageDir(File baseDir, String version, QASTATUS status, Platform platform) {
        String subDir = "maxdb_" + version.replace('.', '_') + (RAMP.equals(status) ? "" : "_" + status) + "_" + platform.distribName;
        File packageDir = new File(baseDir, subDir);
        return packageDir;
    }

    File constructPackageDir(String version, QASTATUS status, Platform platform) {
        return Configuration.constructPackageDir(new File(this.getDirectoriesTemp()), version, status, platform);
    }

    private String fillToWidth(String s, String shit, boolean append) {
        StringBuffer b = new StringBuffer(s);
        for (int i = b.length(); i < shit.length(); ++i) {
            if (append) {
                b.append(" ");
                continue;
            }
            b.insert(0, " ");
        }
        return b.toString();
    }

    UpgradeTestConfiguration getUpgradeTestConfiguration(int index) {
        return (UpgradeTestConfiguration)this.upgradeTests.get(index);
    }

    String getScript(String key) {
        Object ob = this.scripts.get(key);
        if (ob == null) {
            Iterator iter = this.scriptRefs.keySet().iterator();
            while (iter.hasNext()) {
                Object aName = null;
                Object refKey = iter.next();
                String scriptRef = refKey.toString();
                if (!key.matches(scriptRef)) continue;
                aName = this.scriptRefs.get(refKey);
                ob = this.scripts.get(aName);
                break;
            }
        }
        return ob != null ? ob.toString().trim() : null;
    }

    public static Platform[] allPlaforms() {
        return new Platform[]{NTINTEL, LINUXINTEL, LINUX2_6IA32, LINUXIA64, LINUX2_6IA64, RS6000, RS6000_64, RS6000_52_64, RS6000_51_64, RS6000_51, SUN, SUN_64, HP, HP_64, HPIA64, LINUXX86_64, LINUXPPC64, ZLINUX2_6, LINUXS390X, ALPHAOSF, NTIA64, NTX86_64};
    }

    public Platform getCurrentPlatform() {
        return this.currentPlatform;
    }

    public void setCurrentPlatform(Platform pf) {
        this.currentPlatform = pf;
    }

    public Platform getPlatformFromMakeKey() {
        return this.plfMakeKey;
    }

    public Platform getPlatformFromQADB() {
        return this.plfQADB;
    }

    Platform getPlatformByQADB() {
        Platform platform = null;
        try {
            platform = this._getPlatformByQADB();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return platform;
    }

    Platform _getPlatformByQADB() throws SQLException, UnknownHostException {
        String host = InetAddress.getLocalHost().getHostName();
        int index = host.indexOf(".");
        host = index > 0 ? (host = host.substring(0, index)) : host;
        return Configuration.getPlatformByQADB(host);
    }

    static Platform getPlatformByQADB(String host) throws SQLException {
        Platform platform = null;
        Statement stmt = Configuration.getQADBConn().createStatement();
        String select = "SELECT host, idplatform from servers where host = '" + host + "'";
        stmt.execute(select);
        ResultSet res = stmt.getResultSet();
        if (res.next()) {
            platform = Configuration.getPlatform(res.getInt(2));
        }
        return platform;
    }

    public static QASTATUS getQAStatus(int id) {
        QASTATUS st = null;
        switch (id) {
            case 1: {
                st = DEV;
                break;
            }
            case 2: {
                st = COR;
                break;
            }
            case 3: {
                st = RAMP;
                break;
            }
            case 4: {
                st = NONE;
                break;
            }
            case 5: {
                st = HOT;
                break;
            }
            default: {
                st = QAUNKNOWN;
            }
        }
        return st;
    }

    public static QASTATUS getQAStatus(String s) {
        QASTATUS st = QAUNKNOWN;
        if (RAMP.toString().equals(s)) {
            st = RAMP;
        } else if (COR.toString().equals(s)) {
            st = COR;
        } else if (DEV.toString().equals(s)) {
            st = DEV;
        } else if (QAUNKNOWN.toString().equals(s)) {
            st = QAUNKNOWN;
        } else if (HOT.toString().equals(s)) {
            st = HOT;
        } else if (NONE.toString().equals(s)) {
            st = NONE;
        }
        return st;
    }

    public static Platform getPlatform(String str) {
        Platform pf = null;
        Platform[] all = Configuration.allPlaforms();
        for (int i = 0; i < all.length; ++i) {
            if (!str.equals(all[i].descText)) continue;
            pf = all[i];
        }
        return pf;
    }

    public static Platform getPlatform(int id) {
        Platform pf = null;
        switch (id) {
            case 1: {
                pf = SUN_64;
                break;
            }
            case 2: {
                pf = ALPHAOSF;
                break;
            }
            case 3: {
                pf = RS6000_51_64;
                break;
            }
            case 4: {
                pf = RS6000_64;
                break;
            }
            case 5: {
                pf = HP_64;
                break;
            }
            case 6: {
                pf = LINUXINTEL;
                break;
            }
            case 7: {
                pf = NTINTEL;
                break;
            }
            case 8: {
                pf = NTIA64;
                break;
            }
            case 9: {
                pf = SUN;
                break;
            }
            case 10: {
                pf = RS6000;
                break;
            }
            case 11: {
                pf = RS6000_51;
                break;
            }
            case 12: {
                pf = HP;
                break;
            }
            case 13: {
                pf = LINUXIA64;
                break;
            }
            case 14: {
                pf = HPIA64;
                break;
            }
            case 15: {
                pf = LINUXPPC64;
                break;
            }
            case 16: {
                pf = LINUXX86_64;
                break;
            }
            case 17: {
                pf = RS6000_52_64;
                break;
            }
            case 18: {
                pf = LINUXS390X;
                break;
            }
            case 19: {
                pf = NTX86_64;
                break;
            }
            case 20: {
                pf = LINUX2_6IA64;
                break;
            }
            case 21: {
                pf = LINUX2_6IA32;
                break;
            }
            case 22: {
                pf = ZLINUX2_6;
                break;
            }
            default: {
                pf = UNKNOWNPLATFORM;
            }
        }
        return pf;
    }

    public static boolean isWindows() {
        return Configuration.isWindows(System.getProperties());
    }

    public static boolean isWindows(Properties sysProps) {
        return sysProps.getProperty("os.name").indexOf("Windows") >= 0;
    }

    public static boolean isUnix() {
        return !Configuration.isWindows();
    }

    static Connection getQADBConn() throws SQLException {
        connectionException = null;
        if (qadbConnection == null) {
            Thread th = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Class clazz = class$com$sap$sapdb$upgradetest$Configuration == null ? (class$com$sap$sapdb$upgradetest$Configuration = Configuration.class$("com.sap.sapdb.upgradetest.Configuration")) : class$com$sap$sapdb$upgradetest$Configuration;
                        synchronized (clazz) {
                            qadbConnection = DriverManager.getConnection("jdbc:sapdb://PTS/QADB", "TESTER", "TESTER");
                        }
                    }
                    catch (SQLException ex) {
                        connectionException = ex;
                    }
                }
            });
            th.start();
            try {
                th.join(100000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (connectionException != null) {
                throw connectionException;
            }
            if (qadbConnection == null) {
                throw new SQLException("Connection timeout after 100 seconds");
            }
        }
        return qadbConnection;
    }

    Configuration(File dataInputPath, File parameterFile, File xmlConfig) throws IOException, ConfigurationException, ParserConfigurationException, SAXException {
        this.parameterFile = parameterFile;
        this.props = new Properties();
        this.props.load(new FileInputStream(parameterFile));
        this.parseTestConfiguration(null, xmlConfig);
        this.configFile = xmlConfig;
    }

    Configuration(Properties props, InputStream is) throws IOException, ConfigurationException, ParserConfigurationException, SAXException {
        this.props = props;
        this.parseTestConfiguration(is);
    }

    Configuration() {
    }

    public static Configuration getInstance(File dataInputPath, File parameterFile) throws IOException, ConfigurationException, ParserConfigurationException, SAXException {
        Configuration config = new Configuration();
        config.parameterFile = parameterFile;
        config.props = new Properties();
        config.props.load(new FileInputStream(parameterFile));
        String testrunString = config.props.getProperty("testrun", "upgradetest.xml");
        File xmlConfig = new File(testrunString);
        if (!xmlConfig.isAbsolute()) {
            xmlConfig = new File(dataInputPath, xmlConfig.toString());
        }
        config.parseTestConfiguration(null, xmlConfig);
        config.configFile = xmlConfig;
        return config;
    }

    public int getTestCount() {
        return this.upgradeTests.size();
    }

    private List selectVersions(boolean minimalTesting, SoftwareDescription middleRelease, boolean OLTPTestSeries) throws SQLException, ConfigurationException {
        String sql = null;
        ArrayList<DBVersion> versions = new ArrayList<DBVersion>();
        Statement stmt = Configuration.getQADBConn().createStatement();
        sql = OLTPTestSeries ? Configuration.getSelectOLTP(middleRelease, true, this.currentPlatform, minimalTesting) : Configuration.getSelectAPO(middleRelease, true, this.currentPlatform, minimalTesting);
        Logger.log(Logger.STANDARD, "SQL Query for " + (minimalTesting ? "minimal" : "all") + " versions is:");
        Logger.log(Logger.STANDARD, sql);
        if (OLTPTestSeries) {
            int[] rel73 = this.currentPlatform.relevant73();
            for (int i = 0; i < rel73.length; ++i) {
                versions.add(new DBVersion(7, 3, 0, rel73[i], 3, -1));
            }
        }
        if (stmt.execute(sql)) {
            ResultSet res = stmt.getResultSet();
            while (res.next()) {
                DBVersion currversion = new DBVersion();
                currversion.setVersion(res.getInt("lcversion"));
                currversion.build = res.getInt("build");
                currversion.qastatus = Configuration.getQAStatus(res.getInt("qastatus"));
                currversion.lcpoolid = res.getString("lcpool");
                currversion.platform = Configuration.getPlatform(res.getInt("platform"));
                if (!OLTPTestSeries) {
                    currversion.lcaVersion = Configuration.fixupLCAVersion(res.getInt("apoversion"));
                    currversion.lcqastatus = Configuration.getQAStatus(res.getInt("apoqastatus"));
                    currversion.lcapoolid = res.getString("apolcpool");
                    currversion.lcavariant = res.getString("apotype");
                    currversion.branchinfo = res.getString("apobranch");
                }
                versions.add(currversion);
            }
        } else {
            throw new ConfigurationException("Could not fetch _any_ version information from QADB - something must be wrong. SQL was " + sql);
        }
        return versions;
    }

    private List selectVersionsWithQADB(boolean minimalTesting, Installable middleRelease) throws SQLException, ConfigurationException {
        String sql = null;
        ArrayList<DBVersion> versions = new ArrayList<DBVersion>();
        Statement stmt = Configuration.getQADBConn().createStatement();
        sql = minimalTesting ? Configuration.createSelectMaximalBuild(middleRelease.dbVersion.getMajorString(), middleRelease.dbVersion.build + "", this.currentPlatform, true, middleRelease.lcVersion) : Configuration.createSelect(middleRelease.dbVersion.getMajorString(), middleRelease.dbVersion.build + "", this.currentPlatform, true, middleRelease.lcVersion, true);
        Logger.log(Logger.STANDARD, "SQL Query for " + (minimalTesting ? "minimal" : "all") + " versions is:");
        Logger.log(Logger.STANDARD, sql);
        int[] rel73 = this.currentPlatform.relevant73();
        for (int i = 0; i < rel73.length; ++i) {
            versions.add(new DBVersion(7, 3, 0, rel73[i], 3, -1));
        }
        if (stmt.execute(sql)) {
            ResultSet res = stmt.getResultSet();
            while (res.next()) {
                int majorcramped = res.getInt("lcversion");
                int major = majorcramped / 1000;
                int minor = (majorcramped - major * 1000) / 100;
                int correction = majorcramped - major * 1000 - minor * 100;
                int build = res.getInt("build");
                int qastatus = RAMP.toCode();
                String poolid = res.getString("lcpool");
                int platform = res.getInt("platform");
                int apoVersion = Configuration.fixupLCAVersion(res.getInt("apoversion"));
                int apoQAStatus = RAMP.toCode();
                String apoPoolid = res.getString("apolcpool");
                String apoType = res.getString("apotype");
                String apoBranch = res.getString("apobranch");
                DBVersion currversion = new DBVersion(major, minor, correction, build, qastatus, apoVersion, apoQAStatus, poolid, apoPoolid, apoBranch, apoType);
                currversion.platform = Configuration.getPlatform(platform);
                versions.add(currversion);
            }
        } else {
            throw new ConfigurationException("Could not fetch _any_ version information from QADB - something must be wrong. SQL was " + sql);
        }
        return versions;
    }

    private void configureCurrentPlatform(String makeKey) throws ConfigurationException, SQLException {
        this.plfMakeKey = Configuration.getPlatformByMakeKey(makeKey);
        this.plfQADB = this.getPlatformByQADB();
        if (this.currentPlatform.equals(UNKNOWNPLATFORM)) {
            this.currentPlatform = this.plfMakeKey;
            Logger.log("Determined platform from make key: " + this.currentPlatform.stringRep());
        } else {
            if (this.plfMakeKey != null && !this.plfMakeKey.equals(this.currentPlatform)) {
                throw new ConfigurationException("Platform from make key " + this.plfMakeKey.descText + " wrong, need " + this.currentPlatform.descText);
            }
            if (this.plfQADB != null && !this.plfQADB.equals(this.currentPlatform)) {
                Logger.log("WARNING: Platform " + this.currentPlatform.descText + " does not equals platform determined by QADB (" + this.plfQADB.descText);
            }
            Logger.log("Assuming platform  " + this.currentPlatform.stringRep());
        }
    }

    public void createAutoConfigOLTP(String OLTPMakeKey, boolean minimalTesting) throws ConfigurationException, SQLException {
        this.OLPTseperatedAPO = true;
        this.isOLTPTestSerie = true;
        this.upgradeTests.clear();
        Logger.log("Automagically creating an \"OLTP test only\" configuration for OLTP make " + OLTPMakeKey);
        this.configureCurrentPlatform(OLTPMakeKey);
        this.setEnvironmentBits("" + this.currentPlatform.bits());
        this.setEnvironmentOs(System.getProperty("os.arch"));
        DBVersion middlereleaseDBVersion = Configuration.fromMakeKey(OLTPMakeKey);
        if (middlereleaseDBVersion == null) {
            throw new ConfigurationException("Configuration.CreateAutoConfig: No version found for OLTP makekey: '" + OLTPMakeKey + "'");
        }
        List versions = this.selectVersions(minimalTesting, new SoftwareDescription(middlereleaseDBVersion), true);
        Iterator it = versions.iterator();
        while (it.hasNext()) {
            UpgradeTestConfiguration ug = new UpgradeTestConfiguration();
            DBVersion currversion = (DBVersion)it.next();
            if (!ug.setInstallables(currversion, middlereleaseDBVersion)) continue;
            this.upgradeTests.add(ug);
        }
    }

    public void createAutoConfigAPO(String OLTPMakeKey, String APOMakeKey, boolean minimalTesting) throws ConfigurationException, SQLException {
        this.OLPTseperatedAPO = true;
        this.isOLTPTestSerie = false;
        this.upgradeTests.clear();
        Logger.log("Automagically creating a \"APO test only\" configuration for apo make " + APOMakeKey + " (OLTP make " + OLTPMakeKey + ")");
        this.configureCurrentPlatform(OLTPMakeKey);
        this.setEnvironmentBits("" + this.currentPlatform.bits());
        this.setEnvironmentOs(System.getProperty("os.arch"));
        DBVersion middlereleaseDBVersion = Configuration.getDBVersionFromAPOMakeKey(APOMakeKey);
        if (middlereleaseDBVersion == null) {
            throw new ConfigurationException("Configuration.CreateAutoConfig: No version found for apo makekey: '" + APOMakeKey + "'");
        }
        List versions = this.selectVersions(minimalTesting, new SoftwareDescription(middlereleaseDBVersion), false);
        Iterator it = versions.iterator();
        while (it.hasNext()) {
            UpgradeTestConfiguration ug = new UpgradeTestConfiguration();
            DBVersion currversion = (DBVersion)it.next();
            if (!ug.setInstallables(currversion, middlereleaseDBVersion)) continue;
            this.upgradeTests.add(ug);
        }
    }

    public void createAutoConfig(String makeKey, boolean minimalTesting) throws ConfigurationException, SQLException {
        this.OLPTseperatedAPO = false;
        this.upgradeTests.clear();
        Logger.log("Automagically creating a configuration for make " + makeKey);
        this.configureCurrentPlatform(makeKey);
        this.setEnvironmentBits("" + this.currentPlatform.bits());
        this.setEnvironmentOs(System.getProperty("os.arch"));
        DBVersion middlereleaseDBVersion = Configuration.fromMakeKey(makeKey);
        if (middlereleaseDBVersion == null) {
            throw new ConfigurationException("Configuration.CreateAutoConfig: No version found for makekey: '" + makeKey + "'");
        }
        Installable middleRelease = new Installable(middlereleaseDBVersion);
        List versions = this.selectVersionsWithQADB(minimalTesting, middleRelease);
        Iterator it = versions.iterator();
        while (it.hasNext()) {
            UpgradeTestConfiguration ug = new UpgradeTestConfiguration();
            DBVersion currversion = (DBVersion)it.next();
            if (!ug.setInstallables(currversion, middlereleaseDBVersion)) continue;
            this.upgradeTests.add(ug);
        }
    }

    private static Platform getPlatformByMakeKey(String MakeKey) throws SQLException {
        Statement stmt = Configuration.getQADBConn().createStatement();
        String sql = "SELECT idplatform FROM makes m WHERE m.id = " + MakeKey;
        Logger.log(Logger.STANDARD, "SQL Query for platform ID is:");
        Logger.log(Logger.STANDARD, sql);
        stmt.execute(sql);
        ResultSet res = stmt.getResultSet();
        Platform pf = UNKNOWNPLATFORM;
        if (res.next()) {
            pf = Configuration.getPlatform(res.getInt(1));
        }
        return pf;
    }

    public static int fixupLCAVersion(int LCAVersion) {
        int res = LCAVersion;
        if (LCAVersion < 100000 && LCAVersion > 9999) {
            int first2digits = LCAVersion / 1000;
            int last3digits = LCAVersion % 1000;
            res = first2digits * 10000 + last3digits;
        }
        return res;
    }

    public static String fixupLCAVersion(String LCAVersion) {
        return "" + Configuration.fixupLCAVersion(Integer.parseInt(LCAVersion));
    }

    public static String fixupVersion(String aVersion) {
        StringBuffer version = new StringBuffer(aVersion);
        for (int pos = 0; pos < version.length(); ++pos) {
            if (version.charAt(pos) != '.') continue;
            version.deleteCharAt(pos);
        }
        return version.toString();
    }

    public void dropConfiguration() {
        Logger.log(Logger.DEBUG, "Configuration: dropping all configuration information");
    }

    public static int lcaVersion(String version, String platform) throws SQLException {
        if (version.endsWith("COR")) {
            return Configuration.lcaVersion(version, platform, 2);
        }
        if (version.endsWith(LCABRANCHINFO_DEV)) {
            return Configuration.lcaVersion(version, platform, 1);
        }
        return Configuration.lcaVersion(version, platform, 0);
    }

    public static int lcaVersion(String version, String platform, String state) throws SQLException {
        if (state.equals("COR")) {
            return Configuration.lcaVersion(version, platform, 2);
        }
        if (state.equals(LCABRANCHINFO_DEV)) {
            return Configuration.lcaVersion(version, platform, 1);
        }
        return Configuration.lcaVersion(version, platform, 0);
    }

    public static int lcaVersion(String version, String platform, int state) throws SQLException {
        Statement stmt = Configuration.getQADBConn().createStatement();
        StringBuffer sql = new StringBuffer("SELECT MAX(l.version) AS max_lcaversion FROM makes m INNER JOIN platforms p ON m.idplatform = p.id INNER JOIN lcamakes l on m.id = l.idmake WHERE m.version = '" + version.substring(0, 4) + "' ");
        if (state == 0) {
            sql.append("AND m.buildpfx = '" + version.substring(4) + "' " + "AND m.idqastatus = '3' ");
        } else {
            sql.append("AND m.idqastatus = '" + state + "' ");
        }
        sql.append("AND p.distribname = '" + platform + "' ");
        Logger.log(Logger.STANDARD, "SQL Query for LCA version fom database version is:");
        Logger.log(Logger.STANDARD, sql.toString());
        stmt.execute(sql.toString());
        ResultSet res = stmt.getResultSet();
        if (!res.next() || res.getInt(1) == 0) {
            return 0;
        }
        int lcaversion = res.getInt(1);
        if (lcaversion < 100000) {
            lcaversion = Configuration.fixupLCAVersion(lcaversion);
        }
        return lcaversion;
    }

    public static int lcaVersion(String makeKey) throws SQLException {
        Statement stmt = Configuration.getQADBConn().createStatement();
        String sql = "SELECT MAX(l.version) AS max_lcaversion FROM makes m INNER JOIN lcamakes l on m.id = l.idmake WHERE m.id = " + makeKey;
        Logger.log(Logger.STANDARD, "SQL Query for LCA version from make key is:");
        Logger.log(Logger.STANDARD, sql);
        stmt.execute(sql);
        ResultSet res = stmt.getResultSet();
        if (!res.next() || res.getInt(1) == 0) {
            return 0;
        }
        int lcaversion = res.getInt(1);
        if (lcaversion < 100000) {
            lcaversion = Configuration.fixupLCAVersion(lcaversion);
        }
        return lcaversion;
    }

    public static DBVersion getDBVersionFromAPOMakeKey(String apoMakeKey) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT m.version, m.buildpfx, m.idqastatus, ");
        sql.append("l.version AS lcaVersion ,l.idqastatus AS lcaqastatus, ");
        sql.append("m.lcpoolid as lcpoolid, l.lcpoolid as lcapoolid, ");
        sql.append("l.branchinfo as branchinfo, l.type as lcavariant, m.idplatform as platform ");
        sql.append("FROM makes m LEFT OUTER JOIN lcamakes l ON m.id = l.idmake ");
        sql.append("WHERE (not l.lcpoolid in ('skip','cncl','dltd') or l.lcpoolid is null ) and l.id = ");
        sql.append(apoMakeKey);
        Logger.log("SQL Query for DBVersion object from apo make key is:");
        Logger.log(sql.toString());
        Statement stmt = Configuration.getQADBConn().createStatement();
        stmt.execute(sql.toString());
        ResultSet res = stmt.getResultSet();
        if (res.next()) {
            DBVersion currversion = new DBVersion();
            currversion.setVersion(res.getInt("version"));
            currversion.build = res.getInt("buildpfx");
            currversion.qastatus = Configuration.getQAStatus(res.getInt("idqastatus"));
            currversion.lcpoolid = res.getString("lcpoolid");
            currversion.platform = Configuration.getPlatform(res.getInt("platform"));
            currversion.lcaVersion = Configuration.fixupLCAVersion(res.getInt("lcaVersion"));
            currversion.lcqastatus = Configuration.getQAStatus(res.getInt("lcaqastatus"));
            currversion.lcapoolid = res.getString("lcapoolid");
            currversion.lcavariant = res.getString("lcavariant");
            currversion.branchinfo = res.getString("branchinfo");
            return currversion;
        }
        return null;
    }

    public static DBVersion fromMakeKey(String makeKey) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT m.version, m.buildpfx, m.idqastatus, ");
        sql.append("l.version AS lcaVersion ,l.idqastatus AS lcaqastatus, ");
        sql.append("m.lcpoolid as lcpoolid, l.lcpoolid as lcapoolid, ");
        sql.append("l.branchinfo as branchinfo, l.type as lcavariant, m.idplatform as platform ");
        sql.append("FROM makes m LEFT OUTER JOIN lcamakes l ON m.id = l.idmake ");
        sql.append("WHERE (not l.lcpoolid in ('skip','cncl','dltd') or l.lcpoolid is null ) and m.id = ");
        sql.append(makeKey);
        sql.append(" ORDER BY l.version DESC, l.lcpoolid DESC");
        Logger.log("SQL Query for DBVersion object from make key is:");
        Logger.log(sql.toString());
        Statement stmt = Configuration.getQADBConn().createStatement();
        stmt.execute(sql.toString());
        ResultSet res = stmt.getResultSet();
        if (res.next()) {
            DBVersion aversion = null;
            int majorcramped = res.getInt(1);
            int major = majorcramped / 1000;
            int minor = (majorcramped - major * 1000) / 100;
            int correction = majorcramped - major * 1000 - minor * 100;
            int build = res.getInt(2);
            int qastatus = res.getInt(3);
            int lcaVersion = res.getInt(4);
            int lcaqastatus = res.getInt(5);
            String lcpoolid = res.getString(6);
            String lcapoolid = res.getString(7);
            String branchinfo = res.getString(8);
            String lcavariant = res.getString(9);
            int platformId = res.getInt(10);
            lcaVersion = Configuration.fixupLCAVersion(lcaVersion);
            if (lcpoolid == null) {
                lcpoolid = LCPOOL_NONE;
            }
            if (lcapoolid == null) {
                lcapoolid = LCPOOL_NONE;
            }
            if (branchinfo == null) {
                branchinfo = "";
            }
            if (lcavariant == null) {
                lcavariant = "";
            }
            aversion = new DBVersion(major, minor, correction, build, qastatus, lcaVersion, lcaqastatus, lcpoolid, lcapoolid, branchinfo, lcavariant);
            aversion.make = Integer.parseInt(makeKey);
            aversion.platform = Configuration.getPlatform(platformId);
            return aversion;
        }
        return null;
    }

    private void parseTestConfiguration(InputStream testcfg, File afile) throws ConfigurationException, ParserConfigurationException, SAXException, IOException {
        this.readConfig(afile);
    }

    private void parseTestConfiguration(InputStream is) throws ConfigurationException, ParserConfigurationException, SAXException, IOException {
        this.readConfig(is);
    }

    public boolean isApoTest(int testindex) {
        boolean retVal = false;
        String instProfile = this.getInstProfile(testindex);
        retVal = instProfile != null && instProfile.startsWith("APO");
        return retVal;
    }

    public boolean isBrickTest(int testindex) {
        return this.getUpgradeTestConfiguration((int)testindex).brick != null;
    }

    public String getSourceLCVersionNumber(int testindex) {
        return this.getLCVersionNumber(testindex, SOURCEROLE);
    }

    public String getTargetLCVersionNumber(int testindex) {
        return this.getLCVersionNumber(testindex, TARGETROLE);
    }

    private String getLCVersionNumber(int testindex, String role) {
        return this.getUpgradeTestConfiguration(testindex).getLCVersion(role);
    }

    public String getInstProfile(int testindex) {
        return this.getUpgradeTestConfiguration((int)testindex).instProfile;
    }

    protected String getQAStatus(int testindex, String role) {
        return this.getUpgradeTestConfiguration(testindex).getQAStatus(role).toString();
    }

    public String getBrickQAStatus(int testindex) {
        return this.getQAStatus(testindex, BRICKROLE);
    }

    public String getSourceQAStatus(int testindex) {
        return this.getQAStatus(testindex, SOURCEROLE);
    }

    public String getTargetQAStatus(int testindex) {
        return this.getQAStatus(testindex, TARGETROLE);
    }

    public String getBrickVersionNumber(int testindex) {
        return this.getVersionNumber(testindex, BRICKROLE);
    }

    public String getSourceVersionNumber(int testindex) {
        return this.getVersionNumber(testindex, SOURCEROLE);
    }

    public String getTargetVersionNumber(int testindex) {
        return this.getVersionNumber(testindex, TARGETROLE);
    }

    protected String getVersionNumber(int testindex, String role) {
        return this.getUpgradeTestConfiguration(testindex).getVersion(role);
    }

    public String getEnvironmentPlatform() {
        return this.environmentPlatform;
    }

    public void setEnvironmentPlatform(String as) {
        this.environmentPlatform = as;
    }

    public String getEnvironmentBits() {
        return this.environmentBit;
    }

    public void setEnvironmentBits(String as) {
        this.environmentBit = as;
    }

    public String getEnvironmentOs() {
        return this.environmentOs;
    }

    public void setEnvironmentOs(String as) {
        this.environmentOs = as;
    }

    public String getNewInstallUser() {
        return this.newInstallUser;
    }

    public String getNewInstallGroup() {
        return this.newInstallGroup;
    }

    public File getDbmcliExe() {
        return Configuration.getDbmcliExe(this.getIndepProg(), this.currentPlatform);
    }

    public static File getDbmcliExe(File indepProg, Platform plf) {
        return plf.isWindows() ? new File(indepProg, "pgm/dbmcli") : new File(indepProg, "bin/dbmcli");
    }

    public File getDbmgetfExe() {
        return this.currentPlatform.isWindows() ? new File(this.getIndepProg(), "pgm/dbmgetf") : new File(this.getIndepProg(), "bin/dbmgetf");
    }

    public File getXServerExecutable() {
        return this.getXServerExecutable(this.getIndepProg(), this.currentPlatform);
    }

    public File getXServerExecutable(Platform plf) {
        return this.getXServerExecutable(this.getIndepProg(), plf);
    }

    public File getXServerExecutable(File indepProg, Platform plf) {
        return plf.isUnix() ? new File(indepProg, "bin/x_server") : new File(indepProg, "bin/x_server.exe");
    }

    public void setIndepProg(File f) {
        this.indepProg = f;
    }

    public File getIndepProg() {
        return this.indepProg;
    }

    public File getIndepData() {
        return this.indepData;
    }

    public void setIndepData(File f) {
        this.indepData = f;
    }

    public File getDependendPath(int testindex, String role) throws IOException {
        return this.getDependendPathForVersion(this.getUpgradeTestConfiguration(testindex).getVersion(role));
    }

    public File getDependendPathForVersion(String version) throws IOException {
        return new File(this.dependendPrefixDir.getCanonicalPath() + "_" + version);
    }

    public File getDependendPathForVersionOsIndependend(String version) {
        return new File(this.dependendPrefixDir + "_" + version);
    }

    public File getDependendPathOrNull(int testindex, String role) {
        try {
            return this.getDependendPathOrNull(testindex, role);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public File getIndepProgOrNull() {
        return this.getIndepProg();
    }

    public File getIndepDataOrNull() {
        return this.getIndepData();
    }

    public String getIndepDataOrNullString() {
        try {
            return this.getIndepProg().getCanonicalPath();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getIndepProgOrNullString() {
        try {
            return this.getIndepData().getCanonicalPath();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getInstallUser(String concept) {
        String as = null;
        if (NEWUSERCONCEPT.equals(concept)) {
            as = this.newInstallUser;
        } else if (OLDUSERCONCEPT.equals(concept)) {
            as = this.oldInstallUser;
        }
        return as;
    }

    public String getInstallGroup(String concept) {
        String as = null;
        if (NEWUSERCONCEPT.equals(concept)) {
            as = this.newInstallGroup;
        } else if (OLDUSERCONCEPT.equals(concept)) {
            as = this.oldInstallGroup;
        }
        return as;
    }

    float getReleaseAsFloat(int testindex, String role) throws SettingNotFoundException {
        return Float.parseFloat(this.getUpgradeTestConfiguration(testindex).getVersion(role).substring(0, 3));
    }

    Properties getDBMProperties(int testindex) throws IOException {
        String version = this.getUpgradeTestConfiguration(testindex).getSourceVersion();
        return this.getDBMProperties(version);
    }

    Properties getDBMProperties(String version) throws IOException {
        Properties dbmprops = this.initDBMProperties();
        File f = this.getDependendPathForVersion(version);
        dbmprops.setProperty("dbroot", f.getCanonicalPath());
        return dbmprops;
    }

    Hashtable getDBMProperties(String version, Platform plf) {
        Hashtable dbmprops = this.initDBMProperties(plf);
        dbmprops.put("dbroot", this.getDependendPathForVersionOsIndependend(version));
        return dbmprops;
    }

    Properties initDBMProperties() {
        Properties dbmprops = new Properties();
        dbmprops.setProperty("dbname", "TESTDB");
        dbmprops.setProperty("user", "dbm,dbm");
        if (this.currentPlatform.isUnix()) {
            dbmprops.setProperty("host", "localhost:" + UpgradeTest.getDBPort());
        } else {
            dbmprops.setProperty("host", "localhost");
        }
        return dbmprops;
    }

    Hashtable initDBMProperties(Platform plf) {
        Hashtable<String, String> dbmprops = new Hashtable<String, String>();
        dbmprops.put("dbname", "TESTDB");
        dbmprops.put("user", "dbm,dbm");
        dbmprops.put("host", "localhost");
        if (plf.isUnix()) {
            dbmprops.put("host", "localhost:" + this.x_serverPortUx);
        } else {
            dbmprops.put("host", "localhost");
        }
        return dbmprops;
    }

    String getVersionDescription(int index) {
        return this.getInstProfile(index) + " " + this.getVersionDescription(index, SOURCEROLE) + " ---> " + this.getVersionDescription(index, TARGETROLE) + (this.isBrickTest(index) ? " brick [" + this.getBrickVersionNumber(index) + this.getBrickQAStatus(index) + "]" : "");
    }

    public String getVersionDescription(int index, String role) {
        return "[" + this.getVersionNumber(index, role) + this.getQAStatus(index, role) + (this.isApoTest(index) ? " LC" + this.getLCVersionNumber(index, role) : "") + "]";
    }

    public String getEnvironmentDescription() {
        return "[" + this.getEnvironmentOs() + "-" + this.getEnvironmentBits() + "bit-" + this.getEnvironmentPlatform() + "]";
    }

    public String getScript(int testindex, String task) throws ConfigurationException {
        String script = this.getUpgradeTestConfiguration(testindex).getScript(task, null);
        return script;
    }

    public boolean needsLD_ASSUME_KERNEL(int testindex) {
        return this.needsLD_ASSUME_KERNEL(this.getSourceVersionNumber(testindex));
    }

    public boolean needsLD_ASSUME_KERNEL(String version) {
        return this.needsLD_ASSUME_KERNEL(version, this.currentPlatform);
    }

    public boolean needsLD_ASSUME_KERNEL(String version, Platform plf) {
        if (version == null || plf == null) {
            return false;
        }
        if (version.compareTo("7.6") < 0 && plf.isLinux32()) {
            return true;
        }
        if (plf.isSamePlatformFamily(LINUX2_6IA64) && version.length() == 9) {
            String build = version.substring(7, 9);
            int ibuild = Integer.parseInt(build);
            if (version.indexOf("7.4.03") == 0 && ibuild >= 25 && ibuild <= 35) {
                return true;
            }
            if (version.indexOf("7.5.00") == 0 && ibuild >= 11 && ibuild <= 15) {
                return true;
            }
        }
        return false;
    }

    public File getPackdistrib() {
        return this.getPackdistrib(this.currentPlatform);
    }

    public File getPackdistrib(Platform pf) {
        File path = new File(new File(System.getProperty("env.tool")), "bin/packdistrib.pl");
        if (pf.isUnix() && this.packdistribPathUx != null) {
            path = this.packdistribPathUx;
        } else if (pf.isWindows() && this.packdistribPathWin != null) {
            path = this.packdistribPathWin;
        }
        return path;
    }

    public String getPackdistribPath() throws IOException {
        File p = this.getPackdistrib();
        return p == null ? null : p.getCanonicalPath();
    }

    public String getLCState(int testindex, String role) {
        return this.getUpgradeTestConfiguration(testindex).getLCQAStatus(role).toString();
    }

    public String getLCVersion(int testindex, String role) {
        return this.getUpgradeTestConfiguration(testindex).getLCVersion(role);
    }

    public Platform getPlatform(int testindex, String role) {
        return this.getUpgradeTestConfiguration(testindex).getPlatform(role);
    }

    public File getDependendSourcePath(int testindex) throws SettingNotFoundException, IOException {
        return this.getDependendPath(testindex, SOURCEROLE);
    }

    public String getDirectoriesTemp() {
        try {
            return this.directoriesTemp.getCanonicalPath();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String getUpdateNewSecurityConcept(int testindex) throws SettingNotFoundException {
        if (this.getUpgradeTestConfiguration((int)testindex).newSecurity) {
            return "YES";
        }
        throw new SettingNotFoundException("The most silly way I ever saw to indicate NO");
    }

    public String getUpdateNewSecurityConceptBackup(int testindex) throws SettingNotFoundException {
        if (this.getUpgradeTestConfiguration((int)testindex).newSecurityBackup) {
            return "YES";
        }
        throw new SettingNotFoundException("The most silly way I ever saw to indicate NO");
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String level) {
        this.logLevel = level;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File f) {
        this.logFile = f;
    }

    public boolean isAutoCreate() {
        return this.isAutoCreate;
    }

    public void setAutoCreate(boolean b) {
        this.isAutoCreate = b;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File f) {
        this.configFile = f;
    }

    public File getParameterFile() {
        return this.parameterFile;
    }

    public void setParameterFile(File f) {
        this.parameterFile = f;
    }

    static String javaPathFromQADB(String host) throws SQLException {
        String retVal = null;
        String select = "select varvalue from serverconfig where idserver = (select  id from servers where host  = '" + host + "') and varname = 'path'";
        ResultSet res = Configuration.executeSQL(select);
        res.next();
        String path = res.getString(1);
        StringTokenizer tok = new StringTokenizer(path, ":");
        while (tok.hasMoreElements()) {
            String atoken = tok.nextToken();
            if (!atoken.matches(".+([jJ]ava|j2se|j2sdk).+")) continue;
            retVal = atoken;
            break;
        }
        return retVal;
    }

    private static void db(Object ob) {
        System.out.println(ob);
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
        String host = "hs0030";
        Executor exec = Configuration.createStartExecutorServerExecutor(host, "c:\\SapDevelop\\Devtool", "/devtool/Tool/tool", "/SAP_DB/chr/07", Configuration.javaPathFromQADB(host), "/SAP_DB/7700DEV/test/jtest", "/usr/local/bin/chroot");
        String cmdLine = exec.getCommandline();
        Configuration.db(cmdLine);
    }

    private static void testJavaPathFromQADB() throws Exception {
        String[] KNOWN_TESTER_HOSTS = new String[]{"hs0030", "hs0059", "hs0116", "ihls36", "is0025", "is0042", "ldp001", "ls3007", "ls3101", "ls3662", "us4010"};
        Configuration config = new Configuration();
        Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
        for (int i = 0; i < KNOWN_TESTER_HOSTS.length; ++i) {
            String host = KNOWN_TESTER_HOSTS[i];
            String javaPath = Configuration.javaPathFromQADB(host);
        }
    }

    public void readConfig(File f) throws ParserConfigurationException, SAXException, IOException {
        ConfigurationReader reader = new ConfigurationReader();
        reader.read(f);
    }

    public void readConfig(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        ConfigurationReader reader = new ConfigurationReader();
        reader.read(is);
    }

    Executor createDBCreateExecutor(SoftwareDescription sw, String instanceType) {
        String version = sw.version;
        String scriptName = this.dbCreateScriptNameForInstanceType(version, instanceType, null);
        String script = this.getScript(scriptName);
        return this.createDBCreateExecutor(sw, instanceType, script);
    }

    Executor createDBCreateExecutor(SoftwareDescription sw, String instanceType, String script) {
        Platform plf = sw.platform;
        String version = sw.version;
        Hashtable props = this.getDBMProperties(version, plf);
        return this.createDBCreateExecutor(sw, instanceType, script, props);
    }

    Executor createDBCreateExecutor(SoftwareDescription sw, String instanceType, String script, Hashtable props) {
        String version = sw.version;
        Platform plf = sw.platform;
        boolean needsOsUser = version.compareTo("7.5") < 0 && plf.isUnix();
        File dbmcliExe = Configuration.getDbmcliExe(sw.indepProg, sw.platform);
        File depPath = this.getDependendPathForVersionOsIndependend(version);
        String dbname = props.get("dbname").toString();
        String dbm = props.get("user").toString();
        Serializable[] args = needsOsUser ? new Serializable[]{dbmcliExe, "-R", depPath, "db_create", dbname, dbm, "remuser,Remuser"} : new Serializable[]{dbmcliExe, "-R", depPath, "db_create", dbname, dbm};
        Executor exe = new Executor();
        exe.setCmdArray(args);
        exe.setDBMScript(script, props);
        exe.shortName = "Create database";
        exe.setExecutorClass("Create Test  Database Executor");
        return exe;
    }

    Executor createDBDropExecutor(String version, Platform plf) {
        String scriptName = this.dbDropscript(version);
        String script = this.getScript(scriptName);
        Hashtable props = this.getDBMProperties(version, plf);
        return this.createDBDropExecutor(version, plf, props);
    }

    Executor createDBDropExecutor(String version, Platform plf, Hashtable props) {
        String scriptName = this.dbDropscript(version);
        String script = this.getScript(scriptName);
        Executor exe = new Executor();
        exe.shortName = "drop database";
        exe.setDBMScript(script, props);
        exe.setExecutorClass("Drop Test Database Executor");
        return exe;
    }

    Executor createCleanerExecutor(SoftwareDescription sw, boolean force) {
        return this.createCleanerExecutor(sw.version, sw.indepProg, sw.indepData, sw.platform, force);
    }

    Executor createCleanerExecutor(String version, File indepProg, File indepData, Platform plf, boolean force) {
        Executor exec = new Executor();
        exec.shortName = "Installation Cleaner";
        exec.setExecutorClass("Cleaner Executor");
        ExecutorList list = new ExecutorList();
        list.add(this.createDBDropExecutor(version, plf), force);
        list.add(this.createStopXServerExecutor(indepProg, plf), force);
        list.add(this.createSDBUNINSTExecutor(indepProg), force);
        list.add(Configuration.createDirtyFileCleanerExecutor(plf, indepProg, indepData), force);
        exec.setDelegatesImpl(list.toArray());
        return exec;
    }

    Executor createPackdistribExecutor(String profile, String aVersion, String lcversion, QASTATUS status, QASTATUS lcstatus, File unpackDir, String branchInfo, ComplexParameter perl) {
        return this.createPackdistribExecutor(profile, aVersion, lcversion, status, lcstatus, unpackDir, branchInfo, this.currentPlatform, perl);
    }

    Executor createPackdistribExecutor(String profile, String aVersion, String lcversion, QASTATUS status, QASTATUS lcstatus, File unpackDir, String branchInfo, Platform pf, ComplexParameter perl) {
        return this.createPackdistribExecutor(profile, aVersion, lcversion, status, lcstatus, unpackDir, branchInfo, pf, this.getPackdistrib(pf), perl);
    }

    Executor createPackdistribExecutor(String profile, String aVersion, String lcversion, QASTATUS status, QASTATUS lcstatus, File unpackDir, String branchInfo, Platform pf, File packdistrib, ComplexParameter perl) {
        String lcpoolIdIsNull = null;
        String lcapoolIdIsNull = null;
        String lcaVariantIsNull = null;
        return this.createPackdistribExecutor(profile, aVersion, lcversion, status, lcstatus, unpackDir, branchInfo, pf, packdistrib, lcpoolIdIsNull, lcapoolIdIsNull, lcaVariantIsNull, perl);
    }

    Executor createPackdistribExecutor(String profile, String aVersion, String lcversion, QASTATUS status, QASTATUS lcstatus, File unpackDir, String branchInfo, Platform pf, File packdistrib, String lcpool, String lcapool, String lcaVariant, ComplexParameter perl) {
        SoftwareDescription sw = new SoftwareDescription();
        sw.profile = profile;
        sw.version = aVersion;
        sw.status = status;
        sw.apostatus = lcstatus;
        sw.apoversion = lcversion;
        sw.unpackDir = unpackDir;
        sw.branchInfo = branchInfo;
        sw.platform = pf;
        sw.packdistrib = packdistrib;
        sw.lcpool = lcpool;
        sw.apolcpool = lcapool;
        sw.lcaVariant = lcaVariant;
        return this.createPackdistribExecutor(sw, perl);
    }

    Executor createPackdistribExecutor(SoftwareDescription sw, ComplexParameter perl) {
        Executor myExec = new Executor();
        myExec.setExecutorLogic(new PackdistribPreparator(sw.unpackDir));
        myExec.shortName = "packdistrib (" + sw.version + (RAMP.equals(sw.status) ? "" : " " + sw.status.toString()) + (sw.apoversion != null ? ", " + sw.apoversion : "") + ")";
        myExec.setExecutorClass("PackdistribExecutor");
        Vector<Object> cmdline = new Vector<Object>();
        cmdline.add(perl);
        cmdline.add(new ComplexParameter("", sw.packdistrib));
        cmdline.add("-profile");
        cmdline.add(sw.profile);
        if (sw.platform != null) {
            cmdline.add("-os");
            cmdline.add(sw.platform.distribName);
        }
        cmdline.add("-version");
        cmdline.add(Configuration.fixupVersion(sw.version));
        if (!RAMP.equals(sw.status)) {
            cmdline.add("-state");
            cmdline.add(sw.status.toString());
        }
        cmdline.add("-build_cd");
        cmdline.add("-dir");
        cmdline.add(sw.unpackDir);
        if (APOPROFILE.equals(sw.profile)) {
            cmdline.add("-lca_state");
            cmdline.add("".equals(sw.branchInfo) || sw.branchInfo == null ? sw.apostatus.toString() : sw.branchInfo);
            String apoversion = sw.apoversion;
            cmdline.add("-lca_version");
            if (apoversion.length() == 5) {
                apoversion = Configuration.fixupLCAVersion(apoversion);
            }
            cmdline.add(apoversion);
            if (sw.apolcpool != null) {
                cmdline.add("-lca_buildselect");
                cmdline.add(sw.apolcpool);
            }
            if (sw.lcaVariant != null) {
                cmdline.add("-lca_variant");
                cmdline.add(sw.lcaVariant);
            }
        }
        if (sw.lcpool != null && !LCPOOL_NONE.equals(sw.lcpool)) {
            cmdline.add("-buildselect");
            cmdline.add(sw.lcpool);
        }
        Serializable[] cmda = cmdline.toArray(new Serializable[0]);
        myExec.setCmdArray(cmda);
        myExec.setExpectedExitValue(0);
        return myExec;
    }

    Executor createStartXServerExecutor(String version, File indepProg, Platform pf) {
        SoftwareDescription sw = new SoftwareDescription();
        sw.version = version;
        sw.indepProg = indepProg;
        return this.createStartXServerExecutor(sw);
    }

    Executor createStartXServerExecutor(SoftwareDescription sw) {
        File f = this.getXServerExecutable(sw.indepProg, sw.platform);
        Serializable[] commandline = new Serializable[]{f, "start"};
        Executor myExec = new Executor();
        myExec.setCmdArray(commandline);
        myExec.shortName = "x_server start";
        myExec.setExecutorClass("Start X-Server Executor");
        if (this.needsLD_ASSUME_KERNEL(sw.version, sw.platform)) {
            String as = "LD_ASSUME_KERNEL=2.4.1";
            myExec.setEnvironment(new String[]{as});
        }
        return myExec;
    }

    Executor createStopXServerExecutor(File indepProg, Platform plf) {
        SoftwareDescription sw = new SoftwareDescription();
        sw.indepProg = indepProg;
        sw.platform = plf;
        return this.createStopXServerExecutor(sw);
    }

    Executor createStopXServerExecutor(SoftwareDescription sw) {
        File f = this.getXServerExecutable(sw.indepProg, sw.platform);
        Serializable[] commandline = new Serializable[]{f, "stop"};
        Executor myExec = new Executor();
        myExec.setCmdArray(commandline);
        myExec.shortName = "x_server stop";
        myExec.setExecutorClass("Stop X-Server Executor");
        return myExec;
    }

    Executor createSDBINSTExecutor(File packageDir, File indepProg, File indepData, File dep, String prf, String version) {
        SoftwareDescription sw = new SoftwareDescription();
        sw.unpackDir = packageDir;
        sw.indepProg = indepProg;
        sw.indepData = indepData;
        sw.depPath = dep;
        sw.profile = prf;
        sw.version = version;
        sw.platform = this.currentPlatform;
        return this.createSDBINSTExecutor(sw);
    }

    Executor createSDBINSTExecutor(SoftwareDescription sw) {
        Vector<Object> cmdline = new Vector<Object>();
        File sdbinst = new File(sw.unpackDir, "SDBINST");
        cmdline.add(sdbinst);
        cmdline.add("-b");
        cmdline.add("-profile");
        cmdline.add(sw.profile);
        cmdline.add("-indep_prog");
        cmdline.add(sw.indepProg);
        cmdline.add("-indep_data");
        cmdline.add(sw.indepData);
        cmdline.add("-depend");
        cmdline.add(sw.depPath);
        if (sw.platform.isUnix()) {
            float versionNumber = Float.parseFloat(sw.version.substring(0, 3));
            String concept = (double)versionNumber >= 7.5 ? NEWUSERCONCEPT : OLDUSERCONCEPT;
            cmdline.add("-o");
            cmdline.add(this.getInstallUser(concept));
            cmdline.add("-g");
            cmdline.add(this.getInstallGroup(concept));
        }
        Executor myExec = new Executor();
        myExec.setCmdArray(cmdline.toArray(new Serializable[0]));
        myExec.shortName = "SBINST (" + sw.version + ", profile " + sw.profile + ")";
        myExec.setExecutorClass("SDBINST Executor");
        myExec.setStdOutFilter(SDBINSTLINEFILTER);
        myExec.setExpectedExitValue(0);
        return myExec;
    }

    Executor createSDBUNINSTExecutor(File indepProg) {
        Vector<Object> cmdline = new Vector<Object>();
        String input = new String("y\n");
        cmdline.add(new File(indepProg, "bin/sdbuninst"));
        cmdline.add("-all");
        Executor myExec = new Executor();
        myExec.setCmdArray(cmdline.toArray(new Serializable[0]));
        myExec.setInput(input);
        myExec.shortName = "SDBUNINST";
        myExec.setExecutorClass("SDBUNINST Executor");
        myExec.setStdOutFilter(SDBINSTLINEFILTER);
        myExec.setExpectedExitValue(0);
        return myExec;
    }

    Executor createScriptExecutor(String scriptName, String version, Platform plf) {
        Hashtable props = this.getDBMProperties(version, plf);
        return this.createScriptExecutor(scriptName, version, plf, props);
    }

    Executor createScriptExecutor(String scriptName, String version, Platform plf, Hashtable props) {
        Executor myExec = new Executor();
        String minorVersion = Configuration.getMinorVersion(version);
        String postFix = "4".equals(minorVersion) ? "_74" : "_75";
        scriptName = scriptName + postFix;
        String script = this.getScript(scriptName);
        myExec.shortName = "DBM-Script " + scriptName;
        myExec.setExecutorClass("DBM-Script Executor");
        myExec.setDBMScript(script, props);
        return myExec;
    }

    Executor createUpdateExecutor(File unpackDir, String version) {
        Vector<Object> cmdline = new Vector<Object>();
        cmdline.add(new File(unpackDir, "SDBUPD"));
        cmdline.add("-b");
        cmdline.add("-d");
        cmdline.add("TESTDB");
        cmdline.add("-u");
        cmdline.add("dbm,dbm");
        int minor = Integer.parseInt(version.substring(2, 3));
        if (this.currentPlatform.isUnix() && minor >= 5) {
            cmdline.add("-o");
            cmdline.add(this.getNewInstallUser());
            cmdline.add("-g");
            cmdline.add(this.getNewInstallGroup());
        }
        Executor myExec = new Executor();
        myExec.setCmdArray(cmdline.toArray(new Serializable[0]));
        myExec.setStdOutFilter(SDBINSTLINEFILTER);
        myExec.shortName = "SDBUPD (" + version + ")";
        myExec.setExecutorClass("Ugrade Executor");
        myExec.setExpectedExitValue(0);
        return myExec;
    }

    Executor createTemplateTestExecutor(SoftwareDescription sw, ComplexParameter perl) {
        Executor sequenceExecutor = null;
        ExecutorList list = new ExecutorList();
        for (int i = 0; i < KNOWN_TEMPLATES.length; ++i) {
            Template at = KNOWN_TEMPLATES[i];
            ExecutorList list2 = new ExecutorList();
            SoftwareDescription swClone = sw.cloneMe();
            swClone.template = at;
            Executor packDistrib = this.createPackdistribExecutor(swClone, perl);
            list2.add(packDistrib);
            Executor templateExe = this.createTemplateExecutor(swClone);
            templateExe.setForce(true);
            list2.add(templateExe);
            Executor cleaner = this.createCleanerExecutor(swClone, false);
            list2.add(cleaner);
            Executor testExecutor = new Executor();
            testExecutor.setDelegatesImpl(list2.toArray());
            testExecutor.shortName = "Template test " + at;
            testExecutor.setExecutorClass("Template Test Executor");
            list.add(testExecutor);
        }
        sequenceExecutor = new Executor();
        sequenceExecutor.setDelegatesImpl(list.toArray());
        sequenceExecutor.shortName = "Template tests " + sw.version;
        return sequenceExecutor;
    }

    Executor createTemplateTestExecutor(String makeKey, ComplexParameter perl) throws SQLException {
        SoftwareDescription ds = this.middleRelease(makeKey, SERVERPROFILE);
        Executor exec = this.createTemplateTestExecutor(ds, perl);
        return exec;
    }

    Executor createTemplateExecutor(SoftwareDescription sw) {
        return this.createTemplateExecutor(sw.unpackDir, sw.depPath, sw.indepProg, sw.indepData, sw.template);
    }

    Executor createTemplateExecutor(File unpackDir, File depPath, File indepProg, File indepData, Template tpl) {
        Vector<Object> cmdline = new Vector<Object>();
        cmdline.add(new File(unpackDir, "SDBINST"));
        cmdline.add("-t");
        cmdline.add(tpl.toString());
        cmdline.add("-p");
        cmdline.add("DBNAME=TESTDB");
        cmdline.add("-p");
        cmdline.add("DBMANAGER=DBM,DBM");
        cmdline.add("-p");
        cmdline.add(new ComplexParameter("DEPENDENDPATH=", depPath));
        cmdline.add("-p");
        cmdline.add(new ComplexParameter("INDEPPROG=", indepProg));
        cmdline.add("-p");
        cmdline.add(new ComplexParameter("INDEPDATA=", indepData));
        if (tpl.canSloppy()) {
            cmdline.add("-p");
            cmdline.add("SLOPPY=YES");
        }
        Executor myExec = new Executor();
        myExec.setCmdArray(cmdline.toArray(new Serializable[0]));
        myExec.shortName = "sdbinst template installation";
        myExec.setExecutorClass("Template Executor");
        myExec.setStdOutFilter(SDBINSTLINEFILTER);
        myExec.setExpectedExitValue(0);
        return myExec;
    }

    Executor createUpdateTestSequenceExecutorMaximalBuild(SoftwareDescription middleRelease, boolean includePatches, ComplexParameter perl) throws SQLException {
        Executor exec = this.createUpdateTestSequenceExecutor(this.upgradePathsMaximalBuild(middleRelease, includePatches), perl);
        exec.shortName = "Minimal upgrade tests for middle release " + middleRelease.versionString();
        return exec;
    }

    Executor createUpdateTestSequenceExecutor(SoftwareDescription middleRelease, boolean includePatches, boolean maxApo, ComplexParameter perl) throws SQLException {
        Executor exec = this.createUpdateTestSequenceExecutor(this.upgradePaths(middleRelease, includePatches, maxApo), perl);
        exec.shortName = "Upgrade tests for middle release " + middleRelease.versionString();
        return exec;
    }

    Executor createUpdateTestSequenceExecutor(SoftwareDescription[] sequence, ComplexParameter perl) {
        Executor exec = new Executor();
        ExecutorList list = new ExecutorList();
        for (int i = 0; i < sequence.length; ++i) {
            list.add(this.createUpdateTestExecutor(sequence[i], perl));
        }
        exec.setDelegatesImpl(list.toArray());
        return exec;
    }

    Executor createUpdateTestExecutor(SoftwareDescription source, ComplexParameter perl) {
        return this.createUpdateTestExecutor(source, source.target, perl);
    }

    Executor createUpdateTestExecutor(SoftwareDescription origin, SoftwareDescription target, ComplexParameter perl) {
        Executor exec = new Executor();
        exec.setExecutorClass("Ugrade Test Executor");
        ExecutorList list = new ExecutorList();
        exec.shortName = "Upgr. " + origin.versionString() + " --> " + target.versionString();
        Executor delegate = this.createPackdistribExecutor(origin, perl);
        list.add(delegate);
        delegate = this.createPackdistribExecutor(target, perl);
        list.add(delegate);
        delegate = this.createSDBINSTExecutor(origin);
        list.add(delegate);
        delegate = this.createStartXServerExecutor(origin);
        list.add(delegate);
        delegate = this.createDBCreateExecutor(origin, APOPROFILE.equals(origin.profile) && APOPROFILE.equals(target.profile) ? LIVECACHE_INSTANCE : OLTP_INSTANCE);
        list.add(delegate);
        delegate = this.createScriptExecutor("backup", origin.version, origin.platform);
        list.add(delegate);
        delegate = this.createScriptExecutor("fake_lcbackup", origin.version, origin.platform);
        list.add(delegate);
        delegate = this.createUpdateExecutor(target.unpackDir, target.version);
        list.add(delegate);
        delegate = this.createDBDropExecutor(target.version, target.platform);
        list.add(delegate);
        delegate = this.createStopXServerExecutor(target);
        list.add(delegate);
        delegate = this.createSDBUNINSTExecutor(target.indepProg);
        list.add(delegate);
        exec.setDelegatesImpl(list.toArray());
        return exec;
    }

    static Executor createDirtyFileCleanerExecutor(Platform plf, File indepProg, File indepData) {
        Executor exec = new Executor();
        exec.shortName = "Dirty Cleaner";
        exec.setExecutorClass("Dirty File Cleaner Executor");
        if (plf.isWindows()) {
            exec.setSkipped();
        } else {
            File[] files = new File[]{indepProg, indepData, new File("/usr/spool/sql/ini"), new File("/usr/spool/sql/config"), new File("/usr/spool/sql/dbspeed"), new File("/usr/spool/sql/diag"), new File("/usr/spool/sql/fifo"), new File("/usr/spool/sql/ipc"), new File("/usr/spool/sql/pid"), new File("/usr/spool/sql/pipe"), new File("/usr/spool/sql/pppid"), new File("/var/spool/sql/ini"), new File("/etc/opt/sdb")};
            exec.setExecutorLogic(new DirtyCleaner(files));
        }
        return exec;
    }

    static Executor createStartExecutorServerExecutor(String host, String localTools, String toolsDir, String chroot, String javaDir, String testDir, String chrootCommand) {
        Executor exec = new Executor();
        exec.setShortName("InstallerTesterServer: Boot Utility");
        String[] cmd = new String[]{localTools + "\\bin\\plink", "-pw", "Lroot", "lcroot@" + host, chrootCommand, chroot, javaDir + "/java", "-Denv.tool=" + toolsDir, "-Djtest.root=" + testDir, "-Djava.rmi.server.codebase=http://p101402.dhcp.ber.sap.corp:1111/rmi/", "-classpath", testDir + "/tests/upgradetest.jar:" + testDir + "/frame/sapdbc.jar", "com.sap.sapdb.upgradetest.ExecutorServerImpl"};
        exec.setCmdLine(cmd);
        exec.setInput("y");
        return exec;
    }

    static Executor createXtermExecutor(String host, String localTools, String perlCommand, String chrootNum, String display, String chr_term) {
        Executor exec = new Executor();
        exec.setShortName("XTERM Starter");
        Serializable[] cmd = new Serializable[]{localTools + "\\bin\\plink", "-pw", "Lroot", "lcroot@" + host, perlCommand, chr_term, "-dir", chrootNum, "-display", display};
        exec.setCmdArray(cmd);
        exec.setInput("y");
        return exec;
    }

    public String getLCPoolId(int testindex, String role) {
        return this.getUpgradeTestConfiguration(testindex).getLCPoolId(role);
    }

    public String getLCAPoolId(int testindex, String role) {
        return this.getUpgradeTestConfiguration(testindex).getLCAPoolId(role);
    }

    public String getBranchInfo(int testindex, String role) {
        return this.getUpgradeTestConfiguration(testindex).getBranchInfo(role);
    }

    public String getLCAVariant(int testindex, String role) {
        return this.getUpgradeTestConfiguration(testindex).getLCAVariant(role);
    }

    static String createSelectMaximalBuild(String version, String build, Platform plf, boolean includePatches, String apoVersion) {
        String patches = includePatches ? " OR (m.version = '" + version + "' and m.buildpfx < '" + build + "')" : "";
        String whereClause = "( (m.version < '" + version + "' " + patches + ") OR m.version > '" + version + "' )";
        String apoClause = Configuration.apoClause(version, apoVersion);
        return Configuration.createSelectMaximalBuild(plf, whereClause, apoClause);
    }

    static String createSelect(String version, String build, Platform plf, boolean includePatches, String apoVersion, boolean maxApo) {
        String patches = includePatches ? " OR (m.version = '" + version + "' and m.buildpfx < '" + build + "')" : "";
        String whereClause = "( (m.version < '" + version + "' " + patches + " ) OR m.version > '" + version + "')";
        String apoClause = Configuration.apoClause(version, apoVersion);
        maxApo = apoVersion == null ? true : maxApo;
        return Configuration.createSelect(plf, whereClause, apoClause, maxApo);
    }

    private static String apoClause(String version, String apoVersion) {
        String apoClause = "";
        apoClause = apoVersion == null ? ("7402".equals(version) ? " AND apoversion = '999999'\n" : " AND NOT  lcversion = '7402' ") : ("7402".equals(version) ? " AND NOT apoversion IS NULL\n" : "");
        return apoClause;
    }

    private static String createSelectMaximalBuild(Platform plf, String whereClause, String apoClause) {
        String select = "SELECT lcversion ,build,lcpool,max(apoversion) apoversion \n ,max(apolcpool) apolcpool,max(apotype) apotype \n,max(apobranch) apobranch,max(make) make,max(apomake) apomake, max(platform) platform \nFROM\n (SELECT     max(mum.apoversion) lcversion , mum.build build , mum.lcpool lcpool   ,  \n                       l.version  apoversion,  max(l.lcpoolid) apolcpool, max(l.type) apotype, \n                       max(l.branchinfo)  apobranch,max(make) make,max(l.id) apomake,max(platform) platform \n   FROM \n  ( select make make , apoversion apoversion , build  build , mmm.lcpoolid lcpool, mmm.idplatform platform  \n     FROM \n      ( SELECT              max (m.id)  make , m.version apoversion, max(m.buildpfx)  build \n            FROM makes    m  \n               WHERE     " + whereClause + " \n" + "               AND NOT  ( m.version = '7600' and (m.buildpfx < '05'  or m.buildpfx = '14'))     \n" + "               AND NOT  ( m.version = '7600' and m.idplatform IN ( " + Configuration.LINUXINTEL.id + "," + Configuration.ALPHAOSF.id + " )\n" + "               AND NOT   ( m.version = '7500' and m.buildpfx < '07')   \n" + "               AND NOT   ( m.version = '7403' and m.buildpfx < '10')  \n" + "               AND       ( m.lcpoolid  not in ('cncl','dltd','NONE','!RUN','skip','?')                           OR m.lcpoolid = NULL)   \n" + "               AND         m.idqastatus = " + RAMP.toCode() + " \n" + "               AND         m.idplatform IN " + plf.getPlatformFamilyClause() + "  AND              m.idobjstatus > 1000  \n" + "             GROUP BY  m.version  \n" + "       ) mm \n" + "      LEFT OUTER JOIN  makes mmm ON  mmm.id = mm.make )  mum \n" + "      LEFT OUTER JOIN LCAMAKES l  \n" + "         ON mum.make = l.idmake  WHERE      ( l.lcpoolid  not in ('cncl','dltd','NONE','!RUN','skip','?')        \n" + "         OR l.lcpoolid = NULL)    \n" + "         AND   ( l.idqastatus = " + RAMP.toCode() + " OR l.idqastatus = NULL)  \n" + "         AND   ( l.idobjstatus >= 1000  OR l.idobjstatus = NULL)" + "  GROUP BY mum.apoversion, mum.build,mum.lcpool , l.version )\n" + " WHERE NOT (lcversion = '7402'  AND apoversion IS NULL )\n" + apoClause + " GROUP BY lcversion,build,lcpool\n" + " ORDER BY lcversion DESC, build DESC, lcpool DESC, apoversion DESC, apolcpool DESC \n";
        return select;
    }

    protected static String getSelectOLTP(SoftwareDescription middleRelease, boolean includePatches, Platform platform, boolean minimalTest) {
        StringBuffer SQLString = new StringBuffer();
        String version = middleRelease.getMainVersionInfo();
        int qaStatus = middleRelease.status.toInt();
        SQLString.append("SELECT m.id make, m.version lcversion, m.buildpfx build, m.lcpoolid lcpool,m.idplatform platform, m.idqastatus qastatus\n");
        SQLString.append("FROM makes m\n");
        SQLString.append("WHERE\n");
        SQLString.append(" m.id IN (\n");
        SQLString.append("       SELECT max(sm.id)\n");
        SQLString.append("       FROM makes sm\n");
        SQLString.append("       WHERE\n");
        SQLString.append("       (\n");
        SQLString.append("               sm.version < '" + version + "'\n");
        SQLString.append("               OR sm.version > '" + version + "'\n");
        if (includePatches) {
            SQLString.append("               OR (sm.version = '" + version + "' AND sm.buildpfx <> '" + middleRelease.build + "')\n");
        }
        SQLString.append("       )\n");
        SQLString.append("       AND NOT  ( sm.version = '7600' and (sm.buildpfx < '05'  or sm.buildpfx = '14' ) )\n");
        SQLString.append("       AND NOT  ( sm.version = '7600' and sm.idplatform IN ( " + Configuration.LINUXINTEL.id + "," + Configuration.ALPHAOSF.id + " ))\n");
        SQLString.append("       AND NOT  ( sm.version = '7500' and sm.buildpfx < '07' )\n");
        SQLString.append("       AND NOT  ( sm.version = '7403' and sm.buildpfx < '10' )\n");
        SQLString.append("       AND NOT  ( sm.version = '7402' )\n");
        SQLString.append("       AND sm.lcpoolid  not in ('cncl','dltd','NONE','!RUN','skip','?')\n");
        SQLString.append("       AND sm.idqastatus = " + RAMP.toCode() + "\n");
        SQLString.append("       AND sm.idplatform IN " + platform.getPlatformFamilyClause() + "\n");
        SQLString.append("       AND sm.idobjstatus >= 1000\n");
        SQLString.append("       GROUP BY sm.version");
        if (!minimalTest) {
            SQLString.append(", sm.buildpfx\n");
        }
        SQLString.append("       )\n");
        if (!minimalTest) {
            SQLString.append("OR m.id IN (\n");
            SQLString.append("    SELECT max(sm.id)\n");
            SQLString.append("    FROM makes sm\n");
            SQLString.append("    WHERE\n");
            SQLString.append("    NOT (sm.version = '" + version + "' and sm.idqastatus = '" + qaStatus + "')\n");
            SQLString.append("    AND NOT (sm.version = '7700' and sm.idqastatus = '1')\n");
            SQLString.append("    AND NOT (sm.version = '7600' and sm.idplatform IN (" + Configuration.LINUXINTEL.id + "," + Configuration.ALPHAOSF.id + "))\n");
            SQLString.append("    AND NOT sm.version = '7402'\n");
            SQLString.append("    AND sm.lcpoolid  NOT IN ('cncl','dltd','NONE','!RUN','skip','?')\n");
            SQLString.append("    AND sm.idqastatus IN (1,2)\n");
            SQLString.append("    AND sm.idplatform IN " + platform.getPlatformFamilyClause() + "\n");
            SQLString.append("    AND sm.idobjstatus >= 1000\n");
            SQLString.append("    GROUP BY sm.version, sm.idqastatus\n");
            SQLString.append(")\n");
        }
        SQLString.append("ORDER BY m.version desc, m.buildpfx desc, m.lcpoolid desc\n");
        return SQLString.toString();
    }

    protected static String getSelectAPO(SoftwareDescription middleRelease, boolean includePatches, Platform platform, boolean minimalTest) {
        StringBuffer SQLString = new StringBuffer();
        String version = middleRelease.getMainVersionInfo();
        SQLString.append("SELECT m.version lcversion, m.buildpfx build, m.idqastatus qastatus, m.lcpoolid lcpool, l.version apoversion, l.idqastatus apoqastatus, l.lcpoolid apolcpool, l.type apotype, l.branchinfo apobranch, m.idplatform platform\n");
        SQLString.append("FROM LCAMAKES l JOIN MAKES m ON m.id = l.idmake\n");
        SQLString.append("WHERE \n");
        SQLString.append("        l.id IN (\n");
        SQLString.append("                SELECT max(sl.id)\n");
        SQLString.append("                FROM LCAMAKES sl JOIN MAKES sm ON sm.id = sl.idmake\n");
        SQLString.append("                WHERE\n");
        SQLString.append("                        sm.idplatform IN " + platform.getPlatformFamilyClause() + "\n");
        SQLString.append("                        AND\n");
        SQLString.append("                        (\n");
        SQLString.append("                              sm.version < '" + version + "'\n");
        SQLString.append("                              OR sm.version > '" + version + "'\n");
        if (includePatches) {
            SQLString.append("                              OR (sm.version = '" + version + "' AND sm.buildpfx <> '" + middleRelease.build + "')\n");
        }
        SQLString.append("                        )\n");
        SQLString.append("                        AND ( sl.lcpoolid  not in ('cncl','dltd','NONE','!RUN','skip','?')   OR sl.lcpoolid = NULL)\n");
        if (platform.toInt() == Configuration.LINUX2_6IA64.id) {
            SQLString.append("                        AND NOT (sm.version = '7500' and sm.buildpfx = '18')\n");
        }
        SQLString.append("                        AND sl.idobjstatus >= 1000\n");
        SQLString.append("                        AND (sl.idqastatus = 3 OR sl.idqastatus = 5)\n");
        SQLString.append("                GROUP BY sm.version");
        if (!minimalTest) {
            SQLString.append(", sm.buildpfx\n");
        }
        SQLString.append("         )\n");
        if (!minimalTest) {
            SQLString.append("    OR  l.id IN (\n");
            SQLString.append("        SELECT max(sl.id)\n");
            SQLString.append("        FROM LCAMAKES sl JOIN MAKES sm ON sm.id = sl.idmake\n");
            SQLString.append("        WHERE\n");
            SQLString.append("               sm.idplatform IN " + platform.getPlatformFamilyClause() + "\n");
            SQLString.append("               AND NOT (sm.version = '" + version + "' and sm.buildpfx  = '" + middleRelease.build + "')\n");
            SQLString.append("               AND ( sl.lcpoolid  not in ('cncl','dltd','NONE','!RUN','skip','?') OR sl.lcpoolid = NULL)\n");
            SQLString.append("               AND sl.idobjstatus >= 1000\n");
            SQLString.append("               AND sl.idqastatus IN (2)\n");
            SQLString.append("        GROUP BY sm.version\n");
            SQLString.append("   )\n");
        }
        SQLString.append("ORDER BY m.version desc, m.buildpfx desc, m.lcpoolid desc\n");
        return SQLString.toString();
    }

    private static String createSelect(Platform plf, String whereClause, String apoClause, boolean maxApo) {
        String m1 = maxApo ? "max(apoversion) apoversion" : "apoversion apoversion";
        String m2 = maxApo ? "max(mm.apoversion) lcversion" : "mm.apoversion lcversion";
        String m3 = maxApo ? " GROUP BY lcversion, build, lcpool \n" : " GROUP BY lcversion, build, lcpool, apoversion \n";
        String select = "SELECT lcversion,build,lcpool,  " + m1 + ",max(apolcpool)\n" + "      apolcpool,max(apotype) apotype,max(apobranch) apobranch,max(make) make,\n" + "      max(apomake) apomake,max(platform) platform\n" + "FROM \n" + "  (SELECT     " + m2 + ", mm.build build , mm.lcpool lcpool,  \n" + "              l.version  apoversion,  max(l.lcpoolid ) apolcpool, max(l.type) apotype,   \n" + "              max(l.branchinfo)  apobranch,max(make) make, max(l.id) apomake,max(platform) platform\n" + "     FROM   \n" + "      (SELECT max(m.id) make, m.version apoversion, m.buildpfx  build,   \n" + "              max(m.lcpoolid) lcpool,max(m.idplatform) platform   \n" + "         FROM makes    m    \n" + "         WHERE " + whereClause + " \n" + "         AND NOT  ( m.version = '7600' and (m.buildpfx < '05'  or m.buildpfx = '14'))   \n" + "         AND NOT  ( m.version = '7600' and m.idplatform IN ( " + Configuration.LINUXINTEL.id + "," + Configuration.ALPHAOSF.id + " ))\n" + "         AND NOT  ( m.version = '7500' and m.buildpfx < '07')  \n" + "         AND NOT  ( m.version = '7403' and m.buildpfx < '10')  \n" + "         AND      ( m.lcpoolid  not in ('cncl','dltd','NONE','!RUN','skip','?') OR m.lcpoolid = NULL)\n" + "         AND              m.idqastatus = " + RAMP.toCode() + "  \n" + "         AND              m.idplatform IN " + plf.getPlatformFamilyClause() + "  AND \n" + "         m.idobjstatus > 1000  \n" + "         GROUP BY m.version, m.buildpfx   \n" + "  )  mm \n" + "  LEFT OUTER JOIN LCAMAKES l  \n" + "     ON mm.make = l.idmake  \n" + "    WHERE    \n" + "       ( l.lcpoolid  not in ('cncl','dltd','NONE','!RUN','skip','?')   OR l.lcpoolid = NULL)   \n" + "      AND   ( l.idqastatus = " + RAMP.toCode() + " OR l.idqastatus = NULL)  \n" + "      AND   ( l.idobjstatus >= 1000  OR l.idobjstatus = NULL)" + "    GROUP BY mm.apoversion, mm.build,mm.lcpool , l.version  \n" + "   )  \n" + " WHERE NOT (lcversion = '7402'  AND apoversion IS NULL )\n" + apoClause + m3 + " ORDER BY lcversion desc, build desc, lcpool desc, apoversion desc, apolcpool desc      \n";
        return select;
    }

    private static String createSelectMiddleRelease(String makeKey) {
        String select = "SELECT \n m.id makekey ,     m.lcpoolid  lcpool,  m.version  version, \n m.buildpfx  build , m.idplatform platform , m.idqastatus status, \n m.ts zeit,   \n l.id apomakekey, l.lcpoolid apolcpool, l.version apoversion , l.idqastatus apostatus , \n l.branchinfo apobranch, l.type apotype, l.patchlevel  apopatchlevel \n FROM   \n (SELECT * FROM makes m  WHERE m.id = " + makeKey + ")  \n" + " LEFT OUTER JOIN LCAMAKES L ON l.idmake = m.id  \n";
        return select;
    }

    SoftwareDescription middleRelease(String makeKey, String profile) throws SQLException {
        SoftwareDescription sw = null;
        ResultSet res = Configuration.executeSQL(Configuration.createSelectMiddleRelease(makeKey));
        if (res.next()) {
            String build;
            QASTATUS status;
            sw = new SoftwareDescription();
            sw.makeKey = res.getString(1);
            sw.lcpool = res.getString(2);
            sw.status = status = Configuration.getQAStatus(res.getInt(6));
            String qadbversion = res.getString(3);
            sw.build = build = res.getString(4);
            sw.version = Configuration.getNormalizedVersion(qadbversion, build, status);
            sw.platform = Configuration.getPlatform(res.getInt(5));
            sw.apoMakeKey = res.getString(8);
            sw.apolcpool = res.getString(9);
            sw.apoversion = res.getString(10);
            sw.apostatus = Configuration.getQAStatus(res.getInt(11));
            sw.lcaVariant = res.getString(13);
            sw.branchInfo = res.getString(12);
            sw.indepProg = this.getIndepProg();
            sw.indepData = this.getIndepData();
            sw.unpackDir = this.constructPackageDir(sw.version, sw.status, sw.platform);
            sw.depPath = this.getDependendPathForVersionOsIndependend(sw.version);
            sw.packdistrib = this.getPackdistrib(sw.platform);
            sw.profile = profile;
        }
        return sw;
    }

    SoftwareDescription[] upgradePaths(SoftwareDescription middleRelease, boolean includePatches, boolean maxApo) throws SQLException {
        String select = Configuration.createSelect(Configuration.getQADBVersion(middleRelease.version), middleRelease.build, middleRelease.platform, includePatches, middleRelease.apoversion, maxApo);
        SoftwareDescription[] rel73 = null;
        if (middleRelease.platform.hasRelease73() && !middleRelease.isLiveCacheOnly()) {
            int[] builds = middleRelease.platform.relevant73();
            rel73 = new SoftwareDescription[builds.length];
            for (int i = 0; i < builds.length; ++i) {
                SoftwareDescription sw;
                rel73[i] = sw = this.dirtyCreate73(middleRelease, builds[i]);
            }
        }
        return this.upgradePaths(middleRelease, select, rel73);
    }

    SoftwareDescription[] upgradePathsMaximalBuild(SoftwareDescription middleRelease, boolean includePatches) throws SQLException {
        String select = Configuration.createSelectMaximalBuild(Configuration.getQADBVersion(middleRelease.version), middleRelease.build, middleRelease.platform, includePatches, middleRelease.apoversion);
        SoftwareDescription[] additional = null;
        if (middleRelease.platform.hasRelease73() && !middleRelease.isLiveCacheOnly()) {
            int[] rel73 = middleRelease.platform.relevant73();
            int build = rel73[rel73.length - 1];
            SoftwareDescription sw = this.dirtyCreate73(middleRelease, build);
            additional = new SoftwareDescription[]{sw};
        }
        return this.upgradePaths(middleRelease, select, additional);
    }

    private SoftwareDescription dirtyCreate73(SoftwareDescription middleRelease, int build) {
        SoftwareDescription sw = middleRelease.cloneMyBase();
        sw.version = Configuration.getNormalizedVersion("7300", Configuration.buildNumber(build), RAMP);
        sw.status = RAMP;
        sw.depPath = this.getDependendPathForVersionOsIndependend(sw.version);
        sw.target = middleRelease.cloneMe();
        sw.build = Configuration.buildNumber(build);
        sw.profile = SERVERPROFILE;
        return sw;
    }

    SoftwareDescription[] upgradePaths(SoftwareDescription middleRelease, String select, SoftwareDescription[] additional) throws SQLException {
        int i;
        ArrayList<SoftwareDescription> list = new ArrayList<SoftwareDescription>();
        SoftwareDescription[] ds = this.createSoftwareDescriptions(Configuration.executeSQL(select), middleRelease);
        for (i = 0; i < ds.length; ++i) {
            list.add(ds[i]);
        }
        if (additional != null) {
            for (i = 0; i < additional.length; ++i) {
                list.add(additional[i]);
            }
        }
        return list.toArray(new SoftwareDescription[0]);
    }

    SoftwareDescription[] createSoftwareDescriptions(ResultSet res, SoftwareDescription middleRelease) throws SQLException {
        ArrayList<SoftwareDescription> l = new ArrayList<SoftwareDescription>();
        SoftwareDescription seitenRelease = null;
        while ((seitenRelease = this.createSoftwareDescription(res, middleRelease.cloneMyBase())) != null) {
            SoftwareDescription middleReleaseClone = middleRelease.cloneMe();
            if (middleReleaseClone.isLowerThan(seitenRelease)) {
                middleReleaseClone.target = seitenRelease;
                l.add(middleReleaseClone);
                continue;
            }
            seitenRelease.target = middleReleaseClone;
            l.add(seitenRelease);
        }
        SoftwareDescription[] retVal = l.toArray(new SoftwareDescription[0]);
        return retVal;
    }

    SoftwareDescription createSoftwareDescription(ResultSet res, SoftwareDescription descr) throws SQLException {
        if (!res.next()) {
            return null;
        }
        descr.version = Configuration.getNormalizedVersion(res.getString(1), res.getString(2), RAMP);
        descr.lcpool = res.getString(3);
        descr.apoversion = res.getString(4);
        descr.apolcpool = res.getString(5);
        descr.lcaVariant = res.getString(6);
        descr.branchInfo = res.getString(7);
        descr.makeKey = res.getString(8);
        descr.apoMakeKey = res.getString(9);
        descr.platform = Configuration.getPlatform(res.getInt(10));
        descr.status = RAMP;
        descr.apostatus = RAMP;
        descr.depPath = this.getDependendPathForVersionOsIndependend(descr.version);
        if (descr.tempDir != null) {
            descr.unpackDir = Configuration.constructPackageDir(descr.tempDir, descr.version, descr.status, descr.platform);
        }
        descr.profile = descr.apoversion != null ? APOPROFILE : SERVERPROFILE;
        return descr;
    }

    static ResultSet executeSQL(String s) throws SQLException {
        Connection conn = Configuration.getQADBConn();
        Statement stmt = conn.createStatement();
        Configuration.fireSQLEvent(s);
        stmt.execute(s);
        return stmt.getResultSet();
    }

    static String buildNumber(int num) {
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(2);
        return nf.format(num);
    }

    private static SoftwareDescription[] join(SoftwareDescription[] first, SoftwareDescription[] second) {
        SoftwareDescription[] retVal = new SoftwareDescription[first.length + second.length];
        for (int i = 0; i < first.length; ++i) {
            retVal[i] = first[i];
        }
        int k = 0;
        for (int i = first.length; i < retVal.length; ++i) {
            retVal[i] = second[k++];
        }
        return retVal;
    }

    static String hexlToChar(String s) {
        if (s == null) {
            return null;
        }
        String rs = s;
        if (s.startsWith("hex(2):")) {
            rs = s.substring(7);
            StringTokenizer st = new StringTokenizer(rs, ",");
            String converted = "";
            int mask = -1;
            int nxt = -1;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int digit = Integer.parseInt(token, 16);
                if (nxt == -1) {
                    nxt = digit;
                    continue;
                }
                if (nxt > 0) {
                    String aChar = new String(new char[]{(char)(nxt &= digit << 8 | mask)});
                    converted = converted + aChar;
                    nxt = -1;
                    continue;
                }
                nxt = -1;
            }
            rs = converted;
        } else if (s.startsWith("hex(1):")) {
            rs = s.substring(7);
            StringTokenizer st = new StringTokenizer(rs, ",");
            String converted = "";
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int digit = Integer.parseInt(token, 16);
                String aChar = new String(new char[]{(char)digit});
                converted = converted + aChar;
            }
            rs = converted;
        }
        return rs;
    }

    static Properties readWinRegistry() throws IOException {
        int ac;
        File regDumpUnicode = File.createTempFile("WinRegDump", ".reg");
        File regDumpIso = File.createTempFile("WinRegDump", ".reg");
        regDumpIso.deleteOnExit();
        String regDumpUnicodePath = regDumpUnicode.getCanonicalPath();
        regDumpUnicode.delete();
        String[] cmd = new String[]{"REGEDIT", "/E", regDumpUnicodePath, "HKEY_LOCAL_MACHINE\\SOFTWARE\\SAP\\SAP DBTech"};
        Process proc = Runtime.getRuntime().exec(cmd);
        try {
            proc.waitFor();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(regDumpUnicodePath), "UNICODE"));
        BufferedWriter fw = new BufferedWriter(new FileWriter(regDumpIso));
        while ((ac = ((Reader)is).read()) >= 0) {
            ((Writer)fw).write(ac);
        }
        ((Writer)fw).flush();
        ((Writer)fw).close();
        Properties props = new Properties();
        props.load(new FileInputStream(regDumpIso));
        String indepProg = props.getProperty("\"IndepPrograms\"");
        String indepData = props.getProperty("\"IndepData\"");
        String keyID = props.getProperty("\"KeyID\"");
        String versionID = props.getProperty("\"VersionID\"");
        indepProg = Configuration.hexlToChar(indepProg);
        indepData = Configuration.hexlToChar(indepData);
        props = new Properties();
        if (indepData != null) {
            props.setProperty("IndepData", indepData);
        }
        if (indepProg != null) {
            props.setProperty("IndepPrograms", indepProg);
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class PackdistribPreparator
    extends ExecutorLogic {
        private File packDir;
        private boolean MYDEBUG = false;
        static final long serialVersionUID = -4770232787302657103L;

        PackdistribPreparator(File packDir) {
            this.packDir = packDir;
        }

        void executeLogic() {
            if (this.MYDEBUG) {
                this.getExecutor().fireExceptionEvent(new Exception("Debug interruption"));
                this.getExecutor().setSkipped();
                return;
            }
            if (this.packDir.exists()) {
                this.getExecutor().fireLogEvent("Package directory already exists: Skipping packdistrib!\n");
                this.getExecutor().setSkipped();
            } else {
                this.getExecutor().fireLogEvent("Created directory '" + this.packDir + "'\n");
                this.packDir.mkdirs();
                try {
                    this.getExecutor().addExecutorListener(new ExecutorListenerAdapter(this){
                        private final /* synthetic */ PackdistribPreparator this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void exceptionOccurred(ExecutorEvent e) {
                            boolean deleted = ExecutorServerImpl.recursiveDeleteImpl(PackdistribPreparator.access$2300(this.this$0));
                            if (deleted) {
                                this.this$0.getExecutor().fireLogEvent("Deleted directory '" + PackdistribPreparator.access$2300(this.this$0) + "'\n");
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ File access$2300(PackdistribPreparator x0) {
            return x0.packDir;
        }
    }

    static class DirtyCleaner
    extends ExecutorLogic {
        File[] paths;

        DirtyCleaner(File[] paths) {
            this.paths = paths;
        }

        void executeLogic() {
            for (int i = 0; i < this.paths.length; ++i) {
                File aPath = this.paths[i];
                boolean deleted = ExecutorServerImpl.recursiveDeleteImpl(aPath);
                String message = deleted ? "Deleted " + aPath + "\n" : "Could not delete " + aPath + "\n";
                this.getExecutor().fireLogEvent(message);
            }
        }
    }

    class ConfigurationReader
    extends DefaultHandler {
        int scriptRefCounter = 0;
        private StringBuffer strings = new StringBuffer();
        private Stack stack = new Stack();
        private UpgradeTestConfiguration utg = null;
        private String scriptName;

        ConfigurationReader() {
        }

        public void characters(char[] c, int start, int length) throws SAXException {
            super.characters(c, start, length);
            this.strings.append(new String(c, start, length));
        }

        private Installable installable(Attributes attributes) {
            Installable i = new Installable();
            i.version = attributes.getValue("version");
            i.lcVersion = attributes.getValue("lcversion");
            i.status = Configuration.getQAStatus(attributes.getValue("state"));
            i.lcqastatus = Configuration.getQAStatus(attributes.getValue("lcstate"));
            return i;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (!this.stack.empty() && "settings".equals(this.stack.peek())) {
                this.startSettings(uri, localName, qName, attributes);
            } else if ("test".equals(qName)) {
                this.utg = new UpgradeTestConfiguration();
            } else if (Configuration.SOURCEROLE.equals(qName) && this.utg != null) {
                this.utg.source = this.installable(attributes);
            } else if (Configuration.TARGETROLE.equals(qName) && this.utg != null) {
                this.utg.target = this.installable(attributes);
            } else if (Configuration.BRICKROLE.equals(qName) && this.utg != null) {
                this.utg.brick = this.installable(attributes);
            } else if ("updateNewSecurityConceptBackup".equals(qName) && this.utg != null) {
                this.utg.newSecurityBackup = true;
            } else if ("updateNewSecurityConcept".equals(qName) && this.utg != null) {
                this.utg.newSecurity = true;
            } else if ("instprofile".equals(qName) && this.utg != null) {
                this.utg.instProfile = attributes.getValue("name");
            } else if ("script".equals(qName)) {
                String scriptRef = attributes.getValue("ref");
                String aName = attributes.getValue("id");
                if (scriptRef != null) {
                    Configuration.this.scriptRefs.put(new ScriptRefKey(aName), scriptRef);
                } else {
                    this.scriptName = aName;
                }
            } else if ("UpgradeSequence".equals(qName)) {
                Configuration.this.upgradeTests.clear();
            }
            this.stack.push(qName);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if ("test".equals(qName)) {
                Configuration.this.upgradeTests.add(this.utg);
                this.utg = null;
            } else if ("script".equals(qName) && this.scriptName != null) {
                Configuration.this.scripts.put(this.scriptName, this.strings.toString());
                this.scriptName = null;
            }
            this.stack.pop();
            this.strings.setLength(0);
        }

        public void startSettings(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("log".equals(qName)) {
                String level = attributes.getValue("level");
                Configuration.this.setLogLevel(level);
                String autocreateString = attributes.getValue("autocreate");
                boolean autocreate = "true".equalsIgnoreCase(autocreateString);
                Configuration.this.setAutoCreate(autocreate);
            } else if ("packdistrib".equals(qName)) {
                String path;
                String path_ux = attributes.getValue("path-ux");
                if (path_ux != null) {
                    Configuration.this.packdistribPathUx = new File(path_ux);
                }
                if ((path = attributes.getValue("path")) != null) {
                    Configuration.this.packdistribPathWin = new File(path);
                }
            } else if ("x_server".equals(qName)) {
                String x_serverPortUx = attributes.getValue("port-ux");
                Configuration.this.x_serverPortUx = x_serverPortUx;
            } else if ("install_user".equals(qName)) {
                Configuration.this.newInstallUser = attributes.getValue("new-user");
                Configuration.this.newInstallGroup = attributes.getValue("new-group");
                Configuration.this.oldInstallUser = attributes.getValue("old-user");
                Configuration.this.oldInstallGroup = attributes.getValue("old-group");
            } else if ("sapcar".equals(qName)) {
                String path = attributes.getValue("path");
                String path_ux = attributes.getValue("path-ux");
                Configuration.this.sapCar = Configuration.isUnix() ? new File(path_ux) : new File(path);
            } else if ("temp_dir".equals(qName)) {
                String path = attributes.getValue("path");
                Configuration.this.directoriesTemp = new File(path);
            } else if ("indep_data_dir".equals(qName)) {
                String path = attributes.getValue("path");
                Configuration.this.setIndepData(new File(path));
            } else if ("indep_prog_dir".equals(qName)) {
                String path = attributes.getValue("path");
                Configuration.this.setIndepProg(new File(path));
            } else if ("depend_prefix".equals(qName)) {
                String path = attributes.getValue("path");
                Configuration.this.dependendPrefixDir = new File(path);
            } else if ("platform".equals(qName)) {
                String platformId = attributes.getValue("id");
                if (platformId != null && !"".equals(platformId)) {
                    Platform plf = Configuration.getPlatform(platformId);
                    if (plf == null) {
                        throw new SAXException("Unknown platform specificied in element \"platform\": " + platformId);
                    }
                    Configuration.this.currentPlatform = plf;
                }
            } else {
                System.err.println("WARNING: Unknown Setting-Element: " + qName);
            }
        }

        public void read(File configurationFile) throws ParserConfigurationException, SAXException, IOException {
            XMLReader reader = this.createReader();
            reader.parse(configurationFile.toURI().toString());
        }

        public void read(InputStream is) throws ParserConfigurationException, SAXException, IOException {
            XMLReader reader = this.createReader();
            reader.parse(new InputSource(is));
        }

        private XMLReader createReader() throws ParserConfigurationException, SAXException {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(this);
            return reader;
        }

        class ScriptRefKey
        implements Comparable {
            Integer counter;
            String val;

            ScriptRefKey(String as) {
                this.val = as;
                this.counter = new Integer(++ConfigurationReader.this.scriptRefCounter);
            }

            public int compareTo(Object other) {
                ScriptRefKey oc = (ScriptRefKey)other;
                return this.counter.compareTo(oc.counter);
            }

            public String toString() {
                return this.val;
            }
        }
    }

    private static class DBVersion {
        public int major = 0;
        public int minor = 0;
        public int correction = 0;
        public int build = 0;
        public QASTATUS qastatus = QAUNKNOWN;
        public QASTATUS lcqastatus = QAUNKNOWN;
        public int lcaVersion = -1;
        public int make = 0;
        public int lcmake = 0;
        public String lcpoolid = "NONE";
        public String lcapoolid = "NONE";
        public String branchinfo = "";
        public String lcavariant = "";
        public Platform platform = null;

        public DBVersion() {
        }

        public DBVersion(int n_major, int n_minor, int n_correction, int n_build, int n_qastatus, int n_lcaVersion, int n_lcqastatus, String n_lcpoolid, String n_lcapoolid, String n_branchinfo, String n_lcavariant) {
            this(n_major, n_minor, n_correction, n_build, n_qastatus, n_lcaVersion, n_lcqastatus);
            this.lcpoolid = n_lcpoolid;
            this.lcapoolid = n_lcapoolid;
            this.branchinfo = n_branchinfo;
            this.lcavariant = n_lcavariant;
        }

        public DBVersion(int n_major, int n_minor, int n_correction, int n_build, int n_qastatus, int n_lcaVersion, int n_lcqastatus) {
            this(n_major, n_minor, n_correction, n_build, n_qastatus, n_lcaVersion);
            this.lcqastatus = Configuration.getQAStatus(n_lcqastatus);
        }

        public DBVersion(int n_major, int n_minor, int n_correction, int n_build, int n_qastatus, int n_lcaVersion) {
            this.major = n_major;
            this.minor = n_minor;
            this.correction = n_correction;
            this.build = n_build;
            this.qastatus = Configuration.getQAStatus(n_qastatus);
            this.lcaVersion = n_lcaVersion;
        }

        public DBVersion(int n_major, int n_minor, int n_correction, int n_build, int n_qastatus) {
            this(n_major, n_minor, n_correction, n_build, n_qastatus, -1);
        }

        public DBVersion(int n_major, int n_minor, int n_correction, int n_build) {
            this(n_major, n_minor, n_correction, n_build, -1, -1);
        }

        public DBVersion(int[] version) {
            if (version.length < 4) {
                throw new ArrayIndexOutOfBoundsException("DBVersion needs at least 4 array values!");
            }
            this.major = version[0];
            this.minor = version[1];
            this.correction = version[2];
            this.build = version[3];
            if (version.length >= 5) {
                this.qastatus = Configuration.getQAStatus(version[4]);
            }
            if (version.length >= 6) {
                this.lcaVersion = version[5];
            }
        }

        public boolean isSmallerThan(DBVersion other) {
            if (other.major != this.major) {
                return this.major < other.major;
            }
            if (other.minor != this.minor) {
                return this.minor < other.minor;
            }
            if (other.correction != this.correction) {
                return this.correction < other.correction;
            }
            if (other.build != this.build) {
                return this.build < other.build;
            }
            return this.qastatus.toInt() > other.qastatus.toInt();
        }

        public boolean updateNeedsNewSecurityConcept(DBVersion other) {
            return this.major == 7 && other.major == 7 && (this.minor < 5 && other.minor >= 5 || this.minor >= 5 && other.minor < 5);
        }

        public void setVersion(int version) {
            this.major = version / 1000;
            this.minor = (version - this.major * 1000) / 100;
            this.correction = version - this.major * 1000 - this.minor * 100;
        }

        public boolean hasLiveCache() {
            return this.lcaVersion > 0;
        }

        public String getCreateDBScript(boolean lcInstall) throws ConfigurationException {
            StringBuffer scriptName = new StringBuffer("scripts/create");
            if (lcInstall) {
                scriptName.append("lc_");
            } else {
                scriptName.append("db_");
            }
            if (this.major == 7) {
                if (this.minor >= 5) {
                    scriptName.append("75.script");
                } else {
                    scriptName.append("74.script");
                }
                return scriptName.toString();
            }
            throw new ConfigurationException("Don't know how to create a database on this version!");
        }

        public String getMajorString() {
            StringBuffer majorString = new StringBuffer();
            majorString.append(this.major);
            majorString.append(this.minor);
            if (this.correction < 10) {
                majorString.append("0");
                majorString.append(this.correction);
            } else {
                majorString.append(this.correction);
            }
            return majorString.toString();
        }

        public String toString() {
            return this.versionString();
        }

        public String toXMLTag() {
            StringBuffer xml = new StringBuffer();
            xml.append("<versionnumber state=\"" + this.qastatus + "\" ");
            xml.append(" lcstate=\"" + this.lcqastatus + "\" ");
            xml.append(" lcversion=\"" + this.lcaVersion + "\" ");
            xml.append('>');
            xml.append(this.major);
            xml.append('.');
            xml.append(this.minor);
            xml.append('.');
            xml.append(this.correction >= 10 ? "" + this.correction : "0" + this.correction);
            if (this.qastatus.equals(RAMP)) {
                xml.append('.');
                xml.append(this.build >= 10 ? "" + this.build : "0" + this.build);
            }
            xml.append("</versionnumber>");
            return xml.toString();
        }

        public String versionString() {
            return this.major + "." + this.minor + "." + (this.correction >= 10 ? "" + this.correction : "0" + this.correction) + (this.qastatus.equals(RAMP) ? "." + (this.build >= 10 ? "" + this.build : "0" + this.build) : "");
        }
    }

    static class UnknownPlatform
    extends Platform {
        UnknownPlatform() {
            this.descText = "unknown platform";
            this.perlText = "";
            this.readText = "unknown platform ";
            this.osName = "unknown platform name ";
            this.osVersion = "unknown platform version ";
            this.distribName = "";
        }

        void init(ResultSet res) throws SQLException {
        }

        public String toString() {
            return "unknown platform";
        }

        public String toCode() {
            return "-1";
        }

        public int toInt() {
            return -1;
        }

        public boolean isLinux() {
            return false;
        }

        public boolean isUnix() {
            return false;
        }

        public boolean isWindows() {
            return false;
        }
    }

    static class Platform {
        String descText = null;
        String perlText = null;
        String readText = null;
        String osName = null;
        String osVersion = null;
        String distribName = null;
        int id = 0;
        int bits = 0;

        Platform() {
        }

        public String distribName() {
            return this.distribName;
        }

        public String distribNameWithoutBits() {
            try {
                return this.distribName.substring(0, this.distribName.length() - 2);
            }
            catch (IndexOutOfBoundsException ex) {
                return this.distribName;
            }
        }

        public String getPlatformFamilyClause() {
            Platform[] family = this.getPlatformFamily();
            StringBuffer b = new StringBuffer("(");
            for (int i = 0; i < family.length - 1; ++i) {
                b.append(family[i].toCode() + ", ");
            }
            b.append(family[family.length - 1].toCode() + ")");
            return b.toString();
        }

        boolean isSamePlatformFamily(Platform other) {
            Platform[] family = this.getPlatformFamily();
            for (int i = 0; i < family.length; ++i) {
                if (!family[i].equals(other)) continue;
                return true;
            }
            return false;
        }

        public Platform[] getPlatformFamily() {
            Platform[] family = null;
            family = LINUX2_6IA64.equals(this) ? new Platform[]{LINUX2_6IA64, LINUXIA64} : (LINUX2_6IA32.equals(this) ? new Platform[]{LINUXINTEL, LINUX2_6IA32} : (RS6000.equals(this) ? new Platform[]{RS6000, RS6000_64, RS6000_52_64, RS6000_51_64} : (RS6000_64.equals(this) ? new Platform[]{RS6000, RS6000_64} : (RS6000_52_64.equals(this) || RS6000_51_64.equals(this) ? new Platform[]{RS6000, RS6000_52_64, RS6000_51_64} : new Platform[]{this}))));
            return family;
        }

        public boolean isLinux() {
            return "linux".equals(this.perlText);
        }

        public boolean isUnix() {
            return !NTX86_64.equals(this) && !NTINTEL.equals(this);
        }

        public boolean isWindows() {
            return !this.isUnix();
        }

        public boolean isLinux32() {
            return this.equals(LINUX2_6IA32) || this.equals(LINUXINTEL);
        }

        public int bits() {
            return this.bits;
        }

        public boolean isBIT32() {
            return 32 == this.bits;
        }

        public boolean isBIT64() {
            return 64 == this.bits;
        }

        public boolean hasRelease73() {
            return !this.equals(NTIA64) && !this.equals(SUN) && !this.equals(LINUXIA64) && !this.equals(HPIA64) && !this.equals(LINUXX86_64) && !this.equals(LINUXS390X) && !this.equals(NTX86_64) && !this.equals(LINUX2_6IA64) && !this.equals(LINUXPPC64);
        }

        int[] relevant73() {
            if (this.hasRelease73()) {
                return RELEVANT73BUILDS;
            }
            return new int[0];
        }

        Platform(String s) {
            StringTokenizer strt = new StringTokenizer(s, ";");
            this.descText = strt.nextToken();
            this.perlText = strt.nextToken();
            this.readText = strt.nextToken();
            this.osName = strt.nextToken();
            this.osVersion = strt.nextToken();
            this.distribName = strt.nextToken();
            this.id = Integer.parseInt(strt.nextToken());
            this.bits = Integer.parseInt(strt.nextToken());
        }

        void init(ResultSet res) throws SQLException {
            this.id = res.getInt(1);
            this.descText = res.getString(2);
            this.perlText = res.getString(3);
            this.readText = res.getString(4);
            this.osName = res.getString(5);
            this.osVersion = res.getString(6);
            this.distribName = res.getString(7);
        }

        public String toString() {
            return this.descText;
        }

        public String toCode() {
            return this.id + "";
        }

        public int toInt() {
            return this.id;
        }

        public String stringRep() {
            return this.descText + ";" + this.perlText + ";" + this.readText + ";" + this.osName + ";" + this.osVersion + ";" + this.distribName + ";" + this.id;
        }
    }

    public static class HOTSTATUS
    extends QASTATUS {
        public String toString() {
            return "HOT";
        }

        public int toInt() {
            return 5;
        }
    }

    public static class NONESTATUS
    extends QASTATUS {
        public String toString() {
            return Configuration.LCPOOL_NONE;
        }

        public int toInt() {
            return 4;
        }
    }

    public static class RAMPSTATUS
    extends QASTATUS {
        public String toString() {
            return "RAMP";
        }

        public int toInt() {
            return 3;
        }
    }

    public static class CORSTATUS
    extends QASTATUS {
        public String toString() {
            return "COR";
        }

        public int toInt() {
            return 2;
        }
    }

    public static class DEVSTATUS
    extends QASTATUS {
        public String toString() {
            return Configuration.LCABRANCHINFO_DEV;
        }

        public int toInt() {
            return 1;
        }
    }

    public static class QASTATUS {
        private QASTATUS() {
        }

        public String toString() {
            return "UNKNOWN";
        }

        public int toInt() {
            return -1;
        }

        public int toCode() {
            return this.toInt();
        }
    }

    static class SoftwareDescription {
        String profile;
        String version;
        String apoversion;
        String lcpool;
        String apolcpool;
        String branchInfo;
        String lcaVariant;
        String build;
        String makeKey;
        String apoMakeKey;
        QASTATUS status;
        QASTATUS apostatus;
        File unpackDir;
        File packdistrib;
        File indepProg;
        File indepData;
        File depPath;
        File tempDir;
        Platform platform;
        SoftwareDescription target;
        Template template;

        SoftwareDescription() {
        }

        SoftwareDescription(DBVersion dbv) {
            this.makeKey = dbv.make + "";
            this.version = dbv.versionString();
            this.lcpool = dbv.lcpoolid;
            this.build = dbv.build + "";
            this.status = dbv.qastatus;
            this.platform = dbv.platform;
            this.apoMakeKey = dbv.lcmake + "";
            this.apoversion = dbv.lcaVersion + "";
            this.apolcpool = dbv.lcapoolid;
            this.lcaVariant = dbv.lcavariant;
            this.apostatus = dbv.lcqastatus;
            this.branchInfo = dbv.branchinfo;
        }

        SoftwareDescription(Installable inst) {
            this(inst.dbVersion);
        }

        SoftwareDescription cloneMe() {
            SoftwareDescription clone = new SoftwareDescription();
            clone.profile = this.profile;
            clone.version = this.version;
            clone.apoversion = this.apoversion;
            clone.lcpool = this.lcpool;
            clone.apolcpool = this.apolcpool;
            clone.branchInfo = this.branchInfo;
            clone.lcaVariant = this.lcaVariant;
            clone.status = this.status;
            clone.apostatus = this.apostatus;
            clone.unpackDir = this.unpackDir;
            clone.packdistrib = this.packdistrib;
            clone.indepProg = this.indepProg;
            clone.indepData = this.indepData;
            clone.depPath = this.depPath;
            clone.platform = this.platform;
            clone.build = this.build;
            clone.tempDir = this.tempDir;
            clone.makeKey = this.makeKey;
            clone.apoMakeKey = this.apoMakeKey;
            clone.template = this.template;
            return clone;
        }

        private String internalGetBuild() {
            String retVal = "";
            if (this.build != null) {
                retVal = this.build;
            } else if (this.version.length() >= 9) {
                retVal = this.version.substring(7, 9);
            }
            return retVal;
        }

        boolean isLowerThan(SoftwareDescription other) {
            boolean isLower = false;
            String qadbVersion = Configuration.getQADBVersion(this.version);
            String build = this.internalGetBuild();
            String otherQadbVersion = Configuration.getQADBVersion(other.version);
            String otherBuild = other.internalGetBuild();
            int comparison = otherQadbVersion.compareTo(qadbVersion);
            isLower = comparison > 0 ? true : (comparison == 0 ? otherBuild.compareTo(build) > 0 : false);
            return isLower;
        }

        SoftwareDescription cloneMyBase() {
            SoftwareDescription clone = new SoftwareDescription();
            clone.packdistrib = this.packdistrib;
            clone.indepProg = this.indepProg;
            clone.indepData = this.indepData;
            clone.platform = this.platform;
            clone.tempDir = this.tempDir;
            return clone;
        }

        boolean isLiveCacheOnly() {
            return this.version != null && this.version.indexOf("7.4.02") >= 0;
        }

        boolean isServerOnly() {
            return this.version != null && this.version.indexOf("7.3.") >= 0;
        }

        boolean isUpgradeEqualPlatform() {
            return this.platform.equals(this.target.platform);
        }

        public String toString() {
            return this.versionString();
        }

        public String versionString() {
            return this.version + (this.status != null && !RAMP.equals(this.status) ? " " + this.status.toString() : "") + (this.apoversion != null ? ", " + this.apoversion.toString() : "") + (this.apoversion != null && this.apostatus != null && !RAMP.equals(this.apostatus) ? " " + this.apostatus.toString() : "");
        }

        public String makeKeys() {
            return "LC " + this.version + (this.makeKey != null ? (this.makeKey != null ? " [" + this.makeKey + ", " + this.lcpool + "]" : "") : "") + (RAMP.equals(this.status) ? "" : " " + this.status) + (this.apoversion != null ? ", APO " + this.apoversion + (this.apoMakeKey != null ? " [" + this.apoMakeKey + ", " + this.apolcpool + "]" : "") : "");
        }

        public String platforms() {
            return this.platform + " --> " + (this.target != null ? this.target.platform + "" : "???");
        }

        public String upgradeStringMakeKeys() {
            return this.makeKeys() + " --> " + (this.target != null ? this.target.makeKeys() : "???");
        }

        public String upgradeString() {
            return this.versionString() + " --> " + (this.target != null ? this.target.versionString() : "???");
        }

        public String getMainVersionInfo() {
            return this.version.substring(0, 1) + this.version.substring(2, 3) + this.version.substring(4, 6);
        }
    }

    class Installable {
        private String version;
        private String lcVersion;
        public Platform pl;
        private QASTATUS status;
        private QASTATUS lcqastatus;
        DBVersion dbVersion;
        String apowidth = "500000";
        String lcwidth = "7.4.00.14";
        String qawidth = "RAMP";

        Installable() {
        }

        Installable(DBVersion v) {
            this.setDBVersion(v);
        }

        void setDBVersion(DBVersion v) {
            this.dbVersion = v;
            this.version = v.versionString();
            this.lcVersion = "" + v.lcaVersion;
            this.status = v.qastatus;
            this.lcqastatus = v.lcqastatus;
        }

        private boolean isValidLCVersion() {
            boolean retVal = false;
            if (this.lcVersion != null && this.lcVersion.length() > 2) {
                retVal = true;
            }
            return retVal;
        }

        int major() {
            return Integer.parseInt(this.version.substring(0, 1));
        }

        int minor() {
            return Integer.parseInt(this.version.substring(2, 3));
        }

        int getMakeId() {
            return this.dbVersion == null ? 0 : this.dbVersion.make;
        }

        int getLCMakeId() {
            return this.dbVersion == null ? 0 : this.dbVersion.lcmake;
        }

        boolean isLiveCacheOnly() {
            return this.version != null && this.version.indexOf("7.4.02") >= 0;
        }

        boolean isServerOnly() {
            return this.version != null && this.version.indexOf("7.3") >= 0;
        }

        public String makeKeys() {
            String makeNumberFormat = "{0,number,000000}";
            String make = MessageFormat.format(makeNumberFormat, new Integer(this.getMakeId()));
            String lcmake = MessageFormat.format(makeNumberFormat, new Integer(this.getLCMakeId()));
            String s = "[" + Configuration.this.fillToWidth(make, this.lcwidth + this.qawidth, true) + "]" + "[" + Configuration.this.fillToWidth(lcmake, this.apowidth + this.qawidth, true) + "]";
            return s;
        }

        public String toString() {
            String width = "          ";
            String alc = Configuration.this.fillToWidth(this.version, this.lcwidth, true);
            String aqa = Configuration.this.fillToWidth(this.status.toString(), this.qawidth, false);
            String lc = alc + aqa;
            String alcapo = Configuration.this.fillToWidth(this.lcVersion, this.apowidth, true);
            String aqaapo = Configuration.this.fillToWidth(this.lcqastatus.toString(), this.qawidth, false);
            String apo = alcapo + aqaapo;
            String s = "[" + lc + "]" + (!this.isValidLCVersion() ? width + "  " : "[" + apo + "]");
            return s;
        }
    }

    class UpgradeTestConfiguration {
        Installable source;
        Installable target;
        Installable brick;
        boolean newSecurity = false;
        boolean newSecurityBackup = false;
        String instProfile;

        UpgradeTestConfiguration() {
        }

        boolean setInstallables(DBVersion currversion, DBVersion autoCreateForVersion) {
            boolean retVal = true;
            if (autoCreateForVersion.isSmallerThan(currversion)) {
                this.source = new Installable(autoCreateForVersion);
                this.target = new Installable(currversion);
            } else {
                this.source = new Installable(currversion);
                this.target = new Installable(autoCreateForVersion);
            }
            if (currversion.updateNeedsNewSecurityConcept(autoCreateForVersion)) {
                this.newSecurity = true;
            }
            if (Configuration.this.OLPTseperatedAPO) {
                this.instProfile = Configuration.this.isOLTPTestSerie ? Configuration.SERVERPROFILE : Configuration.APOPROFILE;
            } else {
                this.instProfile = autoCreateForVersion.hasLiveCache() && currversion.hasLiveCache() ? Configuration.APOPROFILE : Configuration.SERVERPROFILE;
                if (this.instProfile.equals(Configuration.SERVERPROFILE) && (this.source.isLiveCacheOnly() || this.target.isLiveCacheOnly())) {
                    retVal = false;
                }
                if (this.instProfile.equals(Configuration.APOPROFILE)) {
                    if (this.source.isServerOnly() || this.target.isServerOnly()) {
                        retVal = false;
                    }
                    if (this.source.lcVersion.compareTo(this.target.lcVersion) > 0) {
                        retVal = false;
                    }
                }
            }
            return retVal;
        }

        private Installable getInstallable(String role) {
            Installable i = null;
            if (Configuration.SOURCEROLE.equals(role)) {
                i = this.source;
            } else if (Configuration.TARGETROLE.equals(role)) {
                i = this.target;
            } else if (Configuration.BRICKROLE.equals(role)) {
                i = this.brick;
            }
            return i;
        }

        String getVersion(String role) {
            return this.getInstallable(role).version;
        }

        String getSourceVersion() {
            return this.getVersion(Configuration.SOURCEROLE);
        }

        String getTargetVersion() {
            return this.getVersion(Configuration.TARGETROLE);
        }

        String getLCVersion(String role) {
            return this.getInstallable(role).lcVersion;
        }

        String getSourceLCVersion() {
            return this.getInstallable(Configuration.SOURCEROLE).lcVersion;
        }

        String getTargetLCVersion() {
            return this.getInstallable(Configuration.TARGETROLE).lcVersion;
        }

        QASTATUS getQAStatus(String role) {
            return this.getInstallable(role).status;
        }

        QASTATUS getSourceQAStatus() {
            return this.getInstallable(Configuration.SOURCEROLE).status;
        }

        QASTATUS getTargetQAStatus() {
            return this.getInstallable(Configuration.TARGETROLE).status;
        }

        QASTATUS getLCQAStatus(String role) {
            return this.getInstallable(role).lcqastatus;
        }

        QASTATUS getSourceLCQAStatus() {
            return this.getInstallable(Configuration.SOURCEROLE).lcqastatus;
        }

        QASTATUS getTargetLCQAStatus() {
            return this.getInstallable(Configuration.TARGETROLE).lcqastatus;
        }

        public String toString() {
            String profileString = Configuration.APOPROFILE.equals(this.instProfile) ? "APO" : "LC";
            String apro = Configuration.this.fillToWidth(profileString, "APO", true);
            String ts = this.target.toString();
            String ss = this.source.toString();
            return apro + ss + "--->" + ts;
        }

        private boolean updateNeedsBackup() {
            int sourceMajor = this.source.major();
            int targetMajor = this.target.major();
            int sourceMinor = this.source.minor();
            int targetMinor = this.target.minor();
            boolean retVal = false;
            if (sourceMajor == 7 && targetMajor == 7 && (sourceMinor <= 3 && targetMinor > 3 || sourceMinor > 3 && targetMinor <= 3)) {
                retVal = true;
            }
            return retVal;
        }

        public String getScript(String purpose, String subPurpose) throws ConfigurationException {
            boolean lcInstall = Configuration.APOPROFILE.equals(this.instProfile);
            String scriptName = null;
            if (Configuration.PREPUPDATETASK.equals(purpose)) {
                scriptName = this.updateNeedsBackup() ? "backup" : (lcInstall ? "fake_lcbackup" : "nothing");
            } else if (Configuration.CREATEDBTASK.equals(purpose)) {
                scriptName = Configuration.this.dbCreateScriptNameForVersion(this.source.version, this.instProfile, subPurpose);
            } else if (Configuration.PREPUNINSTTASK.equals(purpose)) {
                scriptName = Configuration.this.dbDropscript(this.target.version);
            } else {
                throw new ConfigurationException("Unknown script task: " + purpose);
            }
            return Configuration.this.getScript(scriptName);
        }

        String getLCPoolId(String role) {
            if (this.getInstallable((String)role).dbVersion == null) {
                return null;
            }
            return this.getInstallable((String)role).dbVersion.lcpoolid;
        }

        String getSourceLCPoolId() {
            return this.getLCPoolId(Configuration.SOURCEROLE);
        }

        String getTargetLCPoolId() {
            return this.getLCPoolId(Configuration.TARGETROLE);
        }

        String getLCAPoolId(String role) {
            if (this.getInstallable((String)role).dbVersion == null) {
                return null;
            }
            return this.getInstallable((String)role).dbVersion.lcapoolid;
        }

        String getSourceLCAPoolId() {
            return this.getLCAPoolId(Configuration.SOURCEROLE);
        }

        String getTargetLCAPoolId() {
            return this.getLCAPoolId(Configuration.TARGETROLE);
        }

        String getBranchInfo(String role) {
            if (this.getInstallable((String)role).dbVersion == null) {
                return null;
            }
            return this.getInstallable((String)role).dbVersion.branchinfo;
        }

        String getSourceBranchInfo() {
            return this.getBranchInfo(Configuration.SOURCEROLE);
        }

        String getTargetBranchInfo() {
            return this.getBranchInfo(Configuration.TARGETROLE);
        }

        String getLCAVariant(String role) {
            if (this.getInstallable((String)role).dbVersion == null) {
                return null;
            }
            return this.getInstallable((String)role).dbVersion.lcavariant;
        }

        String getSourceVariant() {
            return this.getLCAVariant(Configuration.SOURCEROLE);
        }

        String getTargetVariant() {
            return this.getLCAVariant(Configuration.TARGETROLE);
        }

        public Platform getPlatform(String role) {
            if (this.getInstallable((String)role).dbVersion == null) {
                return null;
            }
            return this.getInstallable((String)role).dbVersion.platform;
        }
    }

    static class SAPSBSTemplate
    extends Template {
        SAPSBSTemplate() {
        }

        public String toString() {
            return "sapsbs";
        }

        boolean canSloppy() {
            return true;
        }
    }

    static class SAPMCTemplate
    extends Template {
        SAPMCTemplate() {
        }

        public String toString() {
            return "sapmc";
        }

        boolean canSloppy() {
            return true;
        }
    }

    static class SAPDWTemplate
    extends Template {
        SAPDWTemplate() {
        }

        public String toString() {
            return "sapdw";
        }
    }

    static class CustomTemplate
    extends Template {
        CustomTemplate() {
        }

        public String toString() {
            return "custom";
        }
    }

    static class DesktopTemplate
    extends Template {
        DesktopTemplate() {
        }

        public String toString() {
            return "desktop";
        }
    }

    static class Template {
        Template() {
        }

        boolean canSloppy() {
            return false;
        }

        boolean supportsVersion(String version) {
            return "7.6".compareTo(version) <= 0;
        }
    }
}

