/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;

public abstract class CmdlineTool
implements Serializable {
    static final long serialVersionUID = 4849328405119533441L;
    private transient Process process;
    private transient Thread stdoutThread;
    private transient Thread stderrThread;
    private transient OutputReader stdoutReader;
    private transient OutputReader stderrReader;
    private volatile int exitValue;
    private String[] callString;
    private String[] env;
    private long timeout = 60000L;
    private long timer;
    private volatile boolean processExited = false;
    private static final int MAXREADBYTES = 51200;

    long getTimeout() {
        return this.timeout;
    }

    void setTimeout(long al) {
        this.timeout = al;
    }

    void resetTimer() {
        this.timer = System.currentTimeMillis();
    }

    boolean hasTimeout() {
        return System.currentTimeMillis() - this.timer > this.timeout;
    }

    void timeCheck() throws TimeoutException {
        if (this.hasTimeout()) {
            throw new TimeoutException();
        }
    }

    Process getProcess() {
        return this.process;
    }

    boolean processExited() {
        return this.processExited;
    }

    String[] callString() {
        return this.callString;
    }

    void setCallString(String[] cs) {
        this.callString = cs;
    }

    int getMaxReadBytes() {
        return 51200;
    }

    String getStdOut() {
        return this.stdoutReader.getString();
    }

    void clearStdOut() {
        this.stdoutReader.clear();
    }

    void initProcess() throws IOException {
        this.process = Runtime.getRuntime().exec(this.callString, this.env);
        this.stdoutReader = new OutputReader(this.process.getInputStream());
        this.stdoutThread = new Thread(this.stdoutReader);
        this.stdoutThread.start();
        this.stderrReader = new OutputReader(this.process.getErrorStream());
        this.stderrThread = new Thread(this.stderrReader);
        this.stderrThread.start();
        Thread observerThread = new Thread(new Runnable(){

            public void run() {
                try {
                    CmdlineTool.this.process.waitFor();
                    int aexitValue = CmdlineTool.this.process.exitValue();
                    CmdlineTool.this.processExited = true;
                    CmdlineTool.this.exitValue = aexitValue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        observerThread.start();
    }

    void destroy() {
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.stdoutThread != null) {
            this.stdoutThread.interrupt();
        }
        if (this.stderrThread != null) {
            this.stderrThread.interrupt();
        }
    }

    CmdlineTool(File f) throws IOException {
        this.callString = new String[]{f.getCanonicalPath()};
        this.initProcess();
    }

    CmdlineTool(File f, long al) throws IOException {
        this.callString = new String[]{f.getCanonicalPath()};
        this.setTimeout(al);
        this.initProcess();
    }

    CmdlineTool(String[] aCallString) throws IOException {
        this.callString = aCallString;
        this.initProcess();
    }

    CmdlineTool(String[] aCallString, long at) throws IOException {
        this.callString = aCallString;
        this.setTimeout(at);
        this.initProcess();
    }

    CmdlineTool(String[] aCallString, String[] aenv) throws IOException {
        this.callString = aCallString;
        this.env = aenv;
        this.initProcess();
    }

    CmdlineTool(String[] aCallString, String[] aenv, long timeout) throws IOException {
        this.callString = aCallString;
        this.setTimeout(timeout);
        this.env = aenv;
        this.initProcess();
    }

    void writeStdout(byte[] b) throws IOException {
        OutputStream os = this.process.getOutputStream();
        os.write(b);
        os.flush();
    }

    abstract String cmd(byte[] var1) throws IOException;

    abstract void call(String var1) throws IOException;

    String[] cmdl(String cmd) throws IOException {
        String line;
        String lineString = this.cmd(cmd);
        LineNumberReader lir = new LineNumberReader(new StringReader(lineString));
        ArrayList<String> lineList = new ArrayList<String>();
        while ((line = lir.readLine()) != null) {
            lineList.add(line);
        }
        String[] lines = CmdlineTool.arrayListToStringArray(lineList);
        return lines;
    }

    void call(String[] cmd) throws IOException {
        for (int i = 0; i < cmd.length; ++i) {
            this.call(cmd[i]);
        }
    }

    static String[] arrayListToStringArray(ArrayList al) {
        String[] sa = al.toArray(new String[0]);
        return sa;
    }

    static String arrayListToString(ArrayList al) {
        String[] sa = CmdlineTool.arrayListToStringArray(al);
        String res = "";
        for (int i = 0; i < sa.length; ++i) {
            res = res + sa[i] + "\n";
        }
        return res;
    }

    String cmd(String cmd) throws IOException {
        return this.cmd(new String(cmd + "\n").getBytes());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    class OutputReader
    implements Runnable {
        transient boolean go = true;
        private InputStream is;
        private ByteArrayOutputStream bos = new ByteArrayOutputStream();
        private byte[] b = new byte[CmdlineTool.this.getMaxReadBytes()];

        public OutputReader(InputStream is) {
            this.is = is;
        }

        public void run() {
            while (this.go) {
                try {
                    int size = this.is.read(this.b);
                    if (size < 0) break;
                    this.write(this.b, size);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    break;
                }
            }
        }

        synchronized void write(byte[] bs, int size) {
            this.bos.write(bs, 0, size);
        }

        synchronized byte[] getBytes() {
            byte[] b = this.bos.toByteArray();
            return b;
        }

        synchronized void clear() {
            this.bos = new ByteArrayOutputStream();
        }

        String getString() {
            return new String(this.getBytes());
        }
    }

    class TimeoutException
    extends IOException {
        TimeoutException() {
            super("Timeout occured after " + CmdlineTool.this.getTimeout() + " milliseconds");
        }
    }
}

