/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.ListDescriptor;
import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.lctest.SQLTableDescriptor;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.sql.SQLException;

public abstract class LiveCacheMaster
extends TestCase
implements LiveCacheConstants {
    protected static boolean mTraceOn = false;
    protected static int mTraceLoops = 500;
    protected static int mRandomSeed;
    protected ListDescriptor[] mLists;
    protected ListDescriptor[] mLists_Fallback;
    protected SQLTableDescriptor[] mTables;
    protected SQLTableDescriptor[] mTables_Fallback;
    public static int mNumberOfTables;
    public static int mTableCount;

    public final synchronized ListDescriptor createList(int pIndex) {
        if (this.mLists[pIndex].isValid() || this.mLists[pIndex].isInProgress()) {
            return null;
        }
        ListDescriptor Result = (ListDescriptor)this.mLists[pIndex].clone();
        this.mLists[pIndex].setInProgress(true);
        return Result;
    }

    public final synchronized SQLTableDescriptor createTable(int pIndex) {
        if (this.mTables[pIndex].isValid() || this.mTables[pIndex].isInProgress()) {
            return null;
        }
        SQLTableDescriptor Result = (SQLTableDescriptor)this.mTables[pIndex].clone();
        this.mTables[pIndex].setInProgress(true);
        Result.setTableName("SQLTab" + pIndex);
        return Result;
    }

    public final synchronized ListDescriptor getList(int pIndex) {
        if (!this.mLists[pIndex].isValid() || this.mLists[pIndex].isInProgress()) {
            return null;
        }
        ListDescriptor Res = (ListDescriptor)this.mLists[pIndex].clone();
        return Res;
    }

    public final synchronized ListDescriptor getFallbackList(int pIndex) {
        if (!this.mLists_Fallback[pIndex].isValid() || this.mLists_Fallback[pIndex].isInProgress()) {
            return null;
        }
        ListDescriptor Res = (ListDescriptor)this.mLists_Fallback[pIndex].clone();
        return Res;
    }

    public final synchronized SQLTableDescriptor getTable(int pIndex) {
        if (!this.mTables[pIndex].isValid() || this.mTables[pIndex].isInProgress()) {
            return null;
        }
        SQLTableDescriptor Res = (SQLTableDescriptor)this.mTables[pIndex].clone();
        return Res;
    }

    public final synchronized SQLTableDescriptor getFallbackTable(int pIndex) {
        if (!this.mTables_Fallback[pIndex].isValid() || this.mTables_Fallback[pIndex].isInProgress()) {
            return null;
        }
        SQLTableDescriptor Res = (SQLTableDescriptor)this.mTables_Fallback[pIndex].clone();
        return Res;
    }

    public final Boolean getSyncObject(int pIndex) {
        return this.mLists[pIndex].getSyncObject();
    }

    public final Boolean getTabSyncObject(int pIndex) {
        return this.mTables[pIndex].getTabSyncObject();
    }

    public final boolean isTabLocked(int pIndex) {
        return this.mTables[pIndex].isLocked();
    }

    public final boolean isListLocked(int pIndex) {
        return this.mLists[pIndex].isLocked();
    }

    public boolean isTraceOn() {
        return mTraceOn;
    }

    public final synchronized int nextTableCount() {
        return ++mTableCount;
    }

    protected static void printInfo(String pComponent, String pInfoText) {
        System.out.println(pComponent + " --> " + pInfoText);
        LiveCacheMaster.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
    }

    protected static void printError(String pComponent, String pErrorText) {
        System.out.println(pComponent + " --> " + pErrorText);
        LiveCacheMaster.addGlobalMessage((String)pComponent, (char)'E', (String)pErrorText);
    }

    void printListInfos() {
        for (int i = 0; i < this.mLists.length; ++i) {
            LiveCacheMaster.printInfo("List " + i, this.mLists[i].toString());
        }
    }

    void printTableInfos() {
        for (int i = 0; i < this.mTables.length; ++i) {
            if (this.mTables[i].isValid()) {
                LiveCacheMaster.printInfo("SQLTab" + i, this.mTables[i].toString());
                continue;
            }
            LiveCacheMaster.printInfo("SQLTab" + i, " was dropped!");
        }
    }

    static void printTrace(String TraceMessage) {
        if (mTraceOn) {
            System.out.println(TraceMessage);
        }
    }

    public final synchronized void setList(int pIndex, ListDescriptor pList) {
        this.mLists[pIndex] = (ListDescriptor)pList.clone();
    }

    public final synchronized void setTable(int pIndex, SQLTableDescriptor pTable) {
        this.mTables[pIndex] = (SQLTableDescriptor)pTable.clone();
    }

    public final void setListInProgress(int pIndex, boolean pValue) {
        this.mLists[pIndex].setInProgress(pValue);
    }

    public final void setTabInProgress(int pIndex, boolean pValue) {
        this.mTables[pIndex].setInProgress(pValue);
    }

    public final void setListLocked(int pIndex, boolean pValue) {
        this.mLists[pIndex].setLocked(pValue);
    }

    public final void setTabLocked(int pIndex, boolean pValue) {
        this.mTables[pIndex].setLocked(pValue);
    }

    public static void setTrace(boolean EnableTrace) {
        mTraceOn = EnableTrace;
    }

    static {
        mTableCount = 0;
    }
}

