/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.unlocktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestUnlock005
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestUnlock005.createWebDAVSchema();
        TestUnlock005.addGlobalMessage((String)("prepare test " + TestUnlock005.getTestClassId()), (char)'I', (String)"UNLOCK a resource using a wrong locktoken with a length > 50 chars");
        host = new String(TestUnlock005.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestUnlock005.getPort();
        baseUrl = TestUnlock005.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestUnlock005.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestUnlock005.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestUnlock005.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestUnlock005.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestUnlock005.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestUnlock005.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestUnlock005.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestUnlock005.addGlobalMessage((String)"1. DELETE resource /TestUnlock005.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestUnlock005.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestUnlock005.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (!TestUnlock005.doPut(resource, content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt", contentType = "text/plain", locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        TestUnlock005.doLock(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        locktoken = TestUnlock005.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        try {
            String wrong_locktoken;
            String locktoken_long = wrong_locktoken = "saplocktoken:1a2b3c4d5e6f7g8h9i0jh36dfhsdjejrhjt64t3g";
            while ((locktoken_long = String.valueOf(locktoken_long) + wrong_locktoken.substring(locktoken.indexOf(":") + 1, wrong_locktoken.length())).length() <= 100) {
            }
            resource.UNLOCK(null, locktoken_long);
            if (TestUnlock005.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("F")) {
                if (resource.getStatus().getStatusCode() != 400) {
                    TestUnlock005.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock005.txt with a wrong locktoken with more than 50 chars", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                    TestUnlock005.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock005.txt with a wrong locktoken with more than 50 chars", (char)'I', (String)"Test failed due to some WebDAV feature!");
                    return;
                }
            } else if (resource.getStatus().getStatusCode() != 423) {
                TestUnlock005.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock005.txt with a wrong locktoken with more than 50 chars", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestUnlock005.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock005.txt with a wrong locktoken with more than 50 chars", (char)'I', (String)"Test failed due to some WebDAV feature!");
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (TestUnlock005.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("F")) {
                if (exc.getStatusCode() == 400) {
                    TestUnlock005.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock005.txt with a wrong locktoken with more than 50 chars", (char)'I', (String)("Test was successful! Status: " + exc.getStatusCode() + " " + exc.getLocalizedMessage()));
                }
                TestUnlock005.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock005.txt with a wrong locktoken with more than 50 chars", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestUnlock005.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock005.txt with a wrong locktoken with more than 50 chars", (char)'I', (String)"Test failed due to some WebDAV feature.");
                return;
            }
            if (exc.getStatusCode() == 423) {
                TestUnlock005.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock005.txt with a wrong locktoken with more than 50 chars", (char)'I', (String)("Test was successful! Status: " + exc.getStatusCode() + " " + exc.getLocalizedMessage()));
            }
            TestUnlock005.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock005.txt with a wrong locktoken with more than 50 chars", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestUnlock005.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock005.txt with a wrong locktoken with more than 50 chars", (char)'I', (String)"Test failed due to some WebDAV feature.");
            return;
        }
        catch (Exception exc) {
            TestUnlock005.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock005.txt with a wrong locktoken with more than 50 chars", (char)'E', (String)("Java exception: " + exc.getLocalizedMessage()));
            TestUnlock005.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock005.txt with a wrong locktoken with more than 50 chars", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
        if (TestUnlock005.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr) != null) {
            if (!TestUnlock005.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr).equalsIgnoreCase(locktoken)) {
                TestUnlock005.addGlobalMessage((String)"5. verify that the resource was not unlocked", (char)'E', (String)"Locktoken has been changed. Test failed due to some WebDAV feature.");
                return;
            }
        } else {
            TestUnlock005.addGlobalMessage((String)"5. verify that the resource was not unlocked", (char)'E', (String)"Locktoken could not be received. Resource might have been unlocked. Test failed!");
            return;
        }
        TestUnlock005.addGlobalMessage((String)"5. verify that the resource was not unlocked", (char)'I', (String)"Resource is still locked. Test was successful.");
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestUnlock005.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestUnlock005.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

