/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestPut011
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut011.createWebDAVSchema();
        TestPut011.addGlobalMessage((String)("prepare test " + TestPut011.getTestClassId()), (char)'I', (String)"*************************************************************************************\n* Put a resource with more than 8000 chars (posted content equals received content) *\n*************************************************************************************");
        host = new String(TestPut011.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut011.getPort();
        baseUrl = TestPut011.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestPut011.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut011.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut011.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut011.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut011.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = new String("/TestPut011.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut011.addGlobalMessage((String)"1. DELETE the resource /TestPut011.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPut011.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        content = "Put a resource with more than 8000 chars (posted content equals received content)";
        while (content.length() < 8500) {
            content = String.valueOf(content) + content;
        }
        contentType = "text/plain";
        contentLength = content.length();
        try {
            resource.PUT(content, contentType, locktoken);
            TestPut011.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test was successful!");
        }
        catch (WDVTestJ_WdvException exc) {
            TestPut011.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestPut011.addGlobalMessage((String)"PUT failed due to some WebDAV feature", (char)'I', (String)"Expected result: 201 Created");
            return;
        }
        catch (Exception exc) {
            TestPut011.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("  Java exception: " + exc));
            TestPut011.addGlobalMessage((String)"PUT failed due to some Java feature", (char)'I', (String)("Skipping test " + TestPut011.getTestClassId()));
            return;
        }
        TestPut011.compareContent(resource, content, contentType, contentLength, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestPut011.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut011.addGlobalMessage((String)"4. DELETE the resource /TestPut011.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPut011.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

