/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestPut009
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut009.createWebDAVSchema();
        TestPut009.addGlobalMessage((String)("prepare test " + TestPut009.getTestClassId()), (char)'I', (String)"overwrite 'content-type' on an existing resource and evaluate the result");
        host = new String(TestPut009.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut009.getPort();
        baseUrl = TestPut009.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestPut009.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut009.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut009.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut009.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut009.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = "/TestPut009.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut009.addGlobalMessage((String)"1. DELETE the resource /TestPut009.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestPut009.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }

    public void run() {
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestPut009.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            return;
        }
        contentType = "text/html";
        TestPut009.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        String contentTypeR = TestPut009.doPropfindByTagName(resource, "getcontenttype", String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        if (contentType.equalsIgnoreCase(contentTypeR)) {
            TestPut009.addGlobalMessage((String)"4. check if the content type was overwritten correctly", (char)'I', (String)"test was successfull");
        } else {
            TestPut009.addGlobalMessage((String)"4. check if the content type was overwritten correctly", (char)'E', (String)"test was not successfull");
            TestPut009.addGlobalMessage((String)"4. check if the content type was overwritten correctly", (char)'I', (String)("posted: " + contentType + ", received: " + contentTypeR));
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = "/TestPut009.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut009.addGlobalMessage((String)"5. clean up and DELETE the resource /TestPut009.txt at baseUrl", (char)'E', (String)"clean up failed due to some Java feature.");
        }
        TestPut009.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

