/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestPut003
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut003.createWebDAVSchema();
        TestPut003.addGlobalMessage((String)("prepare test " + TestPut003.getTestClassId()), (char)'I', (String)"put on a not existing resource in a not existing folder");
        host = new String(TestPut003.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut003.getPort();
        baseUrl = TestPut003.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPut003.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPut003.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut003.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut003.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut003.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut003.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = "/TestPut003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut003.addGlobalMessage((String)"1. DELETE the resource /TestPut003 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestPut003.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }

    public void run() {
        urlStr = "/TestPut003/TestPut003.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut003.addGlobalMessage((String)"2. try to PUT the resource /TestPut003/TestPut003.txt to baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
            contentType = "text/plain";
            contentLength = content.length();
            locktoken = null;
            resource.PUT(content, contentType, locktoken);
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() != 409) {
                TestPut003.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + "/TestPut003/TestPut003.txt"), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "    Expected result: 409 Conflict"));
                TestPut003.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + "/TestPut003/TestPut003.txt"), (char)'I', (String)"Test failed due to some WebDAV feature.");
                return;
            }
            TestPut003.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + "/TestPut003/TestPut003.txt"), (char)'I', (String)"Test succesful.");
        }
        catch (Exception exc) {
            TestPut003.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + "/TestPut003/TestPut003.txt"), (char)'E', (String)("Java exception: " + exc));
            TestPut003.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + "/TestPut003/TestPut003.txt"), (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestPut003.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

