/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class TestProppatch012
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node blubber_node = null;

    public static void prepare() throws TestCaseException {
        TestProppatch012.createWebDAVSchema();
        TestProppatch012.addGlobalMessage((String)("prepare test " + TestProppatch012.getTestClassId()), (char)'I', (String)"patch the dead property 'blubber' with a sequence of 'set' and 'remove'");
        host = new String(TestProppatch012.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch012.getPort();
        baseUrl = TestProppatch012.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestProppatch012.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestProppatch012.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch012.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch012.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch012.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch012.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch012.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch012.addGlobalMessage((String)"1. DELETE the resource /TestProppatch012.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch012.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestProppatch012.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String contentType_new = "image/jpeg";
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        body = String.valueOf(body) + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        body = String.valueOf(body) + "\nxmlns:Z=\"http://www.some.place.com\">";
        body = String.valueOf(body) + "\n<D:set>";
        body = String.valueOf(body) + "\n<D:prop>";
        body = String.valueOf(body) + "\n<Z:blubber>text/plain</Z:blubber>";
        body = String.valueOf(body) + "\n</D:prop>";
        body = String.valueOf(body) + "\n</D:set>";
        body = String.valueOf(body) + "\n<D:remove>";
        body = String.valueOf(body) + "\n<D:prop>";
        body = String.valueOf(body) + "\n<Z:blubber/>";
        body = String.valueOf(body) + "\n</D:prop>";
        body = String.valueOf(body) + "\n</D:remove>";
        body = String.valueOf(body) + "\n<D:set>";
        body = String.valueOf(body) + "\n<D:prop>";
        body = String.valueOf(body) + "\n<Z:blubber>text/html</Z:blubber>";
        body = String.valueOf(body) + "\n</D:prop>";
        body = String.valueOf(body) + "\n</D:set>";
        body = String.valueOf(body) + "\n<D:remove>";
        body = String.valueOf(body) + "\n<D:prop>";
        body = String.valueOf(body) + "\n<Z:blubber/>";
        body = String.valueOf(body) + "\n</D:prop>";
        body = String.valueOf(body) + "\n</D:remove>";
        body = String.valueOf(body) + "\n<D:set>";
        body = String.valueOf(body) + "\n<D:prop>";
        body = String.valueOf(body) + "\n<Z:blubber>" + contentType_new + "</Z:blubber>";
        body = String.valueOf(body) + "\n</D:prop>";
        body = String.valueOf(body) + "\n</D:set>";
        body = String.valueOf(body) + "\n</D:propertyupdate>";
        try {
            xmlDocument = resource.PROPPATCH(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestProppatch012.addGlobalMessage((String)"PROPPATCH 'blubber'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch012.addGlobalMessage((String)"PROPPATCH 'blubber'", (char)'I', (String)"test failed due to some WebDAV feature");
        }
        catch (SAXParseException exc) {
            TestProppatch012.addGlobalMessage((String)"PROPPATCH 'blubber'", (char)'E', (String)("parser says: " + exc.getMessage()));
            TestProppatch012.addGlobalMessage((String)"PROPPATCH 'blubber'", (char)'I', (String)("request body: " + body));
        }
        catch (Exception exc) {
            TestProppatch012.addGlobalMessage((String)"PROPPATCH 'blubber'", (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch012.addGlobalMessage((String)"PROPPATCH 'blubber'", (char)'I', (String)"Test failed due to some Java feature");
        }
        if (resource.getStatus().getStatusCode() == 207) {
            try {
                NodeList nl = xmlDocument.getElementsByTagName("blubber");
                blubber_node = nl.item(0);
            }
            catch (NullPointerException exc) {
                TestProppatch012.addGlobalMessage((String)"5. check if the property status of 'blubber' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"the 'blubber'-element for the resource could not be retrieved");
            }
            if (xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue().equalsIgnoreCase("HTTP/1.1 200 OK")) {
                TestProppatch012.addGlobalMessage((String)"5. check if the property status of 'blubber' is \"HTTP/1.1 200 OK\"", (char)'I', (String)"successful");
            } else {
                TestProppatch012.addGlobalMessage((String)"5. check if the property status of 'blubber' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"test failed due to some WebDAV features");
            }
            String contentTypeR = TestProppatch012.doPropfindByTagName(resource, "http://www.some.place.com", "blubber", String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            if (contentType_new.equalsIgnoreCase(contentTypeR)) {
                TestProppatch012.addGlobalMessage((String)"6. check if the content type was overwritten correctly", (char)'I', (String)"test was successfull");
            } else {
                TestProppatch012.addGlobalMessage((String)"6. check if the content type was overwritten correctly", (char)'E', (String)"test was not successfull");
                TestProppatch012.addGlobalMessage((String)"6. check if the content type was overwritten correctly", (char)'I', (String)("posted: " + contentType_new + ", received: " + contentTypeR));
            }
        } else {
            TestProppatch012.addGlobalMessage((String)"PROPPATCH 'blubber'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch012.addGlobalMessage((String)"PROPPATCH 'blubber'", (char)'I', (String)"expected result: 207 Multi-Status");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch012.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch012.addGlobalMessage((String)"7. clean up and DELETE the resource /TestProppatch012.txt at baseUrl", (char)'E', (String)"clean up failed due to some Java feature.");
        }
        TestProppatch012.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

