/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestLock024
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    Document xmlDocument = null;

    public static void prepare() throws TestCaseException {
        TestLock024.createWebDAVSchema();
        TestLock024.addGlobalMessage((String)("prepare test " + TestLock024.getTestClassId()), (char)'I', (String)"******************************************************************************************\n* create a null resource and check, whether it has only one display name (do a PROPFIND) *\n******************************************************************************************");
        host = new String(TestLock024.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock024.getPort();
        baseUrl = TestLock024.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock024.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock024.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock024.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock024.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock024.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock024.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock024.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock024.addGlobalMessage((String)"1. DELETE resource /TestLock024.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && !TestLock024.doDelete(resource, locktoken = TestLock024.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr), String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        if (!TestLock024.doLock(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?> \n<D:propfind xmlns:D=\"DAV:\"> \n<D:allprop/> \n</D:propfind> \n";
        try {
            this.xmlDocument = resource.PROPFIND(body);
        }
        catch (WDVTestJ_WdvException exc) {
            this.handleExceptions(exc);
        }
        catch (SAXException exc) {
            this.handleExceptions(exc);
        }
        catch (Exception exc) {
            this.handleExceptions(exc);
        }
        NodeList displayname_nl = this.xmlDocument.getElementsByTagName("D:displayname");
        if (displayname_nl == null || displayname_nl.getLength() == 0) {
            displayname_nl = this.xmlDocument.getElementsByTagName("s1:displayname");
        }
        if (displayname_nl == null || displayname_nl.getLength() == 0) {
            return;
        }
        int length = 0;
        length = displayname_nl.getLength();
        if (length > 1) {
            String allNames = "'" + displayname_nl.item(0).getFirstChild().getNodeValue() + "'\n";
            int i = 1;
            while (i < length) {
                allNames = String.valueOf(allNames) + "'" + displayname_nl.item(i).getFirstChild().getNodeValue() + "'\n";
                ++i;
            }
            TestLock024.addGlobalMessage((String)"3. perform a PROPFIND to assure, whether there is only one display name for this resource", (char)'E', (String)("there are " + length + " displayname nodes in the response body: \n" + allNames + "Only ONE was expected...test failed."));
            return;
        }
        length = displayname_nl.getLength();
        if (length < 1) {
            TestLock024.addGlobalMessage((String)"3. perform a PROPFIND to assure, whether there is only one display name for this resource", (char)'E', (String)"no displayname node could be found...test failed.");
            return;
        }
        length = displayname_nl.getLength();
        if (length == 1) {
            if (displayname_nl.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("TestLock024.txt")) {
                TestLock024.addGlobalMessage((String)"3. perform a PROPFIND to assure, whether there is only one display name for this resource", (char)'I', (String)"As expected there was found only ONE displayname node for this null resource...test was successful!");
            } else {
                TestLock024.addGlobalMessage((String)"3. perform a PROPFIND to assure, whether there is only one display name for this resource", (char)'E', (String)("As expected there was found only ONE displayname node for this null resource, but the value is not correct:\nexpected: 'TestLock024.txt'\nreceived: '" + displayname_nl.item(0).getFirstChild().getNodeValue() + "'"));
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestLock024.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock024.doUnlock(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

