/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestLock005
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;

    public static void prepare() throws TestCaseException {
        TestLock005.createWebDAVSchema();
        TestLock005.addGlobalMessage((String)("prepare test " + TestLock005.getTestClassId()), (char)'I', (String)"lock a resource using a request body WITH namespaces and check whether the LOCK-owner is stored correctly.");
        host = new String(TestLock005.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock005.getPort();
        baseUrl = TestLock005.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock005.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock005.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock005.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock005.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock005.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock005.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock005.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock005.addGlobalMessage((String)"1. DELETE resource /TestLock005.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
            return;
        }
        if (resource.exists()) {
            locktoken = TestLock005.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock005.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        TestLock005.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        String lockOwner = "D041249";
        String lockOwnerR = null;
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = String.valueOf(body) + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = String.valueOf(body) + "<D:locktype>\n";
        body = String.valueOf(body) + "<D:write/>\n";
        body = String.valueOf(body) + "</D:locktype>\n";
        body = String.valueOf(body) + "<D:lockscope>\n";
        body = String.valueOf(body) + "<D:exclusive/>\n";
        body = String.valueOf(body) + "</D:lockscope>\n";
        body = String.valueOf(body) + "<D:owner>" + lockOwner + "</D:owner>\n";
        body = String.valueOf(body) + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock005.addGlobalMessage((String)"3. LOCK the resource /TestLock005.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock005.addGlobalMessage((String)"3. LOCK the resource /TestLock005.txt", (char)'I', (String)"Test failed due to some WebDAV feature.");
            return;
        }
        catch (Exception exc) {
            TestLock005.addGlobalMessage((String)"3. LOCK the resource /TestLock005.txt", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock005.addGlobalMessage((String)"3. LOCK the resource /TestLock005.txt", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
        String propfindBody = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        propfindBody = String.valueOf(propfindBody) + "<D:propfind xmlns:D=\"DAV:\">\n";
        propfindBody = String.valueOf(propfindBody) + "<D:prop>\n";
        propfindBody = String.valueOf(propfindBody) + "<D:lockdiscovery/>\n";
        propfindBody = String.valueOf(propfindBody) + "</D:prop>\n";
        propfindBody = String.valueOf(propfindBody) + "</D:propfind>\n";
        xmlDocument = TestLock005.doPropfind(resource, propfindBody, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        Node owner_node = null;
        try {
            NodeList nl = xmlDocument.getElementsByTagName("D:owner");
            if (nl.getLength() == 0) {
                nl = xmlDocument.getElementsByTagName("owner");
            }
            owner_node = nl.item(0);
        }
        catch (NullPointerException exc) {
            TestLock005.addGlobalMessage((String)"retrieving the 'D:owner'-element", (char)'E', (String)"the 'owner'-element for the resource could not be retrieved");
        }
        try {
            String element_val;
            lockOwnerR = element_val = owner_node.getFirstChild().getNodeValue().toString();
        }
        catch (NullPointerException npexc) {
            TestLock005.addGlobalMessage((String)"receiving the value of the 'owner'-node for the resource", (char)'E', (String)"value of 'owner'-node is not existing");
        }
        if (lockOwner.equalsIgnoreCase(lockOwnerR)) {
            TestLock005.addGlobalMessage((String)"4. get the LOCK-owner using PROPFIND", (char)'I', (String)"Test was successful!");
        } else {
            TestLock005.addGlobalMessage((String)"4. get the LOCK-owner using PROPFIND", (char)'E', (String)"The posted and the received LOCK-Owner values are not equal.");
            TestLock005.addGlobalMessage((String)"4. get the LOCK-owner using PROPFIND", (char)'I', (String)("Posted: " + lockOwner + "\nReceived: " + lockOwnerR));
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestLock005.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock005.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

