/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestLock002
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock002.createWebDAVSchema();
        TestLock002.addGlobalMessage((String)("prepare test " + TestLock002.getTestClassId()), (char)'I', (String)"lock a file and do a put on it with a locktoken");
        host = new String(TestLock002.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock002.getPort();
        baseUrl = TestLock002.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock002.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock002.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock002.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock002.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock002.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock002.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock002.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock002.addGlobalMessage((String)"1. DELETE resource /TestLock002.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestLock002.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        TestLock002.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = String.valueOf(body) + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = String.valueOf(body) + "<D:locktype>\n";
        body = String.valueOf(body) + "<D:write/>\n";
        body = String.valueOf(body) + "</D:locktype>\n";
        body = String.valueOf(body) + "<D:lockscope>\n";
        body = String.valueOf(body) + "<D:exclusive/>\n";
        body = String.valueOf(body) + "</D:lockscope>\n";
        body = String.valueOf(body) + "<D:owner>D041249</D:owner>\n";
        body = String.valueOf(body) + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock002.addGlobalMessage((String)"3. LOCK the resource /TestLock002.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock002.addGlobalMessage((String)"3. LOCK the resource /TestLock002.txt", (char)'I', (String)"Test failed due to some WebDAV feature.");
        }
        catch (Exception exc) {
            TestLock002.addGlobalMessage((String)"3. LOCK the resource /TestLock002.txt", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock002.addGlobalMessage((String)"3. LOCK the resource /TestLock002.txt", (char)'I', (String)"Test failed due to some Java feature.");
        }
        try {
            if (resource.exists()) {
                locktoken = TestLock002.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            }
        }
        catch (NullPointerException e) {
            this.handleExceptions(e);
        }
        try {
            resource.PUT(content, contentType, locktoken);
            TestLock002.addGlobalMessage((String)"4. PUT the file TestLock002.txt again with a locktoken", (char)'I', (String)("WebDAV code: " + resource.getStatus().getStatusCode() + "expected: 204 No Content"));
            TestLock002.addGlobalMessage((String)"4. PUT the file TestLock002.txt again with a locktoken", (char)'I', (String)"Test was successful!");
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock002.addGlobalMessage((String)"4. PUT the file TestLock002.txt again with a locktoken", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock002.addGlobalMessage((String)"4. PUT the file TestLock002.txt again with a locktoken", (char)'I', (String)"Test failed due to some WebDAV feature");
        }
        catch (Exception exc) {
            TestLock002.addGlobalMessage((String)"4. PUT the file TestLock002.txt again with a locktoken", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock002.addGlobalMessage((String)"4. PUT the file TestLock002.txt again with a locktoken", (char)'I', (String)"Test failed due to some Java feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestLock002.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

