/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.gettests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TestGet005
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String lastModifiedCESTStr = null;
    static String lastModifiedGMTStr = null;

    public static void prepare() throws TestCaseException {
        TestGet005.createWebDAVSchema();
        TestGet005.addGlobalMessage((String)("prepare test " + TestGet005.getTestClassId()), (char)'I', (String)"get on an existing file to verify the 'Last Modified' field in the response header");
        host = new String(TestGet005.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestGet005.getPort();
        baseUrl = TestGet005.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestGet005.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestGet005.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestGet005.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestGet005.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestGet005.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestGet005.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestGet005";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestGet005.addGlobalMessage((String)"1. DELETE /TestGet005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestGet005.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestGet005.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        Date date = new Date();
        SimpleDateFormat sdf_fulldate = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new Locale("en"));
        sdf_fulldate.setTimeZone(TimeZone.getTimeZone("CEST"));
        lastModifiedCESTStr = sdf_fulldate.format(date);
        sdf_fulldate.setTimeZone(TimeZone.getTimeZone("GMT"));
        lastModifiedGMTStr = sdf_fulldate.format(date);
    }

    public void run() {
        try {
            resource.GET();
        }
        catch (WDVTestJ_WdvException exc) {
            TestGet005.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestGet005.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some WebDAV feature.");
        }
        catch (Exception exc) {
            TestGet005.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestGet005.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some Java feature.");
        }
        String lastModifiedStr_R = new String();
        lastModifiedStr_R = resource.getResponseHeaders().lastModified();
        if (lastModifiedStr_R != null) {
            if (lastModifiedStr_R.equalsIgnoreCase(lastModifiedCESTStr) || lastModifiedStr_R.equalsIgnoreCase(lastModifiedGMTStr)) {
                TestGet005.addGlobalMessage((String)"4. Test whether there is the correct 'Last-Modified' value in the response header", (char)'I', (String)"Test was successful!");
            } else {
                TestGet005.addGlobalMessage((String)"4. Test whether there is the correct 'Last-Modified' value in the response header", (char)'W', (String)("expected value: " + lastModifiedGMTStr + "\n received value: " + lastModifiedStr_R + "\n" + "Test failed due to some WebDAV feature.\n" + "See PTS message:\n" + "http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1128958"));
            }
        } else {
            TestGet005.addGlobalMessage((String)"4. Test whether there is the correct 'Last-Modified' value in the response header", (char)'E', (String)"The 'Last-Modified' field is NOT existent");
            TestGet005.addGlobalMessage((String)"4. Test whether there is the correct 'Last-Modified' value in the response header", (char)'I', (String)"Test failed due to some WebDAV feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestGet005.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

