/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.gettests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestGet003
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestGet003.createWebDAVSchema();
        TestGet003.addGlobalMessage((String)("prepare test " + TestGet003.getTestClassId()), (char)'I', (String)"get on an existing folder");
        host = new String(TestGet003.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestGet003.getPort();
        baseUrl = TestGet003.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestGet003.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestGet003.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestGet003.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestGet003.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestGet003.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestGet003.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestGet003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestGet003.addGlobalMessage((String)"1. DELETE folder /TestGet003 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestGet003.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        if (!TestGet003.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String contentTypeR;
        String contentR = TestGet003.doGetContent(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        long contentLengthR = contentR.length();
        if (!TestGet003.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
            if (contentLengthR == 0L) {
                TestGet003.addGlobalMessage((String)("Getting the Content-Length from http://" + host + ":" + WDV_PORT + baseUrl + "/TestGet003"), (char)'E', (String)"No content received");
            }
        } else if (contentLengthR != 0L) {
            TestGet003.addGlobalMessage((String)("Getting the Content-Length from http://" + host + ":" + WDV_PORT + baseUrl + "/TestGet003"), (char)'E', (String)"Content received");
        }
        if ((contentTypeR = TestGet003.doGetContentType(resource)) == null) {
            TestGet003.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)"No content type received!");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = "/TestGet003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestGet003.addGlobalMessage((String)"4. cleaning up and DELETE folder /TestGet003", (char)'E', (String)"Cleaning up failed due to some Java feature.");
        }
        TestGet003.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

