/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.tpbenchlib;

import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.test.JavaUser;
import com.sap.sapdb.benchmark.tp2.test.TestEnv;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class OriginalTp2JavaUser
extends JavaUser {
    protected static final String HISTORY_FILLER = "xxxxxxxxxxxxxxxxxxxxxxxxxx";
    protected static final String ACCOUNT_ADD = "1";
    private int branchKey;
    private int branchKeySave;
    private int branchDecision;
    private int accountBranch;
    private int tellerKey;
    private String accountKeyStr;
    private int branchRandom = 654321;
    private long accountRandom = 55L;
    private long accountModulo = 100L;
    private PreparedStatement updateAccount = null;
    private PreparedStatement selectAccount = null;
    private PreparedStatement insertHistory = null;
    private PreparedStatement updateTeller = null;
    private PreparedStatement updateBranch = null;
    private StringBuffer updateAccountSQL = null;
    private StringBuffer selectAccountSQL = null;
    private StringBuffer insertHistorySQL = null;
    private StringBuffer updateTellerSQL = null;
    private StringBuffer updateBranchSQL = null;
    private StringBuffer insertResultsSQL = null;
    private Statement stmtSQL = null;
    private CallableStatement stmtPlDBProc = null;
    private CallableStatement stmtCppDBProc = null;
    private boolean abort = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OriginalTp2JavaUser(int id, TestEnv testEnv) throws Tp2Exception {
        super(id, testEnv);
        try {
            AccessType at = this.getTestEnv().getAccessType();
            if (at.getTransacImpl() == 32) {
                if (at.getInterface() == 512) {
                    this.updateAccount = this.connection.prepareStatement("UPDATE bench.account SET  account_value=account_value+1 WHERE account_key = ?");
                    this.selectAccount = this.connection.prepareStatement("SELECT account_value FROM bench.account WHERE account_key=?");
                    this.insertHistory = this.connection.prepareStatement("INSERT INTO bench.history VALUES (?,1,?,?,?)");
                    this.updateTeller = this.connection.prepareStatement("UPDATE bench.teller SET  teller_value=teller_value+1 WHERE teller_key = ?");
                    this.updateBranch = this.connection.prepareStatement("UPDATE bench.branch SET  branch_value=branch_value+1 WHERE branch_key=?");
                    return;
                } else {
                    if (at.getInterface() != 768) throw new Tp2Exception("Cannot initialize OriginalTp2JavaUser[" + this.getId() + "]:" + " AccessType '" + at.getCodeStr() + "' is not compatible.", 2);
                    this.stmtSQL = this.connection.createStatement();
                    this.updateAccountSQL = new StringBuffer("UPDATE bench.account SET account_value=account_value+1 WHERE account_key = 'XXXXXXXXXX'");
                    this.selectAccountSQL = new StringBuffer("SELECT account_value FROM bench.account WHERE account_key='XXXXXXXXXX'");
                    this.insertHistorySQL = new StringBuffer("INSERT INTO bench.history VALUES ('XXXXXXXXXX',1,'XXX','XXXX','xxxxxxxxxxxxxxxxxxxxxxxxxx')");
                    this.updateTellerSQL = new StringBuffer("UPDATE bench.teller SET teller_value=teller_value+1 WHERE teller_key = 'XXXX'");
                    this.updateBranchSQL = new StringBuffer("UPDATE bench.branch SET branch_value=branch_value+1 WHERE branch_key='XXX'");
                }
                return;
            } else if (at.getTransacImpl() == 0) {
                this.stmtPlDBProc = this.connection.prepareCall("CALL tp2_transac(?,?,?,?,?,?)");
                return;
            } else {
                if (at.getTransacImpl() != 16) return;
                this.stmtCppDBProc = this.connection.prepareCall("CALL tp2_transac_cpp(?,?,?,?,?,?)");
            }
            return;
        }
        catch (SQLException e) {
            throw new Tp2Exception("Cannont initialize OriginalTp2JavaUser[" + this.getId() + "]", 2, e);
        }
    }

    protected void formatKey(StringBuffer buf, long keyVal, int begin, int length) {
        buf.setCharAt(begin + length - 1, Character.forDigit((int)(keyVal % 10L), 10));
        for (int i = length - 2; i >= 0; --i) {
            buf.setCharAt(begin + i, Character.forDigit((int)((double)keyVal % Math.pow(10.0, length - i) / Math.pow(10.0, length - i - 1)), 10));
        }
    }

    protected void executeTransaction() throws SQLException {
        this.randomSuccessor();
        if (this.getTestEnv().getAccessType().getInterface() == 512) {
            this.updateAccount.setString(1, this.accountKeyStr);
            this.updateAccount.executeUpdate();
            this.selectAccount.setString(1, this.accountKeyStr);
            this.selectAccount.executeQuery();
            this.insertHistory.setString(1, this.accountKeyStr);
            this.insertHistory.setString(2, Integer.toString(this.branchKey));
            this.insertHistory.setString(3, Integer.toString(this.tellerKey));
            this.insertHistory.setString(4, HISTORY_FILLER);
            this.insertHistory.executeUpdate();
            this.updateBranch.setString(1, Integer.toString(this.branchKey));
            this.updateBranch.executeUpdate();
            this.updateTeller.setString(1, Integer.toString(this.tellerKey));
            this.updateTeller.executeUpdate();
        } else if (this.getTestEnv().getAccessType().getInterface() == 768) {
            this.formatKey(this.updateAccountSQL, Long.parseLong(this.accountKeyStr), 76, 10);
            this.formatKey(this.selectAccountSQL, Long.parseLong(this.accountKeyStr), 59, 10);
            this.formatKey(this.insertHistorySQL, Long.parseLong(this.accountKeyStr), 35, 10);
            this.formatKey(this.insertHistorySQL, this.branchKey, 50, 3);
            this.formatKey(this.insertHistorySQL, this.tellerKey, 56, 4);
            this.formatKey(this.updateBranchSQL, this.branchKey, 70, 3);
            this.formatKey(this.updateTellerSQL, this.tellerKey, 72, 4);
            this.stmtSQL.executeUpdate(this.updateAccountSQL.toString());
            this.stmtSQL.executeQuery(this.selectAccountSQL.toString());
            this.stmtSQL.executeUpdate(this.insertHistorySQL.toString());
            this.stmtSQL.executeUpdate(this.updateTellerSQL.toString());
            this.stmtSQL.executeUpdate(this.updateBranchSQL.toString());
        }
        this.connection.commit();
    }

    protected void executeTransactionPlDBProc() throws SQLException {
        this.randomSuccessor();
        this.stmtPlDBProc.setString(1, this.accountKeyStr);
        this.stmtPlDBProc.setString(2, ACCOUNT_ADD);
        this.stmtPlDBProc.setString(3, Long.toString(this.branchKey));
        this.stmtPlDBProc.setString(4, Long.toString(this.tellerKey));
        this.stmtPlDBProc.setString(5, HISTORY_FILLER);
        this.stmtPlDBProc.registerOutParameter(6, 4);
        this.stmtPlDBProc.execute();
        this.connection.commit();
        int rc = this.stmtPlDBProc.getInt(6);
        if (rc != 0) {
            throw new SQLException("Return code of DBProc was " + rc);
        }
    }

    protected void executeTransactionCppDBProc() throws SQLException {
        this.randomSuccessor();
        this.stmtCppDBProc.setString(1, this.accountKeyStr);
        this.stmtCppDBProc.setString(2, ACCOUNT_ADD);
        this.stmtCppDBProc.setString(3, Long.toString(this.branchKey));
        this.stmtCppDBProc.setString(4, Long.toString(this.tellerKey));
        this.stmtCppDBProc.setString(5, HISTORY_FILLER);
        this.stmtCppDBProc.registerOutParameter(6, 4);
        this.stmtCppDBProc.execute();
        this.connection.commit();
        int rc = this.stmtCppDBProc.getInt(5);
        if (rc != 0) {
            throw new SQLException("Return code of DBProc was " + rc);
        }
    }

    protected void randomSuccessor() {
        this.branchRandom = this.branchRandom * 421 + 683;
        this.branchKey = this.branchRandom % 1000;
        this.tellerKey = this.branchKey + this.branchRandom % 10000 / 1000 * 1000;
        this.branchDecision = this.branchRandom % 1000000 / 10000;
        this.branchRandom %= 1000000;
        this.accountRandom = this.accountRandom * 421L + 683L;
        int divres = (int)(this.accountRandom / this.accountModulo);
        this.accountRandom -= (long)divres * this.accountModulo;
        if (this.branchDecision < 85) {
            this.accountBranch = this.branchKey;
        } else {
            this.accountBranch = this.branchKeySave;
            this.branchKeySave = this.branchKey;
        }
        if (this.accountBranch == 0) {
            this.accountKeyStr = Long.toString(this.accountRandom);
        } else {
            long accountKey = this.accountRandom < 10L ? (long)this.accountBranch * 100000L : (long)this.accountBranch * 10000L;
            this.accountKeyStr = Long.toString(accountKey) + Long.toString(this.accountRandom);
        }
    }

    public void runUser(int scaleFactor) {
    }

    protected void closeSQL() throws SQLException {
        if (this.stmtSQL != null) {
            this.stmtSQL.close();
            this.stmtSQL = null;
        }
        if (this.stmtPlDBProc != null) {
            this.stmtPlDBProc.close();
            this.stmtPlDBProc = null;
        }
        if (this.stmtCppDBProc != null) {
            this.stmtCppDBProc.close();
            this.stmtCppDBProc = null;
        }
    }
}

