/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.common;

import com.sap.sapdb.benchmark.common.PropertyContainer;
import com.sap.sapdb.benchmark.tp2.common.PropertyException;
import com.sap.sapdb.benchmark.tp2.util.SimpleXMLHandler;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Tp2TestProperties
implements PropertyContainer {
    private static SortedMap descriptions = null;
    private static SortedSet booleans = null;
    private static SortedMap defaults = null;
    private static SortedMap possibleValues = null;
    private static SortedSet booleanPossibleValues = null;
    private SortedMap setToNonDefaultProperties = new TreeMap();

    public static Iterator listAllKeys() {
        return descriptions.keySet().iterator();
    }

    public static Iterator listDefaultKeys() {
        try {
            TreeSet<String> result = new TreeSet<String>();
            Iterator it = Tp2TestProperties.listAllKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!Tp2TestProperties.hasDefault(key)) continue;
                result.add(key);
            }
            return result.iterator();
        }
        catch (PropertyException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static Iterator listNonDefaultKeys() {
        try {
            TreeSet<String> result = new TreeSet<String>();
            Iterator it = Tp2TestProperties.listAllKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (Tp2TestProperties.hasDefault(key)) continue;
                result.add(key);
            }
            return result.iterator();
        }
        catch (PropertyException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static String getDescription(String key) throws PropertyException {
        if (!Tp2TestProperties.isPropertyKey(key)) {
            throw Tp2TestProperties.notDefined(key);
        }
        return (String)descriptions.get(key);
    }

    public static boolean isPropertyKey(String key) {
        return descriptions.containsKey(key);
    }

    public static boolean hasDefault(String key) throws PropertyException {
        if (!Tp2TestProperties.isPropertyKey(key)) {
            throw Tp2TestProperties.notDefined(key);
        }
        return defaults.containsKey(key) || Tp2TestProperties.isBooleanProperty(key);
    }

    public static String getDefault(String key) throws PropertyException {
        if (!Tp2TestProperties.hasDefault(key)) {
            throw new PropertyException("Property " + key + " has no default.", key);
        }
        if (!defaults.containsKey(key)) {
            if (Tp2TestProperties.isBooleanProperty(key)) {
                return "false";
            }
            throw new PropertyException("Property " + key + " has no default.", key);
        }
        return (String)defaults.get(key);
    }

    public static boolean isBooleanProperty(String propName) throws PropertyException {
        if (!Tp2TestProperties.isPropertyKey(propName)) {
            throw Tp2TestProperties.notDefined(propName);
        }
        return booleans.contains(propName);
    }

    public static boolean hasPossibleValues(String propName) throws PropertyException {
        if (!Tp2TestProperties.isPropertyKey(propName)) {
            throw Tp2TestProperties.notDefined(propName);
        }
        return possibleValues.containsKey(propName) || Tp2TestProperties.isBooleanProperty(propName);
    }

    public static SortedSet getPossibleValues(String propName) throws PropertyException {
        if (!Tp2TestProperties.hasPossibleValues(propName)) {
            throw new PropertyException("Property " + propName + " has not a possible values list.", propName);
        }
        if (!possibleValues.containsKey(propName)) {
            if (Tp2TestProperties.isBooleanProperty(propName)) {
                return booleanPossibleValues;
            }
            throw new PropertyException("Property " + propName + " has not a possible values list.", propName);
        }
        return (SortedSet)possibleValues.get(propName);
    }

    public static void main(String[] arg) {
        try {
            Iterator props = Tp2TestProperties.listAllKeys();
            while (props.hasNext()) {
                String propName = (String)props.next();
                System.out.println("\nName: " + propName);
                System.out.println("Desc: " + Tp2TestProperties.getDescription(propName));
                if (Tp2TestProperties.isBooleanProperty(propName)) {
                    System.out.println("isBoolean!");
                }
                if (Tp2TestProperties.hasDefault(propName)) {
                    System.out.println("Default: " + Tp2TestProperties.getDefault(propName));
                }
                if (!Tp2TestProperties.hasPossibleValues(propName)) continue;
                System.out.println("Pos.Val: " + Tp2TestProperties.getPossibleValues(propName));
            }
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
    }

    private static PropertyException valueNotFound(String key) {
        return new PropertyException("Value for property " + key + " was not found. Make sure it was set.", key);
    }

    private static PropertyException notDefined(String key) {
        return new PropertyException("Property " + key + " is not defined. Check if the name is correct.", key);
    }

    private static PropertyException notCompatible(String key, String value) throws PropertyException {
        return new PropertyException("Value " + value + " of property " + key + " is not compatible with possible values " + Tp2TestProperties.getPossibleValues(key), key);
    }

    public Tp2TestProperties() {
    }

    public Tp2TestProperties(Map map) throws PropertyException {
        this();
        this.putPropertiesMap(map);
    }

    public void putPropertiesMap(Map map) throws PropertyException {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public void setProperty(String key, String value) throws PropertyException {
        if (!Tp2TestProperties.isPropertyKey(key)) {
            throw Tp2TestProperties.notDefined(key);
        }
        if (value == null) {
            if (this.setToNonDefaultProperties.containsKey(key)) {
                this.setToNonDefaultProperties.remove(key);
            }
        } else {
            if (Tp2TestProperties.hasDefault(key) && value.equals(Tp2TestProperties.getDefault(key))) {
                if (this.setToNonDefaultProperties.containsKey(key)) {
                    this.setToNonDefaultProperties.remove(key);
                }
                return;
            }
            if (Tp2TestProperties.hasPossibleValues(key) && !Tp2TestProperties.getPossibleValues(key).contains(value)) {
                throw Tp2TestProperties.notCompatible(key, value);
            }
            this.setToNonDefaultProperties.put(key, value);
        }
    }

    public String getProperty(String key) throws PropertyException {
        if (!Tp2TestProperties.isPropertyKey(key)) {
            throw Tp2TestProperties.notDefined(key);
        }
        String result = null;
        if (this.setToNonDefaultProperties.containsKey(key)) {
            result = (String)this.setToNonDefaultProperties.get(key);
        }
        if (result != null) {
            if (Tp2TestProperties.hasPossibleValues(key)) {
                if (Tp2TestProperties.getPossibleValues(key).contains(result)) {
                    return result;
                }
                throw Tp2TestProperties.notCompatible(key, result);
            }
            return result;
        }
        if (Tp2TestProperties.hasDefault(key)) {
            return Tp2TestProperties.getDefault(key);
        }
        throw Tp2TestProperties.valueNotFound(key);
    }

    public boolean getBooleanProperty(String key) throws PropertyException {
        if (!Tp2TestProperties.isBooleanProperty(key)) {
            throw new PropertyException(key + " is not a boolean property", key);
        }
        if (this.getProperty(key).equals("true")) {
            return true;
        }
        if (this.getProperty(key).equals("false")) {
            return false;
        }
        throw new PropertyException("Value " + this.getProperty(key) + " for key " + key + " is in a bad format for a boolean property", key);
    }

    public boolean isSet(String key) throws PropertyException {
        return Tp2TestProperties.hasDefault(key) || this.setToNonDefaultProperties.containsKey(key);
    }

    public Iterator listSetKeys() {
        TreeSet result = new TreeSet();
        result.addAll(defaults.keySet());
        result.addAll(booleans);
        result.addAll(this.setToNonDefaultProperties.keySet());
        return result.iterator();
    }

    public Iterator listNonSetKeys() {
        TreeSet<String> result = new TreeSet<String>();
        Iterator it = Tp2TestProperties.listNonDefaultKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (this.setToNonDefaultProperties.containsKey(key)) continue;
            result.add(key);
        }
        return result.iterator();
    }

    public String getSetEntriesAsString() throws PropertyException {
        StringBuffer res = new StringBuffer("");
        Iterator it = this.listSetKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            res.append(key).append("=").append(this.getProperty(key)).append("\n");
        }
        return res.toString();
    }

    public Iterator listSetToNonDefaultKeys() {
        return this.setToNonDefaultProperties.keySet().iterator();
    }

    public int nbrOfSetToNonDefault() {
        return this.setToNonDefaultProperties.size();
    }

    public String getPropertyWithDefault(String key, String defaultValue) {
        try {
            return this.getProperty(key);
        }
        catch (PropertyException e) {
            return defaultValue;
        }
    }

    static {
        descriptions = new TreeMap();
        defaults = new TreeMap();
        possibleValues = new TreeMap();
        booleans = new TreeSet();
        booleanPossibleValues = new TreeSet();
        booleanPossibleValues.add("true");
        booleanPossibleValues.add("false");
        try {
            InputStreamReader in = new InputStreamReader(ClassLoader.getSystemResourceAsStream("com/sap/sapdb/benchmark/tp2/common/tp2TestProperties.xml"));
            new DefinitionsHandler().parse(new InputSource(in));
            ((Reader)in).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static class DefinitionsHandler
    extends SimpleXMLHandler {
        private String currName = null;
        private String currDescription = null;
        private String currDefault = null;
        private boolean currIsBoolean = false;
        private SortedSet currPossibleValues = null;

        private DefinitionsHandler() {
        }

        protected void startTag(String tagName, Attributes attr) throws SAXException {
            if (tagName.equals("Property")) {
                this.currName = attr.getValue("name");
            } else if (tagName.equals("Boolean")) {
                this.currIsBoolean = true;
            } else if (tagName.equals("PossibleValues")) {
                this.currPossibleValues = new TreeSet();
            }
        }

        protected void endTag(String tagName) throws SAXException {
            if (tagName.equals("Description")) {
                this.currDescription = this.getTagText();
            } else if (tagName.equals("Default")) {
                this.currDefault = this.getTagText();
            } else if (tagName.equals("PossibleValue")) {
                this.currPossibleValues.add(this.getTagText());
            } else if (tagName.equals("Property")) {
                if (descriptions.containsKey(this.currName)) {
                    throw new SAXException("Duplicate property definition " + this.currName);
                }
                descriptions.put(this.currName, this.currDescription);
                if (this.currDefault != null) {
                    defaults.put(this.currName, this.currDefault);
                }
                if (this.currIsBoolean) {
                    booleans.add(this.currName);
                }
                if (this.currPossibleValues != null) {
                    if (this.currDefault != null && !this.currPossibleValues.contains(this.currDefault)) {
                        throw new SAXException("Default value " + this.currDefault + " is not in possible values " + this.currPossibleValues);
                    }
                    possibleValues.put(this.currName, this.currPossibleValues);
                }
                this.currName = null;
                this.currDescription = null;
                this.currDefault = null;
                this.currIsBoolean = false;
                this.currPossibleValues = null;
            }
        }
    }
}

