/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.lcbenchmarks;

import com.sap.sapdb.lctest.PrimaryTest;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Execute;
import com.sap.sapdb.testframe.utilities.Zipper;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;

public class LcBenchmarkWrapper
extends PrimaryTest {
    public static final String VERSION = "1.1";
    public static int mTraceLevel;
    public static String mMakeKey;
    public static String mBenchSize;
    public static boolean mStoreResultPersistent;
    public static String mUserSetting;
    public static String mTestDBName;
    public static String mBeforeDBAction;
    public static String mAfterDBAction;
    public static String mResultsDBName;
    public static String mResultsDBServer;
    public static String mResultsDBUser;
    public static String mResultsDBPassword;
    private static String fileSep;
    private static String zipFileName;

    public static long getTimeout() {
        return 3600000L;
    }

    public static void prepare() throws TestCaseException {
        mTraceLevel = LcBenchmarkWrapper.getParameterInt((String)"TraceLevel", (int)1);
        mBenchSize = LcBenchmarkWrapper.getParameterString((String)"SizeOption", (String)"-small");
        mMakeKey = LcBenchmarkWrapper.getParameterString((String)"MakeKey", (String)mTestDriverOptions.getProperty("MakeKey"));
        mStoreResultPersistent = LcBenchmarkWrapper.getParameterBoolean((String)"StoreResultPersistent", (boolean)false);
        mUserSetting = LcBenchmarkWrapper.getParameterString((String)"UserSetting", (String)"-multi");
        mTestDBName = LcBenchmarkWrapper.getParameterString((String)"TestDBName", (String)"BENCH");
        mBeforeDBAction = LcBenchmarkWrapper.getParameterString((String)"BeforeDBAction", (String)"FORCE");
        mAfterDBAction = LcBenchmarkWrapper.getParameterString((String)"AfterDBAction", (String)"DROP");
        String storeMode = "NO";
        if (mStoreResultPersistent) {
            storeMode = "YES";
            mResultsDBName = LcBenchmarkWrapper.getParameterString((String)"ResultsDBName", (String)"NONE");
            mResultsDBServer = LcBenchmarkWrapper.getParameterString((String)"ResultsDBServer", (String)"NONE");
            mResultsDBUser = LcBenchmarkWrapper.getParameterString((String)"ResultsDBUser", (String)"NONE");
            mResultsDBPassword = LcBenchmarkWrapper.getParameterString((String)"ResultsDBPassword", (String)"NONE");
        }
        String infoString = "\n       *************************************************\n       Starting LcBenchmarkWrapper - Version: 1.1\n       *************************************************\n\n       Benchmarks settings:       \n       -------------------       \n       Test DB Name  :                " + mTestDBName + "\n" + "       Benchmark size:                " + mBenchSize + "\n" + "       Benchmark user setting:        " + mUserSetting + "\n" + "       Store results persistent:      " + storeMode + "\n";
        if (mStoreResultPersistent) {
            infoString = infoString + "\n" + "       Results DB Name:               " + mResultsDBName + "\n" + "       Results DB Server:             " + mResultsDBServer + "\n";
        }
        LcBenchmarkWrapper.printInfo(mTraceLevel, LcBenchmarkWrapper.getTestClassId(), infoString);
        fileSep = System.getProperty("file.separator");
        zipFileName = LcBenchmarkWrapper.getParameterString((String)"zipFile", (String)"lcbenchmarkprt.zip");
    }

    public void run() {
        try {
            String sFileSep = System.getProperty("file.separator");
            String cmd = "";
            String executableName = "";
            executableName = System.getProperty("os.name").substring(0, 3).equalsIgnoreCase("WIN") ? "lcbenchmark.exe" : "lcbenchmark";
            cmd = mStoreResultPersistent ? TestDriver.getJTestRoot() + sFileSep + "tests" + sFileSep + executableName + " -v " + mBenchSize + " -i " + this.getDBRoot() + " " + mUserSetting + " -d " + mTestDBName + " -G " + mBeforeDBAction + "," + mAfterDBAction + " -dp " + mResultsDBName + " -np " + mResultsDBServer + " -up " + mResultsDBUser + "," + mResultsDBPassword + " -mk " + mMakeKey : TestDriver.getJTestRoot() + sFileSep + "tests" + sFileSep + executableName + " -v " + mBenchSize + " -i " + this.getDBRoot() + " " + mUserSetting + " -d " + mTestDBName + " -G " + mBeforeDBAction + "," + mAfterDBAction;
            LcBenchmarkWrapper.printInfo(mTraceLevel, LcBenchmarkWrapper.getTestClassId(), "\nStarting LCBENCHMARK with the following call:\n " + cmd + "\n");
            StringBuffer sb = new StringBuffer();
            Execute exc = new Execute(cmd, null, sb);
            exc.exec();
            int exitValue = exc.getExitValue();
            if (exitValue == 0) {
                LcBenchmarkWrapper.printInfo(mTraceLevel, LcBenchmarkWrapper.getTestClassId(), "\nExitValue is " + exitValue + "\nTest output:\n\n" + sb.toString());
            } else {
                LcBenchmarkWrapper.addGlobalMessage((String)LcBenchmarkWrapper.getTestClassId(), (char)'E', (String)("\nExitValue is " + exitValue + "\nTest output:\n\n" + sb.toString()));
            }
        }
        catch (Exception e) {
            LcBenchmarkWrapper.addGlobalMessage((String)LcBenchmarkWrapper.getTestClassId(), (char)'E', (String)("Method run() - Exception: " + e.getClass() + e.getMessage()));
            System.out.println("Method run Exception: " + e.getClass() + e.getMessage());
        }
    }

    public static void cleanUp() throws TestCaseException {
        PrimaryTest.cleanUp();
        System.out.println("End of " + LcBenchmarkWrapper.getTestClassId());
    }

    public static String getTestClassId() {
        return "LcBenchmarkWrapper";
    }

    public static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            LcBenchmarkWrapper.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            LcBenchmarkWrapper.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    public String getLogFile() {
        TestDatabaseSap benchDB;
        File theZipFile = new File(this.getDataOutputPath() + fileSep + zipFileName);
        if (theZipFile.exists()) {
            theZipFile.delete();
        }
        Zipper myZipper = new Zipper(theZipFile);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".prot") || name.endsWith(".prt") || name.endsWith(".err") || name.endsWith(".txt");
            }
        };
        try {
            benchDB = new TestDatabaseSap("localhost", mTestDBName);
            String knldiag = benchDB.getDatabaseProtocolViaDBMKey("KNLDIAG");
            if (knldiag.length() != 0) {
                File knldiagFile = new File(this.getDataOutputPath() + fileSep + "knldiag.txt");
                FileWriter fwknl = new FileWriter(knldiagFile);
                fwknl.write(knldiag.substring(0), 0, knldiag.length());
                fwknl.close();
            }
        }
        catch (Exception exp) {
            this.addMessage("LcBenchmarkWrapper", 'I', "Can't create 'knldiag.txt' file. \nBacause database was already dropped after a successful test?" + exp.getLocalizedMessage());
        }
        try {
            benchDB = new TestDatabaseSap("localhost", mTestDBName);
            String dbmprt = benchDB.getDatabaseProtocolViaDBMKey("DBMPRT");
            if (dbmprt.length() != 0) {
                File dbmprtFile = new File(this.getDataOutputPath() + fileSep + "dbmprt.txt");
                FileWriter fwdbm = new FileWriter(dbmprtFile);
                fwdbm.write(dbmprt.substring(0), 0, dbmprt.length());
                fwdbm.close();
            }
        }
        catch (Exception exp) {
            this.addMessage("LcBenchmarkWrapper", 'I', "Can't create 'dbmprt.txt' file. \nBacause database was already dropped after a successful test?" + exp.getLocalizedMessage());
        }
        File[] filelist = new File(this.getDataOutputPath()).listFiles(filter);
        if (filelist[0] != null) {
            myZipper.addFiles(filelist);
        }
        try {
            myZipper.setRootDirectory(new File(this.getDataOutputPath()));
            myZipper.zip();
        }
        catch (IOException e) {
            this.addMessage("LcBenchmarkWrapper", 'W', "Failed to create a zipfile with the protocol files\n" + e.getLocalizedMessage());
            return null;
        }
        return theZipFile.getAbsolutePath();
    }

    static {
        mResultsDBName = "";
        mResultsDBServer = "";
        mResultsDBUser = "";
        mResultsDBPassword = "";
    }
}

