/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common;

import com.sap.sapdb.benchmark.common.StorableObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class DBDescProperties {
    protected static SortedMap booleanPropNames = null;
    protected SortedSet booleanProperties = null;

    public static DBDescProperties getDBDescProperties(int dbDescId) throws SQLException {
        if (!StorableObject.isNonPersistent()) {
            Statement stmt = StorableObject.getConnection().createStatement();
            ResultSet RS = stmt.executeQuery("SELECT prop.name AS name FROM dbdesc_boolean_properties prop, dbdesc_boolean_prop_lnk lnk WHERE prop.id=lnk.prop_id AND dbdesc_id=" + dbDescId + " ORDER BY prop.name");
            SortedSet<String> booleanProperties = Collections.synchronizedSortedSet(new TreeSet());
            while (RS.next()) {
                booleanProperties.add(RS.getString("name"));
            }
            StorableObject.getConnection().commit();
            RS.close();
            stmt.close();
            return new DBDescProperties(booleanProperties);
        }
        return new DBDescProperties();
    }

    public static void createBooleanProperty(String name) throws SQLException {
        if (!StorableObject.isNonPersistent()) {
            Statement stmt = StorableObject.getConnection().createStatement();
            stmt.executeUpdate("INSERT INTO dbdesc_boolean_properties SET name='" + name + "'");
            ResultSet RS = stmt.executeQuery("SELECT id FROM dbdesc_boolean_properties WHERE name='" + name + "'");
            if (RS.next()) {
                booleanPropNames.put(name, new Integer(RS.getInt("id")));
                StorableObject.getConnection().commit();
            } else {
                StorableObject.getConnection().rollback();
            }
            RS.close();
            stmt.close();
        } else {
            booleanPropNames.put(name, new Integer(1));
        }
    }

    public static SortedSet getBooleanPropertiesNames() {
        return new TreeSet(booleanPropNames.keySet());
    }

    public static int getBooleanPropertyId(String name) {
        return (Integer)booleanPropNames.get(name);
    }

    protected DBDescProperties() {
        this.booleanProperties = Collections.synchronizedSortedSet(new TreeSet());
    }

    protected DBDescProperties(SortedSet booleanProperties) {
        this.booleanProperties = new TreeSet(booleanProperties);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBDescProperties) {
            DBDescProperties otherProp = (DBDescProperties)obj;
            Iterator it = DBDescProperties.getBooleanPropertiesNames().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (this.getBooleanProperty(name) == otherProp.getBooleanProperty(name)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean getBooleanProperty(String name) {
        return this.booleanProperties.contains(name);
    }

    public Iterator listSetBooleanProperties() {
        return this.booleanProperties.iterator();
    }

    static {
        booleanPropNames = Collections.synchronizedSortedMap(new TreeMap());
        if (!StorableObject.isNonPersistent()) {
            try {
                Statement stmt = StorableObject.getConnection().createStatement();
                ResultSet RS = stmt.executeQuery("SELECT id,name FROM dbdesc_boolean_properties ORDER BY name");
                while (RS.next()) {
                    booleanPropNames.put(RS.getString("name"), new Integer(RS.getInt("id")));
                }
                StorableObject.getConnection().commit();
                RS.close();
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

