/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class AsciiOutputForAsciiColumns
extends Test {
    private static final String help = "help for AsciiOutputForAsciiColumns";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public AsciiOutputForAsciiColumns(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public AsciiOutputForAsciiColumns(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        if (!this.environment.hasFeature("UnicodeDB")) {
            return;
        }
        String string = "AsciiOutputForAsciiColumns";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (C_CHARASCII    Char (1) ASCII," + "    C_CHARBYTE     Char (1) BYTE," + "    C_CHARUNICODE  Char (1) UNICODE," + "    C_VARCHARASCII Varchar (1) ASCII," + "    C_VARCHARBYTE  Varchar (1) BYTE," + "    C_VARCHARUNICODE Varchar (1) UNICODE," + "    C_DATE         Date," + "    C_TIME         Time," + "    C_TIMESTAMP    Timestamp," + "    C_LONGASCII    Long ASCII," + "    C_LONGBYTE     Long BYTE," + "    C_LONGUNICODE  Long UNICODE )");
        this.connection.commit();
        PreparedStatement preparedStatement = this.connection.prepareStatement("Insert into " + string2 + " values (?,?,?,?,?,?,?,?,?,?,?,?)");
        String string3 = "a";
        byte by = 10;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Date date = new Date(System.currentTimeMillis());
        Time time = new Time(System.currentTimeMillis());
        preparedStatement.setString(1, string3);
        preparedStatement.setByte(2, by);
        preparedStatement.setString(3, string3);
        preparedStatement.setString(4, string3);
        preparedStatement.setByte(5, by);
        preparedStatement.setString(6, string3);
        preparedStatement.setDate(7, date);
        preparedStatement.setTime(8, time);
        preparedStatement.setTimestamp(9, timestamp);
        preparedStatement.setString(10, string3);
        preparedStatement.setByte(11, by);
        preparedStatement.setString(12, string3);
        preparedStatement.executeUpdate();
        ResultSet resultSet = this.stmt.executeQuery("Select * from " + string2);
        this.log.addDifference(string, "Fectch Next", Boolean.TRUE, new Boolean(resultSet.next()));
        this.log.addDifference(string, "Check value for column 1", string3, resultSet.getString(1));
        this.log.addDifference(string, "Check value for column 2", new Byte(by), new Byte(resultSet.getByte(2)));
        this.log.addDifference(string, "Check value for column 3", string3, resultSet.getString(3));
        this.log.addDifference(string, "Check value for column 4", string3, resultSet.getString(4));
        this.log.addDifference(string, "Check value for column 5", new Byte(by), new Byte(resultSet.getByte(5)));
        this.log.addDifference(string, "Check value for column 6", string3, resultSet.getString(6));
        this.log.addDifference(string, "Check value for column 7", date, resultSet.getDate(7));
        this.log.addDifference(string, "Check value for column 8", time, resultSet.getTime(8));
        this.log.addDifference(string, "Check value for column 9", timestamp, resultSet.getTimestamp(9));
        this.log.addDifference(string, "Check value for column 10", string3, resultSet.getString(10));
        this.log.addDifference(string, "Check value for column 11", new Byte(by), new Byte(resultSet.getByte(11)));
        this.log.addDifference(string, "Check value for column 12", string3, resultSet.getString(12));
        this.vtraceFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        AsciiOutputForAsciiColumns asciiOutputForAsciiColumns = new AsciiOutputForAsciiColumns(stringArray);
        try {
            asciiOutputForAsciiColumns.runInner();
        }
        finally {
            asciiOutputForAsciiColumns.connection.close();
        }
        if (asciiOutputForAsciiColumns.log.hasErrors()) {
            System.exit(5);
        }
    }
}

