/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UpdatableStmt
extends Test {
    private static final String help = "help for UpdatableStmt";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public UpdatableStmt(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public UpdatableStmt(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        int n;
        String string = "UpdatableStmt";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (\"K1N5\" Varchar (1000),\"F1C1\" Varchar (1000),\"C3\" Varchar (1000))");
        int n2 = 50;
        string = "Fill Table";
        PreparedStatement preparedStatement = this.connection.prepareStatement("insert into " + string2 + " values (?,?,?)");
        for (int i = 1; i <= n2; ++i) {
            preparedStatement.setString(1, String.valueOf(i));
            preparedStatement.setString(2, "X");
            preparedStatement.setInt(3, 0);
            preparedStatement.executeUpdate();
        }
        this.connection.commit();
        string = "Update Table forward";
        this.log.addInfo(string);
        PreparedStatement preparedStatement2 = this.connection.prepareStatement("select K1N5, F1C1, C3 from " + string2, 1004, 1008);
        ResultSet resultSet = preparedStatement2.executeQuery();
        for (n = 1; n <= n2; ++n) {
            resultSet.next();
            resultSet.updateString(2, String.valueOf(n));
            resultSet.updateRow();
        }
        resultSet.close();
        this.connection.commit();
        resultSet = preparedStatement2.executeQuery();
        for (n = 0; n < n2; ++n) {
            resultSet.next();
            this.log.addDifference(string, "Check Updatable RS Zeile: " + n, new Integer(resultSet.getInt(2)), new Integer(resultSet.getInt(1)));
        }
        string = "Update Table forward random";
        this.log.addInfo(string);
        this.connection.isClosed();
        resultSet = preparedStatement2.executeQuery();
        n = 0;
        while (resultSet.next()) {
            if (n == 15 || n > 25) {
                resultSet.updateString(3, String.valueOf(1));
                resultSet.updateRow();
            }
            this.log.addDifference(string, "Check Random Update Zeile: " + n, new Integer(n + 1), new Integer(resultSet.getInt(1)));
            ++n;
        }
        resultSet.close();
        this.connection.commit();
        resultSet = preparedStatement2.executeQuery();
        for (n = 1; n <= n2; ++n) {
            resultSet.next();
            this.log.addDifference(string, "Check Updatable RS Zeile: " + n, new Integer(n), new Integer(resultSet.getInt(1)));
            this.log.addDifference(string, "Check Updatable RS Zeile: " + n, new Integer(n), new Integer(resultSet.getInt(2)));
            if (n != 16 && n <= 26) continue;
            this.log.addDifference(string, "Check Updatable RS Zeile: " + n, new Integer(1), new Integer(resultSet.getInt(3)));
        }
        string = "Update Table backward";
        this.log.addInfo(string);
        this.connection.isClosed();
        resultSet = preparedStatement2.executeQuery();
        resultSet.last();
        for (n = n2; n >= 1; --n) {
            resultSet.updateString(2, String.valueOf(2 * resultSet.getInt(1)));
            resultSet.updateRow();
            resultSet.previous();
        }
        resultSet.close();
        this.connection.commit();
        resultSet = preparedStatement2.executeQuery();
        for (n = 0; n < n2; ++n) {
            resultSet.next();
            this.log.addDifference(string, "Check Updatable RS Zeile: " + n, new Integer(resultSet.getInt(1) * 2), new Integer(resultSet.getInt(2)));
        }
        resultSet.close();
        string = "Update Table backward random";
        this.log.addInfo(string);
        this.connection.isClosed();
        resultSet = preparedStatement2.executeQuery();
        resultSet.last();
        n = n2 - 1;
        while (resultSet.previous()) {
            if (n == 35 || n <= 25) {
                resultSet.updateString(3, String.valueOf(3));
                resultSet.updateRow();
                this.connection.commit();
            }
            --n;
        }
        resultSet.close();
        this.connection.commit();
        resultSet = preparedStatement2.executeQuery();
        for (n = 1; n <= n2; ++n) {
            resultSet.next();
            this.log.addDifference(string, "Check Updatable RS Zeile: " + n, new Integer(n), new Integer(resultSet.getInt(1)));
            this.log.addDifference(string, "Check Updatable RS Zeile: " + n, new Integer(resultSet.getInt(1) * 2), new Integer(resultSet.getInt(2)));
            if (n != 35 && n >= 25) continue;
            this.log.addDifference(string, "Check Updatable RS Zeile: " + n, new Integer(3), new Integer(resultSet.getInt(3)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        UpdatableStmt updatableStmt = new UpdatableStmt(stringArray);
        try {
            updatableStmt.runInner();
        }
        finally {
            updatableStmt.connection.close();
        }
        if (updatableStmt.log.hasErrors()) {
            System.exit(5);
        }
    }
}

