/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtech.util.Tracer;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class UpdatableResultSetWithDefaultValues
extends Test {
    private static final String help = "help for UpdatableResultSetWithDefaultValues";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public UpdatableResultSetWithDefaultValues(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public UpdatableResultSetWithDefaultValues(Test test) throws SQLException {
        super(test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRun() throws SQLException {
        String string = "UpdatableResultSetWithDefaultValues";
        String string2 = this.getUnicodeIdentifier("UPDRSWithDefVal");
        this.dropTable(string2);
        this.connection.commit();
        if (!this.environment.testRunsWithMaxDB()) {
            return;
        }
        Connection connection = null;
        try {
            String string3 = this.options.getConnectURL();
            string3 = string3.indexOf(63) == -1 ? string3 + "?useDefaultValueForUpdatableRS=yes" : string3 + "&useDefaultValueForUpdatableRS=yes";
            connection = DriverManager.getConnection(string3, this.getUsername(), this.getPasswd());
            Statement statement = connection.createStatement(1003, 1008);
            String string4 = this.makeRandomString(10);
            int n = 42;
            String string5 = "2005-10-05 12:12:12.999999";
            Timestamp timestamp = new Timestamp(105, 9, 5, 12, 12, 12, 999999000);
            statement.execute("CREATE TABLE " + string2 + " (homer varchar(10) default '" + string4 + "', " + "bart integer default " + String.valueOf(n) + ", " + "liza timestamp default '" + string5 + "', " + "marge varchar (10) byte default x'" + Tracer.Hex2String((byte[])string4.getBytes()).toUpperCase() + "' )");
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + string2, 1003, 1008);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.moveToInsertRow();
            resultSet.insertRow();
            resultSet = statement.executeQuery("SELECT * FROM " + string2);
            int n2 = 1;
            while (resultSet.next()) {
                this.log.addDifference(string, "Check updated values for row " + n2, string4, resultSet.getString(1));
                this.log.addDifference(string, "Check updated values for row " + n2, new Integer(n), new Integer(resultSet.getInt(2)));
                this.log.addDifference(string, "Check updated values for row " + n2, timestamp, resultSet.getTimestamp(3));
                this.log.addDifference(string, "Check updated values for row " + n2, string4.getBytes(), resultSet.getBytes(4));
                ++n2;
            }
            statement.executeUpdate("DELETE FROM " + string2);
            String string6 = this.makeRandomString(10);
            int n3 = 73;
            resultSet = statement.executeQuery("SELECT * FROM " + string2);
            resultSet.moveToInsertRow();
            resultSet.updateString(1, string6);
            resultSet.updateInt(2, n3);
            resultSet.insertRow();
            resultSet = statement.executeQuery("SELECT * FROM " + string2);
            int n4 = 1;
            while (resultSet.next()) {
                this.log.addDifference(string, "Check updated values for row " + n4, string6, resultSet.getString(1));
                this.log.addDifference(string, "Check updated values for row " + n4, new Integer(n3), new Integer(resultSet.getInt(2)));
                this.log.addDifference(string, "Check updated values for row " + n4, timestamp, resultSet.getTimestamp(3));
                this.log.addDifference(string, "Check updated values for row " + n4, string4.getBytes(), resultSet.getBytes(4));
                ++n4;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        UpdatableResultSetWithDefaultValues updatableResultSetWithDefaultValues = new UpdatableResultSetWithDefaultValues(stringArray);
        try {
            updatableResultSetWithDefaultValues.runInner();
        }
        finally {
            updatableResultSetWithDefaultValues.connection.close();
        }
        if (updatableResultSetWithDefaultValues.log.hasErrors()) {
            System.exit(5);
        }
    }
}

