/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.ecperf;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLDBCBench
extends Test {
    private static final int MAXROWS = 10000;
    private static final String help = "help for SQLDBCBench";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private int[] id = new int[10000];
    private String[] text1 = new String[10000];
    private String[] text2 = new String[10000];

    public SQLDBCBench(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public SQLDBCBench(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        this.dropTable("phpbench");
        this.stmt.execute("create table phpbench (id int, text1 char(20), text2 varchar(200))");
        PreparedStatement preparedStatement = this.connection.prepareStatement("insert into phpbench values (?,?,?)");
        for (int i = 0; i < 10000; ++i) {
            String string = String.valueOf(i) + ". Zeile";
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string + " " + string + " " + string + " " + string + " " + string + " " + string + " und ein langer Rattenschwanz " + string);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        this.connection.commit();
        long l = System.currentTimeMillis();
        for (int i = 1; i <= 10; ++i) {
            this.SelectTable();
        }
        System.out.println("Laufzeit: " + (System.currentTimeMillis() - l) + " ms");
    }

    void SelectTable() throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("select * from phpbench");
        ResultSet resultSet = preparedStatement.executeQuery();
        for (int i = 0; i < 10000; ++i) {
            resultSet.next();
            this.id[i] = resultSet.getInt(1);
            this.text1[i] = resultSet.getString(2);
            this.text2[i] = resultSet.getString(3);
        }
        System.out.println(this.id[0] + "\t" + this.text1[0] + "\t" + this.text2[0] + "\n");
        System.out.println(this.id[9900] + "\t" + this.text1[9900] + "\t" + this.text2[9900] + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        SQLDBCBench sQLDBCBench = new SQLDBCBench(stringArray);
        try {
            sQLDBCBench.runInner();
        }
        finally {
            sQLDBCBench.connection.close();
        }
        if (sQLDBCBench.log.hasErrors()) {
            System.exit(5);
        }
    }
}

