/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.benchmark;

import com.sap.dbtechtest.jdbc.benchmark.AccessType;
import com.sap.dbtechtest.jdbc.benchmark.JavaUser;
import com.sap.dbtechtest.jdbc.benchmark.OriginalTp2Init;
import com.sap.dbtechtest.jdbc.benchmark.OriginalTp2JavaUser;
import com.sap.dbtechtest.jdbc.benchmark.SimulatedUser;
import com.sap.dbtechtest.jdbc.benchmark.TP2Result;
import com.sap.dbtechtest.util.options.BoolOption;
import com.sap.dbtechtest.util.options.IntOption;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.options.SapDBOptions;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.LogWriter;
import java.sql.SQLException;

public class TP2
extends Test {
    private static final String help = "help for TP2";
    private static final OptionDesc[] optdesc = new OptionDesc[]{new BoolOption("noFill", "do not recreate and fill benchmark tables", new String[0]), new IntOption("duration", "duration of benchmark measurement", 60, new String[0]), new IntOption("users", "number of concurrent users", 6, new String[0]), new IntOption("isolationlevel", "isolationlevel", 1, new String[0]), new BoolOption("debug", "printout debug information", new String[0]), new BoolOption("loadData", "create tables and load the initial data", new String[0])};
    private int duration;
    private int users;
    private boolean debug = false;
    private AccessType accessType = new AccessType("JDBC_NATIVE-STATEMENT-JAVA");

    public TP2(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public TP2(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        int n;
        String string = "TP2";
        int n2 = -1;
        this.duration = this.options.getInt("duration");
        this.users = this.options.getInt("users");
        this.debug = this.options.getBoolean("debug");
        boolean bl = this.options.getBoolean("noFill");
        boolean bl2 = this.options.getBoolean("loadData");
        OriginalTp2Init originalTp2Init = new OriginalTp2Init(this.log);
        if (!bl) {
            this.log.addInfo("Creates and fills tables in test database ...");
            originalTp2Init.fillTables(this.connection, n2);
            this.connection.commit();
        } else {
            this.log.addInfo("Skip create and fill tables");
        }
        if (bl2) {
            this.log.addInfo("Option \"loadData\" is set - skip running the benchmark");
            return;
        }
        originalTp2Init.putTestTablesInCache(this.connection);
        if (this.debug) {
            System.out.println("init user threads");
        }
        SimulatedUser.setWaitingForBegin(true);
        JavaUser[] javaUserArray = new JavaUser[this.users];
        for (n = 0; n < javaUserArray.length; ++n) {
            javaUserArray[n] = new OriginalTp2JavaUser(n + 1, this);
            javaUserArray[n].runUser();
        }
        if (this.debug) {
            System.out.println("wait for user threads");
        }
        n = 1;
        while (n != 0) {
            for (int i = 0; i < javaUserArray.length; ++i) {
                if (javaUserArray[i].getCurrentState() != 2) {
                    n = 1;
                    if (!this.debug) break;
                    System.out.println("user " + javaUserArray[i] + " not ready current state: " + javaUserArray[i].getCurrentState());
                    break;
                }
                if (this.debug) {
                    System.out.println("user " + javaUserArray[i] + " ready");
                }
                n = 0;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        SimulatedUser.setWaitingForBegin(false);
        if (this.debug) {
            System.out.println("waiting for end of messurement ...");
        }
        for (int i = 0; i < javaUserArray.length; ++i) {
            Thread thread = javaUserArray[i].getThread();
            try {
                thread.join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.debug) {
            System.out.println("all user finished ...");
        }
        TP2Result.dump(this.log);
    }

    public long getTestDuration() {
        return this.duration;
    }

    public AccessType getAccessType() throws SQLException {
        return this.accessType;
    }

    public int getTransacImpl() {
        return 32;
    }

    public LogWriter getLog() {
        return this.log;
    }

    public SapDBOptions getOptions() {
        return this.options;
    }

    public synchronized void preStoreResults(int n, long l, int n2, int n3) throws SQLException {
        new TP2Result(n, l, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        TP2 tP2 = new TP2(stringArray);
        try {
            tP2.runInner();
        }
        finally {
            tP2.connection.close();
        }
        if (tP2.log.hasErrors()) {
            System.exit(5);
        }
    }
}

