/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities.webdav.protocol;

import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVFile;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class WebDAVSAXParser
extends DefaultHandler {
    Vector v = null;
    int mode;
    boolean isDirectory;
    boolean doParse = false;
    static final String DIRECTORY = "sapdbwww/directory";
    String sBuffer;
    String name;
    long size;
    public static final int ALL = 0;
    public static final int COLLECTION = 1;
    public static final int FILE = 2;
    public static final int SIZE = 3;

    public WebDAVSAXParser(Vector v, int mode) {
        this.v = v;
        this.mode = mode;
    }

    public void characters(char[] pBuffer, int pStart, int pLength) {
        if (this.doParse) {
            this.sBuffer = this.sBuffer == null ? new String(pBuffer, pStart, pLength) : this.sBuffer + new String(pBuffer, pStart, pLength);
        }
    }

    public void endDocument() {
    }

    public void endElement(String pNamespaceURL, String pLocalName, String pQName) {
        if (this.doParse) {
            if (pLocalName.equals("getcontentlength")) {
                try {
                    this.size = Long.parseLong(this.sBuffer);
                }
                catch (NumberFormatException nfe) {
                    System.err.println(nfe);
                    this.size = -1L;
                }
            } else if (pLocalName.equals("getcontenttype")) {
                this.isDirectory = this.sBuffer.equals(DIRECTORY);
            } else if (pLocalName.equals("displayname")) {
                this.name = this.sBuffer;
            }
        }
        if (pLocalName.equals("response")) {
            if (this.mode == 1 && this.isDirectory) {
                this.v.add(this.name);
            } else if (this.mode == 2 && !this.isDirectory) {
                this.v.add(new WebDAVFile(this.name, this.size));
            } else if (this.mode == 0) {
                if (this.isDirectory) {
                    this.v.add(this.name);
                } else {
                    this.v.add(new WebDAVFile(this.name, this.size));
                }
            }
        }
    }

    public void error(SAXParseException exception) {
        System.err.println("ERROR: line " + exception.getLineNumber() + ": " + exception.getMessage());
    }

    public void fatalError(SAXParseException exception) throws SAXParseException {
        System.err.println("FATAL: line " + exception.getLineNumber() + ": " + exception.getMessage());
        throw exception;
    }

    public static void parse(File pFile, Vector v, int mode) throws IOException, SAXException {
        SAXParser parser = new SAXParser();
        WebDAVSAXParser handler = new WebDAVSAXParser(v, mode);
        parser.setContentHandler(handler);
        parser.setErrorHandler(handler);
        FileReader fr = new FileReader(pFile);
        InputSource input = new InputSource(fr);
        parser.parse(input);
        fr.close();
        if (!pFile.delete()) {
            System.err.println("Could not delete temp file \"" + pFile.toString() + "\"");
        }
    }

    public void startDocument() {
    }

    public void startElement(String pNamespaceURL, String pLocalName, String pQName, Attributes pAttributes) {
        this.sBuffer = null;
        if (pLocalName.equals("response")) {
            this.isDirectory = false;
            this.name = null;
            this.size = 0L;
        }
        this.doParse = pLocalName.equals("getcontentlength") || pLocalName.equals("getcontenttype") || pLocalName.equals("displayname");
    }

    public void warning(SAXParseException exception) {
        System.err.println("WARNING: line " + exception.getLineNumber() + ": " + exception.getMessage());
    }
}

