/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities.webdav;

import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVException;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVFile;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVTimoutHandler;
import java.io.File;
import java.net.URL;
import java.util.Vector;

public class WebDAVClient {
    protected WebDAVTimoutHandler timeoutHandler = null;
    protected Thread mThread = null;
    URL webDAVServerURL = null;
    String url = null;
    int standardTimeout = 60;
    protected long lastSize = 0L;
    protected Vector lastSizeVector = null;
    protected Vector fileInformations = null;
    public static final int ALL = 0;
    public static final int COLLECTION = 1;
    public static final int FILE = 2;

    public WebDAVClient(URL webDAVServer) {
        this.webDAVServerURL = webDAVServer;
        this.timeoutHandler = new WebDAVTimoutHandler(webDAVServer);
    }

    public boolean create(String resource) throws WebDAVException {
        return this.create(resource, this.standardTimeout);
    }

    public boolean create(String resource, int timeout) throws WebDAVException {
        this.timeoutHandler.setActionCreate(resource);
        this.mThread = new Thread(this.timeoutHandler);
        this.mThread.setDaemon(true);
        this.mThread.start();
        try {
            this.mThread.join(timeout * 1000);
            if (this.mThread.isAlive()) {
                throw new WebDAVException(900, "Server Timeout (" + timeout + "s)");
            }
            if (this.timeoutHandler.getStatusCode() == -1) {
                throw new WebDAVException(-1, "Serverstatus Unknown");
            }
            return this.timeoutHandler.getResult();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public boolean exists(String resource) throws WebDAVException {
        return this.exists(resource, this.standardTimeout);
    }

    public boolean exists(String resource, int timeout) throws WebDAVException {
        this.timeoutHandler.setActionExists(resource);
        this.mThread = new Thread(this.timeoutHandler);
        this.mThread.setDaemon(true);
        this.mThread.start();
        try {
            this.mThread.join(timeout * 1000);
            if (this.mThread.isAlive()) {
                throw new WebDAVException(900, "Server Timeout (" + timeout + "s)");
            }
            if (this.timeoutHandler.getStatusCode() == -1) {
                throw new WebDAVException(-1, "Serverstatus Unknown");
            }
            return this.timeoutHandler.getResult();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public boolean download(String resource, File destination) throws WebDAVException {
        return this.download(resource, destination, this.standardTimeout);
    }

    public boolean download(String resource, File destination, int timeout) throws WebDAVException {
        this.timeoutHandler.setActionDownload(resource, destination);
        this.mThread = new Thread(this.timeoutHandler);
        this.mThread.setDaemon(true);
        this.mThread.start();
        try {
            this.mThread.join(timeout * 1000);
            if (this.mThread.isAlive()) {
                throw new WebDAVException(900, "Server Timeout (" + timeout + "s)");
            }
            if (this.timeoutHandler.getStatusCode() == -1) {
                throw new WebDAVException(-1, "Serverstatus Unknown");
            }
            return this.timeoutHandler.getResult();
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    public boolean upload(File file, String resource) throws WebDAVException {
        return this.upload(file, resource, this.standardTimeout);
    }

    public boolean upload(File file, String resource, int timeout) throws WebDAVException {
        this.timeoutHandler.setActionUpload(file, resource);
        this.mThread = new Thread(this.timeoutHandler);
        this.mThread.setDaemon(true);
        this.mThread.start();
        try {
            this.mThread.join(timeout * 1000);
            if (this.mThread.isAlive()) {
                throw new WebDAVException(900, "Server Timeout (" + timeout + "s)");
            }
            if (this.timeoutHandler.getStatusCode() == -1) {
                throw new WebDAVException(-1, "Serverstatus Unknown");
            }
            return this.timeoutHandler.getResult();
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    public boolean upload(String content, String resource) throws WebDAVException {
        return this.upload(content, resource, this.standardTimeout);
    }

    public boolean upload(String content, String resource, int timeout) throws WebDAVException {
        this.timeoutHandler.setActionUpload(content, resource);
        this.mThread = new Thread(this.timeoutHandler);
        this.mThread.setDaemon(true);
        this.mThread.start();
        try {
            this.mThread.join(timeout * 1000);
            if (this.mThread.isAlive()) {
                throw new WebDAVException(900, "Server Timeout (" + timeout + "s)");
            }
            if (this.timeoutHandler.getStatusCode() == -1) {
                throw new WebDAVException(-1, "Serverstatus Unknown");
            }
            return this.timeoutHandler.getResult();
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    public Vector list(String resource) throws WebDAVException {
        return this.list(resource, 0, this.standardTimeout);
    }

    public Vector list(String resource, int mode) throws WebDAVException {
        return this.list(resource, mode, this.standardTimeout);
    }

    public Vector list(String resource, int mode, int timeout) throws WebDAVException {
        Vector vOrg = null;
        Vector<String> vNames = new Vector<String>();
        Vector vFiles = new Vector();
        this.timeoutHandler.setActionList(resource, mode);
        this.mThread = new Thread(this.timeoutHandler);
        this.mThread.setDaemon(true);
        this.mThread.start();
        try {
            this.mThread.join(timeout * 1000);
            if (this.mThread.isAlive()) {
                throw new WebDAVException(900, "Server Timeout (" + timeout + "s)");
            }
            this.lastSize = -1L;
            if (this.timeoutHandler.getStatusCode() == -1) {
                throw new WebDAVException(-1, "Serverstatus Unknown");
            }
            vOrg = this.timeoutHandler.getVector();
            if (vOrg != null) {
                for (int i = 0; i < vOrg.size(); ++i) {
                    Object obj = vOrg.get(i);
                    if (obj instanceof WebDAVFile) {
                        vNames.add(((WebDAVFile)obj).getName());
                        vFiles.add(obj);
                        continue;
                    }
                    vNames.add((String)obj);
                }
            }
            this.fileInformations = vFiles;
            return vNames;
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    public long getLastSize() {
        if (this.lastSize == -1L) {
            if (this.fileInformations != null) {
                this.lastSize = 0L;
            }
            for (int i = 0; i < this.fileInformations.size(); ++i) {
                this.lastSize += ((WebDAVFile)this.fileInformations.get(i)).getSize();
            }
        }
        return this.lastSize;
    }

    public Vector getLastSizeVector() {
        return this.fileInformations;
    }

    public void setStandardTimeout(int timeout) {
        this.standardTimeout = timeout;
    }
}

