/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.sapdb.testframe.testcase.ColumnDescriptor;
import com.sap.sapdb.testframe.utilities.Field;

public final class TableField
extends Field {
    private String mType;
    private int mLength = -1;
    private int mPosition;
    private boolean mPrimaryKey = false;
    private boolean mRandom = true;
    private String mDefaultValue = "";
    private boolean mForeignKey = false;
    private boolean mUnique;
    private int mDecimals = -1;
    private int mTypeInternal;
    private long mMaxRandomValue = -1L;
    private long mMinRandomValue = -1L;
    private boolean mByte = false;
    private int mMaxRandomLength;
    private String mLastValue;

    public TableField(String pName, String pType, boolean pByte, int pLength, int pDecimals, int pPosition, boolean pPrimaryKey, boolean pRandom, String pDefaultValue, boolean pUnique, long pMinRandomValue, long pMaxRandomValue) {
        super(pName);
        this.mType = pType;
        this.mByte = pByte;
        this.mLength = pLength;
        this.mDecimals = pDecimals;
        this.mPosition = pPosition;
        this.mPrimaryKey = pPrimaryKey;
        this.mRandom = pRandom;
        this.mDefaultValue = pDefaultValue;
        this.mUnique = pUnique;
        this.mTypeInternal = !this.mByte ? ColumnDescriptor.getType(pType) : ColumnDescriptor.getType(pType + "byte");
        this.mMaxRandomValue = pMaxRandomValue;
        this.mMinRandomValue = pMinRandomValue;
    }

    public final int getDecimals() {
        return this.mDecimals;
    }

    public final String getDefaultValue() {
        return this.mDefaultValue;
    }

    public String getLastValue() {
        return this.mLastValue;
    }

    public final int getLength() {
        return this.mLength;
    }

    public final int getMaxRandomLength() {
        return this.mMaxRandomLength;
    }

    public final long getMaxRandomValue() {
        return this.mMaxRandomValue;
    }

    public final long getMinRandomValue() {
        return this.mMinRandomValue;
    }

    public final int getPosition() {
        return this.mPosition;
    }

    public final String getType() {
        return this.mType;
    }

    final int getTypeInternal() {
        return this.mTypeInternal;
    }

    public final boolean isByte() {
        return this.mByte;
    }

    public final boolean isForeignKey() {
        return this.mForeignKey;
    }

    public final boolean isPrimaryKey() {
        return this.mPrimaryKey;
    }

    public final boolean isRandom() {
        return this.mRandom;
    }

    public final boolean isUnique() {
        return this.mUnique;
    }

    public void setByte(boolean newByte) {
        this.mByte = newByte;
    }

    public void setDecimals(int newDecimals) {
        this.mDecimals = newDecimals;
    }

    public void setDefaultValue(String newDefaultValue) {
        this.mDefaultValue = newDefaultValue;
    }

    public void setForeignKey(boolean newForeignKey) {
        this.mForeignKey = newForeignKey;
    }

    void setLastValue(String newLastValue) {
        this.mLastValue = newLastValue;
    }

    public void setLength(int newLength) {
        this.mLength = newLength;
    }

    public void setMaxRandomLength(int newMaxRandomLength) {
        this.mMaxRandomLength = newMaxRandomLength;
    }

    public void setMaxRandomValue(long newMaxRandomValue) {
        this.mMaxRandomValue = newMaxRandomValue;
    }

    public void setMinRandomValue(long newMinRandomValue) {
        this.mMinRandomValue = newMinRandomValue;
    }

    public void setPosition(int newPosition) {
        this.mPosition = newPosition;
    }

    public void setPrimaryKey(boolean newPrimaryKey) {
        this.mPrimaryKey = newPrimaryKey;
    }

    public void setRandom(boolean newRandom) {
        this.mRandom = newRandom;
    }

    public void setType(String newType) {
        this.mType = newType;
    }

    void setTypeInternal(int newTypeInternal) {
        this.mTypeInternal = newTypeInternal;
    }

    public void setUnique(boolean newUnique) {
        this.mUnique = newUnique;
    }
}

