/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.ColumnDescriptor;
import java.util.ArrayList;
import java.util.Iterator;

public class VerificationDataIterator
implements Iterator {
    protected int mCurrentPos = 0;
    protected int mNumberOfRows = 0;
    protected int mNumberOfColumns;
    protected ArrayList mValues;
    protected ArrayList mColumnDescriptions;
    protected boolean mColumnNamesDefined = false;
    protected boolean mIsQuickFormat = false;

    protected VerificationDataIterator() {
    }

    VerificationDataIterator(ArrayList Values2, ArrayList ColumnDescriptions, boolean ColumnNamesDefined) {
        this();
        this.mNumberOfRows = Values2.size();
        this.mNumberOfColumns = ColumnDescriptions.size();
        this.mColumnDescriptions = ColumnDescriptions;
        this.mValues = Values2;
        this.mColumnNamesDefined = ColumnNamesDefined;
        this.mCurrentPos = this.mColumnNamesDefined ? -1 : 0;
    }

    VerificationDataIterator(ArrayList Values2, ArrayList ColumnDescriptions, boolean ColumnNamesDefined, boolean IsQuickFormat) {
        this(Values2, ColumnDescriptions, ColumnNamesDefined);
        this.mIsQuickFormat = IsQuickFormat;
    }

    protected static void appendNChars(StringBuffer Dest, char TheChar, int Number2) {
        for (int i = 0; i < Number2; ++i) {
            Dest.append(TheChar);
        }
    }

    public boolean hasNext() {
        return this.mCurrentPos < this.mNumberOfRows;
    }

    public Object next() {
        StringBuffer ResultRow = new StringBuffer(1024);
        if (this.mIsQuickFormat) {
            String Result = (String)this.mValues.get(this.mCurrentPos);
            ++this.mCurrentPos;
            return Result;
        }
        if (this.mCurrentPos == -1) {
            ResultRow.append('[');
            for (int i = 0; i < this.mNumberOfColumns; ++i) {
                ResultRow.append(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getName());
                ResultRow.append(':');
                ResultRow.append(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getTypeName());
                if (i >= this.mNumberOfColumns - 1) continue;
                ResultRow.append(',');
            }
            ResultRow.append(']');
        } else {
            ResultRow.append('(');
            ArrayList Row = (ArrayList)this.mValues.get(this.mCurrentPos);
            for (int i = 0; i < this.mNumberOfColumns; ++i) {
                Object Value = Row.get(i);
                if (Value == null) {
                    ResultRow.append("NULL");
                } else if (ColumnDescriptor.isString(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getType())) {
                    ResultRow.append('\'');
                    ResultRow.append(Value);
                    ResultRow.append('\'');
                } else if (ColumnDescriptor.isNumeric(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getType())) {
                    ResultRow.append(Value);
                } else if (ColumnDescriptor.isBinary(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getType())) {
                    ResultRow.append('X');
                    ResultRow.append(Value);
                }
                if (i >= this.mNumberOfColumns - 1) continue;
                ResultRow.append(',');
            }
            ResultRow.append(')');
        }
        ++this.mCurrentPos;
        return ResultRow.toString();
    }

    public void remove() {
    }
}

