/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.driver;

import com.sap.sapdb.testframe.driver.TestDatabaseSapDevice;
import com.sap.sapdb.testframe.driver.TestDriverConstants;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestDriverConfiguration
extends DefaultHandler
implements TestDriverConstants {
    private HashMap mDBParameterMap = null;
    private ArrayList mDBDeviceList = null;
    private HashMap mConfig = new HashMap();
    private StringBuffer mContent = null;
    private Attributes mAttributes = null;
    private TestDatabaseSapDevice mDBDevice = null;
    private String mKind = null;
    private String mParamName = null;
    private String mParamValue = null;
    private String mUserName = null;
    private String mUserPasword = null;
    private boolean mIsTestResult = false;
    private boolean mIsSaveResult = false;
    private Properties jdbcProperties = null;
    private Vector databasecommands = null;
    private Vector dbmsrvcommands = null;

    public void characters(char[] pBuffer, int pStart, int pLength) {
        this.mContent.append(pBuffer, pStart, pLength);
    }

    public void endDocument() {
    }

    public void endElement(String pNamespaceURL, String pLocalName, String pQName) {
        if (pLocalName.equals("db-name")) {
            if (this.mIsTestResult) {
                this.put(this.mConfig, "ResultDBName", this.mContent.toString().trim().toUpperCase());
            } else if (this.mIsSaveResult) {
                this.put(this.mConfig, "SaveDBName", this.mContent.toString().trim().toUpperCase());
            } else {
                this.put(this.mConfig, "DBName", this.mContent.toString().trim().toUpperCase());
            }
        } else if (pLocalName.equals("db-host")) {
            if (this.mIsTestResult) {
                this.put(this.mConfig, "ResultDBHost", this.mContent.toString().trim());
            } else if (this.mIsSaveResult) {
                this.put(this.mConfig, "SaveDBHost", this.mContent.toString().trim());
            } else {
                this.put(this.mConfig, "DBHost", this.mContent.toString().trim());
            }
        } else if (pLocalName.equals("db-type")) {
            this.put(this.mConfig, "DBType", this.mContent.toString().trim());
        } else if (pLocalName.equals("webdav-host")) {
            if (this.mIsSaveResult) {
                this.put(this.mConfig, "SaveWebdav-host", this.mContent.toString().trim());
            }
        } else if (pLocalName.equals("sqlservice-url")) {
            if (this.mIsSaveResult) {
                this.put(this.mConfig, "sql-service-url", this.mContent.toString().trim());
            }
        } else if (pLocalName.equals("monitor-host")) {
            if (this.mIsSaveResult) {
                this.put(this.mConfig, "Monitor-Host", this.mContent.toString().trim());
            }
        } else if (pLocalName.equals("user-name")) {
            if (this.mIsSaveResult) {
                this.put(this.mConfig, "SaveDBUser", this.mContent.toString().trim());
            } else {
                this.mUserName = this.mContent.toString().trim();
            }
        } else if (pLocalName.equals("user-password")) {
            if (this.mIsSaveResult) {
                this.put(this.mConfig, "SaveDBUser-password", this.mContent.toString().trim());
            } else {
                this.mUserPasword = this.mContent.toString().trim();
            }
        } else if (pLocalName.equals("user")) {
            if (this.mKind.equalsIgnoreCase("DBM")) {
                this.put(this.mConfig, "DBMUser", this.mUserName);
                this.put(this.mConfig, "DBMPwd", this.mUserPasword);
            } else if (this.mKind.equalsIgnoreCase("DBA")) {
                this.put(this.mConfig, "DBAUser", this.mUserName);
                this.put(this.mConfig, "DBAPwd", this.mUserPasword);
            } else if (this.mKind.equalsIgnoreCase("OS")) {
                this.put(this.mConfig, "OSUser", this.mUserName);
                this.put(this.mConfig, "OSPwd", this.mUserPasword);
            }
            this.mKind = null;
            this.mUserName = null;
            this.mUserPasword = null;
        } else if (pLocalName.equals("db-kernel-mode")) {
            this.put(this.mConfig, "DBMode", this.mContent.toString().trim());
        } else if (pLocalName.equals("db-trace")) {
            if (this.mKind != null) {
                if (this.mKind.equalsIgnoreCase("OLTP")) {
                    this.mConfig.put("DBOltpTrace", Boolean.TRUE);
                }
                if (this.mKind.equalsIgnoreCase("OMS")) {
                    this.mConfig.put("DBOmsTrace", Boolean.TRUE);
                }
                if (this.mKind.equalsIgnoreCase("JDBC")) {
                    this.mConfig.put("DBJdbcTrace", Boolean.TRUE);
                }
            }
            this.mKind = null;
        } else if (pLocalName.equals("db-additional-trace")) {
            this.put(this.mConfig, "DBAdditionalTrace", this.mContent.toString().trim());
        } else if (pLocalName.equals("database-command")) {
            if (this.databasecommands == null) {
                this.databasecommands = new Vector();
            }
            this.databasecommands.add(this.mContent.toString().trim());
            this.mConfig.put("Database_Command", this.databasecommands);
        } else if (pLocalName.equals("dbmsrv-command")) {
            if (this.dbmsrvcommands == null) {
                this.dbmsrvcommands = new Vector();
            }
            this.dbmsrvcommands.add(this.mContent.toString().trim());
            this.mConfig.put("DBMsrv_Command", this.dbmsrvcommands);
        } else if (pLocalName.equals("jdbc-property")) {
            if (this.jdbcProperties == null) {
                this.jdbcProperties = new Properties();
            }
            if (this.mAttributes.getValue("prop") != null) {
                this.jdbcProperties.put(this.mAttributes.getValue("prop").trim(), this.mAttributes.getValue("value").trim());
                this.mConfig.put("JDBC_Property", this.jdbcProperties);
            }
        } else if (pLocalName.equals("db-root")) {
            this.put(this.mConfig, "DBRoot", this.mContent.toString().trim());
        } else if (pLocalName.equals("db-size")) {
            this.put(this.mConfig, "DBSize", this.mContent.toString().trim());
        } else if (pLocalName.equals("db-create-mode")) {
            if (this.mContent.toString().trim().equalsIgnoreCase("FORCE")) {
                this.mConfig.put("DBForce", Boolean.TRUE);
            } else if (this.mContent.toString().trim().equalsIgnoreCase("OFF")) {
                this.mConfig.put("DBGenerate", Boolean.FALSE);
            } else if (this.mContent.toString().trim().equalsIgnoreCase("NONE")) {
                this.mConfig.put("DBNone", Boolean.TRUE);
                this.mConfig.put("DBKind", "NONE");
                this.mConfig.put("DBForce", Boolean.FALSE);
                this.mConfig.put("DBGenerate", Boolean.FALSE);
                this.mConfig.put("DBType", "NONE");
            }
        } else if (pLocalName.equals("db-destroy-mode")) {
            if (this.mContent.toString().trim().equalsIgnoreCase("KEEP")) {
                this.mConfig.put("DBKeep", Boolean.TRUE);
            } else if (this.mContent.toString().trim().equalsIgnoreCase("DROP")) {
                this.mConfig.put("DBDrop", Boolean.TRUE);
            } else if (this.mContent.toString().trim().equalsIgnoreCase("DOS") || this.mContent.toString().trim().equalsIgnoreCase("DROP_ON_SUCCESS")) {
                this.mConfig.put("DBKeep", Boolean.FALSE);
                this.mConfig.put("DBDrop", Boolean.FALSE);
            }
        } else if (pLocalName.equals("db-keep-state")) {
            this.put(this.mConfig, "DBKeepState", this.mContent.toString().trim().toUpperCase());
        } else if (pLocalName.equals("param-name")) {
            this.mParamName = this.mContent.toString().trim();
        } else if (pLocalName.equals("param-value")) {
            this.mParamValue = this.mContent.toString().trim();
        } else if (pLocalName.equals("db-param")) {
            if (this.mParamName != null && this.mParamValue != null) {
                if (this.mDBParameterMap == null) {
                    this.mDBParameterMap = new HashMap();
                }
                this.put(this.mDBParameterMap, this.mParamName, this.mParamValue);
            }
            this.mParamName = null;
            this.mParamValue = null;
        } else if (pLocalName.equals("dev-name") && this.mDBDevice != null) {
            this.mDBDevice.setName(this.mContent.toString().trim());
        } else if (pLocalName.equals("dev-number") && this.mDBDevice != null) {
            this.mDBDevice.setNumber(Integer.parseInt(this.mContent.toString()));
        } else if (pLocalName.equals("dev-size") && this.mDBDevice != null) {
            this.mDBDevice.setSize(Integer.parseInt(this.mContent.toString()));
        } else if (pLocalName.equals("dev-type") && this.mDBDevice != null) {
            this.mDBDevice.setType(this.mContent.toString().trim());
        } else if (pLocalName.equals("db-device") && this.mDBDevice != null) {
            if (this.mDBDeviceList == null) {
                this.mDBDeviceList = new ArrayList();
            }
            this.mDBDeviceList.add(this.mDBDevice);
            this.mDBDevice = null;
        } else if (pLocalName.equals("test-input-dir")) {
            this.put(this.mConfig, "ParameterInputDir", this.mContent.toString().trim());
        } else if (pLocalName.equals("test-repetition-rate")) {
            this.put(this.mConfig, "RepetitionRate", this.mContent.toString().trim());
        } else if (pLocalName.equals("test-parallel-rate")) {
            this.put(this.mConfig, "ParallelRate", this.mContent.toString().trim());
        } else if (pLocalName.equals("test-mode")) {
            this.put(this.mConfig, "TestMode", this.mContent.toString().trim());
            if (this.mAttributes.getValue("label") != null) {
                this.put(this.mConfig, "TestLabel", this.mAttributes.getValue("label").trim());
            }
        } else if (pLocalName.equals("test-results-save")) {
            this.mConfig.put("SaveResult", Boolean.TRUE);
        } else if (pLocalName.equals("test-results")) {
            this.mIsTestResult = false;
        } else if (pLocalName.equals("save-result")) {
            this.mIsSaveResult = false;
        } else if (pLocalName.equals("test-verification")) {
            this.mConfig.put("VerificationTrace", Boolean.TRUE);
        } else if (pLocalName.equals("test-verification-result")) {
            this.mConfig.put("VerificationTraceWithResult", Boolean.TRUE);
        } else if (pLocalName.equals("test-verification-explain")) {
            this.mConfig.put("VerificationTraceWithExplain", Boolean.TRUE);
        } else if (pLocalName.equals("test-exception-traceback")) {
            this.mConfig.put("ExceptionTraceback", Boolean.TRUE);
        } else if (pLocalName.equals("protocol-output")) {
            this.put(this.mConfig, "ProtocolOutput", this.mContent.toString().trim());
        } else if (pLocalName.equals("protocol-async")) {
            this.mConfig.put("ProtocolAsync", Boolean.TRUE);
        } else if (pLocalName.equals("protocol-info-filter")) {
            this.mConfig.put("ProtocolInfoFilter", Boolean.TRUE);
        } else if (pLocalName.equals("filter-summary")) {
            this.mConfig.put("ProtocolFilterSummary", Boolean.TRUE);
        } else if (pLocalName.equals("files-to-upload")) {
            this.mConfig.put("files-to-upload", this.mContent.toString().trim());
        } else if (pLocalName.equals("responsible")) {
            this.put(this.mConfig, "Responsible", this.mContent.toString().trim());
        } else if (pLocalName.equals("mailsizelimit")) {
            this.put(this.mConfig, "MailSizeLimit", this.mContent.toString().trim());
        } else if (pLocalName.equals("mailsubject")) {
            this.put(this.mConfig, "MailSubject", this.mContent.toString().trim());
        } else if (pLocalName.equals("individual")) {
            this.mConfig.put("MailIndividual", Boolean.TRUE);
        } else if (pLocalName.equals("test-frame-trace")) {
            this.mConfig.put("TestFrameTrace", Boolean.TRUE);
        } else if (pLocalName.equals("restart")) {
            this.mConfig.put("Restart", this.mContent.toString().trim());
        } else if (pLocalName.equals("monitor")) {
            this.mConfig.put("Monitor", Boolean.TRUE);
        } else if (pLocalName.equals("nomonitor")) {
            this.mConfig.put("NoMonitor", Boolean.TRUE);
        } else if (pLocalName.equals("no-webdav")) {
            this.mConfig.put("NoWebdav", Boolean.TRUE);
        } else if (pLocalName.equals("noknldiag")) {
            this.mConfig.put("NoKnldiag", Boolean.TRUE);
        } else if (pLocalName.equals("novtrace")) {
            this.mConfig.put("NoVtrace", Boolean.TRUE);
        } else if (pLocalName.equals("knldump")) {
            this.mConfig.put("knldump", Boolean.TRUE);
        } else if (pLocalName.equals("zipattachment")) {
            this.mConfig.put("ZipAttachment", this.mContent.toString().trim());
        } else if (pLocalName.equals("db-port")) {
            this.mConfig.put("db-port", this.mContent.toString().trim());
        }
    }

    public void error(SAXParseException exception) {
        System.err.println("ERROR: line " + exception.getLineNumber() + ": " + exception.getMessage());
    }

    public void fatalError(SAXParseException exception) throws SAXParseException {
        System.err.println("FATAL: line " + exception.getLineNumber() + ": " + exception.getMessage());
        throw exception;
    }

    public HashMap getConfiguration() {
        return this.mConfig;
    }

    public void setConfiguration(HashMap pConfiguration) {
        this.mConfig = new HashMap(pConfiguration);
    }

    public void setConfiguration(Properties pConfiguration) {
        this.mConfig = new HashMap<Object, Object>(pConfiguration);
    }

    public Object getConfigValue(String pName) {
        return this.mConfig.get(pName);
    }

    public void setConfigValue(String pName, Object pValue) {
        this.mConfig.put(pName, pValue);
    }

    public ArrayList getDBDeviceList() {
        if (this.mDBDeviceList != null && this.mDBDeviceList.isEmpty()) {
            return null;
        }
        return this.mDBDeviceList;
    }

    public void setDBDeviceList(ArrayList pDBDeviceList) {
        this.mDBDeviceList = new ArrayList(pDBDeviceList);
    }

    public HashMap getDBParameterMap() {
        return this.mDBParameterMap;
    }

    public void setDBParameterMap(HashMap pParameterMap) {
        this.mDBParameterMap = new HashMap(pParameterMap);
    }

    public String getDBParameterValue(String pName) {
        return (String)this.mDBParameterMap.get(pName);
    }

    public boolean isDBParametersEmpty() {
        return this.mDBParameterMap.isEmpty();
    }

    public boolean isEmpty() {
        return this.mConfig.isEmpty();
    }

    public static void main(String[] args) {
        try {
            TestDriverConfiguration config = new TestDriverConfiguration();
            config.parse(new File(System.getProperty("user.dir") + System.getProperty("file.separator") + args[0]));
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        catch (SAXException e) {
            System.err.println(e.getMessage());
        }
    }

    public void parse(File pFile) throws IOException, SAXException {
        SAXParser parser = new SAXParser();
        parser.setFeature("http://xml.org/sax/features/validation", true);
        parser.setContentHandler(this);
        parser.setErrorHandler(this);
        InputSource input = new InputSource(new FileReader(pFile));
        parser.parse(input);
    }

    private void put(HashMap pConfig, String pName, String pValue) {
        if (pName == null) {
            return;
        }
        if (pValue == null || pValue.length() == 0) {
            return;
        }
        if (pConfig == null) {
            return;
        }
        pConfig.put(pName, pValue);
    }

    public void startDocument() {
        this.mContent = new StringBuffer();
    }

    public void startElement(String pNamespaceURL, String pLocalName, String pQName, Attributes pAttributes) {
        this.mContent.setLength(0);
        this.mAttributes = pAttributes;
        if (pLocalName.equals("user") && this.mAttributes != null && this.mAttributes.getValue("kind") != null) {
            this.mKind = this.mAttributes.getValue("kind").trim();
        }
        if (pLocalName.equals("new") && this.mAttributes != null && this.mAttributes.getValue("kind") != null) {
            this.mConfig.put("DBGenerate", Boolean.TRUE);
            this.mConfig.put("DBKind", this.mAttributes.getValue("kind").trim());
        }
        if (pLocalName.equals("db-device") && this.mAttributes != null && this.mAttributes.getValue("kind") != null) {
            this.mDBDevice = new TestDatabaseSapDevice();
            this.mDBDevice.setKind(this.mAttributes.getValue("kind").trim());
        }
        if (pLocalName.equals("db-trace") && this.mAttributes != null && this.mAttributes.getValue("kind") != null) {
            this.mKind = this.mAttributes.getValue("kind").trim();
        }
        if (pLocalName.equals("test-results")) {
            this.mIsTestResult = true;
        }
        if (pLocalName.equals("save-result")) {
            this.mIsSaveResult = true;
        }
    }

    public void warning(SAXParseException exception) {
        System.err.println("WARNING: line " + exception.getLineNumber() + ": " + exception.getMessage());
    }
}

