########################################################################
#
# File Name:            Text.py
#
# Documentation:        http://docs.4suite.com/4DOM/Text.py.html
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

"""
WWW: http://4suite.com/4DOM         e-mail: support@4suite.com

Copyright (c) 2000 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.com/COPYRIGHT  for license and copyright information
"""

from CharacterData import CharacterData

from xml.dom import Node
from xml.dom import IndexSizeErr

class Text(CharacterData):
    nodeType = Node.TEXT_NODE

    def __init__(self, ownerDocument, data):
        CharacterData.__init__(self, ownerDocument, data)
        self.__dict__['__nodeName'] = '#text'

    ### Methods ###

    def splitText(self, offset):
        if not (0 < offset < self.length):
            raise IndexSizeErr()
        data = self.data
        first = data[:int(offset)]
        second = data[int(offset):]
        node = self.ownerDocument.createTextNode(second)
        self._set_data(first)
        parent = self.parentNode
        if parent:
            sibling = self.nextSibling
            if sibling:
                parent.insertBefore(node, self.nextSibling)
            else:
                parent.appendChild(node)
        return node
