########################################################################
#
# File Name:            ProcessingInstruction.py
#
# Documentation:        http://docs.4suite.com/4DOM/ProcessingInstruction.py.html
#
#    ========== licence begin  GPL
#    Copyright (c) 2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

"""
WWW: http://4suite.com/4DOM         e-mail: support@4suite.com

Copyright (c) 2000 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.com/COPYRIGHT  for license and copyright information
"""

from xml.dom import Node, EMPTY_NAMESPACE
from FtNode import FtNode

class ProcessingInstruction(FtNode):
    nodeType = Node.PROCESSING_INSTRUCTION_NODE

    def __init__(self,ownerDocument,target,data):
        FtNode.__init__(self,ownerDocument,EMPTY_NAMESPACE,'','')
        self.__dict__['__nodeName'] = target
        self.__dict__['__nodeValue'] = data

    def _get_target(self):
        return self.__dict__['__nodeName']

    def _get_data(self):
        return self.__dict__['__nodeValue']

    def _set_data(self, newData):
        self.__dict__['__nodeValue'] = newData

    ### Overridden Methods ###

    def __repr__(self):
        data = self.data
        if len(data) > 20:
            data = data[20:] + '...'
        return "<ProcessingInstruction at %x: target='%s' data='%s'>" % (
            id(self),
            self.target,
            data
            )

    ### Helper Functions For Cloning ###

    def _4dom_clone(self, owner):
        return self.__class__(owner, self.target, self.data)

    def __getinitargs__(self):
        return (self.ownerDocument,
                self.target,
                self.data
                )

    ### Attribute Access Mappings ###

    _readComputedAttrs = FtNode._readComputedAttrs.copy()
    _readComputedAttrs.update({'target':_get_target,
                               'data':_get_data
                               })


    _writeComputedAttrs = FtNode._writeComputedAttrs.copy()
    _writeComputedAttrs.update({'data':_set_data
                                })

    # Create the read-only list of attributes
    _readOnlyAttrs = filter(lambda k,m=_writeComputedAttrs: not m.has_key(k),
                            FtNode._readOnlyAttrs + _readComputedAttrs.keys())
