/* ==================================================================
 *
 * responsible:   Bernd Vorsprach (D025588 - Bernd.Vorsprach@SAP-AG.de)
 *
 * created:       1998-02-06 by Bernd Vorsprach
 *
 * purpose:       header for param management (modules vcn2*c)
 *                               
 * ==================================================================
 *

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



 */

#ifndef _GCN002_H_
#define _GCN002_H_

#define XPARAM_NAMES_ONLY
#include "geo002.h"
#include "RunTime/Configuration/RTEConf_ParameterAccess.hpp"

/* SPECIFICATION XParam SYNTAX ERRORS - CODES AND MESSAGES
 * ------------------------------------------------------------------
 */
/* error codes */
typedef enum {
  XPOK_CN002,
  XPERR_UNKNOWN_CN002,
  XPERR_LINESEQ_CN002,
  XPERR_LINEDET_CN002,
  XPERR_INVIDLINE_CN002,
  XPERR_INVPROP_CN002,
  XPERR_INVTYPE_CN002,
  XPERR_INVNAME_CN002,
  XPERR_INVDEF_CN002,
  XPERR_INVINT_CN002,
  XPERR_LONGDEF_CN002,
  XPERR_LONGID_CN002,
  XPERR_NOTKEY_CN002,
  XPERR_TOKEN_CN002,
  XPERR_INVVALUE_CN002,
  XPERR_INVFOLLOW_CN002,
  XPERR_IFSEQ_CN002,
  XPERR_INVID_CN002,
  XPERR_INVSTMT_CN002,
  XPERR_INVTYPES_CN002,
  XPERR_INVOP_CN002,
  XPERR_OVERFL_CN002,
  XPERR_MANYOP_CN002,
  XPERR_INVCONST_CN002,
  XPERR_UNKNOWNID_CN002,
  XPERR_CRYPTUSE_CN002,
  XPERR_FEWOP_CN002,
  XPERR_INVEXPT_CN002,
  XPERR_EOF_CN002,
  XPERR_DECLAFTER_CN002,
  XPERR_DUPCONSTR_CN002,
  XPERR_DIVBYZERO_CN002,
  XPERR_DUPLICATE_CN002
} tcn002_XPError;
/* error messages (<code>,<text>) */
#define XPERROR_TO_TEXT_CN002 { \
  { XPERR_LINESEQ_CN002,   "XPERR_LINESEQ   : wrong line sequence"                }, \
  { XPERR_LINEDET_CN002,   "XPERR_LINEDET   : unknown line type"                  }, \
  { XPERR_INVIDLINE_CN002, "XPERR_INVIDLINE : invalid id line"                    }, \
  { XPERR_INVPROP_CN002,   "XPERR_INVPROP   : invalid parameter property"         }, \
  { XPERR_INVTYPE_CN002,   "XPERR_INVTYPE   : invalid parameter type"             }, \
  { XPERR_INVNAME_CN002,   "XPERR_INVNAME   : invalid parameter name"             }, \
  { XPERR_INVDEF_CN002,    "XPERR_INVDEF    : invalid default specification"      }, \
  { XPERR_INVINT_CN002,    "XPERR_INVDEF    : invalid internal value"             }, \
  { XPERR_LONGDEF_CN002,   "XPERR_LONGDEF   : default value too long"             }, \
  { XPERR_LONGID_CN002,    "XPERR_LONGID    : identifier to long"                 }, \
  { XPERR_NOTKEY_CN002,    "XPERR_NOTKEY    : unknown keyword"                    }, \
  { XPERR_TOKEN_CN002,     "XPERR_TOKEN     : unexpected token"                   }, \
  { XPERR_INVVALUE_CN002,  "XPERR_INVVALUE  : missing value after keyword"        }, \
  { XPERR_INVFOLLOW_CN002, "XPERR_INVFOLLOW : follow line sign not allowed"       }, \
  { XPERR_IFSEQ_CN002,     "XPERR_IVSEQ     : error in IF-ELSIF-ELSE sequence"    }, \
  { XPERR_INVID_CN002,     "XPERR_INVID     : invalid identifier"                 }, \
  { XPERR_INVSTMT_CN002,   "XPERR_INVSTMT   : unexpected statement"               }, \
  { XPERR_INVTYPES_CN002,  "XPERR_INVTYPES  : type mismatch"                      }, \
  { XPERR_INVOP_CN002,     "XPERR_INVOP     : invalid operator"                   }, \
  { XPERR_OVERFL_CN002,    "XPERR_OVERFL    : value overflow"                     }, \
  { XPERR_MANYOP_CN002,    "XPERR_MANYOP    : to many operands in expression"     }, \
  { XPERR_INVCONST_CN002,  "XPERR_INVCONST  : invalid constant"                   }, \
  { XPERR_UNKNOWNID_CN002, "XPERR_UNKNOWNID : unknown identifier"                 }, \
  { XPERR_CRYPTUSE_CN002,  "XPERR_CRYPTUSE  : use of crypt parameter"             }, \
  { XPERR_FEWOP_CN002,     "XPERR_FEWOP     : to few operands in expression"      }, \
  { XPERR_INVEXPT_CN002,   "XPERR_INVEXPT   : invalid type of expression"         }, \
  { XPERR_EOF_CN002,       "XPERR_EOF       : unexpected end of file"             }, \
  { XPERR_DECLAFTER_CN002, "XPERR_DECLAFTER : refers to later declared parameter" }, \
  { XPERR_DUPCONSTR_CN002, "XPERR_DUPCONSTR : duplicate constraint found"         }, \
  { XPERR_DIVBYZERO_CN002, "XPERR_DIVBYZERO : division by zero"                   }, \
  { XPERR_DUPLICATE_CN002, "XPERR_DUPLICATE : duplicate identifier found"         }, \
  { XPERR_UNKNOWN_CN002,   NULL                                                   }}

/* SPECIFICATION SYNTAX
 * ------------------------------------------------------------------
 */
/* syntax key words */
#define XP_KEY_CALC_CN002           "CALC"
#define XP_KEY_FORCE_CN002          "FORCE"
#define XP_KEY_CONSTRAINT_CN002     "CONSTRAINT"
#define XP_KEY_IF_CN002             "IF"
#define XP_KEY_ELSIF_CN002          "ELSIF"
#define XP_KEY_ELSE_CN002           "ELSE"
#define XP_KEY_ID_CN002             "ID"
#define XP_KEY_TYPE_CN002           "TYPE"
#define XP_KEY_DEFAULT_CN002        "DEFAULT"
#define XP_KEY_DEFAULTFOR_CN002     "DEFAULT_FOR"
#define XP_KEY_CODE_CN002           "CODE"
#define XP_KEY_ENDCODE_CN002        "ENDCODE"
#define XP_KEY_HELP_CN002           "HELP"
#define XP_KEY_ENDHELP_CN002        "ENDHELP"
#define XP_KEY_EXPLAIN_CN002        "EXPLAIN"
#define XP_KEY_ENDEXPLAIN_CN002     "ENDEXPLAIN"
#define XP_KEY_GOOD_CN002           "LASTKNOWNGOOD"

/* special characters an strings */
#define XP_CHAR_OLDFOLLOW_CN002     '"'
#define XP_KEY_OLDFOLLOW_CN002      "\""
#define XP_CHAR_CONST_CN002         '$'
#define XP_KEY_IDLINESEP_CN002      "#"
#define XP_KEY_PROPSEP_CN002        ","

#define XP_KEY_DYNAMIC_CN002        "?"
#define XP_KEY_WILDCARD_CN002       "*"
#define XP_CHAR_NEWFOLLOW_CN002     '\\'
#define XP_CHAR_STRING_CN002        '"'
#define XP_KEY_NEWFOLLOW_CN002      "\\"
#define XP_CHAR_UNDERLINE_CN002     '_'
#define XP_CHAR_COMMENT_CN002       '\''
#define XP_KEY_TOKENSEP_CN002       " \t"
#define XP_CHAR_SPACE_CN002         ' '
#define XP_CHAR_TAB_CN002           '\t'
/*#define XP_FIRST_PRINT_CN002        0x20*/
/*#define XP_LAST_PRINT_CN002         0x7E*/

/* SPECIFICATION OPERATORS
 * ------------------------------------------------------------------
 */
/* comparsion operators */
#define XP_OP_EQUAL_CN002          "="
#define XP_OP_LESS_CN002           "<"
#define XP_OP_GREATER_CN002        ">"
#define XP_OP_LESSEQUAL_CN002      "<="
#define XP_OP_GREATEREQUAL_CN002   ">="
#define XP_OP_NOTEQUAL_CN002       "<>"
/* bool    operators */
#define XP_OP_AND_CN002            "AND"
#define XP_OP_OR_CN002             "OR"
#define XP_OP_XOR_CN002            "XOR"
/* arithmetic operators */
#define XP_OP_PLUS_CN002           "+"
#define XP_OP_MINUS_CN002          "-"
#define XP_OP_MULTIPLY_CN002       "*"
#define XP_OP_DIVIDE_CN002         "/"
#define XP_OP_MODULO_CN002         "%"
#define XP_OP_ALIGN_CN002          "#"
#define XP_OP_POWER_CN002       "^"
/* operator types */
typedef enum {
  XPOperatorUnknown,
  XPOperatorAND,
  XPOperatorOR,
  XPOperatorXOR,
  XPOperatorPLUS,
  XPOperatorMINUS,
  XPOperatorMULTIPLY,
  XPOperatorDIVIDE,
  XPOperatorMODULO,
  XPOperatorALIGN,
  XPOperatorPOWER,
  XPOperatorEQUAL,
  XPOperatorLESS,
  XPOperatorGREATER,
  XPOperatorLESSEQUAL,
  XPOperatorGREATEREQUAL,
  XPOperatorNOTEQUAL
} tcn002_XPOperators;
/* operator to keyword table */
#define XP_OPERATOR_TABLE_CN002  { \
  { XPOperatorAND,              XP_OP_AND_CN002           }, \
  { XPOperatorOR,               XP_OP_OR_CN002            }, \
  { XPOperatorXOR,              XP_OP_XOR_CN002           }, \
  { XPOperatorPLUS,             XP_OP_PLUS_CN002          }, \
  { XPOperatorMINUS,            XP_OP_MINUS_CN002         }, \
  { XPOperatorMULTIPLY,         XP_OP_MULTIPLY_CN002      }, \
  { XPOperatorDIVIDE,           XP_OP_DIVIDE_CN002        }, \
  { XPOperatorMODULO,           XP_OP_MODULO_CN002        }, \
  { XPOperatorALIGN,            XP_OP_ALIGN_CN002         }, \
  { XPOperatorPOWER,            XP_OP_POWER_CN002         }, \
  { XPOperatorEQUAL,            XP_OP_EQUAL_CN002         }, \
  { XPOperatorLESS,             XP_OP_LESS_CN002          }, \
  { XPOperatorGREATER,          XP_OP_GREATER_CN002       }, \
  { XPOperatorLESSEQUAL,        XP_OP_LESSEQUAL_CN002     }, \
  { XPOperatorGREATEREQUAL,     XP_OP_GREATEREQUAL_CN002  }, \
  { XPOperatorNOTEQUAL,         XP_OP_NOTEQUAL_CN002      }, \
  { XPOperatorUnknown,          NULL                     }}
/* type of operation */
typedef enum {
  XPOpTypeUnknown,
  XPOpTypeArith,
  XPOpTypeString,
  XPOpTypebool   
} tcn002_XPOpType;
/* operator to type of operation table */
/*  <operator>                  <in-type1>       <in-type2>       <out-type>    */
#define XP_OPERATOR_TO_TYPE_TABLE_CN002  { \
  { XPOperatorAND,              XPOpTypebool   , XPOpTypebool   , XPOpTypebool    }, \
  { XPOperatorOR,               XPOpTypebool   , XPOpTypebool   , XPOpTypebool    }, \
  { XPOperatorXOR,              XPOpTypebool   , XPOpTypebool   , XPOpTypebool    }, \
  { XPOperatorPLUS,             XPOpTypeString , XPOpTypeString , XPOpTypeString  }, \
  { XPOperatorPLUS,             XPOpTypeArith  , XPOpTypeArith  , XPOpTypeArith   }, \
  { XPOperatorPLUS,             XPOpTypeArith  , XPOpTypeString , XPOpTypeString  }, \
  { XPOperatorPLUS,             XPOpTypeString , XPOpTypeArith  , XPOpTypeString  }, \
  { XPOperatorMINUS,            XPOpTypeArith  , XPOpTypeArith  , XPOpTypeArith   }, \
  { XPOperatorMULTIPLY,         XPOpTypeArith  , XPOpTypeArith  , XPOpTypeArith   }, \
  { XPOperatorDIVIDE,           XPOpTypeArith  , XPOpTypeArith  , XPOpTypeArith   }, \
  { XPOperatorMODULO,           XPOpTypeArith  , XPOpTypeArith  , XPOpTypeArith   }, \
  { XPOperatorALIGN,            XPOpTypeArith  , XPOpTypeArith  , XPOpTypeArith   }, \
  { XPOperatorPOWER,            XPOpTypeArith  , XPOpTypeArith  , XPOpTypeArith   }, \
  { XPOperatorEQUAL,            XPOpTypeArith  , XPOpTypeArith  , XPOpTypebool    }, \
  { XPOperatorLESS,             XPOpTypeArith  , XPOpTypeArith  , XPOpTypebool    }, \
  { XPOperatorGREATER,          XPOpTypeArith  , XPOpTypeArith  , XPOpTypebool    }, \
  { XPOperatorLESSEQUAL,        XPOpTypeArith  , XPOpTypeArith  , XPOpTypebool    }, \
  { XPOperatorGREATEREQUAL,     XPOpTypeArith  , XPOpTypeArith  , XPOpTypebool    }, \
  { XPOperatorNOTEQUAL,         XPOpTypeArith  , XPOpTypeArith  , XPOpTypebool    }, \
  { XPOperatorEQUAL,            XPOpTypeString , XPOpTypeString , XPOpTypebool    }, \
  { XPOperatorLESS,             XPOpTypeString , XPOpTypeString , XPOpTypebool    }, \
  { XPOperatorGREATER,          XPOpTypeString , XPOpTypeString , XPOpTypebool    }, \
  { XPOperatorLESSEQUAL,        XPOpTypeString , XPOpTypeString , XPOpTypebool    }, \
  { XPOperatorGREATEREQUAL,     XPOpTypeString , XPOpTypeString , XPOpTypebool    }, \
  { XPOperatorNOTEQUAL,         XPOpTypeString , XPOpTypeString , XPOpTypebool    }, \
  { XPOperatorUnknown,          XPOpTypeUnknown, XPOpTypeUnknown, XPOpTypeUnknown }}

/* SPECIFICATION PROPERTIES
 * ------------------------------------------------------------------
 */

/* new property class keywords */
#define XP_PROP_CHANGE_CN002        "CHANGE"
#define XP_PROP_INTERN_CN002        "INTERN"
#define XP_PROP_MANDATORY_CN002     "MANDATORY"
#define XP_PROP_CLEAR_CN002         "CLEAR"
#define XP_PROP_DYNAMIC_CN002       "DYNAMIC"
#define XP_PROP_CASESENSITIVE_CN002 "CASESENSITIVE"
#define XP_PROP_DEVSPACE_CN002      "DEVSPACE"
#define XP_PROP_MODIFY_CN002        "MODIFY"
#define XP_PROP_GROUP_CN002         "GROUP"
#define XP_PROP_DISPLAY_CN002       "DISPLAYNAME"
#define XP_PROP_VALUESET_CN002      "VALUESET"
#define XP_PROP_MAX_CN002           "MAX"
#define XP_PROP_MIN_CN002           "MIN"
#define XP_PROP_INSTANCE_CN002      "INSTANCES"

/* new property value keywords */
#define XP_PROP_YES_CN002           "YES"
#define XP_PROP_NO_CN002            "NO"
#define XP_PROP_HIGHER_CN002        "HIGHER"
#define XP_PROP_GENERAL_CN002       "GENERAL"
#define XP_PROP_EXTENDED_CN002      "EXTENDED"
#define XP_PROP_SUPPORT_CN002       "SUPPORT"
#define XP_PROP_INFO_CN002          "INFO"

/* new property values */
typedef enum {
   XPPropValueUnknown,
   XPPropValueYes,
   XPPropValueNo,
   XPPropValueHigher,
   XPPropValueGeneral,
   XPPropValueExtended,
   XPPropValueSupport,
   XPPropValueInfo
} tcn002_XPPropValue;

/* new property value table (<value>,<keyword>) */
#define XP_PROP_VALUES_CN002  { \
  {XPPropValueYes,           XP_PROP_YES_CN002        }, \
  {XPPropValueNo,            XP_PROP_NO_CN002         }, \
  {XPPropValueHigher,        XP_PROP_HIGHER_CN002     }, \
  {XPPropValueGeneral,       XP_PROP_GENERAL_CN002    }, \
  {XPPropValueExtended,      XP_PROP_EXTENDED_CN002   }, \
  {XPPropValueSupport,       XP_PROP_SUPPORT_CN002    }, \
  {XPPropValueInfo,          XP_PROP_INFO_CN002       }, \
  {XPPropValueUnknown,       NULL                     }}

/* new property classes */
typedef enum {
   XPPropClassChange,
   XPPropClassIntern,
   XPPropClassMandatory,
   XPPropClassClear,
   XPPropClassDynamic,
   XPPropClassCasesensitive,
   XPPropClassDevspace,
   XPPropClassModify,
   XPPropClassGroup,
   XPPropClassDisplay,
   XPPropClassValueset,
   XPPropClassMax,
   XPPropClassMin,
   XPPropClassInstance,
   XPPropClassUnknown,
   XPPropClassMAX
} tcn002_XPPropClass;

/* new property class table (<class>,<defaultvalue>,<keyword>) */
/* **** Attention **** 
    Maintain the same order like in the enum above! A class will be
    found by the index  */
#define XP_PROP_CLASSES_CN002  { \
  {XPPropClassChange,        XPPropValueYes,     XP_PROP_CHANGE_CN002        }, \
  {XPPropClassIntern,        XPPropValueNo,      XP_PROP_INTERN_CN002        }, \
  {XPPropClassMandatory,     XPPropValueNo,      XP_PROP_MANDATORY_CN002     }, \
  {XPPropClassClear,         XPPropValueNo,      XP_PROP_CLEAR_CN002         }, \
  {XPPropClassDynamic,       XPPropValueNo,      XP_PROP_DYNAMIC_CN002       }, \
  {XPPropClassCasesensitive, XPPropValueNo,      XP_PROP_CASESENSITIVE_CN002 }, \
  {XPPropClassDevspace,      XPPropValueNo,      XP_PROP_DEVSPACE_CN002      }, \
  {XPPropClassModify,        XPPropValueYes,     XP_PROP_MODIFY_CN002        }, \
  {XPPropClassGroup,         XPPropValueGeneral, XP_PROP_GROUP_CN002         }, \
  {XPPropClassDisplay,       XPPropValueUnknown, XP_PROP_DISPLAY_CN002       }, \
  {XPPropClassValueset,      XPPropValueUnknown, XP_PROP_VALUESET_CN002      }, \
  {XPPropClassMax,           XPPropValueUnknown, XP_PROP_MAX_CN002           }, \
  {XPPropClassMin,           XPPropValueUnknown, XP_PROP_MIN_CN002           }, \
  {XPPropClassInstance,      XPPropValueUnknown, XP_PROP_INSTANCE_CN002      }, \
  {XPPropClassUnknown,       XPPropValueUnknown, NULL                        }}

/* valid values for classes */
#define XP_PROP_VALID_CN002  { \
  {XPPropClassChange,        XPPropValueNo        }, \
  {XPPropClassChange,        XPPropValueYes       }, \
  {XPPropClassIntern,        XPPropValueYes       }, \
  {XPPropClassIntern,        XPPropValueNo        }, \
  {XPPropClassMandatory,     XPPropValueYes       }, \
  {XPPropClassMandatory,     XPPropValueNo        }, \
  {XPPropClassClear,         XPPropValueYes       }, \
  {XPPropClassClear,         XPPropValueNo        }, \
  {XPPropClassDynamic,       XPPropValueYes       }, \
  {XPPropClassDynamic,       XPPropValueNo        }, \
  {XPPropClassCasesensitive, XPPropValueYes       }, \
  {XPPropClassCasesensitive, XPPropValueNo        }, \
  {XPPropClassDevspace,      XPPropValueYes       }, \
  {XPPropClassDevspace,      XPPropValueNo        }, \
  {XPPropClassModify,        XPPropValueYes       }, \
  {XPPropClassModify,        XPPropValueNo        }, \
  {XPPropClassGroup,         XPPropValueNo        }, \
  {XPPropClassGroup,         XPPropValueGeneral   }, \
  {XPPropClassGroup,         XPPropValueExtended  }, \
  {XPPropClassGroup,         XPPropValueSupport   }, \
  {XPPropClassGroup,         XPPropValueInfo      }, \
  {XPPropClassDisplay,       XPPropValueUnknown   }, \
  {XPPropClassValueset,      XPPropValueUnknown   }, \
  {XPPropClassMax,           XPPropValueUnknown   }, \
  {XPPropClassMin,           XPPropValueUnknown   }, \
  {XPPropClassInstance,      XPPropValueUnknown   }, \
  {XPPropClassUnknown,       XPPropValueUnknown   }}

#define XP_MAX_VALUES_PER_CLASS_CN002 5

///* SPECIFICATION TYPES
// * ------------------------------------------------------------------
// */
///* parameter types */
//#define XP_TYPE_INT2_CN002          "int2"
//#define XP_TYPE_INT4_CN002          "int4"
//#define XP_TYPE_C8_CN002            "c8"
//#define XP_TYPE_C18_CN002           "c18"
//#define XP_TYPE_C24_CN002           "c24"
//#define XP_TYPE_C40_CN002           "c40"
//#define XP_TYPE_C64_CN002           "c64"
//#define XP_TYPE_CRYPT_CN002         "crypt"
//
///* type of parameter table (<code>,<keyword>) */
//#define XP_TYPES_CN002 { \
//  { xp_int2_type,    XP_TYPE_INT2_CN002   }, \
//  { xp_int4_type,    XP_TYPE_INT4_CN002   }, \
//  { xp_c8_type,      XP_TYPE_C8_CN002     }, \
//  { xp_c18_type,     XP_TYPE_C18_CN002    }, \
//  { xp_c24_type,     XP_TYPE_C24_CN002    }, \
//  { xp_c40_type,     XP_TYPE_C40_CN002    }, \
//  { xp_c64_type,     XP_TYPE_C64_CN002    }, \
//  { xp_crypt_type,   XP_TYPE_CRYPT_CN002  }, \
//  { xp_crypt_type,   ""                  }}

/* SPECIFICATION TYPES
 * ------------------------------------------------------------------
 */
/* parameter types */
#define XP_TYPE_INT_CN002           "int"
#define XP_TYPE_REAL_CN002          "real"
#define XP_TYPE_STRING_CN002        "string"
#define XP_TYPE_CRYPT_CN002         "crypt"

/* type of parameter table (<code>,<keyword>) */
#define XP_TYPES_CN002 { \
  { RTEConf_Parameter::t_Integer,    XP_TYPE_INT_CN002    }, \
  { RTEConf_Parameter::t_Real,       XP_TYPE_REAL_CN002   }, \
  { RTEConf_Parameter::t_String,     XP_TYPE_STRING_CN002 }, \
  { RTEConf_Parameter::t_CryptInfo,  XP_TYPE_CRYPT_CN002  }, \
  { RTEConf_Parameter::t_Invalid,    ""                   }}

/* SPECIFICATION LINES
 * ------------------------------------------------------------------
 */
/* line types in XParam file */
typedef enum {
  XPLineBOF,                     /* Begin Of File                   Old  New */
  XPLineID,                      /* ID-Line                         Old  New */
  XPLineTYPE,                    /* TYPE-Line                            New */
  XPLineDEFAULT,                 /* DEFAULT-Line                         New */
  XPLineDEFAULTFOR,              /* DEFAULT_FOR-Line                     New */
  XPLineProperty,                /* Property-Line                        New */
  XPLineCODE,                    /* CODE-Line                            New */
  XPLineENDCODE,                 /* ENDCODE-Line                         New */
  XPLineCodeCALC,                /* CALC-Line                       Old  New */
  XPLineCodeCALCFollow,          /* CALC-Follow-Line                Old      */
  XPLineCodeFORCE,               /* FORCE-Line                      Old      */
  XPLineCodeFORCEFollow,         /* FORCE-Follow-Line               Old      */
  XPLineCodeIF,                  /* IF-Line                         Old  New */
  XPLineCodeIFFollow,            /* IF-Follow-Line                  Old      */
  XPLineCodeELSIF,               /* ELSIF-Line                      Old  New */
  XPLineCodeELSIFFollow,         /* ELSIF-Follow-Line               Old      */
  XPLineCodeELSE,                /* ELSE-Line                       Old  New */
  XPLineCodeCONSTRAINT,          /* CONSTRAINT-Line                 Old  New */
  XPLineCodeCONSTRAINTFollow,    /* CONSTARINT-Follow-Line          Old      */
  XPLineEXPLAIN,                 /* EXPLAIN-Line                    Old  New */
  XPLineEXPLAINFollow,           /* EXPLAIN-Follow-Line             Old  New */
  XPLineENDEXPLAIN,              /* ENDEXPLAIN-Line                      New */
  XPLineHELP,                    /* HELP-Line                       Old  New */
  XPLineHELPFollow,              /* HELP-Follow-Line                Old  New */
  XPLineENDHELP,                 /* ENDHELP-Line                         New */
  XPLineEOF,                     /* End Of File                     Old  New */
  XPLineUnknown                  /* Special Value                            */
} tcn002_LineType;

/* relation of keyword to line type */
#define XP_KEYWORD_LINE_CN002 { \
  {XPLineID,             XP_KEY_ID_CN002             }, \
  {XPLineTYPE,           XP_KEY_TYPE_CN002           }, \
  {XPLineDEFAULT,        XP_KEY_DEFAULT_CN002        }, \
  {XPLineDEFAULTFOR,     XP_KEY_DEFAULTFOR_CN002     }, \
  {XPLineProperty,       XP_PROP_CHANGE_CN002        }, \
  {XPLineProperty,       XP_PROP_INTERN_CN002        }, \
  {XPLineProperty,       XP_PROP_MANDATORY_CN002     }, \
  {XPLineProperty,       XP_PROP_CLEAR_CN002         }, \
  {XPLineProperty,       XP_PROP_DYNAMIC_CN002       }, \
  {XPLineProperty,       XP_PROP_CASESENSITIVE_CN002 }, \
  {XPLineProperty,       XP_PROP_DEVSPACE_CN002      }, \
  {XPLineProperty,       XP_PROP_MODIFY_CN002        }, \
  {XPLineProperty,       XP_PROP_INFO_CN002          }, \
  {XPLineProperty,       XP_PROP_GROUP_CN002         }, \
  {XPLineProperty,       XP_PROP_DISPLAY_CN002       }, \
  {XPLineProperty,       XP_PROP_VALUESET_CN002      }, \
  {XPLineProperty,       XP_PROP_MAX_CN002           }, \
  {XPLineProperty,       XP_PROP_MIN_CN002           }, \
  {XPLineProperty,       XP_PROP_INSTANCE_CN002      }, \
  {XPLineCODE,           XP_KEY_CODE_CN002           }, \
  {XPLineENDCODE,        XP_KEY_ENDCODE_CN002        }, \
  {XPLineCodeCALC,       XP_KEY_CALC_CN002           }, \
  {XPLineCodeCONSTRAINT, XP_KEY_CONSTRAINT_CN002     }, \
  {XPLineCodeIF,         XP_KEY_IF_CN002             }, \
  {XPLineCodeELSIF,      XP_KEY_ELSIF_CN002          }, \
  {XPLineCodeELSE,       XP_KEY_ELSE_CN002           }, \
  {XPLineEXPLAIN,        XP_KEY_EXPLAIN_CN002        }, \
  {XPLineENDEXPLAIN,     XP_KEY_ENDEXPLAIN_CN002     }, \
  {XPLineHELP,           XP_KEY_HELP_CN002           }, \
  {XPLineENDHELP,        XP_KEY_ENDHELP_CN002        }, \
  {XPLineUnknown,        ""                         }}

/* valid line transitions */
#define XP_LINE_TRANSITIONS_CN002 { \
  {XPLineBOF,            XPLineID            }, \
  {XPLineBOF,            XPLineEOF           }, \
  {XPLineID,             XPLineTYPE          }, \
  {XPLineTYPE,           XPLineDEFAULT       }, \
  {XPLineTYPE,           XPLineProperty      }, \
  {XPLineTYPE,           XPLineCODE          }, \
  {XPLineTYPE,           XPLineEXPLAIN       }, \
  {XPLineTYPE,           XPLineHELP          }, \
  {XPLineTYPE,           XPLineEOF           }, \
  {XPLineTYPE,           XPLineID            }, \
  {XPLineDEFAULT,        XPLineProperty      }, \
  {XPLineDEFAULT,        XPLineCODE          }, \
  {XPLineDEFAULT,        XPLineEXPLAIN       }, \
  {XPLineDEFAULT,        XPLineHELP          }, \
  {XPLineDEFAULT,        XPLineEOF           }, \
  {XPLineDEFAULT,        XPLineID            }, \
  {XPLineDEFAULT,        XPLineDEFAULTFOR    }, \
  {XPLineDEFAULTFOR,     XPLineProperty      }, \
  {XPLineDEFAULTFOR,     XPLineCODE          }, \
  {XPLineDEFAULTFOR,     XPLineEXPLAIN       }, \
  {XPLineDEFAULTFOR,     XPLineHELP          }, \
  {XPLineDEFAULTFOR,     XPLineEOF           }, \
  {XPLineDEFAULTFOR,     XPLineID            }, \
  {XPLineDEFAULTFOR,     XPLineDEFAULTFOR    }, \
  {XPLineProperty,       XPLineProperty      }, \
  {XPLineProperty,       XPLineCODE          }, \
  {XPLineProperty,       XPLineEXPLAIN       }, \
  {XPLineProperty,       XPLineHELP          }, \
  {XPLineProperty,       XPLineEOF           }, \
  {XPLineProperty,       XPLineID            }, \
  {XPLineCODE,           XPLineCodeIF        }, \
  {XPLineCODE,           XPLineCodeCALC      }, \
  {XPLineCODE,           XPLineCodeCONSTRAINT}, \
  {XPLineCODE,           XPLineENDCODE       }, \
  {XPLineCodeIF,         XPLineCodeCALC      }, \
  {XPLineCodeELSIF,      XPLineCodeCALC      }, \
  {XPLineCodeELSE,       XPLineCodeCALC      }, \
  {XPLineCodeCALC,       XPLineCodeCALC      }, \
  {XPLineCodeCALC,       XPLineCodeCONSTRAINT}, \
  {XPLineCodeCALC,       XPLineCodeIF        }, \
  {XPLineCodeCALC,       XPLineCodeELSIF     }, \
  {XPLineCodeCALC,       XPLineCodeELSE      }, \
  {XPLineCodeCALC,       XPLineENDCODE       }, \
  {XPLineCodeCONSTRAINT, XPLineCodeCALC      }, \
  {XPLineCodeCONSTRAINT, XPLineCodeCONSTRAINT}, \
  {XPLineCodeCONSTRAINT, XPLineCodeIF        }, \
  {XPLineCodeCONSTRAINT, XPLineCodeELSIF     }, \
  {XPLineCodeCONSTRAINT, XPLineCodeELSE      }, \
  {XPLineCodeCONSTRAINT, XPLineENDCODE       }, \
  {XPLineENDCODE,        XPLineEXPLAIN       }, \
  {XPLineENDCODE,        XPLineHELP          }, \
  {XPLineENDCODE,        XPLineEOF           }, \
  {XPLineENDCODE,        XPLineID            }, \
  {XPLineEXPLAIN,        XPLineENDEXPLAIN    }, \
  {XPLineEXPLAIN,        XPLineEXPLAINFollow }, \
  {XPLineEXPLAINFollow,  XPLineEXPLAINFollow }, \
  {XPLineEXPLAINFollow,  XPLineENDEXPLAIN    }, \
  {XPLineENDEXPLAIN,     XPLineHELP,         }, \
  {XPLineENDEXPLAIN,     XPLineEOF,          }, \
  {XPLineENDEXPLAIN,     XPLineID,           }, \
  {XPLineHELP,           XPLineHELPFollow,   }, \
  {XPLineHELP,           XPLineENDHELP,      }, \
  {XPLineHELPFollow,     XPLineHELPFollow,   }, \
  {XPLineHELPFollow,     XPLineENDHELP,      }, \
  {XPLineENDHELP,        XPLineEOF,          }, \
  {XPLineENDHELP,        XPLineID,           }, \
  {XPLineUnknown,        XPLineUnknown       }}

/*  {XPLineCodeIF,         XPLineCodeCONSTRAINT}, \ */
/*  {XPLineCodeELSIF,      XPLineCodeCONSTRAINT}, \ */
/*  {XPLineCodeELSE,       XPLineCodeCONSTRAINT}, \ */

/* SPECIFICATION STUFF
 * ------------------------------------------------------------------
 */
#define XP_ANNOTATION_LENGTH_MXCN002    83
#define XP_PARAMLINE_LENGTH_MXCN002     90
#define XP_LINE_LENGTH_MXCN002          512
#define XP_IL_MINDYN_CN002              "MIN_DYN_VALUE"
#define XP_IL_MAXDYN_CN002              "MAX_DYN_VALUE"
#define XP_FILE_CN002                   "xparam.pcf"
#define XP_NEWFILE_CN002                "cserv.pcf"
#define XP_RUNDIR_CN002                 "wrk"
#define XP_FILENAME_LENGTH_MXCN002      1024
#define XP_PROPLINE_LENGTH_MXCN002      200
#define XP_OPERANDS_MXCN002             256
#define XP_STRING_LENGTH_MXCN002        RTECONF_MAXSTRINGLENGTH
#define XP_DEFAULTFOR_MXCN002             5
#define XP_DEFAULTFORINSTANCE_CN002       0
#define XP_DEFAULTFORVALUE_CN002          1

/* check state */
typedef enum {
  XPCalcStateUnknown,     /* oops, what's that?                         */
  XPCalcStateOK,          /* use value from calculation                 */
  XPCalcStateConstraint,  /* constraint not satisfied                   */
  XPCalcStateMandatory    /* missing value for mandatory                */
} tcn002_CalcState;
#define XP_CALC_STATES_TABLE_CN002 { \
  {XPCalcStateOK,          "OK"         }, \
  {XPCalcStateConstraint,  "Constraint" }, \
  {XPCalcStateMandatory,   "Mandatory"  }, \
  {XPCalcStateUnknown,     "Unknown"    }}

/* get requests */
typedef enum {
  XPRequestUnknown, 
  XPRequestDirectGet, 
  XPRequestExtGet, 
  XPRequestType, 
  XPRequestDefault, 
  XPRequestValue, 
  XPRequestValueIntern, 
  XPRequestProperties, 
  XPRequestExplain, 
  XPRequestHelp, 
  XPRequestGood, 
  XPRequestFull
} tcn002_XPRequest;

/* SPECIFICATION STRUCTURES
 * ------------------------------------------------------------------
 */
/* line structure */
typedef struct tcn002_XPLine {
  char                 * szLine;
  tcn002_LineType        xpLine;
  struct tcn002_XPLine * pNext;
  long                   nNumber;
} tcn002_XPLine;

typedef CSTRING_TYPE_MSP00      (  tcn002_XpValueString, RTECONF_MAXSTRINGLENGTH);
typedef CSTRING_TYPE_MSP00      (  tcn002_XpValueName, RTECONF_MAXNAMELENGTH);

typedef struct tcn002_XPRecord {
    RTEConf_Parameter::Type    xpType;
    union
    {
      RTEConf_Parameter::Integer       xpValueInt;
      RTEConf_Parameter::Real          xpValueReal;
      tcn002_XpValueString             xpValueString;
      RTEConf_Parameter::CryptInfo     xpValueCrypt;
    } xpValue;
  } tcn002_XPRecord;

/* parameter structure */
typedef struct tcn002_XParameter {

  tcn002_XpValueName         szParameterName;     /* name of parameter                                 */

  bool                       bHelpExist;          /* flag for existence of parameter in help file      */
  bool                       bParamExist;         /* flag for existence of parameter in param file     */

  tcn002_XpValueString       szDefaultFor[XP_DEFAULTFOR_MXCN002][2]  ;    /* default value              */

  tcn002_XpValueString       szDefValue;                                  /* default value              */
  tcn002_XpValueString       szGoodValue;                                 /* last known good            */
  tcn002_XpValueString       szOldValue;                                  /* value read from paramfile  */
  tcn002_XpValueString       szNewValue;                                  /* input value                */

//  tsp00_XpValueRec           xpValueRecord;       /* parameter record from param file of the db        */
  tcn002_XPRecord            xpRecord;

  tcn002_CalcState           nCalcState;         /* check state value                                 */

  unsigned long              nProperties;         /* properties of parameter as bitfield (old version) */
  tcn002_XPPropValue         xpProperties[XPPropClassMAX];  /* properties                             */
  tsp00_C512c                szProperties[XPPropClassMAX];  /* properties value                       */

  struct tcn002_XParameter * pNext;              /* pointer for list management (help file order)     */
  struct tcn002_XParameter * pPrev;              /* pointer for list management (help file order)     */

  tcn002_XPLine            * pCode;              /* code lines                                        */
  tcn002_XPLine            * pConstraint;        /* constraint line                                   */
  tcn002_XPLine            * pExplain;           /* explain lines                                     */
  tcn002_XPLine            * pHelp;              /* help lines                                        */

} tcn002_XParameter;

/* XParam main structure */
typedef struct tcn002_XParamData {
  tcn002_XParameter        * pFirst;             /* first parameter (by help file order)              */
  tcn002_XParameter        * pLast;              /* last parameter (by help file order)               */
  bool                       bParamFileExist;    /* exists at least one parameter in paramfile        */
  bool                       bKernelDirty;       /* Dirty-Flag                                        */
  bool                       bDevspaceDirty;     /* Dirty-Flag                                        */
} tcn002_XParamData;

/* XParam operand structure */
typedef struct tcn002_XPOperand {
  tcn002_XPOpType            nOpType;            /* type of operand */ 
  union {
    long                    nValue;
    bool                    bValue;
    tcn002_XpValueString    szValue;
  } opValue; 
} tcn002_XPOperand;

#define PAHI_ACTIVE_CN002         _T('A')
#define PAHI_CHANGE_CN002         _T('C')
#define PAHI_DELETE_CN002         _T('D')

#endif /* _GCN002_H_ */
